//
//  CCHRecorderController.m
//  CCHRecorder


#import "CCHRecorderController.h"

@implementation CCHRecorderController

static NSMutableDictionary *allVideoDevices = nil;
static NSMutableDictionary *allAudioDevices = nil;

static UInt32 numberOfBandLevels = 8;       // increase this number for more frequency bands
static UInt32 numberOfChannels = 2;         // for StereoMix - If using DeviceMix, you need to get the channel count of the device.
static UInt8  maxLevelIndicatorValue = 8;  // NSLevelIndicators are set up to have this max value

@synthesize records;
@synthesize indicatorsArray;
@synthesize shouldKeptSave;
@synthesize isRecording;
@synthesize treshold;
@synthesize recordPath;
@synthesize checkPath;
@synthesize shouldCascading;
@synthesize durationInMinutes;
@synthesize delayedStart;

@synthesize savingPathForRecord;
@synthesize savingPathForCheck;


- (NSString *) generateFilePath
{   NSArray* paths = NSSearchPathForDirectoriesInDomains ( NSDocumentDirectory, NSUserDomainMask, YES );
    NSString* otherPath = [[paths objectAtIndex:0] stringByExpandingTildeInPath];
    NSString *processName = [[NSProcessInfo processInfo] processName];
    
    NSError *anErr = nil;
    
    otherPath = [otherPath stringByAppendingPathComponent:processName];
    if(NO == [[NSFileManager defaultManager]fileExistsAtPath:otherPath])
        {// create support directory and original directory on first launch
            [[NSFileManager defaultManager] createDirectoryAtPath:otherPath withIntermediateDirectories:YES attributes:nil error:&anErr];
            
            if(anErr)
                NSLog(@"An Error while creating directory at path: %@ occured:\n%@\n%@",otherPath, [anErr localizedDescription], [anErr localizedFailureReason]);                    
        }    
    if([[NSFileManager defaultManager]fileExistsAtPath:otherPath])
        {   
            otherPath = [otherPath stringByAppendingPathComponent:[[NSCalendarDate date] descriptionWithCalendarFormat:@"%H %M'%S %e-%m-%y"]];
            NSLog(otherPath);
            //            otherPath = [otherPath stringByAppendingPathComponent:[[NSDate date]description]];
            otherPath = [otherPath stringByAppendingPathExtension:@"mov"];
            return otherPath;
            
        }
    return nil;
}


+(NSMutableDictionary *)allAudioDevices
{    
    if(nil == allAudioDevices)
        {
            allAudioDevices = [[NSMutableDictionary alloc]init];
            NSArray *allDevices = [QTCaptureDevice inputDevicesWithMediaType:QTMediaTypeSound];
            for(QTCaptureDevice *anAudioDevice in allDevices)
                {	
                    NSString *keyID = [anAudioDevice uniqueID];
                    NSString *devName = [anAudioDevice localizedDisplayName];
                    NSArray *availableDevices = [anAudioDevice attributeForKey: QTCaptureDeviceAvailableInputSourcesAttribute];
                    if(availableDevices && [availableDevices count])
                        {//NSLog([availableDevices description]);
                            for(NSDictionary *aDict in availableDevices)
                                {
                                    keyID =[aDict valueForKey:QTCaptureDeviceInputSourceIdentifierAttribute];
                                    if(!keyID)
                                        keyID =[aDict valueForKey:QTCaptureDeviceInputSourceIdentifierKey];
                                    if(keyID)
                                        {//NSNumber stringValue; The receiver’s value as a human-readable string, created by invoking descriptionWithLocale: where locale is nil.
                                            if(![keyID isKindOfClass:[NSString class]])
                                                keyID = [keyID description];
                                            devName = [aDict valueForKey:QTCaptureDeviceInputSourceLocalizedDisplayNameKey];
                                            if(devName == nil || [devName length] < 1)
                                                devName = NSLocalizedString(@"unknown Audio", @"entry for an unknown Audio in the popup");
                                            
                                            [allAudioDevices setValue:devName forKey:keyID];
                                        }
                                }
                        }
                    else
                        [allAudioDevices setValue:devName forKey:keyID];
                }
            
        }
    BOOL success = NO;
    NSMutableSet *aSet = [NSMutableSet set];
    while (NO == success) {// open all devices, if they are available
        NSError *error;
        QTCaptureDevice *audioDevice = [QTCaptureDevice defaultInputDeviceWithMediaType:QTMediaTypeSound];
        success = [audioDevice open:&error];
        
        if (success) {
            NSLog(@"Check default devices:%@, [%@]", [audioDevice uniqueID],[audioDevice localizedDisplayName]);
            if (audioDevice) {
                QTCaptureDeviceInput *audioInputDevice = [[QTCaptureDeviceInput alloc] initWithDevice:audioDevice];
                [aSet addObject:audioInputDevice];
                
                [audioInputDevice release];
                
                [aSet addObject:audioDevice];
                
            }
        }
    }
    for(QTCaptureDevice *audioDevice in aSet)
        {
            if ([audioDevice isKindOfClass:[QTCaptureDevice class]]&& [audioDevice isOpen])
                [audioDevice close];
        };
    //    NSLog([[allAudioDevices allKeys]description]);
    //    NSLog([[allAudioDevices allFilterValuesDict]description]);
    return allAudioDevices;
}

+(NSMutableDictionary *)allVideoDevices
{    
    if(nil == allVideoDevices)
        {
            allVideoDevices = [[NSMutableDictionary alloc]init];
            NSArray *allDevices = [QTCaptureDevice inputDevicesWithMediaType:QTMediaTypeVideo];
            
            for(QTCaptureDevice *aVideoDevice in allDevices)
                {	
                    NSString *keyID = [aVideoDevice uniqueID];
                    NSString *devName = [aVideoDevice localizedDisplayName];
                    NSArray *availableDevices = [aVideoDevice attributeForKey: QTCaptureDeviceAvailableInputSourcesAttribute];
                    if(availableDevices && [availableDevices count])
                        {
                            for(NSDictionary *aDict in availableDevices)
                                {
                                    keyID =[aDict valueForKey:QTCaptureDeviceInputSourceIdentifierKey];
                                    if(keyID)
                                        {
                                            devName = [aDict valueForKey:QTCaptureDeviceInputSourceLocalizedDisplayNameKey];
                                            if(devName == nil || [devName length] < 1)
                                                devName = NSLocalizedString(@"unknown Audio", @"entry for an unknown Audio in the popup");
                                            
                                            [allVideoDevices setValue:devName forKey:keyID];
                                        }
                                }
                        }
                    else
                        [allVideoDevices setValue:devName forKey:keyID];
                }
            
        }
    NSLog([[allVideoDevices allKeys]description]);
    NSLog([[allVideoDevices allValues]description]);
    return allVideoDevices;
}

- (NSArray *)allAvailableAudioDevicesByName
{
    return [[[self class] allAudioDevices]allValues];
}

- (NSArray *)allAvailableVideoDevicesByName
{
    return [[[self class] allVideoDevices]allValues];
}


- (void)awakeFromNib
{
    // create two pathes for temporary files
    NSArray* paths = NSSearchPathForDirectoriesInDomains ( NSCachesDirectory, NSUserDomainMask, YES );
	
	NSString *path = [paths objectAtIndex:0];
	path = [path stringByAppendingPathComponent:[[NSProcessInfo processInfo] processName]];

    NSError *anErr = nil;
    
    if(NO == [[NSFileManager defaultManager]fileExistsAtPath:path])
	{// create caches directory and original directory on first launch
		[[NSFileManager defaultManager] createDirectoryAtPath: path withIntermediateDirectories:YES attributes:nil error:&anErr];
	}
		
	
    self.recordPath = [path stringByAppendingPathComponent:@"record"];
    self.checkPath = [path stringByAppendingPathComponent:@"check"];
    // Create the capture session
    

	captureSession = [[QTCaptureSession alloc] init];
    
// Connect inputs and outputs to the session	
    
	BOOL success = NO;
	NSError *error;
	
// Find a video device  
    
    QTCaptureDevice *videoDevice = [QTCaptureDevice defaultInputDeviceWithMediaType:QTMediaTypeVideo];
    success = [videoDevice open:&error];
    
    
// If a video input device can't be found or opened, try to find and open a muxed input device
    
	if (!success) {
		videoDevice = [QTCaptureDevice defaultInputDeviceWithMediaType:QTMediaTypeMuxed];
		success = [videoDevice open:&error];
		
    }
    
    if (!success) {
        videoDevice = nil;
        // Handle error
        
    }
    
    if (videoDevice) {
//Add the video device to the session as a device input
		
		videoInputDevice = [[QTCaptureDeviceInput alloc] initWithDevice:videoDevice];
		success = [captureSession addInput:videoInputDevice error:&error];
		if (!success) {
			// Handle error
		}
        
// If the video device doesn't also supply audio, add an audio device input to the session
        
        if (![videoDevice hasMediaType:QTMediaTypeSound] && ![videoDevice hasMediaType:QTMediaTypeMuxed]) {
            
            QTCaptureDevice *audioDevice = [QTCaptureDevice defaultInputDeviceWithMediaType:QTMediaTypeSound];
            success = [audioDevice open:&error];
            
            if (!success) {
                audioDevice = nil;
                // Handle error
            }
            
            if (audioDevice) {
                audioInputDevice = [[QTCaptureDeviceInput alloc] initWithDevice:audioDevice];
                
                success = [captureSession addInput:audioInputDevice error:&error];
                if (!success) {
                    // Handle error
                }
            }
        }
        
// Create the movie file output and add it to the session
        
        mCaptureMovieFileOutput = [[QTCaptureMovieFileOutput alloc] init];
        success = [captureSession addOutput:mCaptureMovieFileOutput error:&error];
        if (!success) {
            // Handle error
        }
        
        [mCaptureMovieFileOutput setDelegate:self];


// Set the compression for the audio/video that is recorded to the hard disk.

	NSEnumerator *connectionEnumerator = [[mCaptureMovieFileOutput connections] objectEnumerator];
	QTCaptureConnection *connection;
	
	// iterate over each output connection for the capture session and specify the desired compression
	while ((connection = [connectionEnumerator nextObject])) {
		NSString *mediaType = [connection mediaType];
		QTCompressionOptions *compressionOptions = nil;
		// specify the video compression options
		// (note: a list of other valid compression types can be found in the QTCompressionOptions.h interface file)
		if ([mediaType isEqualToString:QTMediaTypeVideo]) {
			// use H.264
			compressionOptions = [QTCompressionOptions compressionOptionsWithIdentifier:@"QTCompressionOptions240SizeH264Video"];
		// specify the audio compression options
		} else if ([mediaType isEqualToString:QTMediaTypeSound]) {
			// use AAC Audio
			compressionOptions = [QTCompressionOptions compressionOptionsWithIdentifier:@"QTCompressionOptionsHighQualityAACAudio"];
		}
		
		// set the compression options for the movie file output
		[mCaptureMovieFileOutput setCompressionOptions:compressionOptions forConnection:connection];
	} 

// Associate the capture view in the UI with the session
        
        [mCaptureView setCaptureSession:captureSession];
        
        [captureSession startRunning];
        
	}
    
    
    NSUInteger j;
    
    [mButton setEnabled:FALSE];
    
    // allocate memory for the QTAudioFrequencyLevels struct and set it up
    // depending on the number of channels and frequency bands you want    
    mFreqResults = malloc(offsetof(QTAudioFrequencyLevels, level[numberOfBandLevels * numberOfChannels]));
    
    mFreqResults->numChannels = numberOfChannels;
    mFreqResults->numFrequencyBands = numberOfBandLevels;
    
    // create an array and load up the UI elements, each NSLevelIndicator has
    // the appropriate tag added in IB
    NSMutableArray *mArray = [NSMutableArray array];
    
	// somewhat cheezoid, but NSLevelIndicator doesn't allow us to create a vertical control
    // so we've created two views containing our controls and we rotate them to vertical
	[mMeterView1 setFrameRotation: 90.0];
    [mMeterView2 setFrameRotation: 90.0];
    
    // add each set of controls to an array we can later interate through
    // one for each channel
  	for (j = 0; j < mFreqResults->numFrequencyBands; j++) {
        id levelIndicator = [mMeterView1 viewWithTag:j];
        
        [levelIndicator setEnabled:FALSE]; // prevent values being changed by clicking on the indicators
        [mArray addObject:levelIndicator];
    }
    
  	for (j = 0; j < mFreqResults->numFrequencyBands; j++) {
        id levelIndicator = [mMeterView2 viewWithTag:j];
        
        [levelIndicator setEnabled:FALSE]; // prevent values being changed by clicking on the indicators
        [mArray addObject:levelIndicator];
    }
    self.indicatorsArray = [NSArray arrayWithArray: mArray];
}

// Handle window closing notifications for your device input

- (void)windowWillClose:(NSNotification *)notification
{
	
	[captureSession stopRunning];
    
    if ([[videoInputDevice device] isOpen])
        [[videoInputDevice device] close];
    
    if ([[audioInputDevice device] isOpen])
        [[audioInputDevice device] close];
    
}

// Handle deallocation of memory for your capture objects

- (void)dealloc
{
	[captureSession release];
	[videoInputDevice release];
    [audioInputDevice release];
	[mCaptureMovieFileOutput release];
	
	[super dealloc];
}

#pragma mark-

// Add these start and stop recording actions, and specify the output destination for your recorded media. The output is a QuickTime movie.

- (void)startRecording
{
        
    self.savingPathForRecord = [self generateFilePath];
    [mCaptureMovieFileOutput recordToOutputFileURL:[NSURL fileURLWithPath:self.recordPath]];
    self.isRecording = YES;
	self.shouldKeptSave = NO;

    
}

- (IBAction)startRecording:(id)sender
{
    if(sender)// triggered by a user's action, the values are set, because calls to NSUserDefaults might be expensive
        {
            [self performSelector:@selector(startRecording:) withObject:nil afterDelay: self.delayedStart * 60];

            self.treshold = [[NSUserDefaults standardUserDefaults]floatForKey:@"SoundLevelTreshold"];
            self.durationInMinutes = [[NSUserDefaults standardUserDefaults]floatForKey:@"DurationInMinutes"];
            self.delayedStart = [[NSUserDefaults standardUserDefaults]floatForKey:@"DelayedStartInMinutes"];
            self.shouldCascading = [[NSUserDefaults standardUserDefaults]floatForKey:@"RecordsShouldCascading"];
            // only if manually started and cascading is on
            if(self.shouldCascading)
                {
                    [self performSelector:@selector(stopRecording:) withObject:nil afterDelay: (self.delayedStart + self.durationInMinutes) * 60];
                    hourlyTimer = [NSTimer timerWithTimeInterval:3600.0 target:self selector:@selector(hourlySafeKeepings:) userInfo:nil repeats:YES];
                    [[NSRunLoop currentRunLoop] addTimer:hourlyTimer forMode:(NSString *)kCFRunLoopCommonModes];


                }
        }
    else [self startRecording];   

}

- (IBAction)stopRecording:(id)sender
{
    // Just for now, if restarted again as cascading, the value is always set from the defaults
    if(sender)
        self.shouldCascading = NO;
    [mCaptureMovieFileOutput recordToOutputFileURL:nil];

	//NSLog([self.records description]);
	NSString *path = [[self.savingPathForCheck stringByDeletingPathExtension]stringByAppendingPathExtension:@"plist"];
	//NSString *lastComponent = [self.savingPathForCheck lastPathComponent];
	//lastComponent = [[NSString stringWithFormat:@"%+1.2f ",maxValue]stringByAppendingString:lastComponent];
	//path = [path stringByAppendingPathComponent: lastComponent];
	
	if(NO==[self.records writeToFile:path atomically:YES])
		//NSLog(@"no index written");
        ;

}

- (void)captureOutput:(QTCaptureFileOutput *)captureOutput willFinishRecordingToOutputFileAtURL:(NSURL *)outputFileURL forConnections:(NSArray *)connections dueToError:(NSError *)error
{
 //   NSLog([connections description]);

}

// Do something with your QuickTime movie at the path you've specified at /Users/Shared/My Recorded Movie.mov"
- (void)captureOutput:(QTCaptureFileOutput *)captureOutput didStartRecordingToOutputFileURL:(NSURL *)fileURL forConnections:(NSArray *)connections
{
    self.isRecording = YES;
    NSLog([connections description]);

}
- (void)captureOutput:(QTCaptureFileOutput *)captureOutput didFinishRecordingToOutputFileAtURL:(NSURL *)outputFileURL forConnections:(NSArray *)connections dueToError:(NSError *)error
{
    self.isRecording = NO;
	//[[NSWorkspace sharedWorkspace] openURL:outputFileURL];
    // if finished, move the file asap from the recording path
    // then open it and check it.
    if([outputFileURL isFileURL])
        {
            NSString *path = [outputFileURL path];
            if([path isEqualToString:self.recordPath] && [[NSFileManager defaultManager]fileExistsAtPath:self.recordPath])
                {
                    BOOL ret = [[NSFileManager defaultManager] movePath:self.recordPath toPath: self.checkPath handler:nil];
                   // NSString *llog = ret? @"ok":@"somehow wrong";
                    // NSLog(@"File with Path %@ was %@", checkPath, llog);
                    if(!ret)
                        NSLog(@"File with Path %@ was somehow wrong!", checkPath);
                    self.savingPathForCheck = self.savingPathForRecord;

                }
            
            [self openMovie: self.checkPath];
        }
    if(self.shouldCascading)
        {
            [self startRecording:nil];
            [self performSelector:@selector(stopRecording:) withObject:nil afterDelay: self.durationInMinutes * 60];

        }
}

// open the QTMovie and set it in the view replacing the movie that was there
- (void)openMovie:(NSString *)inFile
{
    NSAlert *alert = nil;
    NSError *error = nil;
    
	if (mMovie != nil) {
        [mMovieView pause:self];
		[mMovieView setMovie:nil];
	}
    
    mMovie = [QTMovie movieWithFile:inFile error:&error];
    
    if (nil == error && mMovieView && [mMovieView isKindOfClass:[QTMovieView class]]) {
        if(NO == [[mMovieView window]isVisible])
            [[mMovieView window]makeKeyAndOrderFront:nil];
        
        [mMovie setRate: 8.0];//this does not work

        [[mMovieView window] setTitle:[self.savingPathForCheck lastPathComponent]];
         //[mMovie attributeForKey:QTMovieDisplayNameAttribute]];
        
        [mMovieView setMovie:mMovie];
        [mMovie setAttribute:[NSNumber numberWithBool:YES] forKey: QTMovieEditableAttribute];
        [mMovie setAttribute:[NSNumber numberWithFloat: 2.0] forKey: QTMoviePreferredRateAttribute];//this does  work, instead of setRate:
        
        [mMovieView setNeedsDisplay:TRUE];
        //QTTime duration = [mMovieView duration];
        
        //duration = QTMakeTime ( duration.timeValue, duration.timeScale/2);
        

        
        if (TRUE == [[mMovie attributeForKey:QTMovieHasAudioAttribute] boolValue]) {
            
            // do this once per movie to establish metering
            OSStatus err = SetMovieAudioFrequencyMeteringNumBands([mMovie quickTimeMovie], kQTAudioMeter_StereoMix, &numberOfBandLevels);
            if (err) {
            	// if something went wrong turn it off
            	[[mMovieView window] setTitle:[NSString stringWithFormat:@"Error %d", err]];
				
                [mButton setEnabled:FALSE];
                [mButton setState:NSOffState];
                [self toggleFreqLevels:self];
            } else {
            	[mButton setEnabled:TRUE];
                [mButton setState:NSOnState];
                [self toggleFreqLevels:self];

                [mMovieView play:nil];
                [[NSNotificationCenter defaultCenter]addObserver:self selector:@selector(checkDidEnd: ) name:QTMovieDidEndNotification object: mMovie];
            }
        } else {
            alert = [NSAlert alertWithMessageText:@"No Sound Track!"
                                    defaultButton:@"OK"
                                  alternateButton:nil
                                      otherButton:nil
                        informativeTextWithFormat:@"Open some media that contains audio if you're planing to see some frequency levels."];
            
            [alert runModal];
        }
    } else {
        [mButton setEnabled:FALSE];
        
        alert = [NSAlert alertWithError:error];
        
		[alert runModal];
    }
}

-(void) checkDidEnd:(NSNotification *)note
{

    [[NSNotificationCenter defaultCenter]removeObserver:self name:[note name] object:[note object]];
    
    if([[NSFileManager defaultManager]fileExistsAtPath:checkPath])
        {
            if(self.shouldKeptSave)
                {
                    //NSString *path = [self.savingPathForCheck stringByDeletingLastPathComponent];
                    //NSString *lastComponent = [self.savingPathForCheck lastPathComponent];
                    //lastComponent = [[NSString stringWithFormat:@"%+1.2f ",maxValue]stringByAppendingString:lastComponent];
                    //path = [path stringByAppendingPathComponent: lastComponent];
                    
                    [[NSFileManager defaultManager] movePath:checkPath toPath:self.savingPathForCheck handler:nil];
                }
            else
                [[NSFileManager defaultManager]removeFileAtPath:checkPath handler:nil];
            
            maxValue = 0.0;
            tempMaxValue = 0.0;

        }
}

- (void)hourlySafeKeepings:(NSTimer*)theTimer{
    [NSThread detachNewThreadSelector:@selector(threadedSafeKeepings) toTarget:self withObject:nil];
}

- (void)threadedSafeKeepings{
    NSString *path = [self.savingPathForRecord stringByDeletingLastPathComponent];
    NSString *destination = @"/Volumes/lonsing/Sites/JosefD/";
    NSString *destination2 = [[path stringByDeletingLastPathComponent]stringByAppendingPathComponent:@"OldMovies"];
    BOOL isDir;

    if (NO == ([[NSFileManager defaultManager] fileExistsAtPath:destination2 isDirectory:&isDir] && isDir))
        [[NSFileManager defaultManager]createDirectoryAtPath:destination2 attributes:nil];
    NSLog(path);
    NSArray *files =[[NSFileManager defaultManager] contentsOfDirectoryAtPath: path error:nil];
    if(files && [files count])
        {
            for(NSString *file in files)
                {
                    [[NSFileManager defaultManager] copyPath:[path stringByAppendingPathComponent:file] toPath:[destination stringByAppendingPathComponent:file] handler:nil];
                    [[NSFileManager defaultManager] movePath:[path stringByAppendingPathComponent:file] toPath:[destination2 stringByAppendingPathComponent:file] handler:nil];
                }
        }
    


    [[NSFileManager defaultManager] movePath:checkPath toPath:self.savingPathForCheck handler:nil];
    [[NSFileManager defaultManager] movePath:checkPath toPath:self.savingPathForCheck handler:nil];
    

}


// timer method to display the frequency levels in the UI
- (void)myTimerFireMethod:(NSTimer*)theTimer
{
	UInt8 i, j;
	NSEnumerator *enumerator = [self.indicatorsArray objectEnumerator]; // get a enumerator for the array of NSLevelIndicator objects
    //NSLog(@"Timer");
    // get the levels from the movie
	OSStatus err = GetMovieAudioFrequencyLevels([mMovie quickTimeMovie], kQTAudioMeter_StereoMix, mFreqResults);
    if (err) {
    	// something went wrong so turn it off
		[[mMovieView window] setTitle:[NSString stringWithFormat:@"Error %d", err]];
        
		[mButton setEnabled:FALSE];
        [mButton setState:NSOffState];
        [self toggleFreqLevels:self];
        
        return;
    }
    
    // iterate though the frequency level array and though the UI elements getting
    // and setting the levels appropriately
    for (i = 0; i < mFreqResults->numChannels; i++) {
        CGFloat overAllValue = 0.0;
    	for (j = 0; j < mFreqResults->numFrequencyBands; j++) {
        	// the frequency levels are Float32 values between 0. and 1.
            CGFloat value = (mFreqResults->level[(i * mFreqResults->numFrequencyBands) + j]);
            [[enumerator nextObject] setFloatValue:value * maxLevelIndicatorValue];

            overAllValue = value > overAllValue ? value : overAllValue;

        }
        if(overAllValue > self.treshold)
			{
                if(0.0 == tempMaxValue)
                    startTime = [mMovie currentTime];
                tempMaxValue = tempMaxValue < overAllValue ? overAllValue : tempMaxValue;
				maxValue = maxValue > overAllValue ? maxValue : overAllValue;
                
                self.shouldKeptSave = YES;
			}
        else if(tempMaxValue > 0.0)
            {
                if(nil == self.records)
                    self.records = [NSMutableArray array];
                QTTimeRange range = QTMakeTimeRange(startTime, [mMovie currentTime]);
                [self.records addObject:[NSArray arrayWithObjects:[NSNumber numberWithFloat:tempMaxValue],[NSValue valueWithQTTimeRange:range],self.savingPathForRecord, nil]];
                NSLog(@"%1.3f--%1.3f, %d", overAllValue, tempMaxValue, [self.records count]);
                tempMaxValue = 0.0;
            }
    }
}


// called when the button is pressed - turns the level meters on/off by setting up a timer
- (IBAction)toggleFreqLevels:(id)sender
{
    if (nil == checkTimer)//NSOnState == [mButton state]) {
        {
    	// turning it on, set up a timer and add it to the run loop
        checkTimer = [NSTimer timerWithTimeInterval:1.0/30 target:self selector:@selector(myTimerFireMethod:) userInfo:nil repeats:YES];
        
        [[NSRunLoop currentRunLoop] addTimer:checkTimer forMode:(NSString *)kCFRunLoopCommonModes];
    } else {
    	// turning it off invalidate the timer and make sure each level indicator is set to 0
    	NSEnumerator *enumerator = [self.indicatorsArray objectEnumerator];
    	id levelIndicator;
    	
        [checkTimer invalidate];
        checkTimer = nil;
        
        while (levelIndicator = [enumerator nextObject]) {
        	[levelIndicator setFloatValue:0.0];
        }
    }
}

#pragma mark - Video
// The methods for handling audio and video are almost identical.
// The problem, why they are different are the global instances of audio- and videoDevice,
// which need some more attention, especially the closing.
// Instead of being smart and designing single methods for all kind of device I'll leave it
// this way. IMHO it seems safer.

- (IBAction)selectVideoDevice:(id)sender{
    
    NSDictionary *allDevices = [[self class] allVideoDevices];
    NSUInteger index = [sender indexOfItem:[sender selectedItem]];
    NSString *name = [sender titleOfSelectedItem];
    id key = [[allDevices allKeys]objectAtIndex:index];
    //NSLog(@"selected audio-device %@  with ID:%@",name, [key className]);
    //            NSLog(@"selected audio-device %@ (%@) with ID:%@",name,[allDevices valueForKey:key], [key description]);
    if([name isEqualToString:[allDevices valueForKey:key]])
      {
          [self setVideoDeviceWithUniqueID:key];
      }
}


-(void)setVideoDeviceWithUniqueID:(NSString *)uniqueIdentifier
{
    QTCaptureDevice *videoDevice = [QTCaptureDevice deviceWithUniqueID:uniqueIdentifier];
    if(videoDevice)
      {	NSError *error;
          if([videoDevice open:&error])
            {
                QTCaptureDeviceInput *newVideoInputDevice = [[QTCaptureDeviceInput alloc] initWithDevice:videoDevice];
                [self setVideoInputDevice:newVideoInputDevice];
            }
          else
            {
                NSLog([error localizedDescription]);
                NSLog([error localizedFailureReason]);
                NSLog([error localizedRecoverySuggestion]);
            }
      }
}



-(void)setVideoInputDevice:(QTCaptureDeviceInput *)newDevice
{
    if(videoInputDevice !=  newDevice)
      {
          if([self videoInputDevice]!= nil)
            {
                [videoInputDevice retain];// just in case, because the device is released, once removed
                [captureSession removeInput:[self videoInputDevice]];
                if ([[videoInputDevice device] isOpen])
                    [[videoInputDevice device] close];
                [videoInputDevice release];
                videoInputDevice = nil;
            }
          if(videoInputDevice == nil && newDevice != nil)
            {	NSError *error;
                
                if([captureSession addInput:newDevice error:&error])
                  {
                      videoInputDevice = newDevice; // not a property
                  }
                else
                  {
                      if ([[newDevice device] isOpen])
                          [[newDevice device] close];
                      NSLog([error localizedDescription]);
                      NSLog([error localizedFailureReason]);
                      NSLog([error localizedRecoverySuggestion]);
                  }
            }
      }
}

-(QTCaptureDeviceInput *)videoInputDevice {
    return videoInputDevice;
}


#pragma mark - Audio

- (IBAction)selectAudioDevice:(id)sender
{
    NSDictionary *allDevices = [[self class] allAudioDevices];
    
    NSUInteger index = [sender indexOfItem:[sender selectedItem]];
    NSString *name = [sender titleOfSelectedItem];
    id key = [[allDevices allKeys]objectAtIndex:index];
    //NSLog(@"selected audio-device %@  with ID:%@",name, [key className]);
    //            NSLog(@"selected audio-device %@ (%@) with ID:%@",name,[allDevices valueForKey:key], [key description]);
    if([name isEqualToString:[allDevices valueForKey:key]])
      {
          [self setAudioDeviceWithUniqueID:key];
      }
    
}


-(void)setAudioDeviceWithUniqueID:(NSString *)uniqueIdentifier
{
    QTCaptureDevice *audioDevice = [QTCaptureDevice deviceWithUniqueID:uniqueIdentifier];
    if(audioDevice)
        {	NSError *error;
            if([audioDevice open:&error])
                {
                    QTCaptureDeviceInput *newAudioInputDevice = [[QTCaptureDeviceInput alloc] initWithDevice:audioDevice];
                    [self setAudioInputDevice:newAudioInputDevice];
                }
            else
                {
                    NSLog([error localizedDescription]);
                    NSLog([error localizedFailureReason]);
                    NSLog([error localizedRecoverySuggestion]);
                }
        }
}

-(void)setAudioInputDevice:(QTCaptureDeviceInput *)newDevice
{
    if(audioInputDevice !=  newDevice)
        {
            if([self audioInputDevice]!= nil)
                {
                    [audioInputDevice retain];// just in case, because the device is released, once removed
                    [captureSession removeInput:[self audioInputDevice]];
                    if ([[audioInputDevice device] isOpen])
                        [[audioInputDevice device] close];
                    [audioInputDevice release];
                    audioInputDevice = nil;
                }
            if(audioInputDevice == nil && newDevice != nil)
                {	NSError *error;
                    
                    if([captureSession addInput:newDevice error:&error])
                        {
                            audioInputDevice = newDevice;
                        }
                    else
                        {
                            if ([[newDevice device] isOpen])
                                [[newDevice device] close];
                            NSLog([error localizedDescription]);
                            NSLog([error localizedFailureReason]);
                            NSLog([error localizedRecoverySuggestion]);
                        }
                }
        }
}

-(QTCaptureDeviceInput *)audioInputDevice {
    return audioInputDevice;
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
    [mCaptureMovieFileOutput setDelegate:nil];//capturing
    [[NSNotificationCenter defaultCenter]removeObserver:self];// playing and checking

    [self stopRecording:nil];
    [mMovieView pause:nil];
	[mMovieView setMovie:nil];
	if([[NSFileManager defaultManager]fileExistsAtPath:self.recordPath])
		[[NSFileManager defaultManager]removeFileAtPath:recordPath handler:nil];
	
	if([[NSFileManager defaultManager]fileExistsAtPath:self.checkPath])
		[[NSFileManager defaultManager]removeFileAtPath:checkPath handler:nil];

}
@end
