//
//  CCHRecorderController.h
//  CCHRecorder


#import <Cocoa/Cocoa.h>
#import <QTKit/QTkit.h>

@interface CCHRecorderController : NSObject {
    
    IBOutlet QTCaptureView *mCaptureView;
    
    QTCaptureSession            *captureSession;
    QTCaptureMovieFileOutput    *mCaptureMovieFileOutput;
    QTCaptureDeviceInput        *videoInputDevice;
    QTCaptureDeviceInput        *audioInputDevice;
    
    
    QTMovie *mMovie;
    
    IBOutlet QTMovieView *	 mMovieView;
    IBOutlet NSView *        mMeterView1;
    IBOutlet NSView *        mMeterView2;
    IBOutlet NSButton *      mButton;
    
    QTAudioFrequencyLevels * mFreqResults;
    NSTimer * 				 checkTimer;
    NSTimer * 				 hourlyTimer;
    

    NSArray *		 indicatorsArray;

	NSMutableArray *records;
    BOOL isRecording;//easiest method
	BOOL shouldKeptSave;

    CGFloat delayedStart;
    CGFloat treshold;
    CGFloat maxValue;
    CGFloat tempMaxValue;
    QTTime startTime;
    BOOL shouldCascading;
    CGFloat durationInMinutes;

    NSString *recordPath;
    NSString *checkPath;
    NSString *savingPathForRecord;
    NSString *savingPathForCheck;

}

@property BOOL shouldKeptSave;
@property BOOL isRecording;
@property CGFloat treshold;

@property (retain) NSMutableArray *records;
@property (retain) NSArray * indicatorsArray;
@property (retain) NSString *recordPath;
@property (retain) NSString *checkPath;
@property (retain) NSString *savingPathForRecord;
@property (retain) NSString *savingPathForCheck;

@property BOOL shouldCascading;
@property CGFloat durationInMinutes, delayedStart;


+ (NSMutableDictionary *)allAudioDevices;
+ (NSMutableDictionary *)allVideoDevices;
- (NSArray *)allAvailableAudioDevicesByName;
- (NSArray *)allAvailableVideoDevicesByName;

- (IBAction)startRecording:(id)sender;
- (IBAction)stopRecording:(id)sender;
- (IBAction)selectAudioDevice:(id)sender;
- (IBAction)selectVideoDevice:(id)sender;


- (IBAction)toggleFreqLevels:(id)sender;

- (void)openMovie:(NSString *)inFile;

- (void)myTimerFireMethod:(NSTimer*)theTimer;

- (void)setVideoDeviceWithUniqueID:(NSString *)uniqueIdentifier;
- (void)setVideoInputDevice:(QTCaptureDeviceInput *)newDevice;
- (QTCaptureDeviceInput *)videoInputDevice;

- (void)setAudioDeviceWithUniqueID:(NSString *)uniqueIdentifier;
- (void)setAudioInputDevice:(QTCaptureDeviceInput *)newDevice;
- (QTCaptureDeviceInput *)audioInputDevice;
  
@end
