//
//  HOM.m
//  Demo
//
//  Created by Torsten Kammer on 28.05.09.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "HOM.h"


@interface HOMTrampoline : NSProxy
{
	SEL selector;
	id target;
	id parameter;
}
- (id)initWithSelector:(SEL)aSelector target:(id)aTarget parameter:(id)aParameter;

@end

@implementation HOMTrampoline

- (id)initWithSelector:(SEL)aSelector target:(id)aTarget parameter:(id)aParameter;
{
	selector = aSelector;
	target = aTarget;
	parameter = aParameter;
	
	return self;
}

- (NSMethodSignature *)methodSignatureForSelector:(SEL)aSelector
{
	return [target homMethodSignatureForSelector:aSelector];
}

- (void)forwardInvocation:(NSInvocation *)anInvocation
{
	[target performSelector:selector withObject:parameter withObject:anInvocation];
}

@end

@implementation NSObject (HOM)

- (id)performAfterDelay:(NSTimeInterval)delay;
{
	return [[[HOMTrampoline alloc] initWithSelector:@selector(performAfterDelay:withInvocation:) target:self parameter:[NSNumber numberWithDouble:delay]] autorelease];
}

- (void)performAfterDelay:(id)delay withInvocation:(NSInvocation *)invocation;
{
	[invocation performSelector:@selector(invokeWithTarget:) withObject:self afterDelay:[delay doubleValue]];
}

- (id)homMethodSignatureForSelector:(SEL)aSelector
{
	return [self methodSignatureForSelector:aSelector];
}

@end

@interface HOMEachMarker : NSObject
{
	NSEnumerator *enumerator;
}

- (id)initWithEnumerator:(NSEnumerator *)enumerator;
@property (nonatomic, readonly) NSEnumerator *enumerator;

@end

@implementation HOMEachMarker

@synthesize enumerator;

- (id)initWithEnumerator:(NSEnumerator *)anEnumerator;
{
	if ((self = [super init]) != nil)
	{
		enumerator = anEnumerator;
	}
	
	return self;
}

@end

@implementation NSArray (HOM)

- (id)doEach;
{
	return [[[HOMTrampoline alloc] initWithSelector:@selector(doEach:withInvocation:) target:self parameter:nil] autorelease];
}

- (id)each;
{
	return [[[HOMEachMarker alloc] initWithEnumerator:[self objectEnumerator]] autorelease];
}

- (id)homMethodSignatureForSelector:(SEL)aSelector
{
	return [[self objectAtIndex:0] methodSignatureForSelector:aSelector];
}

- (void)doEach:(id)unused withInvocation:(NSInvocation *)invocation;
{
	#define MAX_EACHS 10
	id enumerators[MAX_EACHS];
	memset(enumerators, 0, sizeof(enumerators));
	
	NSEnumerator *selfEnumerator = [self objectEnumerator];
	NSMutableArray *result = [[NSMutableArray alloc] initWithCapacity:[self count]];

	NSUInteger maxEnumerator = MIN(MAX_EACHS, [[invocation methodSignature] numberOfArguments] - 2);
	NSUInteger i;
	for (i = 0; i < maxEnumerator; i++)
	{
		if (strcmp([[invocation methodSignature] getArgumentTypeAtIndex:i + 2], @encode(id)) != 0) continue;
		id arg;
		[invocation getArgument:&arg atIndex:i + 2];
		if (![arg isKindOfClass:[HOMEachMarker class]]) continue;
		
		enumerators[i] = [arg enumerator];
	}
	
	while (YES)
	{
		BOOL atEnd = NO;
		for (i = 0; i < maxEnumerator; i++)
		{
			if (enumerators[i] == nil) continue;
			id nextObject = [enumerators[i] nextObject];
			if (nextObject == nil) atEnd = YES;
			else
				[invocation setArgument:&nextObject atIndex:i + 2];
		}
		if (atEnd) break;
		
		id nextSelf = [selfEnumerator nextObject];
		if (!nextSelf) break;
		

		[invocation invokeWithTarget:nextSelf];
		id invocationResult;
		[invocation getReturnValue:&invocationResult];
		[result addObject:invocationResult];

	}

	NSArray *resultImmutable = [[result copy] autorelease];
	[result release];

	[invocation setReturnValue:&resultImmutable];
}

@end

