#ifndef _LUMINET_H_
#define _LUMINET_H_


#define VECTOR_MESSAGE 0x04

#define EEPROM_VECTOR_ADDRESS 228

#include <avr/io.h>
#include <avr/boot.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <util/delay_basic.h>




//#include <stdint.h>
//#include <inttypes.h>



//only run topology scan and flood outputs (rs232) with binary connections information 
//#define TOPOLOGY_TEST 1

//define this if you want to see the result of the topologyscan (blinkin for each SNEW direction)
#define SHOW_TOPOLOGY_RESULT 1

///////MAGIC KEYS
#define START 0xA0
#define RESET 0xA1
#define DATA 0xB0
#define RETRANSMISSION 0xB1
#define END 0xC0

#define RED_ON (PORTA  |= (1 << RED_LED) ) 
#define RED_ON (PORTA  |= (1 << RED_LED) ) 
#define GREEN_ON (PORTA  |= (1 << GREEN_LED) )
#define BLUE_ON (PORTA  |= (1 << BLUE_LED) )

#define RED_OFF (PORTA  &= ~(1 << RED_LED) ) 
#define GREEN_OFF (PORTA  &= ~(1 << GREEN_LED) )
#define BLUE_OFF (PORTA  &= ~(1 << BLUE_LED) )

//void (*startApplication)( void ) = (void *)0x0000;  // pointer to application at flash start
//void (*startBootloader)( void ) = (void *)BOOTADR;  // pointer to the bootloader start address


#define RED_LED PA4
#define GREEN_LED PA5
#define BLUE_LED PA6

#define RED_ON (PORTA  |= (1 << RED_LED) ) 
#define RED_ON (PORTA  |= (1 << RED_LED) ) 
#define GREEN_ON (PORTA  |= (1 << GREEN_LED) )
#define BLUE_ON (PORTA  |= (1 << BLUE_LED) )

#define RED_OFF (PORTA  &= ~(1 << RED_LED) ) 
#define GREEN_OFF (PORTA  &= ~(1 << GREEN_LED) )
#define BLUE_OFF (PORTA  &= ~(1 << BLUE_LED) )



#define WEST 0
#define EAST 1
#define NORTH 2
#define SOUTH 3

#define	LEFT_TXDDR DDRA
#define	LEFT_TXPORT PORTA
#define	LEFT_TXPIN PINA
#define LEFT_TXPINNumber  PA2			
		
#define	LEFT_RXDDR  DDRA
#define	LEFT_RXPORT PORTA
#define	LEFT_RXPIN  PINA
#define	LEFT_RXPINNumber PA3			

#define	RIGHT_TXDDR DDRB
#define	RIGHT_TXPORT PORTB
#define	RIGHT_TXPIN PINB
#define RIGHT_TXPINNumber  PB1			
		
#define	RIGHT_RXDDR  DDRB
#define	RIGHT_RXPORT PORTB
#define	RIGHT_RXPIN  PINB
#define	RIGHT_RXPINNumber PB0			
	

#define	UP_TXDDR DDRB
#define	UP_TXPORT PORTB
#define	UP_TXPIN PINB
#define UP_TXPINNumber  PB2			
		
#define	UP_RXDDR  DDRA
#define	UP_RXPORT PORTA
#define	UP_RXPIN  PINA
#define	UP_RXPINNumber PA7

#define	DOWN_TXDDR DDRA
#define	DOWN_TXPORT PORTA
#define	DOWN_TXPIN PINA
#define DOWN_TXPINNumber  PA1			
		
#define	DOWN_RXDDR  DDRA
#define	DOWN_RXPORT PORTA
#define	DOWN_RXPIN  PINA
#define	DOWN_RXPINNumber PA0			


#endif

