//#include <stdint.h>
//#include <inttypes.h>
//#include <stdio.h>
//#include <stdlib.h>
#include <avr/io.h>
#include "topology.h"

#include "COM.h"
#include <avr/boot.h>
#include <avr/pgmspace.h>

#include <util/delay_basic.h>

#undef IS_VECTOR_NODE

int main(void)
{
	
	uint8_t connections;//bit7..0: SNEWSNEW - first nibble says: vector present, second says: normal neighbour present
	

	uint8_t* address = (uint8_t*) EEPROM_VECTOR_ADDRESS;
	
	
	//uint8_t calibrationValue;//the calibration value for the RC calibration from the eeprom
	//calibrationValue = eeprom_read_byte(0x01ff); /* the AVR053 application note stores the calibration value at this address */
	/*
	calibrationValue = eeprom_read_byte(0); // calibration value is stored in first byte of eeprom
    if(calibrationValue != 0xff){
        OSCCAL = calibrationValue;
    }
	*/
	
	cli();
	
	connections = eeprom_read_byte((uint8_t) address);//programm space code should have stored the connections here
	if(connections == 0xFF)//no connections found
	{
		topology_scan(&connections);//only terminates if no vector is found
	}
	eeprom_write_byte((uint8_t) address, 0xFF);//clear the eeprom byte because this is bootspace
			
	
	DDRA = 0xFF;
	
	COM_init();
	

_delay_loop_2(62510); // 250ms
_delay_loop_2(62510); // 250ms

RED_OFF;
GREEN_OFF;
BLUE_ON;
_delay_loop_2(60000);

	while(1)
	{
	
		if(connections >= 16)//everything was ok, I received code from a vector path
		{
			GREEN_ON;
					}
		else//I did not receive or send anything
		{
			RED_ON;
		}
	
	}
}



