#include "COM.h"

//void (*startBootloader)( void ) = (void *)BOOTADR;  // pointer to the bootloader start address

//destination: WEST, EAST, NORTH, SOUTH
//c: char to be send
void COM_putc(uint8_t destination, uint8_t c)
{
	void (*ptr) (uint8_t data);
	
	if(destination == WEST)
	{
		ptr = LEFT_putc;
	}
	else if(destination == EAST)
	{
		ptr = RIGHT_putc;
	}
	else if(destination == NORTH)
	{
		ptr = UP_putc;
	}
	else if(destination == SOUTH)
	{
		ptr = DOWN_putc;
	}
	
	ptr(c);
}

//source: WEST, EAST, NORTH, SOUTH
uint8_t COM_getc(uint8_t source)
{
	uint8_t c;
	uint8_t d;
	
	uint8_t (*ptr) (void);
	
	if(source == WEST)
	{
		ptr = LEFT_getc;
	}
	else if(source == EAST)
	{
		ptr = RIGHT_getc;
	}
	else if(source == NORTH)
	{
		ptr = UP_getc;
	}
	else if(source == SOUTH)
	{
		ptr = DOWN_getc;
	}
	
	c = ptr();
	if(c == 0xF0)
	{
		d = ptr();
		return d;
	}
	else if(c == 0xA0)
	{
		//startBootloader();
	}
	
	return 0x00;
}

