#include "topology.h"
//#include "COM.h"

#ifndef EEPROM_VECTOR_ADDRESS
#define EEPROM_VECTOR_ADDRESS 228
#endif

#undef IS_VECTOR_NODE

//performs a topology scan and vector detection 
//returns: connections variable: SNEWSNEW - first nibble is vector path, second nibble is connection indicator
//this function only returns connections if no vector node is present
//otherwise it loops forever, sending the vector_message
void topology_scan(uint8_t *connections)
{
//cli();
	uint16_t z;
		
	*connections = 0;

	//activate outputs, rise pull-ups. set outputs to high level
	DDRA = 0x76;
	PORTA = 0x89;
	DDRB= 0x06;
	PORTB = 0x01;
	
	//OUTPUTS TO LOW
	PORTA &= ~(0x06);
	PORTB &= ~(0x06);
	
	
	//say that the cable is ok, before we have a burning man...
	RED_ON;
		
		_delay_loop_2(62510); // 250ms
   
   
   for(z=0;z<250;z++)//check for connections
   {
		if(! (PINA & (1<<PA3) ) )
		{	
			*connections |= (1 << WEST);
		}
		
		if(! (PINA & (1<<PA7) ) )
		{	
			*connections |= (1 << NORTH);
		}
		
		if(! (PINA & (1<<PA0) ) )
		{	
			*connections |= (1 << SOUTH);
		}
		
		if(! (PINB & (1<<PB0) ) )
		{	
			*connections |= (1 << EAST);
		}
		_delay_loop_2(250); //1ms
	}//loop: 250*1ms = 250ms

   _delay_loop_2(62510); // 250ms
	   
	//OUTPUTS NOW HAVE BEEN LOW FOR 3*250ms = 750ms
		
		//OUTPUTS HIGH
		PORTA |= (0x06);
		PORTB |= (0x06);
	   _delay_loop_2(62510); // 250ms
	   _delay_loop_2(62510); // 250ms
	   
	   
	   
		for(z=0; z<500; z++)
	   {
		
			//sensor nodes do nothing
		
			_delay_loop_2(250); // 1ms
		}		
		
			
	RED_OFF;
	GREEN_OFF;
	BLUE_OFF;

		
	   _delay_loop_2(62510); // 250ms
	   _delay_loop_2(62510); // 250ms

	//tx lines now have been HIGH (normal node) / LOW (vector node) for 1500ms

		//tx lines high again
		PORTA |= (0x06);
		PORTB |= (0x06);
			
		_delay_loop_2(62510); // 250ms
			
		
#ifdef SHOW_TOPOLOGY_RESULT
		//show the result of the topology scan by blinking LEDs
		for(z=0;z<4;z++)
		{
			if(*connections & (16 << z) )
			{
				BLUE_ON;//a connection to a node on the vector path
				
			}
			else if(*connections & (1 << z) )
			{
				GREEN_ON;//a simple connection to another node
			}
			else
			{
				RED_ON;//no connection in this direction
			}
			
			_delay_loop_2(62510); // 250ms
			_delay_loop_2(62510); // 250ms
			RED_OFF;
			GREEN_OFF;
			BLUE_OFF;
		   _delay_loop_2(62510); // 250ms
		   _delay_loop_2(62510); // 250ms
		   	
		}
#endif
	
	//function only returns connections if no vector node is present
	//otherwise it starts the bootloader
	

	//eeprom_write_byte(address, *connections);//write vector message to eeprom
		
	


}

//If a vector is present, it sends a message to the vector path. This message is a single byte
//the byte is stored in the eeprom at address 228 and returned by this function
/*
uint8_t topology_getVectorMessage(void)
{
	uint8_t *address = EEPROM_VECTOR_ADDRESS; //adress to read from
	uint8_t data;
	data = eeprom_read_byte(address);
	return data;
	
	
	


}
*/