#ifndef _COM_H_
#define _COM_H_

#include <stdint.h>
#include <inttypes.h>
#include <util/delay_basic.h>



#define WEST 0
#define EAST 1
#define NORTH 2
#define SOUTH 3

#ifndef BOOTADR
#define BOOTADR 0x1A00
#endif


extern void COM_init(void);

//destination: WEST, EAST, NORTH, SOUTH
//c: char to be send
void COM_putc(uint8_t destination, uint8_t c);

//source: WEST, EAST, NORTH, SOUTH
uint8_t COM_getc(uint8_t source);


//DO NOT USE THESE FUNCTIONS:
//use them only in the bootloader code

extern void LEFT_putc(uint8_t c);//DO NOT USE!
extern uint8_t LEFT_getc(void);//DO NOT USE!

extern void RIGHT_putc(uint8_t c);//DO NOT USE!
extern uint8_t RIGHT_getc(void);//DO NOT USE!

extern void UP_putc(uint8_t c);//DO NOT USE!
extern uint8_t UP_getc(void);//DO NOT USE!

extern void DOWN_putc(uint8_t c);//DO NOT USE!
extern uint8_t DOWN_getc(void);//DO NOT USE!

#endif /* _COM_H_ */
