/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import com.sun.rmi.rmid.ExecOptionPermission;
import com.sun.rmi.rmid.ExecPermission;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.rmi.log.LogHandler;
import sun.rmi.log.ReliableLog;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.server.PipeWriter;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyFile;

public class Activation
implements Serializable,
Runnable {
    private static final long serialVersionUID = 2921265612698155191L;
    private static Registry registry;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 0;
    private static int nextRestart;
    private static Object execPolicy;
    private static Method execPolicyMethod;
    private static final String execPolicyMethodName = "checkExecCommand";
    private static final Class[] execPolicyMethodParamTypes;
    private static boolean debugExec;
    private Hashtable idTable = new Hashtable(101);
    private Hashtable groupTable = new Hashtable(53);
    private byte majorVersion = 1;
    private byte minorVersion = 0;
    private transient ReliableLog log;
    private transient int numUpdates = 0;
    private transient String[] command;
    private static final int snapshotInterval;
    private static final long execTimeout;
    private transient Activator activator;
    private transient Activator activatorStub;
    private transient ActivationSystem system;
    private transient ActivationSystem systemStub;
    private transient ActivationMonitor monitor;
    private volatile transient boolean shuttingDown = false;
    private transient Object startupLock;
    private transient Thread shutdownHook;
    private static ResourceBundle resources;
    private static int[] sem_startgroup;
    static Class class$java$rmi$activation$ActivationGroupDesc;
    static Class array$Ljava$lang$String;
    static Class class$sun$rmi$server$ActivationGroupImpl;
    static Class class$sun$rmi$server$Activation$DefaultExecPolicy;

    static int access$1904() {
        return ++nextRestart;
    }

    static long access$1700() {
        return execTimeout;
    }

    static {
        nextRestart = 0;
        execPolicyMethodParamTypes = new Class[]{class$java$rmi$activation$ActivationGroupDesc == null ? (class$java$rmi$activation$ActivationGroupDesc = Activation.class$("java.rmi.activation.ActivationGroupDesc")) : class$java$rmi$activation$ActivationGroupDesc, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Activation.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        snapshotInterval = Activation.getInt("sun.rmi.activation.snapshotInterval", 200);
        execTimeout = Activation.getInt("sun.rmi.activation.execTimeout", 30000);
        resources = null;
        Integer n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.rmid.maxstartgroup", 3));
        int[] nArray = new int[]{n2};
        sem_startgroup = nArray;
    }

    private Activation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void Pstartgroup() throws InterruptedException {
        int[] nArray = sem_startgroup;
        synchronized (sem_startgroup) {
            while (sem_startgroup[0] <= 0) {
                sem_startgroup.wait();
            }
            sem_startgroup[0] = sem_startgroup[0] - 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void Vstartgroup() {
        int[] nArray = sem_startgroup;
        synchronized (sem_startgroup) {
            sem_startgroup[0] = sem_startgroup[0] + 1;
            sem_startgroup.notifyAll();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void access$1500() throws InterruptedException {
        Activation.Pstartgroup();
    }

    static void access$1800() {
        Activation.Vstartgroup();
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkShutdown() throws ActivationException {
        Object object = this.startupLock;
        if (object != null) {
            Object object2 = object;
            // MONITORENTER : object2
            // MONITOREXIT : object2
        }
        if (!this.shuttingDown) return;
        throw new ActivationException("activation system is shutting down");
    }

    private void restartServices() {
        Enumeration enumeration = this.groupTable.keys();
        while (enumeration.hasMoreElements()) {
            ActivationGroupID activationGroupID = (ActivationGroupID)enumeration.nextElement();
            try {
                GroupEntry groupEntry = this.getGroupEntry(activationGroupID);
                groupEntry.restartServices();
            }
            catch (UnknownGroupException unknownGroupException) {
                System.err.println("\nrmid: unable to restart services");
                System.err.println("rmid: exception occurred:");
                unknownGroupException.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Activation.unexport(this.activator);
            Activation.unexport(this.system);
            Enumeration enumeration = this.groupTable.elements();
            while (enumeration.hasMoreElements()) {
                GroupEntry groupEntry = (GroupEntry)enumeration.nextElement();
                groupEntry.shutdown();
            }
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            Activation.unexport(this.monitor);
            try {
                this.log.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            System.err.println(Activation.getTextResource("rmid.daemon.shutdown"));
            System.exit(0);
        }
    }

    private synchronized void shutdownAll() {
        Thread thread = null;
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "RMID Shutdown", false));
        thread.start();
    }

    static boolean access$1600() {
        return debugExec;
    }

    private static void bomb(String string) {
        System.err.println("rmid: " + string);
        System.err.println(MessageFormat.format(Activation.getTextResource("rmid.usage"), new String[]{"rmid"}));
        System.exit(1);
    }

    private static int getInt(String string, int n2) {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n2));
    }

    private void initCommand(String[] stringArray) {
        this.command = new String[stringArray.length + 2];
        AccessController.doPrivileged(new PrivilegedAction(this){
            private final Activation this$0;

            public Object run() {
                try {
                    Activation.access$2300((Activation)this.this$0)[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                }
                catch (Exception exception) {
                    System.err.println(Activation.access$2400("rmid.unfound.java.home.property"));
                    Activation.access$2300((Activation)this.this$0)[0] = "java";
                }
                return null;
            }
            {
                this.this$0 = activation;
            }
        });
        System.arraycopy(stringArray, 0, this.command, 1, stringArray.length);
        this.command[this.command.length - 1] = "sun.rmi.server.ActivationGroupInit";
    }

    public static void main(String[] stringArray) {
        boolean bl2 = false;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            Object[] objectArray;
            int n2 = 1098;
            String string = "log";
            ArrayList arrayList = new ArrayList();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-port")) {
                    if (i2 + 1 < stringArray.length) {
                        try {
                            n2 = Integer.parseInt(stringArray[++i2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Activation.bomb(Activation.getTextResource("rmid.syntax.port.badnumber"));
                        }
                        continue;
                    }
                    Activation.bomb(Activation.getTextResource("rmid.syntax.port.missing"));
                    continue;
                }
                if (stringArray[i2].equals("-log")) {
                    if (i2 + 1 < stringArray.length) {
                        string = stringArray[++i2];
                        continue;
                    }
                    Activation.bomb(Activation.getTextResource("rmid.syntax.log.missing"));
                    continue;
                }
                if (stringArray[i2].equals("-stop")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].startsWith("-C")) {
                    arrayList.add(stringArray[i2].substring(2));
                    continue;
                }
                objectArray = new Object[]{stringArray[i2]};
                Activation.bomb(MessageFormat.format(Activation.getTextResource("rmid.syntax.illegal.option"), objectArray));
            }
            Boolean bl3 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.activation.debugExec"));
            debugExec = bl3;
            objectArray = (Object[])AccessController.doPrivileged(new GetPropertyAction("sun.rmi.activation.execPolicy", null));
            if (objectArray == null) {
                if (!bl2) {
                    DefaultExecPolicy.checkConfiguration();
                }
                objectArray = "default";
            }
            if (!objectArray.equals("none")) {
                if (objectArray.equals("") || objectArray.equals("default")) {
                    objectArray = (class$sun$rmi$server$Activation$DefaultExecPolicy == null ? (class$sun$rmi$server$Activation$DefaultExecPolicy = Activation.class$("sun.rmi.server.Activation$DefaultExecPolicy")) : class$sun$rmi$server$Activation$DefaultExecPolicy).getName();
                }
                try {
                    Class clazz = RMIClassLoader.loadClass((String)objectArray);
                    execPolicy = clazz.newInstance();
                    execPolicyMethod = clazz.getMethod(execPolicyMethodName, execPolicyMethodParamTypes);
                }
                catch (Exception exception) {
                    if (debugExec) {
                        System.err.println("rmid: exception obtaining exec policy");
                        exception.printStackTrace();
                    }
                    Activation.bomb(Activation.getTextResource("rmid.exec.policy.invalid"));
                }
            }
            if (bl2) {
                int n3 = n2;
                AccessController.doPrivileged(new PrivilegedAction(n3){
                    private final int val$finalPort;
                    {
                        this.val$finalPort = n2;
                    }

                    public Object run() {
                        System.setProperty("java.rmi.activation.port", Integer.toString(this.val$finalPort));
                        return null;
                    }
                });
                ActivationSystem activationSystem = ActivationGroup.getSystem();
                activationSystem.shutdown();
                System.exit(0);
            }
            registry = LocateRegistry.createRegistry(n2);
            Activation.startActivation(n2, string, (String[])arrayList.toArray(new String[arrayList.size()]));
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            System.err.println(MessageFormat.format(Activation.getTextResource("rmid.unexpected.exception"), objectArray));
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private static void unexport(Remote remote) {
        while (true) {
            try {
                while (!UnicastRemoteObject.unexportObject(remote, false)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    static void access$000(Activation activation) throws ActivationException {
        activation.checkShutdown();
    }

    static void access$1200(Activation activation) {
        activation.shutdownAll();
    }

    static boolean access$1302(Activation activation, boolean bl2) {
        activation.shuttingDown = bl2;
        return activation.shuttingDown;
    }

    Activation(1 var1_1) {
        this();
    }

    private synchronized void addLogRecord(LogRecord logRecord) throws ActivationException {
        Exception exception = null;
        try {
            this.log.update(logRecord, true);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        try {
            if (++this.numUpdates >= snapshotInterval || exception != null) {
                this.log.snapshot(this);
                this.numUpdates = 0;
            }
            if (exception != null) {
                System.err.println("\nrmid: warning, could not apply log record update but snapshot succeeded.");
                System.err.println("\nrmid: state is consistent. update exception was: ");
                exception.printStackTrace();
            }
        }
        catch (Exception exception3) {
            System.err.println("\nrmid: could not update update or snapshot log file");
            System.err.println("rmid: the activation system is shutting down");
            if (exception != null) {
                System.err.println("rmid: exception occurred during log update:");
                exception.printStackTrace();
            }
            System.err.println("rmid: exception occurred during log snapshot:");
            exception3.printStackTrace();
            try {
                ((ActivationSystemImpl)this.system).shutdown();
            }
            catch (AccessException accessException) {
                // empty catch block
            }
            throw new ActivationException("rmid could not update its log file", exception);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Object access$1100(Activation activation) {
        return activation.startupLock;
    }

    private static void startActivation(int n2, String string, String[] stringArray) throws Exception {
        ReliableLog reliableLog = new ReliableLog(string, new ActLogHandler());
        Activation activation = (Activation)reliableLog.recover();
        activation.init(n2, reliableLog, stringArray);
        activation.restartServices();
    }

    static String access$2400(String string) {
        return Activation.getTextResource(string);
    }

    private static String getTextResource(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.rmid.resources.rmid");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + string + "]";
            }
        }
        String string2 = null;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            return "[missing resource: " + string + "]";
        }
        return string2;
    }

    private String[] activationArgs(ActivationGroupDesc activationGroupDesc) {
        String[] stringArray;
        Properties properties;
        ActivationGroupDesc.CommandEnvironment commandEnvironment = activationGroupDesc.getCommandEnvironment();
        ArrayList arrayList = new ArrayList();
        arrayList.add(commandEnvironment != null && commandEnvironment.getCommandPath() != null ? commandEnvironment.getCommandPath() : this.command[0]);
        if (commandEnvironment != null && commandEnvironment.getCommandOptions() != null) {
            arrayList.addAll(Arrays.asList(commandEnvironment.getCommandOptions()));
        }
        if ((properties = activationGroupDesc.getPropertyOverrides()) != null) {
            Enumeration enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                arrayList.add("-D" + (String)stringArray + "=" + properties.getProperty((String)stringArray));
            }
        }
        for (int i2 = 1; i2 < this.command.length; ++i2) {
            arrayList.add(this.command[i2]);
        }
        stringArray = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    private void checkArgs(ActivationGroupDesc activationGroupDesc, String[] stringArray) throws SecurityException, ActivationException {
        if (execPolicyMethod != null) {
            if (stringArray == null) {
                stringArray = this.activationArgs(activationGroupDesc);
            }
            Object[] objectArray = new Object[]{activationGroupDesc, stringArray};
            try {
                execPolicyMethod.invoke(execPolicy, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SecurityException) {
                    throw (SecurityException)throwable;
                }
                throw new ActivationException("checkExecCommand: unexpected exception", invocationTargetException);
            }
            catch (Exception exception) {
                throw new ActivationException("checkExecCommand: unexpected exception", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int n2, ReliableLog reliableLog, String[] stringArray) throws Exception {
        this.log = reliableLog;
        this.numUpdates = 0;
        this.shutdownHook = (Thread)AccessController.doPrivileged(new NewThreadAction(new ShutdownHook(this), "RMID Shutdown Hook", false));
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Object object = this.startupLock = new Object();
        synchronized (this.startupLock) {
            this.activator = new ActivatorImpl(this, n2);
            this.activatorStub = (Activator)RemoteObject.toStub(this.activator);
            this.system = new ActivationSystemImpl(this, n2);
            this.systemStub = (ActivationSystem)RemoteObject.toStub(this.system);
            this.monitor = new ActivationMonitorImpl(this, n2);
            this.initCommand(stringArray);
            Naming.rebind("//:" + n2 + "/java.rmi.activation.ActivationSystem", this.system);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.startupLock = null;
            return;
        }
    }

    static String[] access$2300(Activation activation) {
        return activation.command;
    }

    private ActivationGroupID getGroupID(ActivationID activationID) throws UnknownObjectException {
        ActivationGroupID activationGroupID = (ActivationGroupID)this.idTable.get(activationID);
        if (activationGroupID == null) {
            throw new UnknownObjectException("unknown object: " + activationID);
        }
        return activationGroupID;
    }

    static ActivationMonitor access$900(Activation activation) {
        return activation.monitor;
    }

    static ActivationSystem access$600(Activation activation) {
        return activation.systemStub;
    }

    static Activator access$300(Activation activation) {
        return activation.activatorStub;
    }

    static Hashtable access$400(Activation activation) {
        return activation.idTable;
    }

    static Hashtable access$700(Activation activation) {
        return activation.groupTable;
    }

    private GroupEntry getGroupEntry(ActivationGroupID activationGroupID) throws UnknownGroupException {
        GroupEntry groupEntry = (GroupEntry)this.groupTable.get(activationGroupID);
        if (groupEntry == null) {
            throw new UnknownGroupException("unknown group: " + activationGroupID);
        }
        return groupEntry;
    }

    private GroupEntry getGroupEntry(ActivationID activationID) throws UnknownGroupException, UnknownObjectException {
        return this.getGroupEntry(this.getGroupID(activationID));
    }

    static void access$800(Activation activation, LogRecord logRecord) throws ActivationException {
        activation.addLogRecord(logRecord);
    }

    static String[] access$1400(Activation activation, ActivationGroupDesc activationGroupDesc) {
        return activation.activationArgs(activationGroupDesc);
    }

    static void access$500(Activation activation, ActivationGroupDesc activationGroupDesc, String[] stringArray) throws SecurityException, ActivationException {
        activation.checkArgs(activationGroupDesc, stringArray);
    }

    static ActivationGroupID access$1000(Activation activation, ActivationID activationID) throws UnknownObjectException {
        return activation.getGroupID(activationID);
    }

    static GroupEntry access$200(Activation activation, ActivationGroupID activationGroupID) throws UnknownGroupException {
        return activation.getGroupEntry(activationGroupID);
    }

    static GroupEntry access$100(Activation activation, ActivationID activationID) throws UnknownGroupException, UnknownObjectException {
        return activation.getGroupEntry(activationID);
    }

    private static class ActLogHandler
    extends LogHandler {
        ActLogHandler() {
        }

        public Object initialSnapshot() {
            return new Activation(null);
        }

        public Object applyUpdate(Object object, Object object2) throws Exception {
            return ((LogRecord)object).apply(object2);
        }
    }

    class ActivationMonitorImpl
    extends UnicastRemoteObject
    implements ActivationMonitor {
        private final Activation this$0;

        public void inactiveGroup(ActivationGroupID activationGroupID, long l2) throws UnknownGroupException, RemoteException {
            try {
                Activation.access$000(this.this$0);
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("ActivationMonitor.inactiveGroup");
            GroupEntry groupEntry = Activation.access$200(this.this$0, activationGroupID);
            groupEntry.inactiveGroup(l2);
        }

        public void inactiveObject(ActivationID activationID) throws UnknownObjectException, RemoteException {
            try {
                Activation.access$000(this.this$0);
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("Activator.inactiveObject");
            try {
                Activation.access$100(this.this$0, activationID).inactiveObject(activationID);
            }
            catch (UnknownGroupException unknownGroupException) {
                throw new UnknownObjectException("object's group removed");
            }
        }

        ActivationMonitorImpl(Activation activation, int n2) throws RemoteException {
            this.this$0 = activation;
            super(n2);
        }

        public void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, RemoteException {
            try {
                Activation.access$000(this.this$0);
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("ActivationSystem.activeObject");
            try {
                Activation.access$100(this.this$0, activationID).activeObject(activationID, marshalledObject);
            }
            catch (UnknownGroupException unknownGroupException) {
                throw new UnknownObjectException("object's group removed");
            }
        }
    }

    class ActivationSystemImpl
    extends RemoteServer
    implements ActivationSystem {
        private final Activation this$0;

        /*
         * Enabled aggressive block sorting
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void shutdown() throws AccessException {
            RegistryImpl.checkAccess("ActivationSystem.shutdown");
            Object object = Activation.access$1100(this.this$0);
            if (object != null) {
                Object object2 = object;
                // MONITORENTER : object2
                // MONITOREXIT : object2
            }
            Activation.access$1200(this.this$0);
        }

        public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.unregisterGroup");
            GroupEntry groupEntry = (GroupEntry)Activation.access$700(this.this$0).remove(activationGroupID);
            if (groupEntry == null) {
                throw new UnknownGroupException("unknown group: " + activationGroupID);
            }
            groupEntry.unregisterGroup(true);
        }

        public void unregisterObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.unregisterObject");
            ActivationGroupID activationGroupID = (ActivationGroupID)Activation.access$400(this.this$0).get(activationID);
            if (activationGroupID == null) {
                throw new UnknownObjectException("object not registered");
            }
            Activation.access$200(this.this$0, activationGroupID).unregisterObject(activationID, true);
        }

        ActivationSystemImpl(Activation activation, int n2) throws RemoteException {
            this.this$0 = activation;
            LiveRef liveRef = new LiveRef(new ObjID(4), n2);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null);
        }

        public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.getActivationDesc");
            return Activation.access$100(this.this$0, activationID).getActivationDesc(activationID);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.getActivationGroupDesc");
            return Activation.access$200((Activation)this.this$0, (ActivationGroupID)activationGroupID).desc;
        }

        public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.registerGroup");
            Activation.access$500(this.this$0, activationGroupDesc, null);
            ActivationGroupID activationGroupID = new ActivationGroupID(Activation.access$600(this.this$0));
            GroupEntry groupEntry = new GroupEntry(this.this$0, activationGroupID, activationGroupDesc);
            Activation.access$700(this.this$0).put(activationGroupID, groupEntry);
            Activation.access$800(this.this$0, new LogRegisterGroup(activationGroupID, activationGroupDesc));
            return activationGroupID;
        }

        public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.registerObject");
            ActivationGroupID activationGroupID = activationDesc.getGroupID();
            ActivationID activationID = new ActivationID(Activation.access$300(this.this$0));
            Activation.access$200(this.this$0, activationGroupID).registerObject(activationID, activationDesc, true);
            return activationID;
        }

        public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, UnknownObjectException, RemoteException {
            Activation.access$000(this.this$0);
            if (!Activation.access$1000(this.this$0, activationID).equals(activationDesc.getGroupID())) {
                throw new ActivationException("ActivationDesc contains wrong group");
            }
            RegistryImpl.checkAccess("ActivationSystem.setActivationDesc");
            return Activation.access$100(this.this$0, activationID).setActivationDesc(activationID, activationDesc, true);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.setActivationGroupDesc");
            Activation.access$500(this.this$0, activationGroupDesc, null);
            return Activation.access$200(this.this$0, activationGroupID).setActivationGroupDesc(activationGroupID, activationGroupDesc, true);
        }

        public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l2) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.access$000(this.this$0);
            RegistryImpl.checkAccess("ActivationSystem.activeGroup");
            Activation.access$200(this.this$0, activationGroupID).activeGroup(activationInstantiator, l2);
            return Activation.access$900(this.this$0);
        }
    }

    class ActivatorImpl
    extends RemoteServer
    implements Activator {
        private final Activation this$0;

        ActivatorImpl(Activation activation, int n2) throws RemoteException {
            this.this$0 = activation;
            LiveRef liveRef = new LiveRef(new ObjID(1), n2);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null);
        }

        public MarshalledObject activate(ActivationID activationID, boolean bl2) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.access$000(this.this$0);
            return Activation.access$100(this.this$0, activationID).activate(activationID, bl2);
        }
    }

    public static class DefaultExecPolicy {
        static void checkConfiguration() {
            Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Policy.getPolicy();
                }
            });
            if (!(policy instanceof PolicyFile)) {
                return;
            }
            PermissionCollection permissionCollection = DefaultExecPolicy.getExecPermissions();
            Enumeration enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = (Permission)enumeration.nextElement();
                if (!(permission instanceof AllPermission) && !(permission instanceof ExecPermission) && !(permission instanceof ExecOptionPermission)) continue;
                return;
            }
            System.err.println(Activation.access$2400("rmid.exec.perms.inadequate"));
        }

        private static PermissionCollection getExecPermissions() {
            PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CodeSource codeSource = new CodeSource(null, null);
                    Policy policy = Policy.getPolicy();
                    if (policy != null) {
                        return policy.getPermissions(codeSource);
                    }
                    return new Permissions();
                }
            });
            return permissionCollection;
        }

        public void checkExecCommand(ActivationGroupDesc activationGroupDesc, String[] stringArray) throws SecurityException {
            String string;
            Object object;
            Object object2;
            PermissionCollection permissionCollection = DefaultExecPolicy.getExecPermissions();
            Properties properties = activationGroupDesc.getPropertyOverrides();
            if (properties != null) {
                object2 = properties.propertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    string = "-D" + (String)object + "=" + properties.getProperty((String)object);
                    DefaultExecPolicy.checkPermission(permissionCollection, new ExecOptionPermission(string));
                }
            }
            if ((object2 = activationGroupDesc.getClassName()) != null && !((String)object2).equals((class$sun$rmi$server$ActivationGroupImpl == null ? (class$sun$rmi$server$ActivationGroupImpl = Activation.class$("sun.rmi.server.ActivationGroupImpl")) : class$sun$rmi$server$ActivationGroupImpl).getName()) || activationGroupDesc.getLocation() != null || activationGroupDesc.getData() != null) {
                throw new AccessControlException("access denied (custom group implementation not allowed)");
            }
            object = activationGroupDesc.getCommandEnvironment();
            if (object != null) {
                String[] stringArray2;
                string = ((ActivationGroupDesc.CommandEnvironment)object).getCommandPath();
                if (string != null) {
                    DefaultExecPolicy.checkPermission(permissionCollection, new ExecPermission(string));
                }
                if ((stringArray2 = ((ActivationGroupDesc.CommandEnvironment)object).getCommandOptions()) != null) {
                    for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                        DefaultExecPolicy.checkPermission(permissionCollection, new ExecOptionPermission(stringArray2[i2]));
                    }
                }
            }
        }

        private static void checkPermission(PermissionCollection permissionCollection, Permission permission) throws AccessControlException {
            if (!permissionCollection.implies(permission)) {
                throw new AccessControlException("access denied " + permission.toString());
            }
        }
    }

    private class GroupEntry
    implements Serializable {
        private static final long serialVersionUID = 7222464070032993304L;
        static final int MAX_TRIES = 2;
        ActivationGroupDesc desc;
        ActivationGroupID groupID;
        long incarnation;
        HashMap objects;
        HashSet restartSet;
        transient ActivationInstantiator group;
        transient boolean pendingCreate;
        transient Process child;
        transient boolean removed;
        transient RestartThread restartThread;
        private final Activation this$0;

        private void checkRemoved() throws UnknownGroupException {
            if (this.removed) {
                throw new UnknownGroupException("Group removed");
            }
        }

        private synchronized void disposeRestartThread() {
            if (this.restartThread != null) {
                this.restartThread.dispose();
                this.restartThread = null;
            }
        }

        private synchronized void ensureRestart() {
            Object var1_1 = null;
            if (this.restartSet.size() > 0 && this.restartThread == null && this.child != null) {
                this.restartThread = new RestartThread(this);
                this.restartThread.start();
            }
        }

        private synchronized void reset() {
            this.group = null;
            Iterator iterator = this.objects.values().iterator();
            while (iterator.hasNext()) {
                ((ObjectEntry)iterator.next()).reset();
            }
        }

        private synchronized void resetAll() {
            this.reset();
            if (this.child != null) {
                this.child.destroy();
                this.child = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartServices() {
            Iterator iterator = null;
            Serializable serializable = this;
            synchronized (serializable) {
                if (this.restartSet.size() == 0) {
                    return;
                }
                iterator = ((HashSet)this.restartSet.clone()).iterator();
            }
            while (iterator.hasNext()) {
                serializable = (ActivationID)iterator.next();
                try {
                    this.activate((ActivationID)serializable, true);
                }
                catch (Exception exception) {
                    System.err.println("\nrmid: unable to restart service");
                    System.err.println("rmid: exception occurred: " + exception.getMessage());
                    exception.printStackTrace(System.err);
                }
            }
        }

        synchronized void shutdown() {
            this.resetAll();
            this.disposeRestartThread();
        }

        void shutdownFast() {
            if (this.child != null) {
                this.child.destroy();
            }
        }

        synchronized void inactiveGroup(long l2) throws UnknownGroupException {
            this.checkRemoved();
            if (this.incarnation != l2) {
                throw new UnknownGroupException("invalid incarnation");
            }
            this.disposeRestartThread();
            if (!this.pendingCreate) {
                this.reset();
            }
        }

        synchronized void unregisterGroup(boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.removed = true;
            Iterator iterator = this.objects.keySet().iterator();
            while (iterator.hasNext()) {
                ActivationID activationID = (ActivationID)iterator.next();
                Activation.access$400(this.this$0).remove(activationID);
                ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
                objectEntry.removed = true;
            }
            this.objects.clear();
            this.restartSet.clear();
            this.disposeRestartThread();
            if (bl2) {
                Activation.access$800(this.this$0, new LogUnregisterGroup(this.groupID));
            }
            if (this.pendingCreate) {
                this.notifyAll();
            }
        }

        synchronized void inactiveObject(ActivationID activationID) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            objectEntry.reset();
        }

        synchronized void unregisterObject(ActivationID activationID, boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.remove(activationID);
            objectEntry.removed = true;
            if (objectEntry.desc.getRestartMode()) {
                this.restartSet.remove(activationID);
                if (this.restartSet.size() == 0) {
                    this.disposeRestartThread();
                }
            }
            Activation.access$400(this.this$0).remove(activationID);
            if (bl2) {
                Activation.access$800(this.this$0, new LogUnregisterObject(activationID));
            }
        }

        synchronized void activeGroup(ActivationInstantiator activationInstantiator, long l2) throws ActivationException, UnknownGroupException {
            if (this.child != null && !this.pendingCreate) {
                throw new ActivationException("group not being created");
            }
            if (this.incarnation != l2) {
                throw new ActivationException("invalid incarnation");
            }
            if (this.group != null) {
                throw new ActivationException("group already active");
            }
            this.group = activationInstantiator;
            this.pendingCreate = false;
            this.notifyAll();
        }

        static void access$2000(GroupEntry groupEntry) {
            groupEntry.reset();
        }

        synchronized void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            objectEntry.stub = marshalledObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MarshalledObject activate(ActivationID activationID, boolean bl2) throws ActivationException {
            ObjectEntry objectEntry;
            Serializable serializable = this;
            synchronized (serializable) {
                objectEntry = (ObjectEntry)this.objects.get(activationID);
            }
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown " + activationID);
            }
            if (!bl2) {
                serializable = this;
                synchronized (serializable) {
                    if (objectEntry.stub != null) {
                        return objectEntry.stub;
                    }
                }
            }
            serializable = null;
            Object var5_6 = null;
            for (int i2 = 2; i2 > 0; --i2) {
                long l2;
                boolean bl3;
                block23: {
                    ActivationInstantiator activationInstantiator;
                    bl3 = false;
                    GroupEntry groupEntry = this;
                    synchronized (groupEntry) {
                        activationInstantiator = this.getInstantiator(this.groupID);
                        l2 = this.incarnation;
                    }
                    try {
                        return objectEntry.activate(activationID, bl2, activationInstantiator);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        bl3 = true;
                        if (serializable == null) {
                            serializable = noSuchObjectException;
                        }
                    }
                    catch (ConnectException connectException) {
                        bl3 = true;
                        if (serializable == null) {
                            serializable = connectException;
                        }
                    }
                    catch (ConnectIOException connectIOException) {
                        bl3 = true;
                        if (serializable == null) {
                            serializable = connectIOException;
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (serializable != null) break block23;
                        serializable = remoteException;
                    }
                }
                if (!bl3) continue;
                try {
                    Activation.access$200(this.this$0, this.groupID).inactiveGroup(l2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new ActivationException("object activation failed after 2 tries", (Throwable)serializable);
        }

        synchronized ActivationDesc getActivationDesc(ActivationID activationID) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            return objectEntry.desc;
        }

        synchronized void registerObject(ActivationID activationID, ActivationDesc activationDesc, boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.objects.put(activationID, new ObjectEntry(activationDesc));
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
                this.ensureRestart();
            }
            Activation.access$400(this.this$0).put(activationID, this.groupID);
            if (bl2) {
                Activation.access$800(this.this$0, new LogRegisterObject(activationID, activationDesc));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized ActivationInstantiator getInstantiator(ActivationGroupID activationGroupID) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.group != null) {
                return this.group;
            }
            try {
                if (!this.pendingCreate) {
                    String[] stringArray = Activation.access$1400(this.this$0, this.desc);
                    Activation.access$500(this.this$0, this.desc, stringArray);
                    this.resetAll();
                    this.pendingCreate = true;
                    try {
                        Object object;
                        try {
                            Activation.access$1500();
                            bl2 = true;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (Activation.access$1600()) {
                            object = new StringBuffer(stringArray[0]);
                            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                                ((StringBuffer)object).append(' ');
                                ((StringBuffer)object).append(stringArray[i2]);
                            }
                            System.err.println("rmid: debugExec: running \"" + ((StringBuffer)object).toString() + "\"");
                        }
                        this.child = Runtime.getRuntime().exec(stringArray);
                        ++this.incarnation;
                        this.ensureRestart();
                        object = this.child.getOutputStream();
                        MarshalOutputStream marshalOutputStream = new MarshalOutputStream((OutputStream)object);
                        marshalOutputStream.writeObject(activationGroupID);
                        marshalOutputStream.writeObject(this.desc);
                        marshalOutputStream.writeLong(this.incarnation);
                        marshalOutputStream.flush();
                        marshalOutputStream.close();
                        PipeWriter.plugTogetherPair(this.child.getInputStream(), System.out, this.child.getErrorStream(), System.err);
                        Activation.access$800(this.this$0, new LogGroupIncarnation(activationGroupID, this.incarnation));
                    }
                    catch (IOException iOException) {
                        this.pendingCreate = false;
                        this.resetAll();
                        throw new ActivationException("unable to create activation group", iOException);
                    }
                }
                try {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 + Activation.access$1700();
                    do {
                        this.wait(l3 - l2);
                    } while (this.group == null && !this.removed && (l2 = System.currentTimeMillis()) < l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.group == null) {
                    this.pendingCreate = false;
                    this.resetAll();
                    throw new ActivationException(this.removed ? "activation group unregistered" : "timeout creating child process");
                }
            }
            finally {
                if (bl2) {
                    Activation.access$1800();
                }
                bl2 = false;
            }
            return this.group;
        }

        synchronized ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc, boolean bl2) throws UnknownObjectException, UnknownGroupException, ActivationException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            ActivationDesc activationDesc2 = objectEntry.desc;
            objectEntry.desc = activationDesc;
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
                this.ensureRestart();
            } else {
                this.restartSet.remove(activationID);
                if (this.restartSet.size() == 0) {
                    this.disposeRestartThread();
                }
            }
            if (bl2) {
                Activation.access$800(this.this$0, new LogUpdateDesc(activationID, activationDesc));
            }
            return activationDesc2;
        }

        synchronized ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ActivationGroupDesc activationGroupDesc2 = this.desc;
            this.desc = activationGroupDesc;
            if (bl2) {
                Activation.access$800(this.this$0, new LogUpdateGroupDesc(activationGroupID, activationGroupDesc));
            }
            return activationGroupDesc2;
        }

        GroupEntry(Activation activation, ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.this$0 = activation;
            this.desc = null;
            this.groupID = null;
            this.incarnation = 0L;
            this.objects = null;
            this.restartSet = null;
            this.group = null;
            this.pendingCreate = false;
            this.child = null;
            this.removed = false;
            this.restartThread = null;
            this.groupID = activationGroupID;
            this.desc = activationGroupDesc;
            this.objects = new HashMap(11);
            this.restartSet = new HashSet();
        }

        private class RestartThread
        extends Thread {
            private final Process groupProcess;
            private final long groupIncarnation;
            private boolean canInterrupt;
            private boolean shouldQuit;
            private final GroupEntry this$1;

            void dispose() {
                this.shouldQuit = true;
                if (this.canInterrupt) {
                    this.interrupt();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.shouldQuit) {
                    return;
                }
                try {
                    this.groupProcess.waitFor();
                    GroupEntry groupEntry = this.this$1;
                    synchronized (groupEntry) {
                        Thread.interrupted();
                        this.canInterrupt = false;
                        if (this.shouldQuit) {
                            return;
                        }
                        if (this.groupIncarnation == this.this$1.incarnation) {
                            GroupEntry.access$2000(this.this$1);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.this$1.restartServices();
            }

            RestartThread(GroupEntry groupEntry) {
                this.this$1 = groupEntry;
                super("RMID RestartObjects-" + Activation.access$1904());
                this.groupProcess = this.this$1.child;
                this.groupIncarnation = this.this$1.incarnation;
                this.canInterrupt = true;
                this.shouldQuit = false;
                this.setDaemon(true);
            }
        }
    }

    private static class LogGroupIncarnation
    extends LogRecord {
        private static final long serialVersionUID = 4146872747377631897L;
        private ActivationGroupID id;
        private long inc;

        LogGroupIncarnation(ActivationGroupID activationGroupID, long l2) {
            super(null);
            this.id = activationGroupID;
            this.inc = l2;
        }

        Object apply(Object object) {
            try {
                GroupEntry groupEntry = Activation.access$200((Activation)object, this.id);
                groupEntry.incarnation = this.inc;
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterGroup: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static abstract class LogRecord
    implements Serializable {
        private static final long serialVersionUID = 8395140512322687529L;

        private LogRecord() {
        }

        LogRecord(1 var1_1) {
            this();
        }

        abstract Object apply(Object var1) throws Exception;
    }

    private static class LogRegisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -1966827458515403625L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        Object apply(Object object) {
            Hashtable hashtable = Activation.access$700((Activation)object);
            Activation activation = (Activation)object;
            activation.getClass();
            hashtable.put(this.id, new GroupEntry(activation, this.id, this.desc));
            return object;
        }

        LogRegisterGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            super(null);
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }
    }

    private static class LogRegisterObject
    extends LogRecord {
        private static final long serialVersionUID = -6280336276146085143L;
        private ActivationID id;
        private ActivationDesc desc;

        Object apply(Object object) {
            try {
                Activation.access$200((Activation)object, this.desc.getGroupID()).registerObject(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogRegisterObject: skipping...");
                exception.printStackTrace();
            }
            return object;
        }

        LogRegisterObject(ActivationID activationID, ActivationDesc activationDesc) {
            super(null);
            this.id = activationID;
            this.desc = activationDesc;
        }
    }

    private static class LogUnregisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -3356306586522147344L;
        private ActivationGroupID id;

        LogUnregisterGroup(ActivationGroupID activationGroupID) {
            super(null);
            this.id = activationGroupID;
        }

        Object apply(Object object) {
            GroupEntry groupEntry = (GroupEntry)Activation.access$700((Activation)object).remove(this.id);
            try {
                groupEntry.unregisterGroup(false);
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterGroup: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUnregisterObject
    extends LogRecord {
        private static final long serialVersionUID = 6269824097396935501L;
        private ActivationID id;

        LogUnregisterObject(ActivationID activationID) {
            super(null);
            this.id = activationID;
        }

        Object apply(Object object) {
            try {
                Activation.access$100((Activation)object, this.id).unregisterObject(this.id, false);
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterObject: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUpdateDesc
    extends LogRecord {
        private static final long serialVersionUID = 545511539051179885L;
        private ActivationID id;
        private ActivationDesc desc;

        Object apply(Object object) {
            try {
                Activation.access$100((Activation)object, this.id).setActivationDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogUpdateDesc: skipping...");
                exception.printStackTrace();
            }
            return object;
        }

        LogUpdateDesc(ActivationID activationID, ActivationDesc activationDesc) {
            super(null);
            this.id = activationID;
            this.desc = activationDesc;
        }
    }

    private static class LogUpdateGroupDesc
    extends LogRecord {
        private static final long serialVersionUID = -1271300989218424337L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        Object apply(Object object) {
            try {
                Activation.access$200((Activation)object, this.id).setActivationGroupDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogUpdateGroupDesc: skipping...");
                exception.printStackTrace();
            }
            return object;
        }

        LogUpdateGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            super(null);
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }
    }

    private static class ObjectEntry
    implements Serializable {
        ActivationDesc desc;
        transient MarshalledObject stub = null;
        transient boolean removed = false;

        void reset() {
            this.stub = null;
        }

        ObjectEntry(ActivationDesc activationDesc) {
            this.desc = activationDesc;
        }

        synchronized MarshalledObject activate(ActivationID activationID, boolean bl2, ActivationInstantiator activationInstantiator) throws RemoteException, ActivationException {
            MarshalledObject marshalledObject;
            if (this.removed) {
                throw new UnknownObjectException("object removed");
            }
            if (!bl2 && this.stub != null) {
                return this.stub;
            }
            this.stub = marshalledObject = activationInstantiator.newInstance(activationID, this.desc);
            return marshalledObject;
        }
    }

    private class ShutdownHook
    implements Runnable {
        private final Activation this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Activation.access$1302(this.this$0, true);
            Hashtable hashtable = Activation.access$700(this.this$0);
            synchronized (hashtable) {
                Enumeration enumeration = Activation.access$700(this.this$0).elements();
                while (enumeration.hasMoreElements()) {
                    GroupEntry groupEntry = (GroupEntry)enumeration.nextElement();
                    groupEntry.shutdownFast();
                }
            }
        }

        ShutdownHook(Activation activation) {
            this.this$0 = activation;
        }
    }
}

