/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.URLJarFileCallBack;

public class URLJarFile
extends JarFile {
    private static URLJarFileCallBack callback = null;
    private static int BUF_SIZE = 2048;
    private Manifest superMan;
    private Attributes superAttr;
    private Map superEntries;

    static int access$000() {
        return BUF_SIZE;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private synchronized boolean isSuperMan() throws IOException {
        if (this.superMan == null) {
            this.superMan = super.getManifest();
        }
        if (this.superMan != null) {
            this.superAttr = this.superMan.getMainAttributes();
            this.superEntries = this.superMan.getEntries();
            return true;
        }
        return false;
    }

    public URLJarFile(File file) throws IOException {
        super(file, true, 5);
    }

    private URLJarFile(URL uRL) throws IOException {
        super(ParseUtil.decode(uRL.getFile()));
    }

    private static boolean isFileURL(URL uRL) {
        String string;
        return uRL.getProtocol().equalsIgnoreCase("file") && ((string = uRL.getHost()) == null || string.equals("") || string.equals("~") || string.equals("localhost"));
    }

    public Manifest getManifest() throws IOException {
        if (!this.isSuperMan()) {
            return null;
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putAll((Map)this.superAttr.clone());
        if (this.superEntries != null) {
            Map map = manifest.getEntries();
            Iterator iterator = this.superEntries.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                Attributes attributes2 = (Attributes)this.superEntries.get(object);
                map.put(object, attributes2.clone());
            }
        }
        return manifest;
    }

    static boolean access$100(URLJarFile uRLJarFile) throws IOException {
        return uRLJarFile.isSuperMan();
    }

    public static void setCallBack(URLJarFileCallBack uRLJarFileCallBack) {
        callback = uRLJarFileCallBack;
    }

    static Map access$200(URLJarFile uRLJarFile) {
        return uRLJarFile.superEntries;
    }

    static JarFile getJarFile(URL uRL) throws IOException {
        if (URLJarFile.isFileURL(uRL)) {
            return new URLJarFile(uRL);
        }
        return URLJarFile.retrieve(uRL);
    }

    private static JarFile retrieve(URL uRL) throws IOException {
        if (callback != null) {
            return callback.retrieve(uRL);
        }
        JarFile jarFile = null;
        InputStream inputStream = uRL.openConnection().getInputStream();
        try {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(inputStream){
                private final InputStream val$in;
                {
                    this.val$in = inputStream;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    URLJarFile uRLJarFile;
                    FileOutputStream fileOutputStream;
                    block5: {
                        fileOutputStream = null;
                        try {
                            File file = File.createTempFile("jar_cache", null);
                            fileOutputStream = new FileOutputStream(file);
                            int n2 = 0;
                            byte[] byArray = new byte[URLJarFile.access$000()];
                            while ((n2 = this.val$in.read(byArray)) != -1) {
                                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                            }
                            ((OutputStream)fileOutputStream).close();
                            fileOutputStream = null;
                            uRLJarFile = new URLJarFile(file);
                            Object var7_6 = null;
                            if (this.val$in == null) break block5;
                        }
                        catch (Throwable throwable) {
                            block6: {
                                Object var7_7 = null;
                                if (this.val$in != null) {
                                    this.val$in.close();
                                }
                                if (fileOutputStream == null) break block6;
                                ((OutputStream)fileOutputStream).close();
                            }
                            throw throwable;
                        }
                        this.val$in.close();
                    }
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                    return uRLJarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return jarFile;
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            if (zipEntry instanceof JarEntry) {
                return new URLJarFileEntry(this, (JarEntry)zipEntry);
            }
            throw new InternalError(super.getClass() + " returned unexpected entry type " + zipEntry.getClass());
        }
        return null;
    }

    private class URLJarFileEntry
    extends JarEntry {
        private JarEntry je;
        private final URLJarFile this$0;

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = this.je.getCertificates();
            return certificateArray == null ? null : (Certificate[])certificateArray.clone();
        }

        public Attributes getAttributes() throws IOException {
            Attributes attributes;
            Map map;
            if (URLJarFile.access$100(this.this$0) && (map = URLJarFile.access$200(this.this$0)) != null && (attributes = (Attributes)map.get(this.getName())) != null) {
                return (Attributes)attributes.clone();
            }
            return null;
        }

        URLJarFileEntry(URLJarFile uRLJarFile, JarEntry jarEntry) {
            this.this$0 = uRLJarFile;
            super(jarEntry);
            this.je = jarEntry;
        }
    }
}

