/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.awt.DebugHelperImpl;

final class DebugSettings {
    static final String PREFIX = "awtdebug";
    static final String PROP_FILE = "properties";
    private static final String[] DEFAULT_PROPS = new String[]{"awtdebug.assert=true", "awtdebug.trace=false", "awtdebug.on=true", "awtdebug.ctrace=false"};
    private static DebugSettings instance = null;
    private Properties props = new Properties();

    private DebugSettings() {
        new PrivilegedAction(this){
            private final DebugSettings this$0;

            public Object run() {
                DebugSettings.access$000(this.this$0);
                return null;
            }
            {
                this.this$0 = debugSettings;
            }
        }.run();
    }

    private void loadDefaultProperties() {
        try {
            for (int i2 = 0; i2 < DEFAULT_PROPS.length; ++i2) {
                StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(DEFAULT_PROPS[i2]);
                this.props.load(stringBufferInputStream);
                stringBufferInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadFileProperties() {
        String string = System.getProperty("awtdebug.properties", "");
        if (string.equals("")) {
            string = System.getProperty("user.home", "") + File.separator + PREFIX + "." + PROP_FILE;
        }
        File file = new File(string);
        try {
            this.println("Reading debug settings from '" + file.getCanonicalPath() + "'...");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.props.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.println("Did not find settings file.");
        }
        catch (IOException iOException) {
            this.println("Problem reading settings, IOException: " + iOException.getMessage());
        }
    }

    private synchronized void loadProperties() {
        AccessController.doPrivileged(new PrivilegedAction(this){
            private final DebugSettings this$0;

            public Object run() {
                DebugSettings.access$100(this.this$0);
                DebugSettings.access$200(this.this$0);
                DebugSettings.access$300(this.this$0);
                return null;
            }
            {
                this.this$0 = debugSettings;
            }
        });
        this.println(this);
    }

    private void loadSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            if (!string.startsWith(PREFIX)) continue;
            this.props.setProperty(string, string2);
        }
    }

    private void println(Object object) {
        DebugHelperImpl.printlnImpl(object.toString());
    }

    public String toString() {
        Enumeration enumeration = this.props.propertyNames();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println("------------------");
        printStream.println("AWT Debug Settings");
        printStream.println("------------------");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.props.getProperty(string, "");
            printStream.println(string + "=" + string2);
        }
        printStream.println("------------------");
        return new String(byteArrayOutputStream.toByteArray());
    }

    public synchronized int getInt(String string, int n2) {
        String string2 = this.getString(string, String.valueOf(n2));
        return Integer.parseInt(string2);
    }

    public synchronized boolean getBoolean(String string, boolean bl2) {
        String string2 = this.getString(string, String.valueOf(bl2));
        return string2.equalsIgnoreCase("true");
    }

    public synchronized Enumeration getPropertyNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            string = string.substring(PREFIX.length() + 1);
            vector.addElement(string);
        }
        return vector.elements();
    }

    static DebugSettings getInstance() {
        if (instance == null) {
            instance = new DebugSettings();
        }
        return instance;
    }

    static void access$000(DebugSettings debugSettings) {
        debugSettings.loadProperties();
    }

    static void access$100(DebugSettings debugSettings) {
        debugSettings.loadDefaultProperties();
    }

    static void access$200(DebugSettings debugSettings) {
        debugSettings.loadFileProperties();
    }

    static void access$300(DebugSettings debugSettings) {
        debugSettings.loadSystemProperties();
    }

    public synchronized String getString(String string, String string2) {
        String string3 = "awtdebug." + string;
        String string4 = this.props.getProperty(string3, string2);
        return string4;
    }
}

