/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String WARNING = "WARNING.";
    public static final String ERROR_FOUND = "At least one error was found!";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xalan.jar", "xalansamples.jar", "xalanj1compat.jar", "xalanservlet.jar", "xerces.jar", "xercesImpl.jar", "testxsl.jar", "crimson.jar", "lotusxsl.jar", "jaxp.jar", "parser.jar", "dom.jar", "sax.jar", "xml.jar", "xml-apis.jar", "xsltc.jar"};
    protected static Hashtable jarVersions = new Hashtable();
    protected PrintWriter outWriter = new PrintWriter(System.out, true);
    static Class class$java$lang$String;
    static Class class$org$xml$sax$Attributes;
    static Class class$java$lang$Thread;
    static Class class$org$apache$xalan$xslt$EnvironmentCheck;

    static {
        jarVersions.put(new Long(857192L), "xalan.jar from xalan-j_1_1");
        jarVersions.put(new Long(440237L), "xalan.jar from xalan-j_1_2");
        jarVersions.put(new Long(436094L), "xalan.jar from xalan-j_1_2_1");
        jarVersions.put(new Long(426249L), "xalan.jar from xalan-j_1_2_2");
        jarVersions.put(new Long(702536L), "xalan.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(720930L), "xalan.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(732330L), "xalan.jar from xalan-j_2_1_0");
        jarVersions.put(new Long(872241L), "xalan.jar from xalan-j_2_2_D10");
        jarVersions.put(new Long(882739L), "xalan.jar from xalan-j_2_2_D11");
        jarVersions.put(new Long(923866L), "xalan.jar from xalan-j_2_2_0");
        jarVersions.put(new Long(905872L), "xalan.jar from xalan-j_2_3_D1");
        jarVersions.put(new Long(906122L), "xalan.jar from xalan-j_2_3_0");
        jarVersions.put(new Long(906248L), "xalan.jar from xalan-j_2_3_1");
        jarVersions.put(new Long(983377L), "xalan.jar from xalan-j_2_4_D1");
        jarVersions.put(new Long(997276L), "xalan.jar from xalan-j_2_4_0");
        jarVersions.put(new Long(857171L), "xalan.jar from lotusxsl-j_1_0_1");
        jarVersions.put(new Long(802165L), "xalan.jar from lotusxsl-j_2_0_0");
        jarVersions.put(new Long(857692L), "xalan.jar from lotusxsl-j_2_2");
        jarVersions.put(new Long(906359L), "xalan.jar from lotusxsl-j_2_3_1");
        jarVersions.put(new Long(857692L), "xalan.jar from lotusxsl-j_2_3_2");
        jarVersions.put(new Long(1201514L), "xalan.jar from lotusxsl-j_2_3_3");
        jarVersions.put(new Long(1201599L), "xalan.jar from lotusxsl-j_2_3_4");
        jarVersions.put(new Long(1201641L), "xalan.jar from lotusxsl-j_2_3_5");
        jarVersions.put(new Long(596540L), "xsltc.jar from xalan-j_2_2_0");
        jarVersions.put(new Long(590247L), "xsltc.jar from xalan-j_2_3_D1");
        jarVersions.put(new Long(589914L), "xsltc.jar from xalan-j_2_3_0");
        jarVersions.put(new Long(589915L), "xsltc.jar from xalan-j_2_3_1");
        jarVersions.put(new Long(1306667L), "xsltc.jar from xalan-j_2_4_D1");
        jarVersions.put(new Long(1328227L), "xsltc.jar from xalan-j_2_4_0");
        jarVersions.put(new Long(1268634L), "xsltc.jar-bundled from xalan-j_2_3_0");
        jarVersions.put(new Long(100196L), "xml-apis.jar from xalan-j_2_2_0 or xalan-j_2_3_D1");
        jarVersions.put(new Long(108484L), "xml-apis.jar from xalan-j_2_3_0, or xalan-j_2_3_1 from xml-commons-1.0.b2");
        jarVersions.put(new Long(109049L), "xml-apis.jar from xalan-j_2_4_0 from xml-commons RIVERCOURT1 branch");
        jarVersions.put(new Long(109049L), "xml-apis.jar from xalan-j_2_4_0, lotusxsl-j_2_3_2 or lotusxsl-j_2_3_3 from xml-commons RIVERCOURT1");
        jarVersions.put(new Long(113749L), "xml-apis.jar from xalan-j_2_4_1, lotusxsl-j_2_3_4 or lotusxsl-j_2_3_5 from factoryfinder-build of xml-commons RIVERCOURT1");
        jarVersions.put(new Long(424490L), "xalan.jar from Xerces Tools releases - ERROR:DO NOT USE!");
        jarVersions.put(new Long(1591855L), "xerces.jar from xalan-j_1_1 from xerces-1...");
        jarVersions.put(new Long(1498679L), "xerces.jar from xalan-j_1_2 from xerces-1_2_0.bin");
        jarVersions.put(new Long(1484896L), "xerces.jar from xalan-j_1_2_1 from xerces-1_2_1.bin");
        jarVersions.put(new Long(804460L), "xerces.jar from xalan-j_1_2_2 from xerces-1_2_2.bin");
        jarVersions.put(new Long(1499244L), "xerces.jar from xalan-j_2_0_0 from xerces-1_2_3.bin");
        jarVersions.put(new Long(1605266L), "xerces.jar from xalan-j_2_0_1 from xerces-1_3_0.bin");
        jarVersions.put(new Long(904030L), "xerces.jar from xalan-j_2_1_0 from xerces-1_4.bin");
        jarVersions.put(new Long(1190776L), "xerces.jar from lotusxsl_1_0_1 apparently-from xerces-1_0_3.bin");
        jarVersions.put(new Long(1489400L), "xerces.jar from lotusxsl-j_2_0_0 from XML4J-3_1_1");
        jarVersions.put(new Long(1787796L), "xerces.jar from lotusxsl-j_2_2 or xerces-1_4_1.bin");
        jarVersions.put(new Long(904030L), "xerces.jar from xerces-1_4_0.bin");
        jarVersions.put(new Long(1802885L), "xerces.jar from xerces-1_4_2.bin");
        jarVersions.put(new Long(1734594L), "xerces.jar from Xerces-J-bin.2.0.0.beta3");
        jarVersions.put(new Long(1808883L), "xerces.jar from xalan-j_2_2_D10,D11,D12 or xerces-1_4_3.bin");
        jarVersions.put(new Long(1803877L), "xerces.jar from XML4J-3_2_1");
        jarVersions.put(new Long(1812019L), "xerces.jar from xalan-j_2_2_0");
        jarVersions.put(new Long(1720292L), "xercesImpl.jar from xalan-j_2_3_D1");
        jarVersions.put(new Long(1730053L), "xercesImpl.jar from xalan-j_2_3_0 or xalan-j_2_3_1 from xerces-2_0_0");
        jarVersions.put(new Long(1728861L), "xercesImpl.jar from xalan-j_2_4_D1 from xerces-2_0_1");
        jarVersions.put(new Long(972027L), "xercesImpl.jar from xalan-j_2_4_0 from xerces-2_1");
        jarVersions.put(new Long(831587L), "xercesImpl.jar from xalan-j_2_4_1 from xerces-2_2");
        jarVersions.put(new Long(1729063L), "xercesImpl.jar from lotusxsl-j_2_3_1 from XML4J-4_0_0");
        jarVersions.put(new Long(1738551L), "xercesImpl.jar from lotusxsl-j_2_3_2 from XML4J-4_0_2");
        jarVersions.put(new Long(3243826L), "xercesImpl.jar from lotusxsl-j_2_3_3 from XML4J-4_0_5");
        jarVersions.put(new Long(1171789L), "xercesImpl.jar from lotusxsl-j_2_3_4 from XML4J-4_0_6");
        jarVersions.put(new Long(1174955L), "xercesImpl.jar from lotusxsl-j_2_3_5 from XML4J-4_0_8");
        jarVersions.put(new Long(1173922L), "xercesImpl.jar from lotusxsl-j_2_3_6 from XML4J-4_0_9");
        jarVersions.put(new Long(831828L), "xercesImpl.jar from lotusxsl-j_2_4_0 from XML4J-4_1_1");
        jarVersions.put(new Long(37485L), "xalanj1compat.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(38100L), "xalanj1compat.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(18779L), "xalanservlet.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(21453L), "xalanservlet.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(24826L), "xalanservlet.jar from xalan-j_2_3_1 or xalan-j_2_4_1 or lotusxsl-j_2_3_1 to lotusxsl-j-2_3_5");
        jarVersions.put(new Long(24831L), "xalanservlet.jar from xalan-j_2_4_1");
        jarVersions.put(new Long(5618L), "jaxp.jar from jaxp1.0.1");
        jarVersions.put(new Long(136133L), "parser.jar from jaxp1.0.1");
        jarVersions.put(new Long(28404L), "jaxp.jar from jaxp-1.1");
        jarVersions.put(new Long(187162L), "crimson.jar from jaxp-1.1");
        jarVersions.put(new Long(801714L), "xalan.jar from jaxp-1.1");
        jarVersions.put(new Long(196399L), "crimson.jar from crimson-1.1.1");
        jarVersions.put(new Long(33323L), "jaxp.jar from crimson-1.1.1 or jakarta-ant-1.4.1b1");
        jarVersions.put(new Long(152717L), "crimson.jar from crimson-1.1.2beta2");
        jarVersions.put(new Long(88143L), "xml-apis.jar from crimson-1.1.2beta2");
        jarVersions.put(new Long(206384L), "crimson.jar from crimson-1.1.3 or jakarta-ant-1.4.1b1");
        jarVersions.put(new Long(136198L), "parser.jar from jakarta-ant-1.3 or 1.2");
        jarVersions.put(new Long(5537L), "jaxp.jar from jakarta-ant-1.3 or 1.2");
        jarVersions.put(new Long(120274L), "lotusxsl.jar from lotusxsl-0_16_4");
        jarVersions.put(new Long(120293L), "lotusxsl.jar from lotusxsl-0_16_5");
        jarVersions.put(new Long(283777L), "lotusxsl.jar from lotusxsl-0_17_2");
        jarVersions.put(new Long(305577L), "lotusxsl.jar from lotusxsl-0_17_3");
        jarVersions.put(new Long(304500L), "lotusxsl.jar from lotusxsl-0_17_4");
        jarVersions.put(new Long(714959L), "lotusxsl.jar from lotusxsl-0_18_1");
        jarVersions.put(new Long(717674L), "lotusxsl.jar from lotusxsl-0_18_2");
        jarVersions.put(new Long(752343L), "lotusxsl.jar from lotusxsl-0_18_3");
        jarVersions.put(new Long(907101L), "lotusxsl.jar from lotusxsl-0_18_4");
    }

    public boolean checkEnvironment(PrintWriter printWriter) {
        Hashtable hashtable;
        boolean bl2;
        if (null != printWriter) {
            this.outWriter = printWriter;
        }
        if (bl2 = this.writeEnvironmentReport(hashtable = this.getEnvironmentHash())) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (null != this.outWriter) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# YAHOO! Your environment seems to be OK.");
        if (null != this.outWriter) {
            this.outWriter.flush();
        }
        return true;
    }

    protected static ClassLoader findClassLoader() throws ClassNotFoundException {
        Object var0 = null;
        Method method = null;
        try {
            method = (class$java$lang$Thread == null ? (class$java$lang$Thread = EnvironmentCheck.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (class$org$apache$xalan$xslt$EnvironmentCheck == null ? (class$org$apache$xalan$xslt$EnvironmentCheck = EnvironmentCheck.class$("org.apache.xalan.xslt.EnvironmentCheck")) : class$org$apache$xalan$xslt$EnvironmentCheck).getClassLoader();
        }
        try {
            return (ClassLoader)method.invoke(Thread.currentThread(), null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    protected void logMsg(String string) {
        this.outWriter.println(string);
    }

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!"-out".equalsIgnoreCase(stringArray[i2])) continue;
            if (++i2 < stringArray.length) {
                try {
                    printWriter = new PrintWriter(new FileWriter(stringArray[i2], true));
                }
                catch (Exception exception) {
                    System.err.println("# WARNING: -out " + stringArray[i2] + " threw " + exception.toString());
                }
                continue;
            }
            System.err.println("# WARNING: -out argument should have a filename, output sent to console");
        }
        EnvironmentCheck environmentCheck = new EnvironmentCheck();
        environmentCheck.checkEnvironment(printWriter);
    }

    public Hashtable getEnvironmentHash() {
        Hashtable hashtable = new Hashtable();
        this.checkJAXPVersion(hashtable);
        this.checkProcessorVersion(hashtable);
        this.checkParserVersion(hashtable);
        this.checkAntVersion(hashtable);
        this.checkDOMVersion(hashtable);
        this.checkSAXVersion(hashtable);
        this.checkSystemProperties(hashtable);
        return hashtable;
    }

    protected void checkAntVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        try {
            Class[] classArray = new Class[]{};
            Class clazz = EnvironmentCheck.classForName("org.apache.tools.ant.Main");
            Method method = clazz.getMethod("getAntVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            hashtable.put("version.ant", (String)object);
        }
        catch (Exception exception) {
            hashtable.put("version.ant", CLASS_NOTPRESENT);
        }
    }

    protected void checkDOMVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String};
        try {
            Class clazz = EnvironmentCheck.classForName("org.w3c.dom.Document");
            Method method = clazz.getMethod("createElementNS", classArray);
            hashtable.put("version.DOM", "2.0");
            try {
                clazz = EnvironmentCheck.classForName("org.w3c.dom.Node");
                method = clazz.getMethod("supported", classArray);
                hashtable.put("ERROR.version.DOM.draftlevel", "2.0wd");
                hashtable.put(ERROR, ERROR_FOUND);
            }
            catch (Exception exception) {
                try {
                    clazz = EnvironmentCheck.classForName("org.w3c.dom.Node");
                    method = clazz.getMethod("isSupported", classArray);
                    hashtable.put("version.DOM.draftlevel", "2.0fd");
                }
                catch (Exception exception2) {
                    hashtable.put("ERROR.version.DOM.draftlevel", "2.0unknown");
                    hashtable.put(ERROR, ERROR_FOUND);
                }
            }
        }
        catch (Exception exception) {
            hashtable.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + exception.toString());
            hashtable.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkJAXPVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        Class[] classArray = new Class[]{};
        Class clazz = null;
        try {
            clazz = EnvironmentCheck.classForName("javax.xml.parsers.DocumentBuilder");
            Method method = clazz.getMethod("getDOMImplementation", classArray);
            hashtable.put("version.JAXP", "1.1");
        }
        catch (Exception exception) {
            if (null != clazz) {
                hashtable.put("ERROR.version.JAXP", "1.0.1");
                hashtable.put(ERROR, ERROR_FOUND);
            }
            hashtable.put("ERROR.version.JAXP", CLASS_NOTPRESENT);
            hashtable.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkParserVersion(Hashtable hashtable) {
        String string;
        Field field;
        Class clazz;
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xerces.framework.Version");
            field = clazz.getField("fVersion");
            string = (String)field.get(null);
            hashtable.put("version.xerces1", string);
        }
        catch (Exception exception) {
            hashtable.put("version.xerces1", CLASS_NOTPRESENT);
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xerces.impl.Version");
            field = clazz.getField("fVersion");
            string = (String)field.get(null);
            hashtable.put("version.xerces2", string);
        }
        catch (Exception exception) {
            hashtable.put("version.xerces2", CLASS_NOTPRESENT);
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.crimson.parser.Parser2");
            hashtable.put("version.crimson", CLASS_PRESENT);
        }
        catch (Exception exception) {
            hashtable.put("version.crimson", CLASS_NOTPRESENT);
        }
    }

    protected void checkProcessorVersion(Hashtable hashtable) {
        Object object;
        Class[] classArray;
        Class clazz;
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xalan.xslt.XSLProcessorVersion");
            classArray = new StringBuffer();
            object = clazz.getField("PRODUCT");
            classArray.append(((Field)object).get(null));
            classArray.append(';');
            object = clazz.getField("LANGUAGE");
            classArray.append(((Field)object).get(null));
            classArray.append(';');
            object = clazz.getField("S_VERSION");
            classArray.append(((Field)object).get(null));
            classArray.append(';');
            hashtable.put("version.xalan1", classArray.toString());
        }
        catch (Exception exception) {
            hashtable.put("version.xalan1", CLASS_NOTPRESENT);
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xalan.processor.XSLProcessorVersion");
            classArray = new StringBuffer();
            object = clazz.getField("S_VERSION");
            classArray.append(((Field)object).get(null));
            hashtable.put("version.xalan2x", classArray.toString());
        }
        catch (Exception exception) {
            hashtable.put("version.xalan2x", CLASS_NOTPRESENT);
        }
        try {
            classArray = new Class[]{};
            object = EnvironmentCheck.classForName("org.apache.xalan.Version");
            Method method = ((Class)object).getMethod("getVersion", classArray);
            Object object2 = method.invoke(null, new Object[0]);
            hashtable.put("version.xalan2_2", (String)object2);
        }
        catch (Exception exception) {
            hashtable.put("version.xalan2_2", CLASS_NOTPRESENT);
        }
    }

    protected void checkSAXVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String};
        Class[] classArray2 = new Class[]{class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = EnvironmentCheck.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes};
        try {
            Class clazz = EnvironmentCheck.classForName("org.xml.sax.helpers.AttributesImpl");
            Method method = clazz.getMethod("setAttributes", classArray2);
            hashtable.put("version.SAX", "2.0");
        }
        catch (Exception exception) {
            hashtable.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
            hashtable.put(ERROR, ERROR_FOUND);
            try {
                Class clazz = EnvironmentCheck.classForName("org.xml.sax.XMLReader");
                Method method = clazz.getMethod("parse", classArray);
                hashtable.put("version.SAX-backlevel", "2.0beta2-or-earlier");
            }
            catch (Exception exception2) {
                hashtable.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
                hashtable.put(ERROR, ERROR_FOUND);
                try {
                    Class clazz = EnvironmentCheck.classForName("org.xml.sax.Parser");
                    Method method = clazz.getMethod("parse", classArray);
                    hashtable.put("version.SAX-backlevel", "1.0");
                }
                catch (Exception exception3) {
                    hashtable.put("ERROR.version.SAX-backlevel", "ERROR attempting to load SAX version 1 class: " + exception3.toString());
                }
            }
        }
    }

    protected void checkSystemProperties(Hashtable hashtable) {
        String string;
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        try {
            string = System.getProperty("java.version");
            hashtable.put("java.version", string);
        }
        catch (SecurityException securityException) {
            hashtable.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String string2;
            string = System.getProperty("java.class.path");
            hashtable.put("java.class.path", string);
            Vector vector = this.checkPathForJars(string, this.jarNames);
            if (null != vector) {
                hashtable.put("foundclasses.java.class.path", vector);
            }
            if (null != (string2 = System.getProperty("sun.boot.class.path"))) {
                hashtable.put("sun.boot.class.path", string2);
                vector = this.checkPathForJars(string2, this.jarNames);
                if (null != vector) {
                    hashtable.put("foundclasses.sun.boot.class.path", vector);
                }
            }
            if (null != (string2 = System.getProperty("java.ext.dirs"))) {
                hashtable.put("java.ext.dirs", string2);
                vector = this.checkPathForJars(string2, this.jarNames);
                if (null != vector) {
                    hashtable.put("foundclasses.java.ext.dirs", vector);
                }
            }
        }
        catch (SecurityException securityException) {
            hashtable.put("java.class.path", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    protected boolean writeEnvironmentReport(Hashtable hashtable) {
        if (null == hashtable) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Hashtable");
            return false;
        }
        boolean bl2 = false;
        this.logMsg("#---- BEGIN writeEnvironmentReport($Revision: 1.14 $): Useful stuff found: ----");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            String string = (String)object;
            try {
                if (string.startsWith(FOUNDCLASSES)) {
                    Vector vector = (Vector)hashtable.get(string);
                    bl2 |= this.logFoundJars(vector, string);
                    continue;
                }
                if (string.startsWith(ERROR)) {
                    bl2 = true;
                }
                this.logMsg(string + "=" + hashtable.get(string));
            }
            catch (Exception exception) {
                this.logMsg("Reading-" + object + "= threw: " + exception.toString());
            }
        }
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return bl2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected static Class classForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = EnvironmentCheck.findClassLoader();
        if (classLoader == null) {
            return Class.forName(string);
        }
        return classLoader.loadClass(string);
    }

    protected String getApparentVersion(String string, long l2) {
        String string2 = (String)jarVersions.get(new Long(l2));
        if (null != string2 && string2.startsWith(string)) {
            return string2;
        }
        if ("xerces.jar".equalsIgnoreCase(string) || "xercesImpl.jar".equalsIgnoreCase(string) || "xalan.jar".equalsIgnoreCase(string)) {
            return string + " " + WARNING + CLASS_PRESENT;
        }
        return string + " " + CLASS_PRESENT;
    }

    protected boolean logFoundJars(Vector vector, String string) {
        if (null == vector || vector.size() < 1) {
            return false;
        }
        boolean bl2 = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + string + " ----");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i2);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                String string2 = (String)object;
                try {
                    if (string2.startsWith(ERROR)) {
                        bl2 = true;
                    }
                    this.logMsg(string2 + "=" + hashtable.get(string2));
                }
                catch (Exception exception) {
                    bl2 = true;
                    this.logMsg("Reading-" + object + "= threw: " + exception.toString());
                }
            }
        }
        this.logMsg("#----- END Listing XML-related jars in: " + string + " -----");
        return bl2;
    }

    public void appendEnvironmentReport(Node node, Document document, Hashtable hashtable) {
        if (null == node || null == document) {
            return;
        }
        try {
            Element element = document.createElement("EnvironmentCheck");
            element.setAttribute("version", "$Revision: 1.14 $");
            node.appendChild(element);
            if (null == hashtable) {
                Element element2 = document.createElement("status");
                element2.setAttribute("result", "ERROR");
                element2.appendChild(document.createTextNode("appendEnvironmentReport called with null Hashtable!"));
                element.appendChild(element2);
                return;
            }
            boolean bl2 = false;
            Element element3 = document.createElement("environment");
            element.appendChild(element3);
            Object object = hashtable.keys();
            while (object.hasMoreElements()) {
                Object object2 = object.nextElement();
                String string = (String)object2;
                try {
                    Object object3;
                    if (string.startsWith(FOUNDCLASSES)) {
                        object3 = (Vector)hashtable.get(string);
                        bl2 |= this.appendFoundJars(element3, document, (Vector)object3, string);
                        continue;
                    }
                    if (string.startsWith(ERROR)) {
                        bl2 = true;
                    }
                    object3 = document.createElement("item");
                    object3.setAttribute("key", string);
                    object3.appendChild(document.createTextNode((String)hashtable.get(string)));
                    element3.appendChild((Node)object3);
                }
                catch (Exception exception) {
                    bl2 = true;
                    Element element4 = document.createElement("item");
                    element4.setAttribute("key", string);
                    element4.appendChild(document.createTextNode("ERROR. Reading " + object2 + " threw: " + exception.toString()));
                    element3.appendChild(element4);
                }
            }
            object = document.createElement("status");
            object.setAttribute("result", bl2 ? "ERROR" : "OK");
            element.appendChild((Node)object);
        }
        catch (Exception exception) {
            System.err.println("appendEnvironmentReport threw: " + exception.toString());
            exception.printStackTrace();
        }
    }

    protected Vector checkPathForJars(String string, String[] stringArray) {
        if (null == string || null == stringArray || 0 == string.length() || 0 == stringArray.length) {
            return null;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Hashtable hashtable;
                if (string2.indexOf(stringArray[i2]) <= -1) continue;
                File file = new File(string2);
                if (file.exists()) {
                    try {
                        hashtable = new Hashtable(2);
                        hashtable.put(stringArray[i2] + "-path", file.getAbsolutePath());
                        hashtable.put(stringArray[i2] + "-apparent.version", this.getApparentVersion(stringArray[i2], file.length()));
                        vector.addElement(hashtable);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                hashtable = new Hashtable(2);
                hashtable.put(stringArray[i2] + "-path", "WARNING. Classpath entry: " + string2 + " does not exist");
                hashtable.put(stringArray[i2] + "-apparent.version", CLASS_NOTPRESENT);
                vector.addElement(hashtable);
            }
        }
        return vector;
    }

    protected boolean appendFoundJars(Node node, Document document, Vector vector, String string) {
        if (null == vector || vector.size() < 1) {
            return false;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i2);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Element element;
                Object object = enumeration.nextElement();
                try {
                    String string2 = (String)object;
                    if (string2.startsWith(ERROR)) {
                        bl2 = true;
                    }
                    element = document.createElement("foundJar");
                    element.setAttribute("name", string2.substring(0, string2.indexOf("-")));
                    element.setAttribute("desc", string2.substring(string2.indexOf("-") + 1));
                    element.appendChild(document.createTextNode((String)hashtable.get(string2)));
                    node.appendChild(element);
                }
                catch (Exception exception) {
                    bl2 = true;
                    element = document.createElement("foundJar");
                    element.appendChild(document.createTextNode("ERROR. Reading " + object + " threw: " + exception.toString()));
                    node.appendChild(element);
                }
            }
        }
        return bl2;
    }
}

