/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap
extends HashMap {
    private transient Entry header;
    private final boolean accessOrder;

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    void init() {
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null));
    }

    public LinkedHashMap(int n2) {
        super(n2);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n2, float f2) {
        super(n2, f2);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n2, float f2, boolean bl2) {
        super(n2, f2);
        this.accessOrder = bl2;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    void transfer(HashMap.Entry[] entryArray) {
        int n2 = entryArray.length;
        Entry entry = this.header.after;
        while (entry != this.header) {
            int n3 = LinkedHashMap.indexFor(entry.hash, n2);
            entry.next = entryArray[n3];
            entryArray[n3] = entry;
            entry = entry.after;
        }
    }

    Iterator newEntryIterator() {
        return new EntryIterator(this, null);
    }

    Iterator newKeyIterator() {
        return new KeyIterator(this, null);
    }

    Iterator newValueIterator() {
        return new ValueIterator(this, null);
    }

    static boolean access$000(LinkedHashMap linkedHashMap) {
        return linkedHashMap.accessOrder;
    }

    public LinkedHashMap(Map map) {
        super(map);
        this.accessOrder = false;
    }

    protected boolean removeEldestEntry(Map.Entry entry) {
        return false;
    }

    void addEntry(int n2, Object object, Object object2, int n3) {
        this.createEntry(n2, object, object2, n3);
        Entry entry = this.header.after;
        if (this.removeEldestEntry(entry)) {
            this.removeEntryForKey(entry.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n2, Object object, Object object2, int n3) {
        Entry entry = new Entry(n2, object, object2, this.table[n3]);
        this.table[n3] = entry;
        Entry.access$600(entry, this.header);
        ++this.size;
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.getEntry(object);
        if (entry == null) {
            return null;
        }
        entry.recordAccess(this);
        return entry.value;
    }

    static Entry access$100(LinkedHashMap linkedHashMap) {
        return linkedHashMap.header;
    }

    static class 1 {
    }

    private static class Entry
    extends HashMap.Entry {
        Entry before;
        Entry after;

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void recordAccess(HashMap hashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)hashMap;
            if (LinkedHashMap.access$000(linkedHashMap)) {
                ++linkedHashMap.modCount;
                this.remove();
                this.addBefore(LinkedHashMap.access$100(linkedHashMap));
            }
        }

        void recordRemoval(HashMap hashMap) {
            this.remove();
        }

        private void addBefore(Entry entry) {
            this.after = entry;
            this.before = entry.before;
            this.before.after = this;
            this.after.before = this;
        }

        static void access$600(Entry entry, Entry entry2) {
            entry.addBefore(entry2);
        }

        Entry(int n2, Object object, Object object2, HashMap.Entry entry) {
            super(n2, object, object2, entry);
        }
    }

    private class EntryIterator
    extends LinkedHashIterator {
        private final LinkedHashMap this$0;

        public Object next() {
            return this.nextEntry();
        }

        private EntryIterator(LinkedHashMap linkedHashMap) {
            this.this$0 = linkedHashMap;
            super(linkedHashMap, null);
        }

        EntryIterator(LinkedHashMap linkedHashMap, 1 var2_2) {
            this(linkedHashMap);
        }
    }

    private class KeyIterator
    extends LinkedHashIterator {
        private final LinkedHashMap this$0;

        public Object next() {
            return this.nextEntry().getKey();
        }

        private KeyIterator(LinkedHashMap linkedHashMap) {
            this.this$0 = linkedHashMap;
            super(linkedHashMap, null);
        }

        KeyIterator(LinkedHashMap linkedHashMap, 1 var2_2) {
            this(linkedHashMap);
        }
    }

    private abstract class LinkedHashIterator
    implements Iterator {
        Entry nextEntry;
        Entry lastReturned;
        int expectedModCount;
        private final LinkedHashMap this$0;

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.this$0.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = this.this$0.modCount;
        }

        public boolean hasNext() {
            return this.nextEntry != LinkedHashMap.access$100(this.this$0);
        }

        private LinkedHashIterator(LinkedHashMap linkedHashMap) {
            this.this$0 = linkedHashMap;
            this.nextEntry = LinkedHashMap.access$100((LinkedHashMap)this.this$0).after;
            this.lastReturned = null;
            this.expectedModCount = this.this$0.modCount;
        }

        Entry nextEntry() {
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashMap.access$100(this.this$0)) {
                throw new NoSuchElementException();
            }
            Entry entry = this.lastReturned = this.nextEntry;
            this.nextEntry = entry.after;
            return entry;
        }

        LinkedHashIterator(LinkedHashMap linkedHashMap, 1 var2_2) {
            this(linkedHashMap);
        }
    }

    private class ValueIterator
    extends LinkedHashIterator {
        private final LinkedHashMap this$0;

        public Object next() {
            return this.nextEntry().value;
        }

        private ValueIterator(LinkedHashMap linkedHashMap) {
            this.this$0 = linkedHashMap;
            super(linkedHashMap, null);
        }

        ValueIterator(LinkedHashMap linkedHashMap, 1 var2_2) {
            this(linkedHashMap);
        }
    }
}

