/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    float loadFactor() {
        return this.loadFactor;
    }

    int capacity() {
        return this.table.length;
    }

    public int size() {
        return this.size;
    }

    public HashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public void clear() {
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            entryArray[i2] = null;
        }
        this.size = 0;
    }

    void init() {
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public HashMap(int n2) {
        this(n2, 0.75f);
    }

    void resize(int n2) {
        Entry[] entryArray = this.table;
        int n3 = entryArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n2];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n2 * this.loadFactor);
    }

    public HashMap(int n2, float f2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n2);
        }
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal load factor: " + f2);
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)n3 * f2);
        this.table = new Entry[n3];
        this.init();
    }

    static int indexFor(int n2, int n3) {
        return n2 & n3 - 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.table = new Entry[n2];
        this.init();
        int n3 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator iterator = this.entrySet().iterator();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashMap.table = new Entry[this.table.length];
        hashMap.entrySet = null;
        hashMap.modCount = 0;
        hashMap.size = 0;
        hashMap.init();
        hashMap.putAllForCreate(this);
        return hashMap;
    }

    static int hash(Object object) {
        int n2 = object.hashCode();
        n2 += ~(n2 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    public boolean containsKey(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        int n3 = HashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && HashMap.eq(object2, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values(this, null));
    }

    void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n2 = entryArray.length;
        for (int i2 = 0; i2 < entryArray2.length; ++i2) {
            Entry entry;
            Entry entry2 = entryArray2[i2];
            if (entry2 == null) continue;
            entryArray2[i2] = null;
            do {
                entry = entry2.next;
                int n3 = HashMap.indexFor(entry2.hash, n2);
                entry2.next = entryArray[n3];
                entryArray[n3] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    Iterator newEntryIterator() {
        return new EntryIterator(this, null);
    }

    Iterator newKeyIterator() {
        return new KeyIterator(this, null);
    }

    Iterator newValueIterator() {
        return new ValueIterator(this, null);
    }

    public HashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAllForCreate(map);
    }

    public void putAll(Map map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            int n3;
            int n4 = (int)((float)n2 / this.loadFactor + 1.0f);
            if (n4 > 0x40000000) {
                n4 = 0x40000000;
            }
            for (n3 = this.table.length; n3 < n4; n3 <<= 1) {
            }
            if (n3 > this.table.length) {
                this.resize(n3);
            }
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    void putAllForCreate(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet(this, null));
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet(this, null));
    }

    void addEntry(int n2, Object object, Object object2, int n3) {
        this.table[n3] = new Entry(n2, object, object2, this.table[n3]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n2, Object object, Object object2, int n3) {
        this.table[n3] = new Entry(n2, object, object2, this.table[n3]);
        ++this.size;
    }

    public Object get(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        int n3 = HashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && HashMap.eq(object2, entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return entry;
    }

    static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    public Object remove(Object object) {
        Entry entry = this.removeEntryForKey(object);
        return entry == null ? entry : entry.value;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    private void putForCreate(Object object, Object object2) {
        Object object3 = HashMap.maskNull(object);
        int n2 = HashMap.hash(object3);
        int n3 = HashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && HashMap.eq(object3, entry.key)) {
                entry.value = object2;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n2, object3, object2, n3);
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    Entry getEntry(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        int n3 = HashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (!(entry == null || entry.hash == n2 && HashMap.eq(object2, entry.key))) {
            entry = entry.next;
        }
        return entry;
    }

    Entry removeEntryForKey(Object object) {
        Entry entry;
        Object object2 = HashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        int n3 = HashMap.indexFor(n2, this.table.length);
        Entry entry2 = entry = this.table[n3];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n2 && HashMap.eq(object2, entry2.key)) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n3] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    Entry removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = HashMap.maskNull(entry2.getKey());
        int n2 = HashMap.hash(object2);
        int n3 = HashMap.indexFor(n2, this.table.length);
        Entry entry3 = entry = this.table[n3];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n2 && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n3] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    public Object put(Object object, Object object2) {
        Object object3 = HashMap.maskNull(object);
        int n2 = HashMap.hash(object3);
        int n3 = HashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && HashMap.eq(object3, entry.key)) {
                Object object4 = entry.value;
                entry.value = object2;
                entry.recordAccess(this);
                return object4;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n2, object3, object2, n3);
        return null;
    }

    static class 1 {
    }

    static class Entry
    implements Map.Entry {
        final Object key;
        Object value;
        final int hash;
        Entry next;

        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object getKey() {
            return HashMap.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            Object object2;
            Object object3;
            Object object4;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object5 = this.getKey();
            return (object5 == (object4 = entry.getKey()) || object5 != null && object5.equals(object4)) && ((object3 = this.getValue()) == (object2 = entry.getValue()) || object3 != null && object3.equals(object2));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HashMap hashMap) {
        }

        void recordRemoval(HashMap hashMap) {
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        Entry(int n2, Object object, Object object2, Entry entry) {
            this.value = object2;
            this.next = entry;
            this.key = object;
            this.hash = n2;
        }
    }

    private class EntryIterator
    extends HashIterator {
        private final HashMap this$0;

        public Object next() {
            return this.nextEntry();
        }

        private EntryIterator(HashMap hashMap) {
            this.this$0 = hashMap;
            super(hashMap);
        }

        EntryIterator(HashMap hashMap, 1 var2_2) {
            this(hashMap);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private final HashMap this$0;

        public int size() {
            return this.this$0.size;
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = this.this$0.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return this.this$0.removeMapping(object) != null;
        }

        private EntrySet(HashMap hashMap) {
            this.this$0 = hashMap;
        }

        public Iterator iterator() {
            return this.this$0.newEntryIterator();
        }

        EntrySet(HashMap hashMap, 1 var2_2) {
            this(hashMap);
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;
        private final HashMap this$0;

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object object = this.current.key;
            this.current = null;
            this.this$0.removeEntryForKey(object);
            this.expectedModCount = this.this$0.modCount;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        HashIterator(HashMap hashMap) {
            this.this$0 = hashMap;
            this.expectedModCount = hashMap.modCount;
            Entry[] entryArray = hashMap.table;
            int n2 = entryArray.length;
            Entry entry = null;
            if (hashMap.size != 0) {
                while (n2 > 0 && (entry = entryArray[--n2]) == null) {
                }
            }
            this.next = entry;
            this.index = n2;
        }

        Entry nextEntry() {
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry[] entryArray = this.this$0.table;
            int n2 = this.index;
            while (entry2 == null && n2 > 0) {
                entry2 = entryArray[--n2];
            }
            this.index = n2;
            this.next = entry2;
            this.current = entry;
            return this.current;
        }
    }

    private class KeyIterator
    extends HashIterator {
        private final HashMap this$0;

        public Object next() {
            return this.nextEntry().getKey();
        }

        private KeyIterator(HashMap hashMap) {
            this.this$0 = hashMap;
            super(hashMap);
        }

        KeyIterator(HashMap hashMap, 1 var2_2) {
            this(hashMap);
        }
    }

    private class KeySet
    extends AbstractSet {
        private final HashMap this$0;

        public int size() {
            return this.this$0.size;
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            return this.this$0.containsKey(object);
        }

        public boolean remove(Object object) {
            return this.this$0.removeEntryForKey(object) != null;
        }

        private KeySet(HashMap hashMap) {
            this.this$0 = hashMap;
        }

        public Iterator iterator() {
            return this.this$0.newKeyIterator();
        }

        KeySet(HashMap hashMap, 1 var2_2) {
            this(hashMap);
        }
    }

    private class ValueIterator
    extends HashIterator {
        private final HashMap this$0;

        public Object next() {
            return this.nextEntry().value;
        }

        private ValueIterator(HashMap hashMap) {
            this.this$0 = hashMap;
            super(hashMap);
        }

        ValueIterator(HashMap hashMap, 1 var2_2) {
            this(hashMap);
        }
    }

    private class Values
    extends AbstractCollection {
        private final HashMap this$0;

        public int size() {
            return this.this$0.size;
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            return this.this$0.containsValue(object);
        }

        private Values(HashMap hashMap) {
            this.this$0 = hashMap;
        }

        public Iterator iterator() {
            return this.this$0.newValueIterator();
        }

        Values(HashMap hashMap, 1 var2_2) {
            this(hashMap);
        }
    }
}

