/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    private static final int BINARYSEARCH_THRESHOLD = 5000;
    private static final int REVERSE_THRESHOLD = 18;
    private static final int SHUFFLE_THRESHOLD = 5;
    private static final int FILL_THRESHOLD = 25;
    private static final int ROTATE_THRESHOLD = 100;
    private static final int COPY_THRESHOLD = 10;
    private static final int REPLACEALL_THRESHOLD = 11;
    private static final int INDEXOFSUBLIST_THRESHOLD = 35;
    private static Random r = new Random();
    public static final Set EMPTY_SET = new EmptySet(null);
    public static final List EMPTY_LIST = new EmptyList(null);
    public static final Map EMPTY_MAP = new EmptyMap(null);
    private static final Comparator REVERSE_ORDER = new ReverseComparator(null);

    private Collections() {
    }

    private static void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    public static Comparator reverseOrder() {
        return REVERSE_ORDER;
    }

    public static void reverse(List list) {
        int n2 = list.size();
        if (n2 < 18 || list instanceof RandomAccess) {
            int n3 = 0;
            int n4 = n2 >> 1;
            int n5 = n2 - 1;
            while (n3 < n4) {
                Collections.swap(list, n3, n5);
                ++n3;
                --n5;
            }
        } else {
            ListIterator listIterator = list.listIterator();
            ListIterator listIterator2 = list.listIterator(n2);
            int n6 = list.size() >> 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                Object object = listIterator.next();
                listIterator.set(listIterator2.previous());
                listIterator2.set(object);
            }
        }
    }

    public static void shuffle(List list) {
        Collections.shuffle(list, r);
    }

    public static void sort(List list) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        ListIterator listIterator = list.listIterator();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            listIterator.next();
            listIterator.set(objectArray[i2]);
        }
    }

    public static void rotate(List list, int n2) {
        if (list instanceof RandomAccess || list.size() < 100) {
            Collections.rotate1(list, n2);
        } else {
            Collections.rotate2(list, n2);
        }
    }

    private static void rotate1(List list, int n2) {
        int n3 = list.size();
        if (n3 == 0) {
            return;
        }
        if ((n2 %= n3) < 0) {
            n2 += n3;
        }
        if (n2 == 0) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 != n3) {
            Object object = list.get(n4);
            int n6 = n4;
            do {
                if ((n6 += n2) >= n3) {
                    n6 -= n3;
                }
                object = list.set(n6, object);
                ++n5;
            } while (n6 != n4);
            ++n4;
        }
    }

    private static void rotate2(List list, int n2) {
        int n3 = list.size();
        if (n3 == 0) {
            return;
        }
        int n4 = -n2 % n3;
        if (n4 < 0) {
            n4 += n3;
        }
        if (n4 == 0) {
            return;
        }
        Collections.reverse(list.subList(0, n4));
        Collections.reverse(list.subList(n4, n3));
        Collections.reverse(list);
    }

    public static void swap(List list, int n2, int n3) {
        list.set(n2, list.set(n3, list.get(n2)));
    }

    static boolean access$000(Object object, Object object2) {
        return Collections.eq(object, object2);
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static Object max(Collection collection) {
        Iterator iterator = collection.iterator();
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            if (comparable2.compareTo(comparable) <= 0) continue;
            comparable = comparable2;
        }
        return comparable;
    }

    public static Object min(Collection collection) {
        Iterator iterator = collection.iterator();
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            if (comparable2.compareTo(comparable) >= 0) continue;
            comparable = comparable2;
        }
        return comparable;
    }

    public static int binarySearch(List list, Object object) {
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, object);
        }
        return Collections.iteratorBinarySearch(list, object);
    }

    private static int indexedBinarySearch(List list, Object object) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Object object2 = list.get(n4);
            int n5 = ((Comparable)object2).compareTo(object);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    private static int iteratorBinarySearch(List list, Object object) {
        int n2 = 0;
        int n3 = list.size() - 1;
        ListIterator listIterator = list.listIterator();
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Object object2 = Collections.get(listIterator, n4);
            int n5 = ((Comparable)object2).compareTo(object);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static void fill(List list, Object object) {
        int n2 = list.size();
        if (n2 < 25 || list instanceof RandomAccess) {
            for (int i2 = 0; i2 < n2; ++i2) {
                list.set(i2, object);
            }
        } else {
            ListIterator listIterator = list.listIterator();
            for (int i3 = 0; i3 < n2; ++i3) {
                listIterator.next();
                listIterator.set(object);
            }
        }
    }

    private static Object get(ListIterator listIterator, int n2) {
        Object object = null;
        int n3 = listIterator.nextIndex();
        if (n3 <= n2) {
            do {
                object = listIterator.next();
            } while (n3++ < n2);
        } else {
            do {
                object = listIterator.previous();
            } while (--n3 > n2);
        }
        return object;
    }

    public static ArrayList list(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static Collection synchronizedCollection(Collection collection) {
        return new SynchronizedCollection(collection);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return new UnmodifiableCollection(collection);
    }

    public static void sort(List list, Comparator comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator listIterator = list.listIterator();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            listIterator.next();
            listIterator.set(objectArray[i2]);
        }
    }

    public static Enumeration enumeration(Collection collection) {
        return new Enumeration(collection){
            Iterator i;
            private final Collection val$c;

            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            public Object nextElement() {
                return this.i.next();
            }
            {
                this.val$c = collection;
                this.i = this.val$c.iterator();
            }
        };
    }

    public static List nCopies(int n2, Object object) {
        return new CopiesList(n2, object);
    }

    public static List singletonList(Object object) {
        return new SingletonList(object);
    }

    public static List synchronizedList(List list) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList(list) : new SynchronizedList(list);
    }

    public static List unmodifiableList(List list) {
        return list instanceof RandomAccess ? new UnmodifiableRandomAccessList(list) : new UnmodifiableList(list);
    }

    public static int indexOfSubList(List list, List list2) {
        int n2 = list.size();
        int n3 = list2.size();
        int n4 = n2 - n3;
        if (n2 < 35 || list instanceof RandomAccess && list2 instanceof RandomAccess) {
            block0: for (int i2 = 0; i2 <= n4; ++i2) {
                int n5 = 0;
                int n6 = i2;
                while (n5 < n3) {
                    if (!Collections.eq(list2.get(n5), list.get(n6))) continue block0;
                    ++n5;
                    ++n6;
                }
                return i2;
            }
        } else {
            ListIterator listIterator = list.listIterator();
            block2: for (int i3 = 0; i3 <= n4; ++i3) {
                ListIterator listIterator2 = list2.listIterator();
                for (int i4 = 0; i4 < n3; ++i4) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    for (int i5 = 0; i5 < i4; ++i5) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i3;
            }
        }
        return -1;
    }

    public static int lastIndexOfSubList(List list, List list2) {
        int n2 = list.size();
        int n3 = list2.size();
        int n4 = n2 - n3;
        if (n2 < 35 || list instanceof RandomAccess) {
            block0: for (int i2 = n4; i2 >= 0; --i2) {
                int n5 = 0;
                int n6 = i2;
                while (n5 < n3) {
                    if (!Collections.eq(list2.get(n5), list.get(n6))) continue block0;
                    ++n5;
                    ++n6;
                }
                return i2;
            }
        } else {
            if (n4 < 0) {
                return -1;
            }
            ListIterator listIterator = list.listIterator(n4);
            block2: for (int i3 = n4; i3 >= 0; --i3) {
                ListIterator listIterator2 = list2.listIterator();
                for (int i4 = 0; i4 < n3; ++i4) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    if (i3 == 0) continue block2;
                    for (int i5 = 0; i5 <= i4 + 1; ++i5) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i3;
            }
        }
        return -1;
    }

    public static void copy(List list, List list2) {
        int n2 = list2.size();
        if (n2 > list.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        if (n2 < 10 || list2 instanceof RandomAccess && list instanceof RandomAccess) {
            for (int i2 = 0; i2 < n2; ++i2) {
                list.set(i2, list2.get(i2));
            }
        } else {
            ListIterator listIterator = list.listIterator();
            ListIterator listIterator2 = list2.listIterator();
            for (int i3 = 0; i3 < n2; ++i3) {
                listIterator.next();
                listIterator.set(listIterator2.next());
            }
        }
    }

    public static Map synchronizedMap(Map map) {
        return new SynchronizedMap(map);
    }

    public static Map unmodifiableMap(Map map) {
        return new UnmodifiableMap(map);
    }

    public static void shuffle(List list, Random random) {
        int n2 = list.size();
        if (n2 < 5 || list instanceof RandomAccess) {
            for (int i2 = n2; i2 > 1; --i2) {
                Collections.swap(list, i2 - 1, random.nextInt(i2));
            }
        } else {
            Object[] objectArray = list.toArray();
            for (int i3 = n2; i3 > 1; --i3) {
                Collections.swap(objectArray, i3 - 1, random.nextInt(i3));
            }
            ListIterator listIterator = list.listIterator();
            for (int i4 = 0; i4 < objectArray.length; ++i4) {
                listIterator.next();
                listIterator.set(objectArray[i4]);
            }
        }
    }

    public static Set singleton(Object object) {
        return new SingletonSet(object);
    }

    public static Set synchronizedSet(Set set) {
        return new SynchronizedSet(set);
    }

    public static Set unmodifiableSet(Set set) {
        return new UnmodifiableSet(set);
    }

    public static SortedMap synchronizedSortedMap(SortedMap sortedMap) {
        return new SynchronizedSortedMap(sortedMap);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap sortedMap) {
        return new UnmodifiableSortedMap(sortedMap);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return new SynchronizedSortedSet(sortedSet);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return new UnmodifiableSortedSet(sortedSet);
    }

    public static boolean replaceAll(List list, Object object, Object object2) {
        boolean bl2 = false;
        int n2 = list.size();
        if (n2 < 11 || list instanceof RandomAccess) {
            if (object == null) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (list.get(i2) != null) continue;
                    list.set(i2, object2);
                    bl2 = true;
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (!object.equals(list.get(i3))) continue;
                    list.set(i3, object2);
                    bl2 = true;
                }
            }
        } else {
            ListIterator listIterator = list.listIterator();
            if (object == null) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    if (listIterator.next() != null) continue;
                    listIterator.set(object2);
                    bl2 = true;
                }
            } else {
                for (int i5 = 0; i5 < n2; ++i5) {
                    if (!object.equals(listIterator.next())) continue;
                    listIterator.set(object2);
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public static Object max(Collection collection, Comparator comparator) {
        if (comparator == null) {
            return Collections.max(collection);
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Object min(Collection collection, Comparator comparator) {
        if (comparator == null) {
            return Collections.min(collection);
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) >= 0) continue;
            object = object2;
        }
        return object;
    }

    static Collection synchronizedCollection(Collection collection, Object object) {
        return new SynchronizedCollection(collection, object);
    }

    public static int binarySearch(List list, Object object, Comparator comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, object);
        }
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, object, comparator);
        }
        return Collections.iteratorBinarySearch(list, object, comparator);
    }

    private static int indexedBinarySearch(List list, Object object, Comparator comparator) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Object object2 = list.get(n4);
            int n5 = comparator.compare(object2, object);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    private static int iteratorBinarySearch(List list, Object object, Comparator comparator) {
        int n2 = 0;
        int n3 = list.size() - 1;
        ListIterator listIterator = list.listIterator();
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Object object2 = Collections.get(listIterator, n4);
            int n5 = comparator.compare(object2, object);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    static List synchronizedList(List list, Object object) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList(list, object) : new SynchronizedList(list, object);
    }

    public static Map singletonMap(Object object, Object object2) {
        return new SingletonMap(object, object2);
    }

    static Set synchronizedSet(Set set, Object object) {
        return new SynchronizedSet(set, object);
    }

    private static class CopiesList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        static final long serialVersionUID = 2739099268398711800L;
        int n;
        Object element;

        public int size() {
            return this.n;
        }

        public Object get(int n2) {
            if (n2 < 0 || n2 >= this.n) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.n);
            }
            return this.element;
        }

        CopiesList(int n2, Object object) {
            if (n2 < 0) {
                throw new IllegalArgumentException("List length = " + n2);
            }
            this.n = n2;
            this.element = object;
        }

        public boolean contains(Object object) {
            return this.n != 0 && Collections.access$000(object, this.element);
        }
    }

    private static class EmptyList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        public int size() {
            return 0;
        }

        private EmptyList() {
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }

        public Object get(int n2) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }

        public boolean contains(Object object) {
            return false;
        }

        EmptyList(1 var1_1) {
            this();
        }
    }

    private static class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        public int hashCode() {
            return 0;
        }

        public int size() {
            return 0;
        }

        private EmptyMap() {
        }

        public boolean isEmpty() {
            return true;
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        public boolean containsKey(Object object) {
            return false;
        }

        public boolean containsValue(Object object) {
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).size() == 0;
        }

        public Collection values() {
            return EMPTY_SET;
        }

        EmptyMap(1 var1_1) {
            this();
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Object get(Object object) {
            return null;
        }
    }

    private static class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        public int size() {
            return 0;
        }

        private EmptySet() {
        }

        private Object readResolve() {
            return EMPTY_SET;
        }

        public boolean contains(Object object) {
            return false;
        }

        EmptySet(1 var1_1) {
            this();
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final EmptySet this$0;

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }
                {
                    this.this$0 = emptySet;
                }
            };
        }
    }

    private static class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        private ReverseComparator() {
        }

        ReverseComparator(1 var1_1) {
            this();
        }

        public int compare(Object object, Object object2) {
            Comparable comparable = (Comparable)object;
            Comparable comparable2 = (Comparable)object2;
            int n2 = comparable.compareTo(comparable2);
            return -(n2 | n2 >>> 1);
        }
    }

    private static class SingletonList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        static final long serialVersionUID = 3093736618740652951L;
        private final Object element;

        public int size() {
            return 1;
        }

        public Object get(int n2) {
            if (n2 != 0) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: 1");
            }
            return this.element;
        }

        SingletonList(Object object) {
            this.element = object;
        }

        public boolean contains(Object object) {
            return Collections.access$000(object, this.element);
        }
    }

    private static class SingletonMap
    extends AbstractMap
    implements Serializable {
        private final Object k;
        private final Object v;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean containsKey(Object object) {
            return Collections.access$000(object, this.k);
        }

        public boolean containsValue(Object object) {
            return Collections.access$000(object, this.v);
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new ImmutableEntry(this.k, this.v));
            }
            return this.entrySet;
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        public Object get(Object object) {
            return Collections.access$000(object, this.k) ? this.v : null;
        }

        SingletonMap(Object object, Object object2) {
            this.k = object;
            this.v = object2;
        }

        private static class ImmutableEntry
        implements Map.Entry {
            final Object k;
            final Object v;

            public int hashCode() {
                return (this.k == null ? 0 : this.k.hashCode()) ^ (this.v == null ? 0 : this.v.hashCode());
            }

            public Object getKey() {
                return this.k;
            }

            public Object getValue() {
                return this.v;
            }

            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return Collections.access$000(entry.getKey(), this.k) && Collections.access$000(entry.getValue(), this.v);
            }

            public String toString() {
                return this.k + "=" + this.v;
            }

            public Object setValue(Object object) {
                throw new UnsupportedOperationException();
            }

            ImmutableEntry(Object object, Object object2) {
                this.k = object;
                this.v = object2;
            }
        }
    }

    private static class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private Object element;

        public int size() {
            return 1;
        }

        SingletonSet(Object object) {
            this.element = object;
        }

        public boolean contains(Object object) {
            return Collections.access$000(object, this.element);
        }

        public Iterator iterator() {
            return new Iterator(this){
                private boolean hasNext;
                private final SingletonSet this$0;

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.access$400(this.this$0);
                    }
                    throw new NoSuchElementException();
                }
                {
                    this.this$0 = singletonSet;
                    this.hasNext = true;
                }
            };
        }

        static Object access$400(SingletonSet singletonSet) {
            return singletonSet.element;
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        Collection c;
        Object mutex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        SynchronizedCollection(Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
            this.mutex = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        public Iterator iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] objectArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(objectArray);
            }
        }

        SynchronizedCollection(Collection collection, Object object) {
            this.c = collection;
            this.mutex = object;
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        static final long serialVersionUID = -7754090372962971524L;
        List list;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).hashCode();
            }
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new SynchronizedRandomAccessList(this.list) : this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int n2, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.list.add(n2, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.list).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int n2, Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(n2, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int n2, int n3) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList(this.list.subList(n2, n3), this.mutex);
            }
        }

        SynchronizedList(List list) {
            super(list);
            this.list = list;
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int n2) {
            return this.list.listIterator(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int n2, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.set(n2, object);
            }
        }

        SynchronizedList(List list, Object object) {
            super(list, object);
            this.list = list;
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private Map m;
        Object mutex;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.m).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.m).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection(this.m.values(), this.mutex);
                }
                return this.values;
            }
        }

        SynchronizedMap(Map map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.m = map;
            this.mutex = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet(this.m.entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet(this.m.keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.remove(object);
            }
        }

        SynchronizedMap(Map map, Object object) {
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return this.m.put(object, object2);
            }
        }
    }

    static class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        static final long serialVersionUID = 1530674583602358482L;

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int n2, int n3) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(n2, n3), this.mutex);
            }
        }

        SynchronizedRandomAccessList(List list) {
            super(list);
        }

        SynchronizedRandomAccessList(List list, Object object) {
            super(list, object);
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.c).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.c).equals(object);
            }
        }

        SynchronizedSet(Set set) {
            super(set);
        }

        SynchronizedSet(Set set, Object object) {
            super(set, object);
        }
    }

    static class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private SortedMap sm;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        SynchronizedSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(SortedMap sortedMap, Object object) {
            super(sortedMap, object);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap headMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedMap(this.sm.headMap(object), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap tailMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedMap(this.sm.tailMap(object), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap subMap(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return new SynchronizedSortedMap(this.sm.subMap(object, object2), this.mutex);
            }
        }
    }

    static class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private SortedSet ss;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        SynchronizedSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(SortedSet sortedSet, Object object) {
            super(sortedSet, object);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet headSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedSet(this.ss.headSet(object), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet tailSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedSet(this.ss.tailSet(object), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet subSet(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return new SynchronizedSortedSet(this.ss.subSet(object, object2), this.mutex);
            }
        }
    }

    static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        Collection c;

        public int size() {
            return this.c.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.c.toString();
        }

        UnmodifiableCollection(Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator i;
                private final UnmodifiableCollection this$0;

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }
                {
                    this.this$0 = unmodifiableCollection;
                    this.i = this.this$0.c.iterator();
                }
            };
        }

        public Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }
    }

    static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        static final long serialVersionUID = -283967356065247728L;
        List list;

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new UnmodifiableRandomAccessList(this.list) : this;
        }

        public Object get(int n2) {
            return this.list.get(n2);
        }

        public Object remove(int n2) {
            throw new UnsupportedOperationException();
        }

        public void add(int n2, Object object) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public boolean equals(Object object) {
            return ((Object)this.list).equals(object);
        }

        public boolean addAll(int n2, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public List subList(int n2, int n3) {
            return new UnmodifiableList(this.list.subList(n2, n3));
        }

        UnmodifiableList(List list) {
            super(list);
            this.list = list;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n2) {
            return new ListIterator(this, n2){
                ListIterator i;
                private final int val$index;
                private final UnmodifiableList this$0;

                public int nextIndex() {
                    return this.i.nextIndex();
                }

                public int previousIndex() {
                    return this.i.previousIndex();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                public Object next() {
                    return this.i.next();
                }

                public Object previous() {
                    return this.i.previous();
                }

                public void add(Object object) {
                    throw new UnsupportedOperationException();
                }

                public void set(Object object) {
                    throw new UnsupportedOperationException();
                }
                {
                    this.this$0 = unmodifiableList;
                    this.val$index = n2;
                    this.i = this.this$0.list.listIterator(this.val$index);
                }
            };
        }

        public Object set(int n2, Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        public int size() {
            return this.m.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        public boolean equals(Object object) {
            return ((Object)this.m).equals(object);
        }

        public String toString() {
            return this.m.toString();
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        UnmodifiableMap(Map map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.m = map;
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entrySet;
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        public Object get(Object object) {
            return this.m.get(object);
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        static class UnmodifiableEntrySet
        extends UnmodifiableSet {
            public Object[] toArray() {
                Object[] objectArray = this.c.toArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    objectArray[i2] = new UnmodifiableEntry((Map.Entry)objectArray[i2]);
                }
                return objectArray;
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)object));
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                if (set.size() != this.c.size()) {
                    return false;
                }
                return this.containsAll(set);
            }

            public boolean containsAll(Collection collection) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (this.contains(iterator.next())) continue;
                    return false;
                }
                return true;
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator i;
                    private final UnmodifiableEntrySet this$0;

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return new UnmodifiableEntry((Map.Entry)this.i.next());
                    }
                    {
                        this.this$0 = unmodifiableEntrySet;
                        this.i = this.this$0.c.iterator();
                    }
                };
            }

            UnmodifiableEntrySet(Set set) {
                super(set);
            }

            public Object[] toArray(Object[] objectArray) {
                Object[] objectArray2 = this.c.toArray(objectArray.length == 0 ? objectArray : (Object[])Array.newInstance(objectArray.getClass().getComponentType(), 0));
                for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                    objectArray2[i2] = new UnmodifiableEntry((Map.Entry)objectArray2[i2]);
                }
                if (objectArray2.length > objectArray.length) {
                    return objectArray2;
                }
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
                if (objectArray.length > objectArray2.length) {
                    objectArray[objectArray2.length] = null;
                }
                return objectArray;
            }

            private static class UnmodifiableEntry
            implements Map.Entry {
                private Map.Entry e;

                public int hashCode() {
                    return ((Object)this.e).hashCode();
                }

                public Object getKey() {
                    return this.e.getKey();
                }

                public Object getValue() {
                    return this.e.getValue();
                }

                public boolean equals(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return Collections.access$000(this.e.getKey(), entry.getKey()) && Collections.access$000(this.e.getValue(), entry.getValue());
                }

                public String toString() {
                    return this.e.toString();
                }

                UnmodifiableEntry(Map.Entry entry) {
                    this.e = entry;
                }

                public Object setValue(Object object) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }

        public List subList(int n2, int n3) {
            return new UnmodifiableRandomAccessList(this.list.subList(n2, n3));
        }

        UnmodifiableRandomAccessList(List list) {
            super(list);
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set,
    Serializable {
        public int hashCode() {
            return ((Object)this.c).hashCode();
        }

        public boolean equals(Object object) {
            return ((Object)this.c).equals(object);
        }

        UnmodifiableSet(Set set) {
            super(set);
        }
    }

    static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap,
    Serializable {
        private SortedMap sm;

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        UnmodifiableSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        public SortedMap headMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.headMap(object));
        }

        public SortedMap tailMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.tailMap(object));
        }

        public SortedMap subMap(Object object, Object object2) {
            return new UnmodifiableSortedMap(this.sm.subMap(object, object2));
        }
    }

    static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet,
    Serializable {
        private SortedSet ss;

        public Object first() {
            return this.ss.first();
        }

        public Object last() {
            return this.ss.last();
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        UnmodifiableSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        public SortedSet headSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.headSet(object));
        }

        public SortedSet tailSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.tailSet(object));
        }

        public SortedSet subSet(Object object, Object object2) {
            return new UnmodifiableSortedSet(this.ss.subSet(object, object2));
        }
    }
}

