/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertPathHelperImpl;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.x509.CRLNumberExtension;
import sun.security.x509.X500Name;

public class X509CRLSelector
implements CRLSelector {
    private static final Debug debug;
    private HashSet issuerNames;
    private HashSet issuerX500Principals;
    private BigInteger minCRL;
    private BigInteger maxCRL;
    private Date dateAndTime;
    private X509Certificate certChecking;

    static {
        CertPathHelperImpl.initialize();
        debug = Debug.getInstance("certpath");
    }

    public void addIssuerName(byte[] byArray) throws IOException {
        this.addIssuerNameInternal(byArray.clone(), new X500Name(byArray).asX500Principal());
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.issuerNames != null) {
                this.issuerNames = new HashSet(this.issuerNames);
                this.issuerX500Principals = new HashSet(this.issuerX500Principals);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CRLSelector: [\n");
        if (this.issuerNames != null) {
            stringBuffer.append("  IssuerNames:\n");
            Iterator iterator = this.issuerNames.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    " + iterator.next() + "\n");
            }
        }
        if (this.minCRL != null) {
            stringBuffer.append("  minCRLNumber: " + this.minCRL + "\n");
        }
        if (this.maxCRL != null) {
            stringBuffer.append("  maxCRLNumber: " + this.maxCRL + "\n");
        }
        if (this.dateAndTime != null) {
            stringBuffer.append("  dateAndTime: " + this.dateAndTime + "\n");
        }
        if (this.certChecking != null) {
            stringBuffer.append("  Certificate being checked: " + this.certChecking + "\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addIssuerName(String string) throws IOException {
        this.addIssuerNameInternal(string, new X500Name(string, "RFC2253").asX500Principal());
    }

    public BigInteger getMaxCRL() {
        return this.maxCRL;
    }

    public BigInteger getMinCRL() {
        return this.minCRL;
    }

    public void setMaxCRLNumber(BigInteger bigInteger) {
        this.maxCRL = bigInteger;
    }

    public void setMinCRLNumber(BigInteger bigInteger) {
        this.minCRL = bigInteger;
    }

    public boolean match(CRL cRL) {
        Object object;
        Object object2;
        if (!(cRL instanceof X509CRL)) {
            return false;
        }
        X509CRL x509CRL = (X509CRL)cRL;
        if (this.issuerNames != null) {
            object2 = x509CRL.getIssuerX500Principal();
            object = this.issuerX500Principals.iterator();
            boolean bl2 = false;
            while (!bl2 && object.hasNext()) {
                if (!object.next().equals(object2)) continue;
                bl2 = true;
            }
            if (!bl2) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: issuer DNs don't match");
                }
                return false;
            }
        }
        if (this.minCRL != null || this.maxCRL != null) {
            object2 = x509CRL.getExtensionValue("2.5.29.20");
            if (object2 == null && debug != null) {
                debug.println("X509CRLSelector.match: no CRLNumber");
            }
            try {
                DerInputStream derInputStream = new DerInputStream((byte[])object2);
                byte[] byArray = derInputStream.getOctetString();
                CRLNumberExtension cRLNumberExtension = new CRLNumberExtension(Boolean.FALSE, byArray);
                object = (BigInteger)cRLNumberExtension.get("value");
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: exception in decoding CRL number");
                }
                return false;
            }
            if (this.minCRL != null && ((BigInteger)object).compareTo(this.minCRL) < 0) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: CRLNumber too small");
                }
                return false;
            }
            if (this.maxCRL != null && ((BigInteger)object).compareTo(this.maxCRL) > 0) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: CRLNumber too large");
                }
                return false;
            }
        }
        if (this.dateAndTime != null) {
            object2 = x509CRL.getThisUpdate();
            object = x509CRL.getNextUpdate();
            if (object == null) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: nextUpdate null");
                }
                return false;
            }
            if (((Date)object2).after(this.dateAndTime) || ((Date)object).before(this.dateAndTime)) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: update out of range");
                }
                return false;
            }
        }
        return true;
    }

    public X509Certificate getCertificateChecking() {
        return this.certChecking;
    }

    public void setCertificateChecking(X509Certificate x509Certificate) {
        this.certChecking = x509Certificate;
    }

    public Collection getIssuerNames() {
        if (this.issuerNames == null) {
            return null;
        }
        return X509CRLSelector.cloneIssuerNames(this.issuerNames);
    }

    Collection getIssuers() {
        return this.issuerX500Principals;
    }

    public void setIssuerNames(Collection collection) throws IOException {
        if (collection == null || collection.size() == 0) {
            this.issuerNames = null;
            this.issuerX500Principals = null;
        } else {
            HashSet hashSet = X509CRLSelector.cloneAndCheckIssuerNames(collection);
            this.issuerX500Principals = X509CRLSelector.parseIssuerNames(hashSet);
            this.issuerNames = hashSet;
        }
    }

    public Date getDateAndTime() {
        if (this.dateAndTime == null) {
            return null;
        }
        return (Date)this.dateAndTime.clone();
    }

    public void setDateAndTime(Date date) {
        this.dateAndTime = date == null ? null : (Date)date.clone();
    }

    void addIssuer(X500Principal x500Principal) {
        this.addIssuerNameInternal(x500Principal.getName(), x500Principal);
    }

    private static HashSet cloneAndCheckIssuerNames(Collection collection) throws IOException {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof byte[]) && !(object instanceof String)) {
                throw new IOException("name not byte array or String");
            }
            if (object instanceof byte[]) {
                hashSet.add(((byte[])object).clone());
                continue;
            }
            hashSet.add(object);
        }
        return hashSet;
    }

    private static HashSet cloneIssuerNames(Collection collection) {
        try {
            return X509CRLSelector.cloneAndCheckIssuerNames(collection);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static HashSet parseIssuerNames(Collection collection) throws IOException {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                hashSet.add(new X500Name((String)object, "RFC2253").asX500Principal());
                continue;
            }
            try {
                hashSet.add(new X500Principal((byte[])object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException("Invalid name").initCause(illegalArgumentException);
            }
        }
        return hashSet;
    }

    private void addIssuerNameInternal(Object object, X500Principal x500Principal) {
        if (this.issuerNames == null) {
            this.issuerNames = new HashSet();
        }
        if (this.issuerX500Principals == null) {
            this.issuerX500Principals = new HashSet();
        }
        this.issuerNames.add(object);
        this.issuerX500Principals.add(x500Principal);
    }
}

