/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import sun.awt.geom.Crossings;

public class Polygon
implements Shape,
Serializable {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;
    private static final long serialVersionUID = -6460061437900069969L;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(double var1_1, double var3_2) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(var1_1, var3_2)) {
            return false;
        }
        var5_3 = 0;
        var6_4 = this.xpoints[this.npoints - 1];
        var7_5 = this.ypoints[this.npoints - 1];
        for (var10_6 = 0; var10_6 < this.npoints; ++var10_6) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                var8_7 = this.xpoints[var10_6];
                                var9_8 = this.ypoints[var10_6];
                                if (var9_8 == var7_5) break block8;
                                if (var8_7 >= var6_4) break block9;
                                if (var1_1 >= (double)var6_4) break block8;
                                var11_9 = var8_7;
                                break block10;
                            }
                            if (var1_1 >= (double)var8_7) break block8;
                            var11_9 = var6_4;
                        }
                        if (var9_8 >= var7_5) break block11;
                        if (var3_2 < (double)var9_8 || var3_2 >= (double)var7_5) break block8;
                        if (!(var1_1 < (double)var11_9)) break block12;
                        ++var5_3;
                        break block8;
                    }
                    var12_10 = var1_1 - (double)var8_7;
                    var14_11 = var3_2 - (double)var9_8;
                    ** GOTO lbl34
                }
                if (var3_2 < (double)var7_5 || var3_2 >= (double)var9_8) break block8;
                if (var1_1 < (double)var11_9) {
                    ++var5_3;
                } else {
                    var12_10 = var1_1 - (double)var6_4;
                    var14_11 = var3_2 - (double)var7_5;
lbl34:
                    // 2 sources

                    if (var12_10 < var14_11 / (double)(var7_5 - var9_8) * (double)(var6_4 - var8_7)) {
                        ++var5_3;
                    }
                }
            }
            var6_4 = var8_7;
            var7_5 = var9_8;
        }
        return (var5_3 & true) != false;
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(d2, d3, d4, d5)) {
            return false;
        }
        Crossings crossings = this.getCrossings(d2, d3, d2 + d4, d3 + d5);
        return crossings != null && crossings.covers(d3, d3 + d5);
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(d2, d3, d4, d5)) {
            return false;
        }
        Crossings crossings = this.getCrossings(d2, d3, d2 + d4, d3 + d5);
        return crossings == null || !crossings.isEmpty();
    }

    public void addPoint(int n2, int n3) {
        if (this.npoints == this.xpoints.length) {
            int[] nArray = new int[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
            this.xpoints = nArray;
            nArray = new int[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
            this.ypoints = nArray;
        }
        this.xpoints[this.npoints] = n2;
        this.ypoints[this.npoints] = n3;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(n2, n3);
        }
    }

    public void translate(int n2, int n3) {
        int n4 = 0;
        while (n4 < this.npoints) {
            int n5 = n4;
            this.xpoints[n5] = this.xpoints[n5] + n2;
            int n6 = n4++;
            this.ypoints[n6] = this.ypoints[n6] + n3;
        }
        if (this.bounds != null) {
            this.bounds.translate(n2, n3);
        }
    }

    void updateBounds(int n2, int n3) {
        if (n2 < this.bounds.x) {
            this.bounds.width += this.bounds.x - n2;
            this.bounds.x = n2;
        } else {
            this.bounds.width = Math.max(this.bounds.width, n2 - this.bounds.x);
        }
        if (n3 < this.bounds.y) {
            this.bounds.height += this.bounds.y - n3;
            this.bounds.y = n3;
        } else {
            this.bounds.height = Math.max(this.bounds.height, n3 - this.bounds.y);
        }
    }

    public boolean contains(int n2, int n3) {
        return this.contains((double)n2, (double)n3);
    }

    public boolean inside(int n2, int n3) {
        return this.contains((double)n2, (double)n3);
    }

    public Polygon(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new int[n2];
        this.ypoints = new int[n2];
        System.arraycopy(nArray, 0, this.xpoints, 0, n2);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n2);
    }

    void calculateBounds(int[] nArray, int[] nArray2, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n7 = nArray[i2];
            n3 = Math.min(n3, n7);
            n5 = Math.max(n5, n7);
            int n8 = nArray2[i2];
            n4 = Math.min(n4, n8);
            n6 = Math.max(n6, n8);
        }
        this.bounds = new Rectangle(n3, n4, n5 - n3, n6 - n4);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Rectangle getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private Crossings getCrossings(double d2, double d3, double d4, double d5) {
        Crossings.EvenOdd evenOdd = new Crossings.EvenOdd(d2, d3, d4, d5);
        int n2 = this.xpoints[this.npoints - 1];
        int n3 = this.ypoints[this.npoints - 1];
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            int n4 = this.xpoints[i2];
            int n5 = this.ypoints[i2];
            if (evenOdd.accumulateLine(n2, n3, n4, n5)) {
                return null;
            }
            n2 = n4;
            n3 = n5;
        }
        return evenOdd;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PolygonPathIterator(this, this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.getPathIterator(affineTransform);
    }

    class PolygonPathIterator
    implements PathIterator {
        Polygon poly;
        AffineTransform transform;
        int index;
        private final Polygon this$0;

        public int getWindingRule() {
            return 0;
        }

        public void next() {
            ++this.index;
        }

        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        public int currentSegment(double[] dArray) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            dArray[0] = this.poly.xpoints[this.index];
            dArray[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(dArray, 0, dArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int currentSegment(float[] fArray) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            fArray[0] = this.poly.xpoints[this.index];
            fArray[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(fArray, 0, fArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public PolygonPathIterator(Polygon polygon, Polygon polygon2, AffineTransform affineTransform) {
            this.this$0 = polygon;
            this.poly = polygon2;
            this.transform = affineTransform;
            if (polygon2.npoints == 0) {
                this.index = 1;
            }
        }
    }
}

