/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class List
extends Component
implements ItemSelectable,
Accessible {
    Vector items = new Vector();
    int rows = 0;
    boolean multipleMode = false;
    int[] selected = new int[0];
    int visibleIndex = -1;
    transient ActionListener actionListener;
    transient ItemListener itemListener;
    private static final String base = "list";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -3304312411574666869L;
    static final int DEFAULT_VISIBLE_ROWS = 4;
    private int listSerializedDataVersion = 1;
    static Class class$java$awt$event$ItemListener;
    static Class class$java$awt$event$ActionListener;

    public int countItems() {
        return this.items.size();
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int getRows() {
        return this.rows;
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        return nArray.length == 1 ? nArray[0] : -1;
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public List() throws HeadlessException {
        this(0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createList(this);
            }
            super.addNotify();
        }
    }

    public synchronized void clear() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.clear();
        }
        this.items = new Vector();
        this.selected = new int[0];
    }

    public void removeAll() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
            super.removeNotify();
        }
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    public synchronized int[] getSelectedIndexes() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            this.selected = listPeer.getSelectedIndexes();
        }
        return (int[])this.selected.clone();
    }

    public List(int n2) throws HeadlessException {
        this(n2, false);
    }

    public void delItem(int n2) {
        this.delItems(n2, n2);
    }

    public synchronized void deselect(int n2) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.deselect(n2);
        }
        for (int i2 = 0; i2 < this.selected.length; ++i2) {
            if (this.selected[i2] != n2) continue;
            int[] nArray = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, nArray, 0, i2);
            System.arraycopy(this.selected, i2 + 1, nArray, i2, this.selected.length - (i2 + 1));
            this.selected = nArray;
            return;
        }
    }

    public synchronized void makeVisible(int n2) {
        this.visibleIndex = n2;
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.makeVisible(n2);
        }
    }

    public void remove(int n2) {
        this.delItem(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(int n2) {
        ListPeer listPeer;
        do {
            if ((listPeer = (ListPeer)this.peer) != null) {
                listPeer.select(n2);
                return;
            }
            List list = this;
            synchronized (list) {
                boolean bl2 = false;
                for (int i2 = 0; i2 < this.selected.length; ++i2) {
                    if (this.selected[i2] != n2) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (!this.multipleMode) {
                        this.selected = new int[1];
                        this.selected[0] = n2;
                    } else {
                        int[] nArray = new int[this.selected.length + 1];
                        System.arraycopy(this.selected, 0, nArray, 0, this.selected.length);
                        nArray[this.selected.length] = n2;
                        this.selected = nArray;
                    }
                }
            }
        } while (listPeer != this.peer);
    }

    public boolean isIndexSelected(int n2) {
        return this.isSelected(n2);
    }

    public boolean isSelected(int n2) {
        int[] nArray = this.getSelectedIndexes();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public synchronized void delItems(int n2, int n3) {
        for (int i2 = n3; i2 >= n2; --i2) {
            this.items.removeElementAt(i2);
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.delItems(n2, n3);
        }
    }

    public List(int n2, boolean bl2) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.rows = n2 != 0 ? n2 : 4;
        this.multipleMode = bl2;
    }

    public void setMultipleMode(boolean bl2) {
        this.setMultipleSelections(bl2);
    }

    public synchronized void setMultipleSelections(boolean bl2) {
        if (bl2 != this.multipleMode) {
            this.multipleMode = bl2;
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                listPeer.setMultipleSelections(bl2);
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 1001: {
                return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
            }
            case 701: {
                return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 ? this.minimumSize(this.rows) : super.minimumSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 ? this.preferredSize(this.rows) : super.preferredSize();
        }
    }

    public Dimension getMinimumSize(int n2) {
        return this.minimumSize(n2);
    }

    public Dimension getPreferredSize(int n2) {
        return this.preferredSize(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            return listPeer != null ? listPeer.minimumSize(n2) : super.minimumSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            return listPeer != null ? listPeer.preferredSize(n2) : super.preferredSize();
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        ActionListener actionListener = this.actionListener;
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = List.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        ItemListener itemListener = this.itemListener;
        if (itemListener != null) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = List.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        List list = this;
        synchronized (list) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public synchronized String getSelectedItem() {
        int n2 = this.getSelectedIndex();
        return n2 < 0 ? null : this.getItem(n2);
    }

    protected String paramString() {
        return super.paramString() + ",selected=" + this.getSelectedItem();
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.items.size()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = this.getItem(nArray[i2]);
        }
        return stringArray;
    }

    public String getItem(int n2) {
        return this.getItemImpl(n2);
    }

    final String getItemImpl(int n2) {
        return (String)this.items.elementAt(n2);
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public synchronized void remove(String string) {
        int n2 = this.items.indexOf(string);
        if (n2 < 0) {
            throw new IllegalArgumentException("item " + string + " not found in list");
        }
        this.remove(n2);
    }

    public void add(String string, int n2) {
        this.addItem(string, n2);
    }

    public synchronized void addItem(String string, int n2) {
        if (n2 < -1 || n2 >= this.items.size()) {
            n2 = -1;
        }
        if (string == null) {
            string = "";
        }
        if (n2 == -1) {
            this.items.addElement(string);
        } else {
            this.items.insertElementAt(string, n2);
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.addItem(string, n2);
        }
    }

    public synchronized void replaceItem(String string, int n2) {
        this.remove(n2);
        this.add(string, n2);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTList(this);
        }
        return this.accessibleContext;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener eventListener = null;
        if (clazz == (class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = List.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener)) {
            eventListener = this.actionListener;
        } else if (clazz == (class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = List.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener)) {
            eventListener = this.itemListener;
        } else {
            return super.getListeners(clazz);
        }
        return AWTEventMulticaster.getListeners(eventListener, clazz);
    }

    protected class AccessibleAWTList
    extends Component.AccessibleAWTComponent
    implements AccessibleSelection,
    ItemListener,
    ActionListener {
        private final List this$0;

        public int getAccessibleChildrenCount() {
            return this.this$0.getItemCount();
        }

        public int getAccessibleSelectionCount() {
            return this.this$0.getSelectedIndexes().length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAccessibleSelection() {
            List list = this.this$0;
            synchronized (list) {
                int[] nArray = this.this$0.getSelectedIndexes();
                if (nArray == null) {
                    return;
                }
                for (int i2 = nArray.length; i2 >= 0; --i2) {
                    this.this$0.deselect(nArray[i2]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectAllAccessibleSelection() {
            List list = this.this$0;
            synchronized (list) {
                for (int i2 = this.this$0.getItemCount() - 1; i2 >= 0; --i2) {
                    this.this$0.select(i2);
                }
            }
        }

        public void addAccessibleSelection(int n2) {
            this.this$0.select(n2);
        }

        public void removeAccessibleSelection(int n2) {
            this.this$0.deselect(n2);
        }

        public boolean isAccessibleChildSelected(int n2) {
            return this.this$0.isIndexSelected(n2);
        }

        public AccessibleAWTList(List list) {
            this.this$0 = list;
            super(list);
            list.addActionListener(this);
            list.addItemListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Accessible getAccessibleChild(int n2) {
            List list = this.this$0;
            synchronized (list) {
                if (n2 >= this.this$0.getItemCount()) {
                    return null;
                }
                return new AccessibleAWTListChild(this, this.this$0, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Accessible getAccessibleSelection(int n2) {
            List list = this.this$0;
            synchronized (list) {
                int n3 = this.getAccessibleSelectionCount();
                if (n2 <= 0 || n2 >= n3) {
                    return null;
                }
                return this.getAccessibleChild(this.this$0.getSelectedIndexes()[n2]);
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isMultipleMode()) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        static List access$000(AccessibleAWTList accessibleAWTList) {
            return accessibleAWTList.this$0;
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        protected class AccessibleAWTListChild
        extends Component.AccessibleAWTComponent
        implements Accessible {
            private List parent;
            private int indexInParent;
            private final AccessibleAWTList this$1;

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public void requestFocus() {
            }

            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            public boolean isFocusTraversable() {
                return false;
            }

            public boolean isShowing() {
                return false;
            }

            public boolean isVisible() {
                return false;
            }

            public void setEnabled(boolean bl2) {
                this.parent.setEnabled(bl2);
            }

            public void setVisible(boolean bl2) {
                this.parent.setVisible(bl2);
            }

            public Color getBackground() {
                return this.parent.getBackground();
            }

            public Color getForeground() {
                return this.parent.getForeground();
            }

            public void setBackground(Color color) {
                this.parent.setBackground(color);
            }

            public void setForeground(Color color) {
                this.parent.setForeground(color);
            }

            public Cursor getCursor() {
                return this.parent.getCursor();
            }

            public void setCursor(Cursor cursor) {
                this.parent.setCursor(cursor);
            }

            public Dimension getSize() {
                return null;
            }

            public void setSize(Dimension dimension) {
            }

            public Font getFont() {
                return this.parent.getFont();
            }

            public void setFont(Font font) {
                this.parent.setFont(font);
            }

            public Point getLocation() {
                return null;
            }

            public Point getLocationOnScreen() {
                return null;
            }

            public void setLocation(Point point) {
            }

            public boolean contains(Point point) {
                return false;
            }

            public Rectangle getBounds() {
                return null;
            }

            public void setBounds(Rectangle rectangle) {
            }

            public void addFocusListener(FocusListener focusListener) {
            }

            public void removeFocusListener(FocusListener focusListener) {
            }

            public Locale getLocale() {
                return this.parent.getLocale();
            }

            public Accessible getAccessibleChild(int n2) {
                return null;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                if (this.parent.isIndexSelected(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.parent.getFontMetrics(font);
            }

            public AccessibleAWTListChild(AccessibleAWTList accessibleAWTList, List list, int n2) {
                this.this$1 = accessibleAWTList;
                super(AccessibleAWTList.access$000(accessibleAWTList));
                this.parent = list;
                this.setAccessibleParent(list);
                this.indexInParent = n2;
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }
        }
    }
}

