/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12NewEventDispatcherAction;
import com.sun.media.sound.JDK12TopmostThreadGroupAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class EventDispatcher
implements Runnable {
    private static final int AUTO_CLOSE_TIME = 5000;
    private long lastProcessEventTime = System.currentTimeMillis();
    private Vector eventQueue = new Vector();
    private boolean done = false;
    Thread thread = null;
    static boolean creatingThread = false;
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private static ThreadGroup topmostThreadGroup = null;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private ArrayList autoClosingClips = new ArrayList();

    EventDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAutoClosingClips() {
        ArrayList arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            for (int i2 = this.autoClosingClips.size() - 1; i2 >= 0; --i2) {
                AutoClosingClip autoClosingClip = (AutoClosingClip)this.autoClosingClips.get(i2);
                if (!autoClosingClip.isOpen() || !autoClosingClip.isAutoClosing()) {
                    this.autoClosingClips.remove(i2);
                    continue;
                }
                if (autoClosingClip.isRunning() || autoClosingClip.isActive() || !autoClosingClip.isAutoClosing()) continue;
                autoClosingClip.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                if (!this.done && this.eventQueue.size() == 0) {
                    if (this.autoClosingClips.size() > 0) {
                        this.wait(5100L);
                    } else {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.done = true;
                this.notifyAll();
            }
            if (!this.done && this.eventQueue.size() > 0) {
                eventInfo = (EventInfo)this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            }
        }
        if (!this.done) {
            if (eventInfo != null) {
                this.lastProcessEventTime = System.currentTimeMillis();
                this.processEvent(eventInfo);
            } else {
                long l2 = System.currentTimeMillis() - this.lastProcessEventTime;
                if (l2 >= 5000L) {
                    this.closeAutoClosingClips();
                }
            }
        }
    }

    private static void initSecurity() {
        securityPrivilege = true;
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
        }
        catch (SecurityException securityException) {
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        Constructor constructor = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[0])});
                    }
                    catch (Exception exception) {
                        topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                }
            }
        } else {
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }

    synchronized void kill() {
        this.done = true;
        this.notifyAll();
    }

    public void run() {
        while (!this.done) {
            try {
                this.dispatchEvents();
            }
            catch (Throwable throwable) {}
        }
    }

    void start() {
        if (this.thread == null && !creatingThread || this.done) {
            EventDispatcher.initSecurity();
            EventDispatcher eventDispatcher = this;
            this.done = false;
            if (securityPrivilege && jsSecurity != null) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        creatingThread = true;
                        Constructor constructor = JDK12NewEventDispatcherAction.cons;
                        Object[] objectArray = new Object[]{topmostThreadGroup, eventDispatcher};
                        this.thread = (Thread)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(objectArray)});
                        creatingThread = false;
                    }
                    catch (InstantiationException instantiationException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                } else {
                    try {
                        jsSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke(this.cl[0], this.args[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    this.thread = new Thread(topmostThreadGroup, this);
                    this.thread.start();
                }
            } else {
                this.thread = new Thread(topmostThreadGroup, this);
                this.thread.start();
            }
            if (this.thread != null) {
                try {
                    this.thread.setName("Java Sound event dispatcher");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    void autoClosingClipClosed(AutoClosingClip autoClosingClip) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoClosingClipOpened(AutoClosingClip autoClosingClip) {
        int n2 = 0;
        Object object = this.autoClosingClips;
        synchronized (object) {
            n2 = this.autoClosingClips.indexOf(autoClosingClip);
            if (n2 == -1) {
                this.autoClosingClips.add(autoClosingClip);
            }
        }
        if (n2 == -1) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.addElement(eventInfo);
        this.notifyAll();
    }

    protected void processEvent(EventInfo eventInfo) {
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent lineEvent = (LineEvent)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                ((LineListener)vector.elementAt(i2)).update(lineEvent);
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                ((MetaEventListener)vector.elementAt(i3)).meta(metaMessage);
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)eventInfo.getEvent();
            int n2 = shortMessage.getStatus();
            if (n2 >> 4 == 11) {
                Vector vector = eventInfo.getListeners();
                for (int i4 = 0; i4 < vector.size(); ++i4) {
                    ((ControllerEventListener)vector.elementAt(i4)).controlChange(shortMessage);
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    void sendAudioEvents(Object object, Vector vector) {
        this.start();
        Vector vector2 = (Vector)vector.clone();
        EventInfo eventInfo = new EventInfo(this, object, vector2);
        this.postEvent(eventInfo);
    }

    class EventInfo {
        private Object event;
        private Vector listeners;
        private final EventDispatcher this$0;

        Object getEvent() {
            return this.event;
        }

        Vector getListeners() {
            return this.listeners;
        }

        EventInfo(EventDispatcher eventDispatcher, Object object, Vector vector) {
            this.this$0 = eventDispatcher;
            this.event = object;
            this.listeners = vector;
        }
    }
}

