/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifDesktopIconUI;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class MotifInternalFrameUI
extends BasicInternalFrameUI {
    Color color;
    Color highlight;
    Color shadow;
    MotifInternalFrameTitlePane titlePane;
    protected KeyStroke closeMenuKey;

    protected void installDefaults() {
        Border border = this.frame.getBorder();
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        if (border == null || border instanceof UIResource) {
            this.frame.setBorder(new MotifBorders.InternalFrameBorder(this.frame));
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.closeMenuKey = KeyStroke.getKeyStroke(27, 0);
    }

    protected void setupMenuCloseKey() {
        Object object;
        JInternalFrame.JDesktopIcon jDesktopIcon;
        InputMap inputMap;
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.frame);
        if (actionMap != null) {
            actionMap.put("hideSystemMenu", new AbstractAction(this){
                private final MotifInternalFrameUI this$0;

                public boolean isEnabled() {
                    return this.this$0.isKeyBindingActive();
                }
                {
                    this.this$0 = motifInternalFrameUI;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.titlePane.hideSystemMenu();
                }
            });
        }
        if ((inputMap = SwingUtilities.getUIInputMap(jDesktopIcon = this.frame.getDesktopIcon(), 2)) == null && (object = (Object[])UIManager.get("DesktopIcon.windowBindings")) != null) {
            inputMap = LookAndFeel.makeComponentInputMap(jDesktopIcon, (Object[])object);
            SwingUtilities.replaceUIInputMap(jDesktopIcon, 2, inputMap);
        }
        if ((object = SwingUtilities.getUIActionMap(jDesktopIcon)) == null) {
            object = new ActionMapUIResource();
            ((ActionMap)object).put("hideSystemMenu", new AbstractAction(this){
                private final MotifInternalFrameUI this$0;

                public boolean isEnabled() {
                    return this.this$0.isKeyBindingActive();
                }
                {
                    this.this$0 = motifInternalFrameUI;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JInternalFrame.JDesktopIcon jDesktopIcon = MotifInternalFrameUI.access$000(this.this$0).getDesktopIcon();
                    MotifDesktopIconUI motifDesktopIconUI = (MotifDesktopIconUI)jDesktopIcon.getUI();
                    motifDesktopIconUI.hideSystemMenu();
                }
            });
            SwingUtilities.replaceUIActionMap(jDesktopIcon, (ActionMap)object);
        }
    }

    protected void setupMenuOpenKey() {
        super.setupMenuOpenKey();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.frame);
        if (actionMap != null) {
            actionMap.put("showSystemMenu", new AbstractAction(this){
                private final MotifInternalFrameUI this$0;

                public boolean isEnabled() {
                    return this.this$0.isKeyBindingActive();
                }
                {
                    this.this$0 = motifInternalFrameUI;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.titlePane.showSystemMenu();
                }
            });
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.frame);
        this.frame.setLayout(null);
        this.internalFrameLayout = null;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        if (this.isKeyBindingRegistered()) {
            JInternalFrame.JDesktopIcon jDesktopIcon = this.frame.getDesktopIcon();
            SwingUtilities.replaceUIActionMap(jDesktopIcon, null);
            SwingUtilities.replaceUIInputMap(jDesktopIcon, 2, null);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.setColors((JInternalFrame)jComponent);
    }

    private JInternalFrame getFrame() {
        return this.frame;
    }

    public MotifInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        super.activateFrame(jInternalFrame);
        this.setColors(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.setColors(jInternalFrame);
        super.deactivateFrame(jInternalFrame);
    }

    void setColors(JInternalFrame jInternalFrame) {
        this.color = jInternalFrame.isSelected() ? UIManager.getColor("InternalFrame.activeTitleBackground") : UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.highlight = this.color.brighter();
        this.shadow = this.color.darker().darker();
        this.titlePane.setColors(this.color, this.highlight, this.shadow);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MotifInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    static JInternalFrame access$000(MotifInternalFrameUI motifInternalFrameUI) {
        return motifInternalFrameUI.getFrame();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifInternalFrameUI((JInternalFrame)jComponent);
    }
}

