/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.javax.rmi.CORBA;

import com.sun.corba.se.internal.util.Utility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.PortableServer.Servant;

public class StubDelegateImpl
implements StubDelegate {
    private int hashCode = 0;
    private int typeLength;
    private byte[] typeData;
    private int numProfiles = 0;
    private int[] profileTags;
    private byte[][] profileData;

    public int hashCode(Stub stub) {
        this.init(stub);
        if (this.hashCode == 0) {
            int n2;
            for (n2 = 0; n2 < this.typeLength; ++n2) {
                this.hashCode = this.hashCode * 37 + this.typeData[n2];
            }
            for (n2 = 0; n2 < this.numProfiles; ++n2) {
                this.hashCode = this.hashCode * 37 + this.profileTags[n2];
                for (int i2 = 0; i2 < this.profileData[n2].length; ++i2) {
                    this.hashCode = this.hashCode * 37 + this.profileData[n2][i2];
                }
            }
        }
        return this.hashCode;
    }

    private void init(Stub stub) {
        if (this.numProfiles == 0) {
            OutputStream outputStream = stub._orb().create_output_stream();
            outputStream.write_Object(stub);
            InputStream inputStream = outputStream.create_input_stream();
            this.typeLength = inputStream.read_long();
            this.typeData = new byte[this.typeLength];
            inputStream.read_octet_array(this.typeData, 0, this.typeLength);
            this.numProfiles = inputStream.read_long();
            this.profileTags = new int[this.numProfiles];
            this.profileData = new byte[this.numProfiles][];
            for (int i2 = 0; i2 < this.numProfiles; ++i2) {
                this.profileTags[i2] = inputStream.read_long();
                this.profileData[i2] = new byte[inputStream.read_long()];
                inputStream.read_octet_array(this.profileData[i2], 0, this.profileData[i2].length);
            }
        }
    }

    public void readObject(Stub stub, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.typeLength = objectInputStream.readInt();
        this.typeData = new byte[this.typeLength];
        objectInputStream.readFully(this.typeData);
        this.numProfiles = objectInputStream.readInt();
        this.profileTags = new int[this.numProfiles];
        this.profileData = new byte[this.numProfiles][];
        for (int i2 = 0; i2 < this.numProfiles; ++i2) {
            this.profileTags[i2] = objectInputStream.readInt();
            this.profileData[i2] = new byte[objectInputStream.readInt()];
            objectInputStream.readFully(this.profileData[i2]);
        }
    }

    public void writeObject(Stub stub, ObjectOutputStream objectOutputStream) throws IOException {
        this.init(stub);
        objectOutputStream.writeInt(this.typeLength);
        objectOutputStream.write(this.typeData);
        objectOutputStream.writeInt(this.numProfiles);
        for (int i2 = 0; i2 < this.numProfiles; ++i2) {
            objectOutputStream.writeInt(this.profileTags[i2]);
            objectOutputStream.writeInt(this.profileData[i2].length);
            objectOutputStream.write(this.profileData[i2]);
        }
    }

    public boolean equals(Stub stub, java.lang.Object object) {
        if (stub == object) {
            return true;
        }
        if (!(object instanceof Stub)) {
            return false;
        }
        Stub stub2 = (Stub)object;
        if (stub2.hashCode() != stub.hashCode()) {
            return false;
        }
        return stub.toString().equals(stub2.toString());
    }

    public String toString(Stub stub) {
        try {
            return stub._orb().object_to_string(stub);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            return null;
        }
    }

    public void connect(Stub stub, ORB oRB) throws RemoteException {
        boolean bl2;
        block16: {
            bl2 = false;
            try {
                Delegate delegate = stub._get_delegate();
                if (delegate.orb(stub) != oRB) {
                    bl2 = true;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                if (this.numProfiles == 0) {
                    Tie tie = Utility.getAndForgetTie(stub);
                    if (tie == null) {
                        bl2 = true;
                    }
                    try {
                        ORB oRB2 = tie.orb();
                        if (oRB2 != oRB) {
                            bl2 = true;
                        }
                    }
                    catch (SystemException systemException) {
                        if (!(systemException instanceof BAD_OPERATION) && !(systemException instanceof BAD_INV_ORDER)) {
                            throw systemException;
                        }
                        if (tie instanceof ObjectImpl) {
                            tie.orb(oRB);
                            stub._set_delegate(((ObjectImpl)((java.lang.Object)tie))._get_delegate());
                            break block16;
                        }
                        tie.orb(oRB);
                        try {
                            Object object = ((Servant)((java.lang.Object)tie))._this_object();
                            stub._set_delegate(((ObjectImpl)object)._get_delegate());
                            break block16;
                        }
                        catch (BAD_INV_ORDER bAD_INV_ORDER) {
                            bl2 = true;
                        }
                    }
                }
                try {
                    OutputStream outputStream = oRB.create_output_stream();
                    outputStream.write_long(this.typeLength);
                    outputStream.write_octet_array(this.typeData, 0, this.typeLength);
                    outputStream.write_long(this.numProfiles);
                    for (int i2 = 0; i2 < this.numProfiles; ++i2) {
                        outputStream.write_long(this.profileTags[i2]);
                        outputStream.write_long(this.profileData[i2].length);
                        outputStream.write_octet_array(this.profileData[i2], 0, this.profileData[i2].length);
                    }
                    ObjectImpl objectImpl = (ObjectImpl)outputStream.create_input_stream().read_Object();
                    stub._set_delegate(objectImpl._get_delegate());
                }
                catch (Exception exception) {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            throw new RemoteException("CORBA BAD_OPERATION 0");
        }
    }
}

