/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PConstants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PImage
implements PConstants,
Cloneable {
    static final int PRECISIONB = 15;
    static final int PRECISIONF = 32768;
    static final int PREC_MAXVAL = Short.MAX_VALUE;
    static final int PREC_ALPHA_SHIFT = 9;
    static final int PREC_RED_SHIFT = 1;
    static byte[] TIFF_HEADER;
    static final String TIFF_ERROR = "Error: Processing can only read its own TIFF files.";
    public int format;
    public int[] pixels;
    public int width;
    public int height;
    public PApplet parent;
    public int imageMode;
    public boolean smooth;
    public Object cache;
    public boolean modified;
    public int mx1;
    public int my1;
    public int mx2;
    public int my2;
    private int fracU;
    private int ifU;
    private int fracV;
    private int ifV;
    private int u1;
    private int u2;
    private int v1;
    private int v2;
    private int sX;
    private int sY;
    private int iw;
    private int iw1;
    private int ih1;
    private int ul;
    private int ll;
    private int ur;
    private int lr;
    private int cUL;
    private int cLL;
    private int cUR;
    private int cLR;
    private int srcXOffset;
    private int srcYOffset;
    private int r;
    private int g;
    private int b;
    private int a;
    private int[] srcBuffer;
    int blurRadius;
    int blurKernelSize;
    int[] blurKernel;
    int[][] blurMult;
    protected String[] saveImageFormats;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    public void init(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.pixels = new int[n * n2];
        this.format = n3;
        this.cache = null;
    }

    protected void checkAlpha() {
        if (this.pixels == null) {
            return;
        }
        int n = 0;
        while (n < this.pixels.length) {
            if ((this.pixels[n] & 0xFF000000) != -16777216) {
                this.format = 2;
                break;
            }
            ++n;
        }
    }

    public void imageMode(int n) {
        if (n != 0 && n != 1) {
            String string = "imageMode() only works with CORNER or CORNERS";
            throw new RuntimeException(string);
        }
        this.imageMode = n;
    }

    public void smooth() {
        this.smooth = true;
    }

    public void noSmooth() {
        this.smooth = false;
    }

    public void loadPixels() {
    }

    public void updatePixels() {
        this.updatePixels(0, 0, this.width, this.height);
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        if (this.imageMode == 0) {
            n3 += n;
            n4 += n2;
        }
        if (!this.modified) {
            this.mx1 = n;
            this.mx2 = n3;
            this.my1 = n2;
            this.my2 = n4;
            this.modified = true;
        } else {
            if (n < this.mx1) {
                this.mx1 = n;
            }
            if (n > this.mx2) {
                this.mx2 = n;
            }
            if (n2 < this.my1) {
                this.my1 = n2;
            }
            if (n2 > this.my2) {
                this.my2 = n2;
            }
            if (n3 < this.mx1) {
                this.mx1 = n3;
            }
            if (n3 > this.mx2) {
                this.mx2 = n3;
            }
            if (n4 < this.my1) {
                this.my1 = n4;
            }
            if (n4 > this.my2) {
                this.my2 = n4;
            }
        }
    }

    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        switch (this.format) {
            case 1: {
                return this.pixels[n2 * this.width + n] | 0xFF000000;
            }
            case 2: {
                return this.pixels[n2 * this.width + n];
            }
            case 4: {
                return this.pixels[n2 * this.width + n] << 24 | 0xFFFFFF;
            }
        }
        return 0;
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (this.imageMode == 1) {
            n3 -= n;
            n4 -= n;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        PImage pImage = new PImage(n3, n4, this.format);
        pImage.parent = this.parent;
        int n5 = n2 * this.width + n;
        int n6 = 0;
        int n7 = n2;
        while (n7 < n2 + n4) {
            System.arraycopy(this.pixels, n5, pImage.pixels, n6, n3);
            n5 += this.width;
            n6 += n3;
            ++n7;
        }
        return pImage;
    }

    public PImage get() {
        try {
            return (PImage)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        this.pixels[n2 * this.width + n] = n3;
    }

    public void set(int n, int n2, PImage pImage) {
        int n3 = 0;
        int n4 = 0;
        int n5 = pImage.width;
        int n6 = pImage.height;
        if (n < 0) {
            n3 -= n;
            n5 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 -= n2;
            n6 += n2;
            n2 = 0;
        }
        if (n + n5 > this.width) {
            n5 = this.width - n;
        }
        if (n2 + n6 > this.height) {
            n6 = this.height - n2;
        }
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        this.setImpl(n, n2, n3, n4, n5, n6, pImage);
    }

    protected void setImpl(int n, int n2, int n3, int n4, int n5, int n6, PImage pImage) {
        int n7 = n4 * pImage.width + n3;
        int n8 = n2 * this.width + n;
        int n9 = n4;
        while (n9 < n4 + n6) {
            System.arraycopy(pImage.pixels, n7, this.pixels, n8, n5);
            n7 += pImage.width;
            n8 += this.width;
            ++n9;
        }
    }

    public void mask(int[] nArray) {
        if (nArray.length != this.pixels.length) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        int n = 0;
        while (n < this.pixels.length) {
            this.pixels[n] = (nArray[n] & 0xFF) << 24 | this.pixels[n] & 0xFFFFFF;
            ++n;
        }
        this.format = 2;
    }

    public void mask(PImage pImage) {
        this.mask(pImage.pixels);
    }

    public void filter(int n) {
        this.loadPixels();
        switch (n) {
            case 11: {
                this.filter(11, 1.0f);
                break;
            }
            case 12: {
                if (this.format == 4) {
                    int n2 = 0;
                    while (n2 < this.pixels.length) {
                        int n3 = 255 - this.pixels[n2];
                        this.pixels[n2] = 0xFF000000 | n3 << 16 | n3 << 8 | n3;
                        ++n2;
                    }
                    this.format = 1;
                    break;
                }
                int n4 = 0;
                while (n4 < this.pixels.length) {
                    int n5 = this.pixels[n4];
                    int n6 = 77 * (n5 >> 16 & 0xFF) + 151 * (n5 >> 8 & 0xFF) + 28 * (n5 & 0xFF) >> 8;
                    this.pixels[n4] = n5 & 0xFF000000 | n6 << 16 | n6 << 8 | n6;
                    ++n4;
                }
                break;
            }
            case 13: {
                int n7 = 0;
                while (n7 < this.pixels.length) {
                    int n8 = n7++;
                    this.pixels[n8] = this.pixels[n8] ^ 0xFFFFFF;
                }
                break;
            }
            case 15: {
                throw new RuntimeException("Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)");
            }
            case 1: {
                int n9 = 0;
                while (n9 < this.pixels.length) {
                    int n10 = n9++;
                    this.pixels[n10] = this.pixels[n10] | 0xFF000000;
                }
                this.format = 1;
                break;
            }
            case 16: {
                this.filter(16, 0.5f);
                break;
            }
            case 17: {
                this.dilate(true);
                break;
            }
            case 18: {
                this.dilate(false);
                break;
            }
        }
        this.updatePixels();
    }

    public void filter(int n, float f) {
        this.loadPixels();
        switch (n) {
            case 11: {
                if (this.format == 4) {
                    this.blurAlpha(f);
                    break;
                }
                if (this.format == 2) {
                    this.blurARGB(f);
                    break;
                }
                this.blurRGB(f);
                break;
            }
            case 12: {
                throw new RuntimeException("Use filter(GRAY) instead of filter(GRAY, param)");
            }
            case 13: {
                throw new RuntimeException("Use filter(INVERT) instead of filter(INVERT, param)");
            }
            case 14: {
                throw new RuntimeException("Use filter(OPAQUE) instead of filter(OPAQUE, param)");
            }
            case 15: {
                int n2 = (int)f;
                if (n2 < 2 || n2 > 255) {
                    throw new RuntimeException("Levels must be between 2 and 255 for filter(POSTERIZE, levels)");
                }
                int n3 = n2 - 1;
                int n4 = 0;
                while (n4 < this.pixels.length) {
                    int n5 = this.pixels[n4] >> 16 & 0xFF;
                    int n6 = this.pixels[n4] >> 8 & 0xFF;
                    int n7 = this.pixels[n4] & 0xFF;
                    n5 = (n5 * n2 >> 8) * 255 / n3;
                    n6 = (n6 * n2 >> 8) * 255 / n3;
                    n7 = (n7 * n2 >> 8) * 255 / n3;
                    this.pixels[n4] = 0xFF000000 & this.pixels[n4] | n5 << 16 | n6 << 8 | n7;
                    ++n4;
                }
                break;
            }
            case 16: {
                int n8 = (int)(f * 255.0f);
                int n9 = 0;
                while (n9 < this.pixels.length) {
                    int n10 = Math.max((this.pixels[n9] & 0xFF0000) >> 16, Math.max((this.pixels[n9] & 0xFF00) >> 8, this.pixels[n9] & 0xFF));
                    this.pixels[n9] = this.pixels[n9] & 0xFF000000 | (n10 < n8 ? 0 : 0xFFFFFF);
                    ++n9;
                }
                break;
            }
            case 17: {
                throw new RuntimeException("Use filter(ERODE) instead of filter(ERODE, param)");
            }
            case 18: {
                throw new RuntimeException("Use filter(DILATE) instead of filter(DILATE, param)");
            }
        }
        this.updatePixels();
    }

    protected void buildBlurKernel(float f) {
        int n = (int)(f * 3.5f);
        int n2 = 1;
        if (n >= 1) {
            n2 = n < 248 ? n : 248;
        }
        if (this.blurRadius != (n = n2)) {
            int[] nArray;
            this.blurRadius = n;
            this.blurKernelSize = 1 + this.blurRadius << 1;
            this.blurKernel = new int[this.blurKernelSize];
            this.blurMult = new int[this.blurKernelSize][256];
            int n3 = 1;
            int n4 = n - 1;
            while (n3 < n) {
                int n5;
                this.blurKernel[n4] = n5 = n4 * n4;
                this.blurKernel[n + n3] = n5;
                nArray = this.blurMult[n + n3];
                int[] nArray2 = this.blurMult[n4--];
                int n6 = 0;
                while (n6 < 256) {
                    nArray[n6] = nArray2[n6] = n5 * n6;
                    ++n6;
                }
                ++n3;
            }
            int n7 = this.blurKernel[n] = n * n;
            nArray = this.blurMult[n];
            n3 = 0;
            while (n3 < 256) {
                nArray[n3] = n7 * n3;
                ++n3;
            }
        }
    }

    protected void blurAlpha(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = new int[this.pixels.length];
        int n8 = 0;
        this.buildBlurKernel(f);
        int n9 = 0;
        while (n9 < this.height) {
            n7 = 0;
            while (n7 < this.width) {
                n6 = 0;
                n5 = 0;
                n4 = n7 - this.blurRadius;
                if (n4 < 0) {
                    n3 = -n4;
                    n4 = 0;
                } else {
                    if (n4 >= this.width) break;
                    n3 = 0;
                }
                n2 = n3;
                while (n2 < this.blurKernelSize) {
                    if (n4 >= this.width) break;
                    int n10 = this.pixels[n4 + n8];
                    int[] nArray2 = this.blurMult[n2];
                    n5 += nArray2[n10 & 0xFF];
                    n6 += this.blurKernel[n2];
                    ++n4;
                    ++n2;
                }
                n = n8 + n7;
                nArray[n] = n5 / n6;
                ++n7;
            }
            n8 += this.width;
            ++n9;
        }
        n8 = 0;
        int n11 = -this.blurRadius;
        int n12 = n11 * this.width;
        n9 = 0;
        while (n9 < this.height) {
            n7 = 0;
            while (n7 < this.width) {
                n6 = 0;
                n5 = 0;
                if (n11 < 0) {
                    n3 = n = -n11;
                    n4 = n7;
                } else {
                    if (n11 >= this.height) break;
                    n3 = 0;
                    n = n11;
                    n4 = n7 + n12;
                }
                n2 = n3;
                while (n2 < this.blurKernelSize) {
                    if (n >= this.height) break;
                    int[] nArray3 = this.blurMult[n2];
                    n5 += nArray3[nArray[n4]];
                    n6 += this.blurKernel[n2];
                    ++n;
                    n4 += this.width;
                    ++n2;
                }
                this.pixels[n7 + n8] = n5 / n6;
                ++n7;
            }
            n8 += this.width;
            n12 += this.width;
            ++n11;
            ++n9;
        }
    }

    protected void blurRGB(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = new int[this.pixels.length];
        int[] nArray2 = new int[this.pixels.length];
        int[] nArray3 = new int[this.pixels.length];
        int n10 = 0;
        this.buildBlurKernel(f);
        int n11 = 0;
        while (n11 < this.height) {
            n9 = 0;
            while (n9 < this.width) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = n9 - this.blurRadius;
                if (n4 < 0) {
                    n3 = -n4;
                    n4 = 0;
                } else {
                    if (n4 >= this.width) break;
                    n3 = 0;
                }
                n2 = n3;
                while (n2 < this.blurKernelSize) {
                    if (n4 >= this.width) break;
                    int n12 = this.pixels[n4 + n10];
                    int[] nArray4 = this.blurMult[n2];
                    n7 += nArray4[(n12 & 0xFF0000) >> 16];
                    n6 += nArray4[(n12 & 0xFF00) >> 8];
                    n5 += nArray4[n12 & 0xFF];
                    n8 += this.blurKernel[n2];
                    ++n4;
                    ++n2;
                }
                n = n10 + n9;
                nArray[n] = n7 / n8;
                nArray2[n] = n6 / n8;
                nArray3[n] = n5 / n8;
                ++n9;
            }
            n10 += this.width;
            ++n11;
        }
        n10 = 0;
        int n13 = -this.blurRadius;
        int n14 = n13 * this.width;
        n11 = 0;
        while (n11 < this.height) {
            n9 = 0;
            while (n9 < this.width) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                if (n13 < 0) {
                    n3 = n = -n13;
                    n4 = n9;
                } else {
                    if (n13 >= this.height) break;
                    n3 = 0;
                    n = n13;
                    n4 = n9 + n14;
                }
                n2 = n3;
                while (n2 < this.blurKernelSize) {
                    if (n >= this.height) break;
                    int[] nArray5 = this.blurMult[n2];
                    n7 += nArray5[nArray[n4]];
                    n6 += nArray5[nArray2[n4]];
                    n5 += nArray5[nArray3[n4]];
                    n8 += this.blurKernel[n2];
                    ++n;
                    n4 += this.width;
                    ++n2;
                }
                this.pixels[n9 + n10] = 0xFF000000 | n7 / n8 << 16 | n6 / n8 << 8 | n5 / n8;
                ++n9;
            }
            n10 += this.width;
            n14 += this.width;
            ++n13;
            ++n11;
        }
    }

    protected void blurARGB(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.pixels.length;
        int[] nArray = new int[n11];
        int[] nArray2 = new int[n11];
        int[] nArray3 = new int[n11];
        int[] nArray4 = new int[n11];
        int n12 = 0;
        this.buildBlurKernel(f);
        int n13 = 0;
        while (n13 < this.height) {
            n10 = 0;
            while (n10 < this.width) {
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = n10 - this.blurRadius;
                if (n4 < 0) {
                    n3 = -n4;
                    n4 = 0;
                } else {
                    if (n4 >= this.width) break;
                    n3 = 0;
                }
                n2 = n3;
                while (n2 < this.blurKernelSize) {
                    if (n4 >= this.width) break;
                    int n14 = this.pixels[n4 + n12];
                    int[] nArray5 = this.blurMult[n2];
                    n8 += nArray5[(n14 & 0xFF000000) >>> 24];
                    n7 += nArray5[(n14 & 0xFF0000) >> 16];
                    n6 += nArray5[(n14 & 0xFF00) >> 8];
                    n5 += nArray5[n14 & 0xFF];
                    n9 += this.blurKernel[n2];
                    ++n4;
                    ++n2;
                }
                n = n12 + n10;
                nArray4[n] = n8 / n9;
                nArray[n] = n7 / n9;
                nArray2[n] = n6 / n9;
                nArray3[n] = n5 / n9;
                ++n10;
            }
            n12 += this.width;
            ++n13;
        }
        n12 = 0;
        int n15 = -this.blurRadius;
        int n16 = n15 * this.width;
        n13 = 0;
        while (n13 < this.height) {
            n10 = 0;
            while (n10 < this.width) {
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                if (n15 < 0) {
                    n3 = n = -n15;
                    n4 = n10;
                } else {
                    if (n15 >= this.height) break;
                    n3 = 0;
                    n = n15;
                    n4 = n10 + n16;
                }
                n2 = n3;
                while (n2 < this.blurKernelSize) {
                    if (n >= this.height) break;
                    int[] nArray6 = this.blurMult[n2];
                    n8 += nArray6[nArray4[n4]];
                    n7 += nArray6[nArray[n4]];
                    n6 += nArray6[nArray2[n4]];
                    n5 += nArray6[nArray3[n4]];
                    n9 += this.blurKernel[n2];
                    ++n;
                    n4 += this.width;
                    ++n2;
                }
                this.pixels[n10 + n12] = n8 / n9 << 24 | n7 / n9 << 16 | n6 / n9 << 8 | n5 / n9;
                ++n10;
            }
            n12 += this.width;
            n16 += this.width;
            ++n15;
            ++n13;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void dilate(boolean var1_1) {
        block20: {
            var2_2 = 0;
            var3_3 = this.pixels.length;
            var4_4 = new int[var3_3];
            if (var1_1) ** GOTO lbl86
            while (var2_2 < var3_3) {
                var5_5 = var2_2;
                var6_7 = var2_2 + this.width;
                while (var2_2 < var6_7) {
                    var7_9 = var8_11 = this.pixels[var2_2];
                    var9_13 = var2_2 - 1;
                    var10_15 = var2_2 + 1;
                    var11_17 = var2_2 - this.width;
                    var12_19 = var2_2 + this.width;
                    if (var9_13 < var5_5) {
                        var9_13 = var2_2;
                    }
                    if (var10_15 >= var6_7) {
                        var10_15 = var2_2;
                    }
                    if (var11_17 < 0) {
                        var11_17 = 0;
                    }
                    if (var12_19 >= var3_3) {
                        var12_19 = var2_2;
                    }
                    var13_21 = this.pixels[var11_17];
                    var14_23 = this.pixels[var9_13];
                    var15_25 = this.pixels[var12_19];
                    var16_27 = this.pixels[var10_15];
                    var17_29 = 77 * (var7_9 >> 16 & 255) + 151 * (var7_9 >> 8 & 255) + 28 * (var7_9 & 255);
                    var18_31 = 77 * (var14_23 >> 16 & 255) + 151 * (var14_23 >> 8 & 255) + 28 * (var14_23 & 255);
                    var19_33 = 77 * (var16_27 >> 16 & 255) + 151 * (var16_27 >> 8 & 255) + 28 * (var16_27 & 255);
                    var20_35 = 77 * (var13_21 >> 16 & 255) + 151 * (var13_21 >> 8 & 255) + 28 * (var13_21 & 255);
                    var21_37 = 77 * (var15_25 >> 16 & 255) + 151 * (var15_25 >> 8 & 255) + 28 * (var15_25 & 255);
                    if (var18_31 > var17_29) {
                        var8_11 = var14_23;
                        var17_29 = var18_31;
                    }
                    if (var19_33 > var17_29) {
                        var8_11 = var16_27;
                        var17_29 = var19_33;
                    }
                    if (var20_35 > var17_29) {
                        var8_11 = var13_21;
                        var17_29 = var20_35;
                    }
                    if (var21_37 > var17_29) {
                        var8_11 = var15_25;
                        var17_29 = var21_37;
                    }
                    var4_4[var2_2++] = var8_11;
                }
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                var5_6 = var2_2;
                var6_8 = var2_2 + this.width;
                while (var2_2 < var6_8) {
                    var7_10 = var8_12 = this.pixels[var2_2];
                    var9_14 = var2_2 - 1;
                    var10_16 = var2_2 + 1;
                    var11_18 = var2_2 - this.width;
                    var12_20 = var2_2 + this.width;
                    if (var9_14 < var5_6) {
                        var9_14 = var2_2;
                    }
                    if (var10_16 >= var6_8) {
                        var10_16 = var2_2;
                    }
                    if (var11_18 < 0) {
                        var11_18 = 0;
                    }
                    if (var12_20 >= var3_3) {
                        var12_20 = var2_2;
                    }
                    var13_22 = this.pixels[var11_18];
                    var14_24 = this.pixels[var9_14];
                    var15_26 = this.pixels[var12_20];
                    var16_28 = this.pixels[var10_16];
                    var17_30 = 77 * (var7_10 >> 16 & 255) + 151 * (var7_10 >> 8 & 255) + 28 * (var7_10 & 255);
                    var18_32 = 77 * (var14_24 >> 16 & 255) + 151 * (var14_24 >> 8 & 255) + 28 * (var14_24 & 255);
                    var19_34 = 77 * (var16_28 >> 16 & 255) + 151 * (var16_28 >> 8 & 255) + 28 * (var16_28 & 255);
                    var20_36 = 77 * (var13_22 >> 16 & 255) + 151 * (var13_22 >> 8 & 255) + 28 * (var13_22 & 255);
                    var21_38 = 77 * (var15_26 >> 16 & 255) + 151 * (var15_26 >> 8 & 255) + 28 * (var15_26 & 255);
                    if (var18_32 < var17_30) {
                        var8_12 = var14_24;
                        var17_30 = var18_32;
                    }
                    if (var19_34 < var17_30) {
                        var8_12 = var16_28;
                        var17_30 = var19_34;
                    }
                    if (var20_36 < var17_30) {
                        var8_12 = var13_22;
                        var17_30 = var20_36;
                    }
                    if (var21_38 < var17_30) {
                        var8_12 = var15_26;
                        var17_30 = var21_38;
                    }
                    var4_4[var2_2++] = var8_12;
                }
lbl86:
                // 2 sources

                ** while (var2_2 < var3_3)
            }
        }
        System.arraycopy(var4_4, 0, this.pixels, 0, var3_3);
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.copy(this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.imageMode == 0) {
            n3 += n;
            n4 += n2;
            n7 += n5;
            n8 += n6;
        }
        if (pImage == this && this.intersect(n, n2, n3, n4, n5, n6, n7, n8)) {
            this.blit_resize(this.get(n, n2, n3 - n, n4 - n2), 0, 0, n3 - n - 1, n4 - n2 - 1, this.pixels, this.width, this.height, n5, n6, n7, n8, 0);
        } else {
            this.blit_resize(pImage, n, n2, n3, n4, this.pixels, this.width, this.height, n5, n6, n7, n8, 0);
        }
    }

    public static int blendColor(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return n2;
            }
            case 1: {
                return PImage.blend_blend(n, n2);
            }
            case 2: {
                return PImage.blend_add_pin(n, n2);
            }
            case 4: {
                return PImage.blend_sub_pin(n, n2);
            }
            case 8: {
                return PImage.blend_lightest(n, n2);
            }
            case 16: {
                return PImage.blend_darkest(n, n2);
            }
            case 32: {
                return PImage.blend_difference(n, n2);
            }
            case 64: {
                return PImage.blend_exclusion(n, n2);
            }
            case 128: {
                return PImage.blend_multiply(n, n2);
            }
            case 256: {
                return PImage.blend_screen(n, n2);
            }
            case 1024: {
                return PImage.blend_hard_light(n, n2);
            }
            case 2048: {
                return PImage.blend_soft_light(n, n2);
            }
            case 512: {
                return PImage.blend_overlay(n, n2);
            }
            case 4096: {
                return PImage.blend_dodge(n, n2);
            }
            case 8192: {
                return PImage.blend_burn(n, n2);
            }
        }
        return 0;
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.blend(this, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.imageMode == 0) {
            n3 += n;
            n4 += n2;
            n7 += n5;
            n8 += n6;
        }
        if (pImage == this && this.intersect(n, n2, n3, n4, n5, n6, n7, n8)) {
            this.blit_resize(this.get(n, n2, n3 - n, n4 - n2), 0, 0, n3 - n - 1, n4 - n2 - 1, this.pixels, this.width, this.height, n5, n6, n7, n8, n9);
        } else {
            this.blit_resize(pImage, n, n2, n3, n4, this.pixels, this.width, this.height, n5, n6, n7, n8, n9);
        }
    }

    protected boolean intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10 = n3 - n + 1;
        int n11 = n4 - n2 + 1;
        int n12 = n7 - n5 + 1;
        int n13 = n8 - n6 + 1;
        if (n5 < n) {
            if ((n12 += n5 - n) > n10) {
                n12 = n10;
            }
        } else {
            n9 = n10 + n - n5;
            if (n12 > n9) {
                n12 = n9;
            }
        }
        if (n6 < n2) {
            if ((n13 += n6 - n2) > n11) {
                n13 = n11;
            }
        } else {
            n9 = n11 + n2 - n6;
            if (n13 > n9) {
                n13 = n9;
            }
        }
        boolean bl = false;
        if (n12 <= 0 || n13 <= 0) {
            bl = true;
        }
        return bl ^ true;
    }

    public Object clone() throws CloneNotSupportedException {
        PImage pImage = (PImage)super.clone();
        pImage.pixels = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, pImage.pixels, 0, this.pixels.length);
        return pImage;
    }

    private final void blit_resize(PImage pImage, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        block103: {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            block102: {
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n3 >= pImage.width) {
                    n3 = pImage.width - 1;
                }
                if (n4 >= pImage.height) {
                    n4 = pImage.height - 1;
                }
                int n17 = n3 - n;
                int n18 = n4 - n2;
                n16 = n9 - n7;
                n15 = n10 - n8;
                if (!this.smooth) {
                    ++n17;
                    ++n18;
                }
                if (n16 <= 0 || n15 <= 0 || n17 <= 0 || n18 <= 0 || n7 >= n5 || n8 >= n6 || n >= pImage.width || n2 >= pImage.height) {
                    return;
                }
                n14 = (int)((float)n17 / (float)n16 * 32768.0f);
                n13 = (int)((float)n18 / (float)n15 * 32768.0f);
                this.srcXOffset = n7 < 0 ? -n7 * n14 : n * 32768;
                int n19 = this.srcYOffset = n8 < 0 ? -n8 * n13 : n2 * 32768;
                if (n7 < 0) {
                    n16 += n7;
                    n7 = 0;
                }
                if (n8 < 0) {
                    n15 += n8;
                    n8 = 0;
                }
                n16 = PImage.low(n16, n5 - n7);
                n15 = PImage.low(n15, n6 - n8);
                n12 = n8 * n5 + n7;
                this.srcBuffer = pImage.pixels;
                if (!this.smooth) break block102;
                this.iw = pImage.width;
                this.iw1 = pImage.width - 1;
                this.ih1 = pImage.height - 1;
                switch (n11) {
                    case 1: {
                        int n20 = 0;
                        while (n20 < n15) {
                            this.filter_new_scanline();
                            int n21 = 0;
                            while (n21 < n16) {
                                nArray[n12 + n21] = PImage.blend_blend(nArray[n12 + n21], this.filter_bilinear());
                                this.sX += n14;
                                ++n21;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n20;
                        }
                        break block103;
                    }
                    case 2: {
                        int n22 = 0;
                        while (n22 < n15) {
                            this.filter_new_scanline();
                            int n23 = 0;
                            while (n23 < n16) {
                                nArray[n12 + n23] = PImage.blend_add_pin(nArray[n12 + n23], this.filter_bilinear());
                                this.sX += n14;
                                ++n23;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n22;
                        }
                        break block103;
                    }
                    case 4: {
                        int n24 = 0;
                        while (n24 < n15) {
                            this.filter_new_scanline();
                            int n25 = 0;
                            while (n25 < n16) {
                                nArray[n12 + n25] = PImage.blend_sub_pin(nArray[n12 + n25], this.filter_bilinear());
                                this.sX += n14;
                                ++n25;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n24;
                        }
                        break block103;
                    }
                    case 8: {
                        int n26 = 0;
                        while (n26 < n15) {
                            this.filter_new_scanline();
                            int n27 = 0;
                            while (n27 < n16) {
                                nArray[n12 + n27] = PImage.blend_lightest(nArray[n12 + n27], this.filter_bilinear());
                                this.sX += n14;
                                ++n27;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n26;
                        }
                        break block103;
                    }
                    case 16: {
                        int n28 = 0;
                        while (n28 < n15) {
                            this.filter_new_scanline();
                            int n29 = 0;
                            while (n29 < n16) {
                                nArray[n12 + n29] = PImage.blend_darkest(nArray[n12 + n29], this.filter_bilinear());
                                this.sX += n14;
                                ++n29;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n28;
                        }
                        break block103;
                    }
                    case 0: {
                        int n30 = 0;
                        while (n30 < n15) {
                            this.filter_new_scanline();
                            int n31 = 0;
                            while (n31 < n16) {
                                nArray[n12 + n31] = this.filter_bilinear();
                                this.sX += n14;
                                ++n31;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n30;
                        }
                        break block103;
                    }
                    case 32: {
                        int n32 = 0;
                        while (n32 < n15) {
                            this.filter_new_scanline();
                            int n33 = 0;
                            while (n33 < n16) {
                                nArray[n12 + n33] = PImage.blend_difference(nArray[n12 + n33], this.filter_bilinear());
                                this.sX += n14;
                                ++n33;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n32;
                        }
                        break block103;
                    }
                    case 64: {
                        int n34 = 0;
                        while (n34 < n15) {
                            this.filter_new_scanline();
                            int n35 = 0;
                            while (n35 < n16) {
                                nArray[n12 + n35] = PImage.blend_exclusion(nArray[n12 + n35], this.filter_bilinear());
                                this.sX += n14;
                                ++n35;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n34;
                        }
                        break block103;
                    }
                    case 128: {
                        int n36 = 0;
                        while (n36 < n15) {
                            this.filter_new_scanline();
                            int n37 = 0;
                            while (n37 < n16) {
                                nArray[n12 + n37] = PImage.blend_multiply(nArray[n12 + n37], this.filter_bilinear());
                                this.sX += n14;
                                ++n37;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n36;
                        }
                        break block103;
                    }
                    case 256: {
                        int n38 = 0;
                        while (n38 < n15) {
                            this.filter_new_scanline();
                            int n39 = 0;
                            while (n39 < n16) {
                                nArray[n12 + n39] = PImage.blend_screen(nArray[n12 + n39], this.filter_bilinear());
                                this.sX += n14;
                                ++n39;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n38;
                        }
                        break block103;
                    }
                    case 512: {
                        int n40 = 0;
                        while (n40 < n15) {
                            this.filter_new_scanline();
                            int n41 = 0;
                            while (n41 < n16) {
                                nArray[n12 + n41] = PImage.blend_overlay(nArray[n12 + n41], this.filter_bilinear());
                                this.sX += n14;
                                ++n41;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n40;
                        }
                        break block103;
                    }
                    case 1024: {
                        int n42 = 0;
                        while (n42 < n15) {
                            this.filter_new_scanline();
                            int n43 = 0;
                            while (n43 < n16) {
                                nArray[n12 + n43] = PImage.blend_hard_light(nArray[n12 + n43], this.filter_bilinear());
                                this.sX += n14;
                                ++n43;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n42;
                        }
                        break block103;
                    }
                    case 2048: {
                        int n44 = 0;
                        while (n44 < n15) {
                            this.filter_new_scanline();
                            int n45 = 0;
                            while (n45 < n16) {
                                nArray[n12 + n45] = PImage.blend_soft_light(nArray[n12 + n45], this.filter_bilinear());
                                this.sX += n14;
                                ++n45;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n44;
                        }
                        break block103;
                    }
                    case 4096: {
                        int n46 = 0;
                        while (n46 < n15) {
                            this.filter_new_scanline();
                            int n47 = 0;
                            while (n47 < n16) {
                                nArray[n12 + n47] = PImage.blend_dodge(nArray[n12 + n47], this.filter_bilinear());
                                this.sX += n14;
                                ++n47;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n46;
                        }
                        break block103;
                    }
                    case 8192: {
                        int n48 = 0;
                        while (n48 < n15) {
                            this.filter_new_scanline();
                            int n49 = 0;
                            while (n49 < n16) {
                                nArray[n12 + n49] = PImage.blend_burn(nArray[n12 + n49], this.filter_bilinear());
                                this.sX += n14;
                                ++n49;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                            ++n48;
                        }
                        break block103;
                    }
                }
                break block103;
            }
            switch (n11) {
                case 1: {
                    int n50 = 0;
                    while (n50 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n51 = 0;
                        while (n51 < n16) {
                            nArray[n12 + n51] = PImage.blend_blend(nArray[n12 + n51], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n51;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n50;
                    }
                    break;
                }
                case 2: {
                    int n52 = 0;
                    while (n52 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n53 = 0;
                        while (n53 < n16) {
                            nArray[n12 + n53] = PImage.blend_add_pin(nArray[n12 + n53], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n53;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n52;
                    }
                    break;
                }
                case 4: {
                    int n54 = 0;
                    while (n54 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n55 = 0;
                        while (n55 < n16) {
                            nArray[n12 + n55] = PImage.blend_sub_pin(nArray[n12 + n55], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n55;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n54;
                    }
                    break;
                }
                case 8: {
                    int n56 = 0;
                    while (n56 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n57 = 0;
                        while (n57 < n16) {
                            nArray[n12 + n57] = PImage.blend_lightest(nArray[n12 + n57], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n57;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n56;
                    }
                    break;
                }
                case 16: {
                    int n58 = 0;
                    while (n58 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n59 = 0;
                        while (n59 < n16) {
                            nArray[n12 + n59] = PImage.blend_darkest(nArray[n12 + n59], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n59;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n58;
                    }
                    break;
                }
                case 0: {
                    int n60 = 0;
                    while (n60 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n61 = 0;
                        while (n61 < n16) {
                            nArray[n12 + n61] = this.srcBuffer[this.sY + (this.sX >> 15)];
                            this.sX += n14;
                            ++n61;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n60;
                    }
                    break;
                }
                case 32: {
                    int n62 = 0;
                    while (n62 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n63 = 0;
                        while (n63 < n16) {
                            nArray[n12 + n63] = PImage.blend_difference(nArray[n12 + n63], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n63;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n62;
                    }
                    break;
                }
                case 64: {
                    int n64 = 0;
                    while (n64 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n65 = 0;
                        while (n65 < n16) {
                            nArray[n12 + n65] = PImage.blend_exclusion(nArray[n12 + n65], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n65;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n64;
                    }
                    break;
                }
                case 128: {
                    int n66 = 0;
                    while (n66 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n67 = 0;
                        while (n67 < n16) {
                            nArray[n12 + n67] = PImage.blend_multiply(nArray[n12 + n67], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n67;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n66;
                    }
                    break;
                }
                case 256: {
                    int n68 = 0;
                    while (n68 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n69 = 0;
                        while (n69 < n16) {
                            nArray[n12 + n69] = PImage.blend_screen(nArray[n12 + n69], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n69;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n68;
                    }
                    break;
                }
                case 512: {
                    int n70 = 0;
                    while (n70 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n71 = 0;
                        while (n71 < n16) {
                            nArray[n12 + n71] = PImage.blend_overlay(nArray[n12 + n71], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n71;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n70;
                    }
                    break;
                }
                case 1024: {
                    int n72 = 0;
                    while (n72 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n73 = 0;
                        while (n73 < n16) {
                            nArray[n12 + n73] = PImage.blend_hard_light(nArray[n12 + n73], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n73;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n72;
                    }
                    break;
                }
                case 2048: {
                    int n74 = 0;
                    while (n74 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n75 = 0;
                        while (n75 < n16) {
                            nArray[n12 + n75] = PImage.blend_soft_light(nArray[n12 + n75], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n75;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n74;
                    }
                    break;
                }
                case 4096: {
                    int n76 = 0;
                    while (n76 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n77 = 0;
                        while (n77 < n16) {
                            nArray[n12 + n77] = PImage.blend_dodge(nArray[n12 + n77], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n77;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n76;
                    }
                    break;
                }
                case 8192: {
                    int n78 = 0;
                    while (n78 < n15) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        int n79 = 0;
                        while (n79 < n16) {
                            nArray[n12 + n79] = PImage.blend_burn(nArray[n12 + n79], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                            ++n79;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                        ++n78;
                    }
                    break;
                }
            }
        }
    }

    private final void filter_new_scanline() {
        this.sX = this.srcXOffset;
        this.fracV = this.srcYOffset & Short.MAX_VALUE;
        this.ifV = Short.MAX_VALUE - this.fracV;
        this.v1 = (this.srcYOffset >> 15) * this.iw;
        this.v2 = PImage.low((this.srcYOffset >> 15) + 1, this.ih1) * this.iw;
    }

    private final int filter_bilinear() {
        this.fracU = this.sX & Short.MAX_VALUE;
        this.ifU = Short.MAX_VALUE - this.fracU;
        this.ul = this.ifU * this.ifV >> 15;
        this.ll = this.ifU * this.fracV >> 15;
        this.ur = this.fracU * this.ifV >> 15;
        this.lr = this.fracU * this.fracV >> 15;
        this.u1 = this.sX >> 15;
        this.u2 = PImage.low(this.u1 + 1, this.iw1);
        this.cUL = this.srcBuffer[this.v1 + this.u1];
        this.cUR = this.srcBuffer[this.v1 + this.u2];
        this.cLL = this.srcBuffer[this.v2 + this.u1];
        this.cLR = this.srcBuffer[this.v2 + this.u2];
        this.r = this.ul * ((this.cUL & 0xFF0000) >> 16) + this.ll * ((this.cLL & 0xFF0000) >> 16) + this.ur * ((this.cUR & 0xFF0000) >> 16) + this.lr * ((this.cLR & 0xFF0000) >> 16) << 1 & 0xFF0000;
        this.g = this.ul * (this.cUL & 0xFF00) + this.ll * (this.cLL & 0xFF00) + this.ur * (this.cUR & 0xFF00) + this.lr * (this.cLR & 0xFF00) >>> 15 & 0xFF00;
        this.b = this.ul * (this.cUL & 0xFF) + this.ll * (this.cLL & 0xFF) + this.ur * (this.cUR & 0xFF) + this.lr * (this.cLR & 0xFF) >>> 15;
        this.a = this.ul * ((this.cUL & 0xFF000000) >>> 24) + this.ll * ((this.cLL & 0xFF000000) >>> 24) + this.ur * ((this.cUR & 0xFF000000) >>> 24) + this.lr * ((this.cLR & 0xFF000000) >>> 24) << 9 & 0xFF000000;
        return this.a | this.r | this.g | this.b;
    }

    private static final int low(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static final int high(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static final int peg(int n) {
        int n2 = 0;
        if (n >= 0) {
            n2 = n > 255 ? 255 : n;
        }
        return n2;
    }

    private static final int mix(int n, int n2, int n3) {
        return n + ((n2 - n) * n3 >> 8);
    }

    private static final int blend_blend(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.mix(n & 0xFF0000, n2 & 0xFF0000, n3) & 0xFF0000 | PImage.mix(n & 0xFF00, n2 & 0xFF00, n3) & 0xFF00 | PImage.mix(n & 0xFF, n2 & 0xFF, n3);
    }

    private static final int blend_add_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.low((n & 0xFF0000) + ((n2 & 0xFF0000) >> 8) * n3, 0xFF0000) & 0xFF0000 | PImage.low((n & 0xFF00) + ((n2 & 0xFF00) >> 8) * n3, 65280) & 0xFF00 | PImage.low((n & 0xFF) + ((n2 & 0xFF) * n3 >> 8), 255);
    }

    private static final int blend_sub_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.high((n & 0xFF0000) - ((n2 & 0xFF0000) >> 8) * n3, 65280) & 0xFF0000 | PImage.high((n & 0xFF00) - ((n2 & 0xFF00) >> 8) * n3, 255) & 0xFF00 | PImage.high((n & 0xFF) - ((n2 & 0xFF) * n3 >> 8), 0);
    }

    private static final int blend_lightest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.high(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3) & 0xFF0000 | PImage.high(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3) & 0xFF00 | PImage.high(n & 0xFF, (n2 & 0xFF) * n3 >> 8);
    }

    private static final int blend_darkest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.mix(n & 0xFF0000, PImage.low(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3), n3) & 0xFF0000 | PImage.mix(n & 0xFF00, PImage.low(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3), n3) & 0xFF00 | PImage.mix(n & 0xFF, PImage.low(n & 0xFF, (n2 & 0xFF) * n3 >> 8), n3);
    }

    private static final int blend_difference(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 > n7 ? n4 - n7 : n7 - n4;
        int n11 = n5 > n8 ? n5 - n8 : n8 - n5;
        int n12 = n6 > n9 ? n6 - n9 : n9 - n6;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_exclusion(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 + n7 - (n4 * n7 >> 7);
        int n11 = n5 + n8 - (n5 * n8 >> 7);
        int n12 = n6 + n9 - (n6 * n9 >> 7);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_multiply(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 * n7 >> 8;
        int n11 = n5 * n8 >> 8;
        int n12 = n6 * n9 >> 8;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_screen(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = 255 - ((255 - n4) * (255 - n7) >> 8);
        int n11 = 255 - ((255 - n5) * (255 - n8) >> 8);
        int n12 = 255 - ((255 - n6) * (255 - n9) >> 8);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_overlay(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 < 128 ? n4 * n7 >> 7 : 255 - ((255 - n4) * (255 - n7) >> 7);
        int n11 = n5 < 128 ? n5 * n8 >> 7 : 255 - ((255 - n5) * (255 - n8) >> 7);
        int n12 = n6 < 128 ? n6 * n9 >> 7 : 255 - ((255 - n6) * (255 - n9) >> 7);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_hard_light(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n7 < 128 ? n4 * n7 >> 7 : 255 - ((255 - n4) * (255 - n7) >> 7);
        int n11 = n8 < 128 ? n5 * n8 >> 7 : 255 - ((255 - n5) * (255 - n8) >> 7);
        int n12 = n9 < 128 ? n6 * n9 >> 7 : 255 - ((255 - n6) * (255 - n9) >> 7);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_soft_light(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = (n4 * n7 >> 7) + (n4 * n4 >> 8) - (n4 * n4 * n7 >> 15);
        int n11 = (n5 * n8 >> 7) + (n5 * n5 >> 8) - (n5 * n5 * n8 >> 15);
        int n12 = (n6 * n9 >> 7) + (n6 * n6 >> 8) - (n6 * n6 * n9 >> 15);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_dodge(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n7 == 255 ? 255 : PImage.peg((n4 << 8) / (255 - n7));
        int n11 = n8 == 255 ? 255 : PImage.peg((n5 << 8) / (255 - n8));
        int n12 = n9 == 255 ? 255 : PImage.peg((n6 << 8) / (255 - n9));
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static final int blend_burn(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = 0;
        if (n7 != 0) {
            n10 = 255 - PImage.peg((255 - n4 << 8) / n7);
        }
        int n11 = n10;
        int n12 = 0;
        if (n8 != 0) {
            n12 = 255 - PImage.peg((255 - n5 << 8) / n8);
        }
        int n13 = n12;
        int n14 = 0;
        if (n9 != 0) {
            n14 = 255 - PImage.peg((255 - n6 << 8) / n9);
        }
        int n15 = n14;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n11 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n13 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n15 - n6) * n3 >> 8));
    }

    protected static PImage loadTIFF(byte[] byArray) {
        if (byArray[42] != byArray[102] || byArray[43] != byArray[103]) {
            System.err.println(TIFF_ERROR);
            return null;
        }
        int n = (byArray[114] & 0xFF) << 24 | (byArray[115] & 0xFF) << 16 | (byArray[116] & 0xFF) << 8 | byArray[117] & 0xFF;
        int n2 = (byArray[30] & 0xFF) << 8 | byArray[31] & 0xFF;
        int n3 = (byArray[42] & 0xFF) << 8 | byArray[43] & 0xFF;
        if (n != n2 * n3 * 3) {
            System.err.println("Error: Processing can only read its own TIFF files. (" + n2 + ", " + n3 + ')');
            return null;
        }
        int n4 = 0;
        while (n4 < TIFF_HEADER.length) {
            if (n4 != 30 && n4 != 31 && n4 != 42 && n4 != 43 && n4 != 102 && n4 != 103 && n4 != 114 && n4 != 115 && n4 != 116 && n4 != 117 && byArray[n4] != TIFF_HEADER[n4]) {
                System.err.println("Error: Processing can only read its own TIFF files. (" + n4 + ')');
                return null;
            }
            ++n4;
        }
        PImage pImage = new PImage(n2, n3, 1);
        int n5 = 768;
        n /= 3;
        int n6 = 0;
        while (n6 < n) {
            pImage.pixels[n6] = 0xFF000000 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
            ++n6;
        }
        return pImage;
    }

    protected boolean saveTIFF(OutputStream outputStream) {
        try {
            byte[] byArray = new byte[768];
            System.arraycopy(TIFF_HEADER, 0, byArray, 0, TIFF_HEADER.length);
            byArray[30] = (byte)(this.width >> 8 & 0xFF);
            byArray[31] = (byte)(this.width & 0xFF);
            byArray[42] = byArray[102] = (byte)(this.height >> 8 & 0xFF);
            byArray[43] = byArray[103] = (byte)(this.height & 0xFF);
            int n = this.width * this.height * 3;
            byArray[114] = (byte)(n >> 24 & 0xFF);
            byArray[115] = (byte)(n >> 16 & 0xFF);
            byArray[116] = (byte)(n >> 8 & 0xFF);
            byArray[117] = (byte)(n & 0xFF);
            outputStream.write(byArray);
            int n2 = 0;
            while (n2 < this.pixels.length) {
                outputStream.write(this.pixels[n2] >> 16 & 0xFF);
                outputStream.write(this.pixels[n2] >> 8 & 0xFF);
                outputStream.write(this.pixels[n2] & 0xFF);
                ++n2;
            }
            outputStream.flush();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean saveTGA(OutputStream var1_1) {
        var2_2 = new byte[18];
        if (this.format == 4) {
            var2_2[2] = 11;
            var2_2[16] = 8;
            var2_2[17] = 40;
        } else if (this.format == 1) {
            var2_2[2] = 10;
            var2_2[16] = 24;
            var2_2[17] = 32;
        } else if (this.format == 2) {
            var2_2[2] = 10;
            var2_2[16] = 32;
            var2_2[17] = 40;
        } else {
            throw new RuntimeException("Image format not recognized inside save()");
        }
        var2_2[12] = (byte)(this.width & 255);
        var2_2[13] = (byte)(this.width >> 8);
        var2_2[14] = (byte)(this.height & 255);
        var2_2[15] = (byte)(this.height >> 8);
        try {
            block30: {
                var1_1.write(var2_2);
                var3_3 = this.height * this.width;
                var4_5 = 0;
                var6_6 = new int[128];
                if (this.format != 4) ** GOTO lbl115
                while (var4_5 < var3_3) {
                    var7_9 = false;
                    var8_11 = 1;
                    var6_6[0] = var5_7 = this.pixels[var4_5] & 255;
                    while (var4_5 + var8_11 < var3_3) {
                        if (var5_7 != (this.pixels[var4_5 + var8_11] & 255) || var8_11 == 128) {
                            v0 = false;
                            if (var8_11 > 1) {
                                v0 = true;
                            }
                            var7_9 = v0;
                            break;
                        }
                        ++var8_11;
                    }
                    if (var7_9) {
                        var1_1.write(128 | var8_11 - 1);
                        var1_1.write(var5_7);
                    } else {
                        var8_11 = 1;
                        while (var4_5 + var8_11 < var3_3) {
                            var9_13 = this.pixels[var4_5 + var8_11] & 255;
                            if ((var5_7 == var9_13 || var8_11 >= 128) && var8_11 >= 3) {
                                if (var5_7 != var9_13) break;
                                var8_11 -= 2;
                                break;
                            }
                            var6_6[var8_11] = var5_7 = var9_13;
                            ++var8_11;
                        }
                        var1_1.write(var8_11 - 1);
                        var9_13 = 0;
                        while (var9_13 < var8_11) {
                            var1_1.write(var6_6[var9_13]);
                            ++var9_13;
                        }
                    }
                    var4_5 += var8_11;
                }
                break block30;
lbl-1000:
                // 1 sources

                {
                    var7_10 = false;
                    var6_6[0] = var5_8 = this.pixels[var4_5];
                    var8_12 = 1;
                    while (var4_5 + var8_12 < var3_3) {
                        if (var5_8 != this.pixels[var4_5 + var8_12] || var8_12 == 128) {
                            v1 = false;
                            if (var8_12 > 1) {
                                v1 = true;
                            }
                            var7_10 = v1;
                            break;
                        }
                        ++var8_12;
                    }
                    if (var7_10) {
                        var1_1.write(128 | var8_12 - 1);
                        var1_1.write(var5_8 & 255);
                        var1_1.write(var5_8 >> 8 & 255);
                        var1_1.write(var5_8 >> 16 & 255);
                        if (this.format == 2) {
                            var1_1.write(var5_8 >>> 24 & 255);
                        }
                    } else {
                        var8_12 = 1;
                        while (var4_5 + var8_12 < var3_3) {
                            if ((var5_8 == this.pixels[var4_5 + var8_12] || var8_12 >= 128) && var8_12 >= 3) {
                                if (var5_8 != this.pixels[var4_5 + var8_12]) break;
                                var8_12 -= 2;
                                break;
                            }
                            var6_6[var8_12] = var5_8 = this.pixels[var4_5 + var8_12];
                            ++var8_12;
                        }
                        var1_1.write(var8_12 - 1);
                        if (this.format == 2) {
                            var9_14 = 0;
                            while (var9_14 < var8_12) {
                                var5_8 = var6_6[var9_14];
                                var1_1.write(var5_8 & 255);
                                var1_1.write(var5_8 >> 8 & 255);
                                var1_1.write(var5_8 >> 16 & 255);
                                var1_1.write(var5_8 >>> 24 & 255);
                                ++var9_14;
                            }
                        } else {
                            var9_14 = 0;
                            while (var9_14 < var8_12) {
                                var5_8 = var6_6[var9_14];
                                var1_1.write(var5_8 & 255);
                                var1_1.write(var5_8 >> 8 & 255);
                                var1_1.write(var5_8 >> 16 & 255);
                                ++var9_14;
                            }
                        }
                    }
                    var4_5 += var8_12;
lbl115:
                    // 2 sources

                    ** while (var4_5 < var3_3)
                }
            }
            var1_1.flush();
            return true;
        }
        catch (IOException var3_4) {
            var3_4.printStackTrace();
            return false;
        }
    }

    protected void saveImageIO(String string) throws IOException {
        try {
            Class clazz;
            Class<?> clazz2 = Class.forName("java.awt.image.BufferedImage");
            Constructor<?> constructor = clazz2.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Field field = clazz2.getField("TYPE_INT_RGB");
            int n = field.getInt(field);
            Field field2 = clazz2.getField("TYPE_INT_ARGB");
            int n2 = field2.getInt(field2);
            Object obj = constructor.newInstance(new Integer(this.width), new Integer(this.height), new Integer(this.format == 2 ? n2 : n));
            Method method = clazz2.getMethod("setRGB", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, this.pixels.getClass(), Integer.TYPE, Integer.TYPE);
            method.invoke(obj, new Integer(0), new Integer(0), new Integer(this.width), new Integer(this.height), this.pixels, new Integer(0), new Integer(this.width));
            File file = new File(string);
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            Class<?> clazz3 = Class.forName("java.awt.image.RenderedImage");
            Class<?> clazz4 = Class.forName("javax.imageio.ImageIO");
            Class[] classArray = new Class[3];
            classArray[0] = clazz3;
            Class clazz5 = class$java$lang$String;
            if (clazz5 == null) {
                clazz5 = classArray[1] = (class$java$lang$String = PImage.class("[Ljava.lang.String;", false));
            }
            if ((clazz = class$java$io$File) == null) {
                clazz = class$java$io$File = PImage.class("[Ljava.io.File;", false);
            }
            classArray[2] = clazz;
            Method method2 = clazz4.getMethod("write", classArray);
            method2.invoke(null, obj, string2, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("image save failed.");
        }
    }

    public void save(String string) {
        boolean bl = false;
        File file = new File(string);
        if (!file.isAbsolute()) {
            if (this.parent != null) {
                string = this.parent.savePath(string);
            } else {
                String string2 = "PImage.save() requires an absolute path. Use createImage(), or pass savePath() to save().";
                throw new RuntimeException(string2);
            }
        }
        try {
            BufferedOutputStream bufferedOutputStream = null;
            if (PApplet.javaVersion >= 1.4f) {
                if (this.saveImageFormats == null) {
                    try {
                        Class<?> clazz = Class.forName("javax.imageio.ImageIO");
                        Method method = clazz.getMethod("getWriterFormatNames", null);
                        this.saveImageFormats = (String[])method.invoke(null, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (this.saveImageFormats != null) {
                    int n = 0;
                    while (n < this.saveImageFormats.length) {
                        if (string.endsWith("." + this.saveImageFormats[n])) {
                            this.saveImageIO(string);
                            return;
                        }
                        ++n;
                    }
                }
            }
            if (string.toLowerCase().endsWith(".tga")) {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 32768);
                bl = this.saveTGA(bufferedOutputStream);
            } else {
                if (!string.toLowerCase().endsWith(".tif") && !string.toLowerCase().endsWith(".tiff")) {
                    string = string + ".tif";
                }
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 32768);
                bl = this.saveTIFF(bufferedOutputStream);
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        if (!bl) {
            throw new RuntimeException("Error while saving image.");
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.imageMode = 0;
        this.smooth = false;
    }

    public PImage() {
        this.this();
        this.format = 2;
        this.cache = null;
    }

    public PImage(int n, int n2) {
        this.this();
        this.init(n, n2, 1);
    }

    public PImage(int n, int n2, int n3) {
        this.this();
        this.init(n, n2, n3);
    }

    public PImage(Image image) {
        this.this();
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        this.format = 1;
        this.cache = null;
    }

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 77;
        byArray[1] = 77;
        byArray[3] = 42;
        byArray[7] = 8;
        byArray[9] = 9;
        byArray[11] = -2;
        byArray[13] = 4;
        byArray[17] = 1;
        byArray[22] = 1;
        byArray[25] = 3;
        byArray[29] = 1;
        byArray[34] = 1;
        byArray[35] = 1;
        byArray[37] = 3;
        byArray[41] = 1;
        byArray[46] = 1;
        byArray[47] = 2;
        byArray[49] = 3;
        byArray[53] = 3;
        byArray[57] = 122;
        byArray[58] = 1;
        byArray[59] = 6;
        byArray[61] = 3;
        byArray[65] = 1;
        byArray[67] = 2;
        byArray[70] = 1;
        byArray[71] = 17;
        byArray[73] = 4;
        byArray[77] = 1;
        byArray[80] = 3;
        byArray[82] = 1;
        byArray[83] = 21;
        byArray[85] = 3;
        byArray[89] = 1;
        byArray[91] = 3;
        byArray[94] = 1;
        byArray[95] = 22;
        byArray[97] = 3;
        byArray[101] = 1;
        byArray[106] = 1;
        byArray[107] = 23;
        byArray[109] = 4;
        byArray[113] = 1;
        byArray[123] = 8;
        byArray[125] = 8;
        byArray[127] = 8;
        TIFF_HEADER = byArray;
    }
}

