/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.text.Segment;
import processing.app.Editor;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarker;
import processing.core.PApplet;

public class DiscourseFormat {
    Editor editor;
    JEditTextArea parent;

    public void show() {
        StringBuffer stringBuffer = new StringBuffer("[quote] \n \n");
        int n = 0;
        while (n < this.parent.getLineCount()) {
            stringBuffer.append(this.formatCode(n));
            ++n;
        }
        stringBuffer.append("\n [/quote]");
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            public final void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        });
        this.editor.message("Discourse-formatted code has been copied to the clipboard.");
    }

    public String formatCode(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Segment segment = new Segment();
        TextAreaPainter textAreaPainter = this.parent.getPainter();
        TokenMarker tokenMarker = this.parent.getTokenMarker();
        FontMetrics fontMetrics = textAreaPainter.getFontMetrics();
        this.parent.getLineText(n, segment);
        char[] cArray = segment.array;
        int n2 = segment.getEndIndex();
        int n3 = segment.offset;
        int n4 = segment.count;
        int n5 = 0;
        boolean bl = false;
        if (tokenMarker == null) {
            int n6 = 0;
            while (n6 < n4) {
                char c = cArray[n6 + n3];
                stringBuffer = stringBuffer.append(c);
                int n7 = c == '\t' ? (int)textAreaPainter.nextTabStop(n5, n6) - n5 : fontMetrics.charWidth(c);
                n5 += n7;
                ++n6;
            }
        } else {
            Token token;
            if (textAreaPainter.getCurrentLineIndex() == n && textAreaPainter.getCurrentLineTokens() != null) {
                token = textAreaPainter.getCurrentLineTokens();
            } else {
                textAreaPainter.setCurrentLineIndex(n);
                textAreaPainter.setCurrentLineTokens(tokenMarker.markTokens(segment, n));
                token = textAreaPainter.getCurrentLineTokens();
            }
            int n8 = 0;
            Toolkit toolkit = textAreaPainter.getToolkit();
            Font font = textAreaPainter.getFont();
            SyntaxStyle[] syntaxStyleArray = textAreaPainter.getStyles();
            while (true) {
                int n9;
                byte by;
                if ((by = token.id) == 127) {
                    n9 = cArray[n3 + n8];
                    if (n3 + n8 < n2) {
                        stringBuffer.append((char)n9);
                    } else {
                        stringBuffer.append('\n');
                    }
                    return stringBuffer.toString();
                }
                if (by == 0) {
                    fontMetrics = textAreaPainter.getFontMetrics();
                } else {
                    stringBuffer.append("[color=#");
                    stringBuffer.append(PApplet.hex(syntaxStyleArray[by].getColor().getRGB() & 0xFFFFFF, 6));
                    stringBuffer.append("]");
                    if (syntaxStyleArray[by].isBold()) {
                        stringBuffer.append("[b]");
                    }
                    fontMetrics = syntaxStyleArray[by].getFontMetrics(font);
                }
                n9 = token.length;
                int n10 = 0;
                while (n10 < n9) {
                    char c = cArray[n3 + n8 + n10];
                    stringBuffer.append(c);
                    if (n10 == n9 - '\u0001' && by != 0 && syntaxStyleArray[by].isBold()) {
                        stringBuffer.append("[/b]");
                    }
                    if (n10 == n9 - '\u0001' && by != 0) {
                        stringBuffer.append("[/color]");
                    }
                    int n11 = c == '\t' ? (int)textAreaPainter.nextTabStop(n5, n8 + n10) - n5 : fontMetrics.charWidth(c);
                    n5 += n11;
                    ++n10;
                }
                n8 += n9;
                token = token.next;
            }
        }
        return stringBuffer.toString();
    }

    public DiscourseFormat(Editor editor) {
        this.editor = editor;
        this.parent = editor.textarea;
    }
}

