/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import processing.app.syntax.InputHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultInputHandler
extends InputHandler {
    private Hashtable bindings;
    private Hashtable currentBindings;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public void addDefaultKeyBindings() {
        this.addKeyBinding("BACK_SPACE", BACKSPACE);
        this.addKeyBinding("C+BACK_SPACE", BACKSPACE_WORD);
        this.addKeyBinding("DELETE", DELETE);
        this.addKeyBinding("C+DELETE", DELETE_WORD);
        this.addKeyBinding("ENTER", INSERT_BREAK);
        this.addKeyBinding("TAB", INSERT_TAB);
        this.addKeyBinding("INSERT", OVERWRITE);
        this.addKeyBinding("C+\\", TOGGLE_RECT);
        this.addKeyBinding("HOME", HOME);
        this.addKeyBinding("END", END);
        this.addKeyBinding("S+HOME", SELECT_HOME);
        this.addKeyBinding("S+END", SELECT_END);
        this.addKeyBinding("C+HOME", DOCUMENT_HOME);
        this.addKeyBinding("C+END", DOCUMENT_END);
        this.addKeyBinding("CS+HOME", SELECT_DOC_HOME);
        this.addKeyBinding("CS+END", SELECT_DOC_END);
        this.addKeyBinding("PAGE_UP", PREV_PAGE);
        this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
        this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
        this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
        this.addKeyBinding("LEFT", PREV_CHAR);
        this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
        this.addKeyBinding("C+LEFT", PREV_WORD);
        this.addKeyBinding("CS+LEFT", SELECT_PREV_WORD);
        this.addKeyBinding("RIGHT", NEXT_CHAR);
        this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
        this.addKeyBinding("C+RIGHT", NEXT_WORD);
        this.addKeyBinding("CS+RIGHT", SELECT_NEXT_WORD);
        this.addKeyBinding("UP", PREV_LINE);
        this.addKeyBinding("S+UP", SELECT_PREV_LINE);
        this.addKeyBinding("DOWN", NEXT_LINE);
        this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
        this.addKeyBinding("C+ENTER", REPEAT);
    }

    public void addKeyBinding(String string, ActionListener actionListener) {
        Hashtable hashtable = this.bindings;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            KeyStroke keyStroke = DefaultInputHandler.parseKeyStroke(stringTokenizer.nextToken());
            if (keyStroke == null) {
                return;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Object object = hashtable.get(keyStroke);
                if (object instanceof Hashtable) {
                    hashtable = (Hashtable)object;
                    continue;
                }
                object = new Hashtable();
                hashtable.put(keyStroke, object);
                hashtable = (Hashtable)object;
                continue;
            }
            hashtable.put(keyStroke, actionListener);
        }
    }

    public void removeKeyBinding(String string) {
        throw new InternalError("Not yet implemented");
    }

    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    public InputHandler copy() {
        return new DefaultInputHandler(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        KeyStroke keyStroke;
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n == 17 || n == 16 || n == 18 || n == 157) {
            return;
        }
        if ((n2 & 4) != 0 && this.currentBindings.get(keyStroke = KeyStroke.getKeyStroke(n, n2)) == null) {
            return;
        }
        if ((n2 & 0xFFFFFFFE) != 0 || keyEvent.isActionKey() || n == 8 || n == 127 || n == 10 || n == 9 || n == 27) {
            if (this.grabAction != null) {
                this.handleGrabAction(keyEvent);
                return;
            }
            keyStroke = KeyStroke.getKeyStroke(n, n2);
            Object v = this.currentBindings.get(keyStroke);
            if (v == null) {
                if (this.currentBindings != this.bindings) {
                    Toolkit.getDefaultToolkit().beep();
                    this.repeatCount = 0;
                    this.repeat = false;
                    keyEvent.consume();
                }
                this.currentBindings = this.bindings;
                return;
            }
            if (v instanceof ActionListener) {
                this.currentBindings = this.bindings;
                this.executeAction((ActionListener)v, keyEvent.getSource(), null);
                keyEvent.consume();
                return;
            }
            if (v instanceof Hashtable) {
                this.currentBindings = (Hashtable)v;
                keyEvent.consume();
                return;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        if ((n & 4) != 0) {
            return;
        }
        if (c != (char)-1 && c >= ' ' && c != '\u007f') {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(Character.toUpperCase(c));
            Object v = this.currentBindings.get(keyStroke);
            if (v instanceof Hashtable) {
                this.currentBindings = (Hashtable)v;
                return;
            }
            if (v instanceof ActionListener) {
                this.currentBindings = this.bindings;
                this.executeAction((ActionListener)v, keyEvent.getSource(), String.valueOf(c));
                return;
            }
            this.currentBindings = this.bindings;
            if (this.grabAction != null) {
                this.handleGrabAction(keyEvent);
                return;
            }
            if (this.repeat && Character.isDigit(c)) {
                this.repeatCount *= 10;
                this.repeatCount += c - 48;
                return;
            }
            this.executeAction(INSERT_CHAR, keyEvent.getSource(), String.valueOf(keyEvent.getKeyChar()));
            this.repeatCount = 0;
            this.repeat = false;
        }
    }

    public static KeyStroke parseKeyStroke(String string) {
        int n;
        String string2;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string.indexOf(43);
        if (n3 != -1) {
            int n4 = 0;
            while (n4 < n3) {
                switch (Character.toUpperCase(string.charAt(n4))) {
                    case 'A': {
                        n2 |= 8;
                        break;
                    }
                    case 'C': {
                        n2 |= 2;
                        break;
                    }
                    case 'M': {
                        n2 |= 4;
                        break;
                    }
                    case 'S': {
                        n2 |= 1;
                        break;
                    }
                }
                ++n4;
            }
        }
        if ((string2 = string.substring(n3 + 1)).length() == 1) {
            char c = Character.toUpperCase(string2.charAt(0));
            if (n2 == 0) {
                return KeyStroke.getKeyStroke(c);
            }
            return KeyStroke.getKeyStroke((int)c, n2);
        }
        if (string2.length() == 0) {
            System.err.println("Invalid key stroke: " + string);
            return null;
        }
        try {
            Class clazz = class$java$awt$event$KeyEvent;
            if (clazz == null) {
                clazz = class$java$awt$event$KeyEvent = DefaultInputHandler.class("[Ljava.awt.event.KeyEvent;", false);
            }
            n = clazz.getField("VK_".concat(string2)).getInt(null);
        }
        catch (Exception exception) {
            System.err.println("Invalid key stroke: " + string);
            return null;
        }
        return KeyStroke.getKeyStroke(n, n2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DefaultInputHandler() {
        this.bindings = this.currentBindings = new Hashtable();
    }

    private DefaultInputHandler(DefaultInputHandler defaultInputHandler) {
        this.bindings = this.currentBindings = defaultInputHandler.bindings;
    }
}

