/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import processing.app.Base;
import processing.app.Editor;
import processing.app.LibraryManager;
import processing.app.Preferences;

public class Sketchbook {
    static File examplesFolder;
    static String examplesPath;
    static File librariesFolder;
    static String librariesPath;
    static Hashtable importToLibraryTable;
    static String librariesClassPath;
    Editor editor;
    JMenu openMenu;
    JMenu popupMenu;
    JMenu importMenu;
    boolean builtOnce;

    public static String getSketchbookPath() {
        return Preferences.get("sketchbook.path");
    }

    public String handleNew(boolean bl, boolean bl2, boolean bl3) throws IOException {
        Object object;
        File file = null;
        String string = null;
        boolean bl4 = Preferences.getBoolean("sketchbook.prompt");
        if (bl2) {
            bl4 ^= true;
        }
        if (bl) {
            bl4 = false;
        }
        if (bl4) {
            object = new FileDialog((Frame)this.editor, "Create sketch folder named:", 1);
            ((FileDialog)object).setDirectory(Sketchbook.getSketchbookPath());
            ((Dialog)object).show();
            String string2 = ((FileDialog)object).getDirectory();
            string = ((FileDialog)object).getFile();
            if (string == null) {
                return null;
            }
            string = Sketchbook.sanitizeName(string);
            file = new File(string2, string);
        } else {
            object = Sketchbook.getSketchbookPath();
            int n = 0;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd");
            String string3 = simpleDateFormat.format(new Date());
            do {
                string = "sketch_" + string3 + (char)(97 + n);
                file = new File((String)object, string);
                ++n;
            } while (file.exists());
        }
        file.mkdirs();
        if (bl3) {
            new File(file, "library").mkdirs();
        }
        object = new File(file, string + ".pde");
        new FileOutputStream((File)object);
        if (Base.isMacOS()) {
            MRJFileUtils.setFileTypeAndCreator((File)object, (MRJOSType)MRJOSType.kTypeTEXT, (MRJOSType)new MRJOSType("Pde1"));
        }
        this.rebuildMenusAsync();
        return ((File)object).getAbsolutePath();
    }

    public static String sanitizeName(String string) {
        String string2 = Sketchbook.sanitizedName(string);
        if (!string2.equals(string)) {
            Base.showMessage("Naming issue", "The sketch name had to be modified.\nYou can only use basic letters and numbers\nto name a sketch (ascii only and no spaces,\nit can't start with a number, and should be\nless than 64 characters long)");
        }
        return string2;
    }

    public static boolean isSanitary(String string) {
        return Sketchbook.sanitizedName(string).equals(string);
    }

    public static String sanitizedName(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray[0] >= '0' && cArray[0] <= '9') {
            stringBuffer.append('_');
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] >= '0' && cArray[n] <= '9' || cArray[n] >= 'a' && cArray[n] <= 'z' || cArray[n] >= 'A' && cArray[n] <= 'Z') {
                stringBuffer.append(cArray[n]);
            } else {
                stringBuffer.append('_');
            }
            ++n;
        }
        if (stringBuffer.length() > 63) {
            stringBuffer.setLength(63);
        }
        return stringBuffer.toString();
    }

    public String handleOpen() {
        FileDialog fileDialog = new FileDialog((Frame)this.editor, "Open a Processing sketch...", 0);
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public final boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".pde");
            }
        });
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return null;
        }
        File file = new File(string, string2);
        return file.getAbsolutePath();
    }

    public void rebuildMenusAsync() {
        this.rebuildMenus();
    }

    public void rebuildMenus() {
        try {
            this.buildMenu(this.openMenu);
            this.builtOnce = true;
            this.buildMenu(this.popupMenu);
            librariesClassPath = "";
            this.importMenu.removeAll();
            if (this.addLibraries(this.importMenu, examplesFolder)) {
                this.importMenu.addSeparator();
            }
            this.addLibraries(this.importMenu, librariesFolder);
        }
        catch (IOException iOException) {
            Base.showWarning("Problem while building sketchbook menu", "There was a problem with building the\nsketchbook menu. Things might get a little\nkooky around here.", iOException);
        }
    }

    public void buildMenu(JMenu jMenu) {
        jMenu.removeAll();
        JMenuItem jMenuItem = Editor.newJMenuItem("Open...", 79, false);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Sketchbook.this.editor.handleOpen(null);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        try {
            boolean bl = this.addSketches(jMenu, new File(Sketchbook.getSketchbookPath()));
            if (bl) {
                jMenu.addSeparator();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ActionListener actionListener = new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Sketchbook.this.editor.handleOpen(actionEvent.getActionCommand());
            }
        };
        try {
            LibraryManager libraryManager = new LibraryManager();
            JMenu jMenu2 = new JMenu("Examples");
            this.addSketches(jMenu2, examplesFolder);
            libraryManager.populateExamplesMenu(jMenu2, actionListener);
            jMenu.add(jMenu2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public JMenu getOpenMenu() {
        if (this.openMenu == null) {
            this.rebuildMenus();
        }
        return this.openMenu;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.rebuildMenus();
        }
        return this.popupMenu.getPopupMenu();
    }

    public JMenu getImportMenu() {
        return this.importMenu;
    }

    protected boolean addSketches(JMenu jMenu, File file) throws IOException {
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        ActionListener actionListener = new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Sketchbook.this.editor.handleOpen(actionEvent.getActionCommand());
            }
        };
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            File file2;
            if (stringArray[n].charAt(0) != '.' && !stringArray[n].equals("CVS") && (file2 = new File(file, stringArray[n])).isDirectory()) {
                Object object;
                File file3 = new File(file2, stringArray[n] + ".pde");
                if (file3.exists()) {
                    if (!Sketchbook.isSanitary(stringArray[n])) {
                        if (!this.builtOnce) {
                            object = "The sketch \"" + stringArray[n] + "\" cannot be used.\nSketch names must contain only basic letters and numbers\n(ASCII-only with no spaces, and it cannot start with a number).\nTo get rid of this message, remove the sketch from\n" + file3.getAbsolutePath();
                            Base.showMessage("Ignoring sketch with bad name", (String)object);
                        }
                    } else {
                        object = new JMenuItem(stringArray[n]);
                        ((AbstractButton)object).addActionListener(actionListener);
                        ((AbstractButton)object).setActionCommand(file3.getAbsolutePath());
                        jMenu.add((JMenuItem)object);
                        bl = true;
                    }
                } else {
                    object = new JMenu(stringArray[n]);
                    boolean bl2 = this.addSketches((JMenu)object, file2);
                    if (bl2) {
                        jMenu.add((JMenuItem)object);
                        bl = true;
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    protected boolean addLibraries(JMenu jMenu, File file) throws IOException {
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        ActionListener actionListener = new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Sketchbook.this.editor.sketch.importLibrary(actionEvent.getActionCommand());
            }
        };
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            File file2;
            if (stringArray[n].charAt(0) != '.' && !stringArray[n].equals("CVS") && (file2 = new File(file, stringArray[n])).isDirectory()) {
                JMenuItem jMenuItem;
                FileFilter fileFilter = new FileFilter(){

                    public final boolean accept(File file) {
                        return file.getName().endsWith(".h");
                    }
                };
                if (file2.listFiles(fileFilter).length > 0) {
                    jMenuItem = new JMenuItem(stringArray[n]);
                    jMenuItem.addActionListener(actionListener);
                    jMenuItem.setActionCommand(file2.getAbsolutePath());
                    jMenu.add(jMenuItem);
                    bl = true;
                } else {
                    jMenuItem = new JMenu(stringArray[n]);
                    boolean bl2 = this.addLibraries((JMenu)jMenuItem, file2);
                    if (bl2) {
                        jMenu.add(jMenuItem);
                        bl = true;
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    public void clean() {
        File file = new File(Sketchbook.getSketchbookPath());
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2;
                File file3;
                if (stringArray[n].charAt(0) != '.' && (file3 = new File(file2 = new File(file, stringArray[n]), stringArray[n] + ".pde")).exists() && Base.calcFolderSize(file2) == 0) {
                    if (Preferences.getBoolean("sketchbook.auto_clean")) {
                        Base.removeDir(file2);
                    } else {
                        Object[] objectArray;
                        String string = "Remove empty sketch titled \"" + stringArray[n] + "\"?";
                        int n2 = JOptionPane.showOptionDialog(this.editor, string, "Housekeeping", 0, 3, null, objectArray = new Object[]{"Yes", "No"}, objectArray[0]);
                        if (n2 == 0) {
                            Base.removeDir(file2);
                        }
                    }
                }
                ++n;
            }
        }
    }

    public Sketchbook(Editor editor) {
        File file;
        this.editor = editor;
        examplesFolder = new File(System.getProperty("user.dir"), "examples");
        examplesPath = examplesFolder.getAbsolutePath();
        librariesFolder = new File(System.getProperty("user.dir"), "hardware" + File.separator + "libraries");
        librariesPath = librariesFolder.getAbsolutePath();
        String string = Preferences.get("sketchbook.path");
        if (string != null && !(file = new File(string)).exists()) {
            Base.showWarning("Sketchbook folder disappeared", "The sketchbook folder no longer exists,\nso a new sketchbook will be created in the\ndefault location.", null);
            string = null;
        }
        if (string == null) {
            file = Base.getDefaultSketchbookFolder();
            Preferences.set("sketchbook.path", file.getAbsolutePath());
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        this.openMenu = new JMenu("Sketchbook");
        this.popupMenu = new JMenu("Sketchbook");
        this.importMenu = new JMenu("Import Library");
    }

    static {
        importToLibraryTable = new Hashtable();
    }
}

