/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import processing.app.AvrdudeUploader;
import processing.app.Base;
import processing.app.Compiler;
import processing.app.Editor;
import processing.app.Library;
import processing.app.LibraryManager;
import processing.app.Preferences;
import processing.app.RunnerException;
import processing.app.Sizer;
import processing.app.SketchCode;
import processing.app.Sketchbook;
import processing.app.Target;
import processing.app.Uploader;
import processing.app.preproc.PdePreprocessor;

public class Sketch {
    static File tempBuildFolder;
    static final int PDE = 0;
    static final int CPP = 1;
    static final int C = 2;
    static final int HEADER = 3;
    static final String[] flavorExtensionsReal;
    static final String[] flavorExtensionsShown;
    Editor editor;
    String name;
    String mainFilename;
    boolean modified;
    public File folder;
    public File dataFolder;
    public File codeFolder;
    public SketchCode current;
    int currentIndex;
    int codeCount;
    SketchCode[] code;
    int hiddenCount;
    SketchCode[] hidden;
    Hashtable zipFileContents;
    String mainClassName;
    String classPath;
    String libraryPath;
    boolean externalRuntime;
    public Vector importedLibraries;
    boolean renamingCode;

    public void load() {
        int n;
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        String[] stringArray = this.folder.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].endsWith(".pde")) {
                ++this.codeCount;
            } else if (stringArray[n2].endsWith(".c")) {
                ++this.codeCount;
            } else if (stringArray[n2].endsWith(".h")) {
                ++this.codeCount;
            } else if (stringArray[n2].endsWith(".cpp")) {
                ++this.codeCount;
            } else if (stringArray[n2].endsWith(".pde.x")) {
                ++this.hiddenCount;
            } else if (stringArray[n2].endsWith(".c.x")) {
                ++this.hiddenCount;
            } else if (stringArray[n2].endsWith(".h.x")) {
                ++this.hiddenCount;
            } else if (stringArray[n2].endsWith(".cpp.x")) {
                ++this.hiddenCount;
            }
            ++n2;
        }
        this.code = new SketchCode[this.codeCount];
        this.hidden = new SketchCode[this.hiddenCount];
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4].endsWith(".pde")) {
                this.code[n2++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 4), new File(this.folder, stringArray[n4]), 0);
            } else if (stringArray[n4].endsWith(".c")) {
                this.code[n2++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 2), new File(this.folder, stringArray[n4]), 2);
            } else if (stringArray[n4].endsWith(".h")) {
                this.code[n2++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 2), new File(this.folder, stringArray[n4]), 3);
            } else if (stringArray[n4].endsWith(".cpp")) {
                this.code[n2++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 4), new File(this.folder, stringArray[n4]), 1);
            } else if (stringArray[n4].endsWith(".pde.x")) {
                this.hidden[n3++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 6), new File(this.folder, stringArray[n4]), 0);
            } else if (stringArray[n4].endsWith(".c.x")) {
                this.hidden[n3++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 4), new File(this.folder, stringArray[n4]), 2);
            } else if (stringArray[n4].endsWith(".h.x")) {
                this.hidden[n3++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 4), new File(this.folder, stringArray[n4]), 3);
            } else if (stringArray[n4].endsWith(".cpp.x")) {
                this.hidden[n3++] = new SketchCode(stringArray[n4].substring(0, stringArray[n4].length() - 6), new File(this.folder, stringArray[n4]), 1);
            }
            ++n4;
        }
        this.hiddenCount = n3;
        n4 = 0;
        while (n4 < this.codeCount) {
            if (this.code[n4] == null || this.code[n4].program == null) {
                n = n4 + 1;
                while (n < this.codeCount) {
                    this.code[n - 1] = this.code[n];
                    ++n;
                }
                --this.codeCount;
                continue;
            }
            ++n4;
        }
        n = 1;
        while (n < this.codeCount) {
            if (this.code[n].file.getName().equals(this.mainFilename)) {
                SketchCode sketchCode = this.code[0];
                this.code[0] = this.code[n];
                this.code[n] = sketchCode;
                break;
            }
            ++n;
        }
        this.sortCode();
        this.setCurrent(0);
    }

    protected void insertCode(SketchCode sketchCode) {
        this.ensureExistence();
        if (this.codeCount == this.code.length) {
            SketchCode[] sketchCodeArray = new SketchCode[this.codeCount + 1];
            System.arraycopy(this.code, 0, sketchCodeArray, 0, this.codeCount);
            this.code = sketchCodeArray;
        }
        this.code[this.codeCount++] = sketchCode;
    }

    protected void sortCode() {
        int n = 1;
        while (n < this.codeCount) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 < this.codeCount) {
                if (this.code[n3].name.compareTo(this.code[n2].name) < 0) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 != n) {
                SketchCode sketchCode = this.code[n2];
                this.code[n2] = this.code[n];
                this.code[n] = sketchCode;
            }
            ++n;
        }
    }

    public void newCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = false;
        this.editor.status.edit("Name for new file:", "");
    }

    public void renameCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = true;
        String string = this.currentIndex == 0 ? "New name for sketch:" : "New name for file:";
        String string2 = this.current.name + flavorExtensionsShown[this.current.flavor];
        this.editor.status.edit(string, string2);
    }

    public void nameCode(String string) {
        File file;
        this.ensureExistence();
        if (this.renamingCode && string.equalsIgnoreCase(this.current.name)) {
            return;
        }
        if (string.trim().equals("")) {
            return;
        }
        if (string.trim().equals(".c") || string.trim().equals(".h") || string.trim().equals(".pde") || string.trim().equals(".cpp")) {
            return;
        }
        String string2 = null;
        int n = 0;
        if (string.endsWith(".pde")) {
            string2 = string;
            string = string.substring(0, string.length() - 4);
            n = 0;
        } else if (string.endsWith(".c") || string.endsWith(".cpp") || string.endsWith(".h")) {
            if (this.renamingCode && this.code[0] == this.current) {
                Base.showWarning("Problem with rename", "The main .pde file cannot be .c, .cpp, or .h file.\n(It may be time for your to graduate to a\n\"real\" programming environment)", null);
                return;
            }
            string2 = string;
            if (string.endsWith(".c")) {
                string = string.substring(0, string.length() - 2);
                n = 2;
            }
            if (string.endsWith(".h")) {
                string = string.substring(0, string.length() - 2);
                n = 3;
            } else if (string.endsWith(".cpp")) {
                string = string.substring(0, string.length() - 4);
                n = 1;
            }
        } else {
            string2 = string + ".pde";
            n = 0;
        }
        if (string.indexOf(46) != -1) {
            string = Sketchbook.sanitizedName(string);
            string2 = string + (n == 0 ? ".pde" : ".cpp");
        }
        if ((file = new File(this.folder, string2)).exists()) {
            Base.showMessage("Nope", "A file named \"" + file + "\" already exists\nin \"" + this.folder.getAbsolutePath() + '\"');
            return;
        }
        File file2 = new File(this.folder, string2 + ".x");
        if (file2.exists()) {
            Base.showMessage("No Way", "A hidden tab with the same name already exists.\nUse \"Unhide\" to bring it back.");
            return;
        }
        if (this.renamingCode) {
            if (this.currentIndex == 0) {
                int n2;
                File file3 = new File(this.folder.getParentFile(), string);
                if (file3.exists()) {
                    Base.showWarning("Cannot Rename", "Sorry, a sketch (or folder) named \"" + string + "\" already exists.", null);
                    return;
                }
                if (this.current.modified) {
                    this.current.program = this.editor.getText();
                    try {
                        this.current.save();
                    }
                    catch (Exception exception) {
                        Base.showWarning("Error", "Could not rename the sketch. (0)", exception);
                        return;
                    }
                }
                if (!this.current.file.renameTo(file)) {
                    Base.showWarning("Error", "Could not rename \"" + this.current.file.getName() + "\" to \"" + file.getName() + '\"', null);
                    return;
                }
                try {
                    n2 = 1;
                    while (n2 < this.codeCount) {
                        this.code[n2].save();
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    Base.showWarning("Error", "Could not rename the sketch. (1)", exception);
                    return;
                }
                n2 = this.folder.renameTo(file3) ? 1 : 0;
                if (n2 == 0) {
                    Base.showWarning("Error", "Could not rename the sketch. (2)", null);
                    return;
                }
                File file4 = new File(file3, string + ".pde");
                this.mainFilename = file4.getAbsolutePath();
                this.editor.handleOpenUnchecked(this.mainFilename, this.currentIndex, this.editor.textarea.getSelectionStart(), this.editor.textarea.getSelectionEnd(), this.editor.textarea.getScrollPosition());
                this.editor.sketchbook.rebuildMenus();
            } else {
                if (!this.current.file.renameTo(file)) {
                    Base.showWarning("Error", "Could not rename \"" + this.current.file.getName() + "\" to \"" + file.getName() + '\"', null);
                    return;
                }
                this.current.name = string;
                this.current.file = file;
                this.current.flavor = n;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                Base.showWarning("Error", "Could not create the file \"" + file + "\"\nin \"" + this.folder.getAbsolutePath() + '\"', iOException);
                return;
            }
            SketchCode sketchCode = new SketchCode(string, file, n);
            this.insertCode(sketchCode);
        }
        this.sortCode();
        this.setCurrent(string + flavorExtensionsShown[n]);
        this.editor.header.rebuild();
        Toolkit.getDefaultToolkit().sync();
    }

    public void deleteCode() {
        Object[] objectArray;
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String string = this.currentIndex == 0 ? "Are you sure you want to delete this sketch?" : "Are you sure you want to delete \"" + this.current.name + flavorExtensionsShown[this.current.flavor] + "\"?";
        int n = JOptionPane.showOptionDialog(this.editor, string, "Delete", 0, 3, null, objectArray = new Object[]{"OK", "Cancel"}, objectArray[0]);
        if (n == 0) {
            if (this.currentIndex == 0) {
                Base.removeDir(this.folder);
                this.editor.handleNewUnchecked();
            } else {
                if (!this.current.file.delete()) {
                    Base.showMessage("Couldn't do it", "Could not delete \"" + this.current.name + "\".");
                    return;
                }
                this.removeCode(this.current);
                this.setCurrent(0);
                this.editor.header.repaint();
            }
        }
    }

    protected void removeCode(SketchCode sketchCode) {
        int n = 0;
        while (n < this.codeCount) {
            if (this.code[n] == sketchCode) {
                int n2 = n;
                while (n2 < this.codeCount - 1) {
                    this.code[n2] = this.code[n2 + 1];
                    ++n2;
                }
                --this.codeCount;
                return;
            }
            ++n;
        }
        System.err.println("removeCode: internal error.. could not find code");
    }

    public void hideCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        if (this.currentIndex == 0) {
            Base.showMessage("Can't do that", "You cannot hide the main .pde file from a sketch\n");
            return;
        }
        File file = new File(this.current.file.getAbsolutePath() + ".x");
        if (!this.current.file.renameTo(file)) {
            Base.showWarning("Error", "Could not hide \"" + this.current.file.getName() + "\".", null);
            return;
        }
        this.current.file = file;
        if (this.hiddenCount == this.hidden.length) {
            SketchCode[] sketchCodeArray = new SketchCode[this.hiddenCount + 1];
            System.arraycopy(this.hidden, 0, sketchCodeArray, 0, this.hiddenCount);
            this.hidden = sketchCodeArray;
        }
        this.hidden[this.hiddenCount++] = this.current;
        this.removeCode(this.current);
        this.setCurrent(0);
        this.editor.header.repaint();
    }

    public void unhideCode(String string) {
        SketchCode sketchCode = null;
        String string2 = string.substring(0, string.indexOf(".") == -1 ? string.length() : string.indexOf("."));
        String string3 = string.indexOf(".") == -1 ? "" : string.substring(string.indexOf("."));
        int n = 0;
        while (n < this.hiddenCount) {
            if (this.hidden[n].name.equals(string2) && flavorExtensionsShown[this.hidden[n].flavor].equals(string3)) {
                sketchCode = this.hidden[n];
                int n2 = n;
                while (n2 < this.hiddenCount - 1) {
                    this.hidden[n2] = this.hidden[n2 + 1];
                    ++n2;
                }
                --this.hiddenCount;
                break;
            }
            ++n;
        }
        if (sketchCode == null) {
            System.err.println("internal error: could find " + string + " to unhide.");
            return;
        }
        if (!sketchCode.file.exists()) {
            Base.showMessage("Can't unhide", "The file \"" + string + "\" no longer exists.");
            return;
        }
        String string4 = sketchCode.file.getAbsolutePath();
        File file = new File(string4.substring(0, string4.length() - 2));
        if (!sketchCode.file.renameTo(file)) {
            Base.showMessage("Can't unhide", "The file \"" + string + "\" could not berenamed and unhidden.");
            return;
        }
        sketchCode.file = file;
        this.insertCode(sketchCode);
        this.sortCode();
        this.setCurrent(sketchCode.name);
        this.editor.header.repaint();
    }

    public void setModified(boolean bl) {
        this.current.modified = bl;
        this.calcModified();
    }

    public void calcModified() {
        this.modified = false;
        int n = 0;
        while (n < this.codeCount) {
            if (this.code[n].modified) {
                this.modified = true;
                break;
            }
            ++n;
        }
        this.editor.header.repaint();
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        if (this.current.modified) {
            this.current.program = this.editor.getText();
        }
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is read-only", "Some files are marked \"read-only\", so you'll\nneed to re-save this sketch to another location.");
            if (!this.saveAs()) {
                return false;
            }
        }
        int n = 0;
        while (n < this.codeCount) {
            if (this.code[n].modified) {
                this.code[n].save();
            }
            ++n;
        }
        this.calcModified();
        return true;
    }

    public boolean saveAs() throws IOException {
        Object object;
        FileDialog fileDialog = new FileDialog((Frame)this.editor, "Save sketch folder as...", 1);
        if (this.isReadOnly()) {
            fileDialog.setDirectory(Preferences.get("sketchbook.path"));
        } else {
            fileDialog.setDirectory(this.folder.getParent());
        }
        fileDialog.setFile(this.folder.getName());
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return false;
        }
        File file = new File(this.folder, (string2 = Sketchbook.sanitizeName(string2)) + ".pde");
        if (file.exists() && !string2.equals(this.name)) {
            Base.showMessage("Nope", "You can't save the sketch as \"" + string2 + "\"\nbecause the sketch already has a tab with that name.");
            return false;
        }
        File file2 = new File(this.folder, string2 + ".pde.x");
        if (file2.exists()) {
            Base.showMessage("Nope", "You can't save the sketch as \"" + string2 + "\"\nbecause the sketch already has a hidden tab with that name.");
            return false;
        }
        File file3 = new File(string, string2);
        if (file3.equals(this.folder)) {
            Base.showWarning("You can't fool me", "The new sketch name and location are the same as\nthe old. I ain't not doin nuthin' not now.", null);
            return false;
        }
        try {
            String string3 = file3.getCanonicalPath() + File.separator;
            object = this.folder.getCanonicalPath() + File.separator;
            if (string3.indexOf((String)object) == 0) {
                Base.showWarning("How very Borges of you", "You cannot save the sketch into a folder\ninside itself. This would go on forever.", null);
                return false;
            }
        }
        catch (IOException iOException) {}
        if (file3.exists()) {
            Base.removeDir(file3);
        }
        file3.mkdirs();
        if (this.current.modified) {
            this.current.program = this.editor.getText();
        }
        int n = 1;
        while (n < this.codeCount) {
            object = new File(file3, this.code[n].file.getName());
            this.code[n].saveAs((File)object);
            ++n;
        }
        n = 0;
        while (n < this.hiddenCount) {
            object = new File(file3, this.hidden[n].file.getName());
            this.hidden[n].saveAs((File)object);
            ++n;
        }
        if (this.dataFolder.exists()) {
            File file4 = new File(file3, "data");
            Base.copyDir(this.dataFolder, file4);
        }
        if (this.codeFolder.exists()) {
            File file5 = new File(file3, "code");
            Base.copyDir(this.codeFolder, file5);
        }
        File file6 = new File(file3, string2 + ".pde");
        this.code[0].saveAs(file6);
        this.editor.handleOpenUnchecked(file6.getPath(), this.currentIndex, this.editor.textarea.getSelectionStart(), this.editor.textarea.getSelectionEnd(), this.editor.textarea.getScrollPosition());
        this.editor.sketchbook.rebuildMenusAsync();
        return true;
    }

    public void addFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String string = "Select an image or other data file to copy to your sketch";
        FileDialog fileDialog = new FileDialog((Frame)this.editor, string, 0);
        fileDialog.show();
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null) {
            return;
        }
        File file = new File(string2, string3);
        this.addFile(file);
    }

    public boolean addFile(File file) {
        String string = file.getName();
        File file2 = null;
        boolean bl = false;
        if (string.toLowerCase().endsWith(".o")) {
            if (!this.codeFolder.exists()) {
                this.codeFolder.mkdirs();
            }
            file2 = new File(this.codeFolder, string);
        } else if (string.toLowerCase().endsWith(".pde") || string.toLowerCase().endsWith(".c") || string.toLowerCase().endsWith(".h") || string.toLowerCase().endsWith(".cpp")) {
            file2 = new File(this.folder, string);
            bl = true;
        } else {
            if (!this.dataFolder.exists()) {
                this.dataFolder.mkdirs();
            }
            file2 = new File(this.dataFolder, string);
        }
        if (!bl && file.equals(file2)) {
            Base.showWarning("You can't fool me", "This file has already been copied to the\nlocation where you're trying to add it.\nI ain't not doin nuthin'.", null);
            return false;
        }
        if (!file.equals(file2)) {
            try {
                Base.copyFile(file, file2);
            }
            catch (IOException iOException) {
                Base.showWarning("Error adding file", "Could not add '" + string + "' to the sketch.", iOException);
                return false;
            }
        }
        if (bl) {
            String string2 = file2.getName();
            int n = -1;
            if (string2.toLowerCase().endsWith(".pde")) {
                string2 = string2.substring(0, string2.length() - 4);
                n = 0;
            } else if (string2.toLowerCase().endsWith(".c")) {
                string2 = string2.substring(0, string2.length() - 2);
                n = 2;
            } else if (string2.toLowerCase().endsWith(".h")) {
                string2 = string2.substring(0, string2.length() - 2);
                n = 3;
            } else {
                string2 = string2.substring(0, string2.length() - 4);
                n = 1;
            }
            SketchCode sketchCode = new SketchCode(string2, file2, n);
            this.insertCode(sketchCode);
            this.sortCode();
            this.setCurrent(string2);
            this.editor.header.repaint();
        }
        return true;
    }

    public void importLibrary(String string) {
        this.ensureExistence();
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.getName().endsWith(".h");
            }
        };
        File[] fileArray = new File(string).listFiles(fileFilter);
        if (this.current.flavor == 0) {
            this.setCurrent(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fileArray.length) {
            stringBuffer.append("#include <");
            stringBuffer.append(fileArray[n].getName());
            stringBuffer.append(">\n");
            ++n;
        }
        stringBuffer.append('\n');
        stringBuffer.append(this.editor.getText());
        this.editor.setText(stringBuffer.toString(), 0, 0);
        this.setModified(true);
    }

    public void setCurrent(int n) {
        if (this.currentIndex == n && this.current != null) {
            return;
        }
        if (this.current != null) {
            this.current.program = this.editor.getText();
            this.current.selectionStart = this.editor.textarea.getSelectionStart();
            this.current.selectionStop = this.editor.textarea.getSelectionEnd();
            this.current.scrollPosition = this.editor.textarea.getScrollPosition();
        }
        this.current = this.code[n];
        this.currentIndex = n;
        this.editor.setCode(this.current);
        this.editor.header.rebuild();
    }

    protected void setCurrent(String string) {
        Object var2_2 = null;
        String string2 = string.substring(0, string.indexOf(".") == -1 ? string.length() : string.indexOf("."));
        String string3 = string.indexOf(".") == -1 ? "" : string.substring(string.indexOf("."));
        int n = 0;
        while (n < this.codeCount) {
            if (string2.equals(this.code[n].name) && flavorExtensionsShown[this.code[n].flavor].equals(string3)) {
                this.setCurrent(n);
                return;
            }
            ++n;
        }
    }

    protected void cleanup() {
        System.gc();
        Base.removeDescendants(tempBuildFolder);
    }

    public boolean handleRun(Target target) throws RunnerException {
        this.ensureExistence();
        this.current.program = this.editor.getText();
        if (Preferences.getBoolean("editor.external")) {
            this.current = null;
            this.load();
        }
        this.cleanup();
        String string = "Temporary_" + String.valueOf((int)(Math.random() * 10000.0)) + '_' + String.valueOf((int)(Math.random() * 10000.0));
        this.mainClassName = this.build(target, tempBuildFolder.getAbsolutePath(), string);
        this.size(tempBuildFolder.getAbsolutePath(), this.name);
        if (!this.externalRuntime && this.dataFolder.exists()) {
            try {
                Base.copyDir(this.dataFolder, new File(tempBuildFolder, "data"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RunnerException("Problem copying files from data folder");
            }
        }
        boolean bl = false;
        if (this.mainClassName != null) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    protected String build(Target var1_1, String var2_2, String var3_3) throws RunnerException {
        block34: {
            this.editor.prepareLibraries();
            this.ensureExistence();
            var4_4 = null;
            var5_5 = System.getProperty("java.class.path");
            if (var5_5.startsWith("\"") && var5_5.endsWith("\"")) {
                var5_5 = var5_5.substring(1, var5_5.length() - 1);
            }
            this.classPath = var2_2 + File.pathSeparator + Sketchbook.librariesClassPath + File.pathSeparator + var5_5;
            if (this.codeFolder.exists()) {
                this.externalRuntime = true;
                this.classPath = Compiler.contentsToClassPath(this.codeFolder) + File.pathSeparator + this.classPath;
                this.libraryPath = this.codeFolder.getAbsolutePath();
                var6_6 = Compiler.contentsToClassPath(this.codeFolder);
            } else {
                this.externalRuntime = false;
                var6_7 = 0;
                while (var6_7 < this.codeCount) {
                    if (this.code[var6_7].flavor == 2 || this.code[var6_7].flavor == 1) {
                        this.externalRuntime = true;
                        break;
                    }
                    ++var6_7;
                }
                this.libraryPath = "";
            }
            if (this.dataFolder.exists() && Base.calcFolderSize(this.dataFolder) > 786432) {
                this.externalRuntime = true;
            }
            var6_6 = new StringBuffer(this.code[0].program);
            var7_8 = this.countLines(this.code[0].program);
            var8_9 = 1;
            while (var8_9 < this.codeCount) {
                if (this.code[var8_9].flavor == 0) {
                    this.code[var8_9].preprocOffset = ++var7_8;
                    var6_6.append('\n');
                    var6_6.append(this.code[var8_9].program);
                    var7_8 += this.countLines(this.code[var8_9].program);
                    this.code[var8_9].preprocName = null;
                }
                ++var8_9;
            }
            var8_10 = null;
            var9_11 = new PdePreprocessor();
            try {
                var10_12 = var9_11.write(var6_6.toString(), var2_2, var3_3, var4_4, var1_1);
                if (var10_12 == null) {
                    throw new RunnerException("Could not find main class");
                }
                this.code[0].preprocName = (String)var10_12 + ".cpp";
                var8_10 = var10_12;
                if (PdePreprocessor.programType == 2 || var9_11.extraImports.length != 0) {
                    this.externalRuntime = true;
                }
            }
            catch (RecognitionException var10_13) {
                var11_17 = 0;
                var12_23 = var10_13.getLine() - 1;
                var13_27 = 1;
                ** while (var13_27 < this.codeCount)
            }
lbl-1000:
            // 1 sources

            {
                if (this.code[var13_27].flavor == 0 && this.code[var13_27].preprocOffset < var12_23) {
                    var11_17 = var13_27;
                }
                ++var13_27;
                continue;
            }
lbl59:
            // 1 sources

            var12_23 -= this.code[var11_17].preprocOffset;
            var12_23 -= var9_11.prototypeCount;
            throw new RunnerException(var10_13.getMessage(), var11_17, var12_23 -= var9_11.headerCount, var10_13.getColumn());
            catch (TokenStreamRecognitionException var10_14) {
                var11_18 = new Perl5Matcher();
                var12_24 = new Perl5Compiler();
                var13_28 = "^line (\\d+):(\\d+):\\s";
                var14_33 = null;
                try {
                    var14_33 = var12_24.compile(var13_28);
                }
                catch (MalformedPatternException var15_35) {
                    Base.showWarning("Internal Problem", "An internal error occurred while trying\nto compile the sketch. Please report\nthis online at https://developer.berlios.de/bugs/?group_id=3590", (Exception)var15_35);
                }
                var15_36 = new PatternMatcherInput(var10_14.toString());
                if (!var11_18.contains(var15_36, var14_33)) break block34;
                var16_38 = var11_18.getMatch();
                var17_40 = Integer.parseInt(var16_38.group(1).toString()) - 1;
                var18_42 = Integer.parseInt(var16_38.group(2).toString());
                var19_43 = 0;
                var20_44 = 1;
                ** while (var20_44 < this.codeCount)
            }
lbl-1000:
            // 1 sources

            {
                if (this.code[var20_44].flavor == 0 && this.code[var20_44].preprocOffset < var17_40) {
                    var19_43 = var20_44;
                }
                ++var20_44;
                continue;
            }
lbl84:
            // 1 sources

            var17_40 -= this.code[var19_43].preprocOffset;
            var17_40 -= var9_11.prototypeCount;
            throw new RunnerException(var10_14.getMessage(), var19_43, var17_40 -= var9_11.headerCount, var18_42);
        }
        throw new RunnerException(var10_14.toString(), 0, -1, -1);
        catch (RunnerException var10_15) {
            throw var10_15;
        }
        catch (Exception var10_16) {
            System.err.println("Uncaught exception type:" + var10_16.getClass());
            var10_16.printStackTrace();
            throw new RunnerException(var10_16.toString());
        }
        this.importedLibraries = new Vector<E>();
        var10_12 = var9_11.extraImports;
        try {
            var11_19 = new LibraryManager();
            var12_25 = var11_19.getAll();
            var13_29 = var12_25.iterator();
            while (var13_29.hasNext()) {
                var14_34 = (Library)var13_29.next();
                var15_37 = var14_34.getHeaderFiles();
                var16_39 = 0;
                while (var16_39 < var15_37.length) {
                    var17_41 = 0;
                    while (var17_41 < var10_12.length) {
                        if (var15_37[var16_39].getName().equals(var10_12[var17_41]) && !this.importedLibraries.contains(var14_34)) {
                            this.importedLibraries.add(var14_34);
                        }
                        ++var17_41;
                    }
                    ++var16_39;
                }
            }
        }
        catch (IOException var11_20) {
            System.err.println("Error finding libraries:");
            var11_20.printStackTrace();
            throw new RunnerException(var11_20.getMessage());
        }
        var11_21 = 0;
        while (var11_21 < this.codeCount) {
            if (this.code[var11_21].flavor == 1 || this.code[var11_21].flavor == 2 || this.code[var11_21].flavor == 3) {
                var12_25 = this.code[var11_21].name + Sketch.flavorExtensionsReal[this.code[var11_21].flavor];
                try {
                    Base.saveFile(this.code[var11_21].program, new File(var2_2, (String)var12_25));
                }
                catch (IOException var13_30) {
                    var13_30.printStackTrace();
                    throw new RunnerException("Problem moving " + (String)var12_25 + " to the build folder");
                }
                this.code[var11_21].preprocName = var12_25;
            }
            ++var11_21;
        }
        var11_22 = new Compiler();
        try {
            var12_26 = var11_22.compile(this, var2_2, var1_1);
        }
        catch (RunnerException var13_31) {
            throw new RunnerException(var13_31.getMessage(), var13_31.file, var13_31.line - var9_11.prototypeCount - var9_11.headerCount, var13_31.column);
        }
        catch (Exception var13_32) {
            throw new RunnerException(var13_32.toString());
        }
        return var12_26 != false ? var8_10 : null;
    }

    protected void size(String string, String string2) throws RunnerException {
        long l = 0L;
        long l2 = Preferences.getInteger("boards." + Preferences.get("board") + ".upload.maximum_size");
        Sizer sizer = new Sizer(string, string2);
        try {
            l = sizer.computeSize();
            System.out.println("Binary sketch size: " + l + " bytes (of a " + l2 + " byte maximum)");
        }
        catch (RunnerException runnerException) {
            System.err.println("Couldn't determine program size: " + runnerException.getMessage());
        }
        if (l > l2) {
            throw new RunnerException("Sketch too big; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing it.");
        }
    }

    protected String upload(String string, String string2) throws RunnerException {
        AvrdudeUploader avrdudeUploader = new AvrdudeUploader();
        boolean bl = ((Uploader)avrdudeUploader).uploadUsingPreferences(string, string2);
        return bl ? string2 : null;
    }

    protected int countLines(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\n') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean exportApplet(Target target) throws RunnerException {
        this.ensureExistence();
        if (Preferences.getBoolean("editor.external")) {
            this.load();
        } else {
            this.current.program = this.editor.getText();
        }
        this.zipFileContents = new Hashtable();
        File file = new File(this.folder, "applet");
        Base.removeDir(file);
        file.mkdirs();
        String string = this.build(target, file.getPath(), this.name);
        this.size(file.getPath(), this.name);
        string = this.upload(file.getPath(), this.name);
        if (string == null) {
            return false;
        }
        if (!this.name.equals(string)) {
            Base.showWarning("Error during export", "Sketch name is " + this.name + " but the sketch\nname in the code was " + string, null);
            return false;
        }
        int n = 0;
        while (n < this.codeCount) {
            try {
                Base.copyFile(this.code[n].file, new File(file, this.code[n].file.getName()));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++n;
        }
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2;
            if (stringArray[n2].endsWith(".class") && !(file2 = new File(file, stringArray[n2])).delete()) {
                Base.showWarning("Could not delete", stringArray[n2] + " could not \nbe deleted from the applet folder.  \nYou'll need to remove it by hand.", null);
            }
            ++n2;
        }
        if (Preferences.getBoolean("uploader.open_folder")) {
            Base.openFolder(file);
        }
        return true;
    }

    public static String scrubComments(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '/') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                while (n < cArray.length && cArray[n] != '\n') {
                    cArray[n++] = 32;
                }
                continue;
            }
            if (cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '*') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                boolean bl = false;
                while (n < cArray.length - 1) {
                    if (cArray[n] == '*' && cArray[n + 1] == '/') {
                        cArray[n++] = 32;
                        cArray[n++] = 32;
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            ++n;
        }
        return new String(cArray);
    }

    public boolean exportApplication() {
        return true;
    }

    protected void ensureExistence() {
        if (this.folder.exists()) {
            return;
        }
        Base.showWarning("Sketch Disappeared", "The sketch folder has disappeared.\n Will attempt to re-save in the same location,\nbut anything besides the code will be lost.", null);
        try {
            this.folder.mkdirs();
            this.modified = true;
            int n = 0;
            while (n < this.codeCount) {
                this.code[n].save();
                ++n;
            }
            n = 0;
            while (n < this.hiddenCount) {
                this.hidden[n].save();
                ++n;
            }
            this.calcModified();
        }
        catch (Exception exception) {
            Base.showWarning("Could not re-save sketch", "Could not properly re-save the sketch. You may be in trouble at this point,\nand it might be time to copy and paste your code to another text editor.", exception);
        }
    }

    public boolean isReadOnly() {
        String string = this.folder.getAbsolutePath();
        if (string.startsWith(Sketchbook.examplesPath) || string.startsWith(Sketchbook.librariesPath)) {
            return true;
        }
        int n = 0;
        while (n < this.codeCount) {
            if (this.code[n].modified && !this.code[n].file.canWrite() && this.code[n].file.exists()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getMainFilePath() {
        return this.code[0].file.getAbsolutePath();
    }

    public void prevCode() {
        int n = this.currentIndex - 1;
        if (n < 0) {
            n = this.codeCount - 1;
        }
        this.setCurrent(n);
    }

    public void nextCode() {
        this.setCurrent((this.currentIndex + 1) % this.codeCount);
    }

    public Sketch(Editor editor, String string) throws IOException {
        this.editor = editor;
        File file = new File(string);
        this.mainFilename = file.getName();
        if (this.mainFilename.endsWith(".pde")) {
            this.name = this.mainFilename.substring(0, this.mainFilename.length() - 4);
        } else if (this.mainFilename.endsWith(".c")) {
            this.name = this.mainFilename.substring(0, this.mainFilename.length() - 2);
        } else if (this.mainFilename.endsWith(".h")) {
            this.name = this.mainFilename.substring(0, this.mainFilename.length() - 2);
        } else if (this.mainFilename.endsWith(".cpp")) {
            this.name = this.mainFilename.substring(0, this.mainFilename.length() - 4);
        }
        tempBuildFolder = Base.getBuildFolder();
        this.folder = new File(new File(string).getParent());
        this.load();
    }

    static {
        flavorExtensionsReal = new String[]{".pde", ".cpp", ".c", ".h"};
        flavorExtensionsShown = new String[]{"", ".cpp", ".c", ".h"};
    }
}

