/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import processing.app.Base;
import processing.app.LibraryManager;
import processing.app.MessageConsumer;
import processing.app.MessageSiphon;
import processing.app.Preferences;
import processing.app.RunnerException;
import processing.app.syntax.PdeKeywords;
import processing.core.PApplet;

public class Library
implements MessageConsumer {
    static final String BUGS_URL = "https://developer.berlios.de/bugs/?group_id=3590";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to https://developer.berlios.de/bugs/?group_id=3590";
    private File libFolder;
    private File utilityFolder;
    private LibraryManager libManager;
    RunnerException exception;

    public File getFolder() {
        return this.libFolder;
    }

    public String getName() {
        return this.libFolder.getName();
    }

    public boolean isBuilt() {
        return this.getObjectFiles().length >= this.getCSourceFiles().length + this.getCPPSourceFiles().length + this.getSSourceFiles().length;
    }

    public boolean isBuildable() {
        return this.getCSourceFiles().length + this.getCPPSourceFiles().length + this.getSSourceFiles().length > 0;
    }

    public boolean isUnbuiltBuildable() {
        return this.isBuildable() && !this.isBuilt();
    }

    private final File getUtilityFolder() {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.isDirectory() && file.getName().equalsIgnoreCase("utility");
            }
        };
        File[] fileArray = this.libFolder.listFiles(fileFilter);
        if (fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    private final File getExamplesFolder() {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.isDirectory() && file.getName().equalsIgnoreCase("examples");
            }
        };
        File[] fileArray = this.libFolder.listFiles(fileFilter);
        if (fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    private final void populateWithExamples(File file, JMenu jMenu, ActionListener actionListener) {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        int n = 0;
        while (n < fileArray.length) {
            File file2 = new File(fileArray[n], fileArray[n].getName() + ".pde");
            if (file2.exists()) {
                JMenuItem jMenuItem = new JMenuItem(fileArray[n].getName());
                jMenuItem.setActionCommand(file2.getAbsolutePath());
                jMenuItem.addActionListener(actionListener);
                jMenu.add(jMenuItem);
            } else {
                JMenu jMenu2 = new JMenu(fileArray[n].getName());
                this.populateWithExamples(fileArray[n], jMenu2, actionListener);
                jMenu.add(jMenu2);
            }
            ++n;
        }
    }

    public JMenu getExamplesMenu(ActionListener actionListener) {
        File file = this.getExamplesFolder();
        if (file != null) {
            JMenu jMenu = new JMenu("Library-" + this.getName());
            this.populateWithExamples(file, jMenu, actionListener);
            return jMenu;
        }
        return null;
    }

    private final File[] getObjectFiles(File file) {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.getName().endsWith(".o");
            }
        };
        return file.listFiles(fileFilter);
    }

    public File[] getObjectFiles() {
        if (this.utilityFolder == null) {
            return this.getObjectFiles(this.libFolder);
        }
        File[] fileArray = this.getObjectFiles(this.libFolder);
        File[] fileArray2 = this.getObjectFiles(this.utilityFolder);
        File[] fileArray3 = new File[fileArray.length + fileArray2.length];
        System.arraycopy(fileArray, 0, fileArray3, 0, fileArray.length);
        System.arraycopy(fileArray2, 0, fileArray3, fileArray.length, fileArray2.length);
        return fileArray3;
    }

    public File[] getHeaderFiles() {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.getName().endsWith(".h");
            }
        };
        return this.libFolder.listFiles(fileFilter);
    }

    private final File[] getCSourceFiles(File file) {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.getName().endsWith(".c");
            }
        };
        return file.listFiles(fileFilter);
    }

    private final File[] getCSourceFiles() {
        if (this.utilityFolder == null) {
            return this.getCSourceFiles(this.libFolder);
        }
        File[] fileArray = this.getCSourceFiles(this.libFolder);
        File[] fileArray2 = this.getCSourceFiles(this.utilityFolder);
        File[] fileArray3 = new File[fileArray.length + fileArray2.length];
        System.arraycopy(fileArray, 0, fileArray3, 0, fileArray.length);
        System.arraycopy(fileArray2, 0, fileArray3, fileArray.length, fileArray2.length);
        return fileArray3;
    }

    private final File[] getSSourceFiles(File file) {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.getName().endsWith(".S");
            }
        };
        return file.listFiles(fileFilter);
    }

    private final File[] getSSourceFiles() {
        if (this.utilityFolder == null) {
            return this.getSSourceFiles(this.libFolder);
        }
        File[] fileArray = this.getSSourceFiles(this.libFolder);
        File[] fileArray2 = this.getSSourceFiles(this.utilityFolder);
        File[] fileArray3 = new File[fileArray.length + fileArray2.length];
        System.arraycopy(fileArray, 0, fileArray3, 0, fileArray.length);
        System.arraycopy(fileArray2, 0, fileArray3, fileArray.length, fileArray2.length);
        return fileArray3;
    }

    private final File[] getCPPSourceFiles(File file) {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.getName().endsWith(".cpp");
            }
        };
        return file.listFiles(fileFilter);
    }

    private final File[] getCPPSourceFiles() {
        if (this.utilityFolder == null) {
            return this.getCPPSourceFiles(this.libFolder);
        }
        File[] fileArray = this.getCPPSourceFiles(this.libFolder);
        File[] fileArray2 = this.getCPPSourceFiles(this.utilityFolder);
        File[] fileArray3 = new File[fileArray.length + fileArray2.length];
        System.arraycopy(fileArray, 0, fileArray3, 0, fileArray.length);
        System.arraycopy(fileArray2, 0, fileArray3, fileArray.length, fileArray2.length);
        return fileArray3;
    }

    public boolean build() throws RunnerException {
        if (!this.isBuildable()) {
            return false;
        }
        String string = System.getProperty("user.dir") + File.separator;
        String string2 = Base.isMacOS() ? new String("hardware/tools/avr/bin/") : (Base.isLinux() ? new String("") : new String(string + "hardware/tools/avr/bin/"));
        String[] stringArray = new String[]{string2 + "avr-gcc", "-c", "-g", "-Os", "-Wall", "-ffunction-sections", "-fdata-sections", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu"), "-I" + this.libManager.getTarget().getPath(), "-I" + this.getFolder()};
        String[] stringArray2 = new String[]{string2 + "avr-g++", "-c", "-g", "-Os", "-Wall", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu"), "-I" + this.libManager.getTarget().getPath(), "-I" + this.getFolder()};
        String[] stringArray3 = new String[]{string2 + "avr-gcc", "-c", "-g", "-x", "assembler-with-cpp", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu")};
        int n = 2;
        this.utilityFolder = this.getUtilityFolder();
        if (this.utilityFolder != null) {
            n = 3;
        }
        String[] stringArray4 = this.libManager.getFolderPaths();
        String[] stringArray5 = new String[stringArray.length + stringArray4.length + n];
        String[] stringArray6 = new String[stringArray2.length + stringArray4.length + n];
        String[] stringArray7 = new String[stringArray3.length + stringArray4.length + n];
        System.arraycopy(stringArray, 0, stringArray5, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray6, 0, stringArray2.length);
        System.arraycopy(stringArray3, 0, stringArray7, 0, stringArray3.length);
        int n2 = 0;
        while (n2 < stringArray4.length) {
            stringArray5[stringArray.length + n2] = "-I" + stringArray4[n2];
            stringArray6[stringArray2.length + n2] = "-I" + stringArray4[n2];
            stringArray7[stringArray3.length + n2] = "-I" + stringArray4[n2];
            ++n2;
        }
        if (this.utilityFolder != null) {
            stringArray5[stringArray5.length - 3] = "-I" + this.utilityFolder.getPath();
            stringArray6[stringArray6.length - 3] = "-I" + this.utilityFolder.getPath();
            stringArray7[stringArray7.length - 3] = "-I" + this.utilityFolder.getPath();
        }
        File[] fileArray = this.getCSourceFiles();
        File[] fileArray2 = this.getCPPSourceFiles();
        File[] fileArray3 = this.getSSourceFiles();
        int n3 = 0;
        try {
            Process process;
            String string3;
            boolean bl = true;
            int n4 = 0;
            while (n4 < fileArray.length) {
                string3 = fileArray[n4].getPath();
                string3 = string3.substring(0, string3.length() - 2);
                stringArray5[stringArray5.length - 2] = fileArray[n4].getPath();
                stringArray5[stringArray5.length - 1] = "-o" + string3 + ".o";
                process = Runtime.getRuntime().exec(stringArray5);
                new MessageSiphon(process.getInputStream(), this);
                new MessageSiphon(process.getErrorStream(), this);
                bl = true;
                while (bl) {
                    try {
                        n3 = process.waitFor();
                        bl = false;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.exception != null) {
                    this.exception.hideStackTrace = true;
                    throw this.exception;
                }
                if (n3 != 0) {
                    return false;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < fileArray2.length) {
                string3 = fileArray2[n4].getPath();
                string3 = string3.substring(0, string3.length() - 4);
                stringArray6[stringArray6.length - 2] = fileArray2[n4].getPath();
                stringArray6[stringArray6.length - 1] = "-o" + string3 + ".o";
                process = Runtime.getRuntime().exec(stringArray6);
                new MessageSiphon(process.getInputStream(), this);
                new MessageSiphon(process.getErrorStream(), this);
                bl = true;
                while (bl) {
                    try {
                        n3 = process.waitFor();
                        bl = false;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.exception != null) {
                    this.exception.hideStackTrace = true;
                    throw this.exception;
                }
                if (n3 != 0) {
                    return false;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < fileArray3.length) {
                string3 = fileArray3[n4].getPath();
                string3 = string3.substring(0, string3.length() - 2);
                stringArray5[stringArray7.length - 2] = fileArray[n4].getPath();
                stringArray5[stringArray7.length - 1] = "-o" + string3 + ".o";
                process = Runtime.getRuntime().exec(stringArray7);
                new MessageSiphon(process.getInputStream(), this);
                new MessageSiphon(process.getErrorStream(), this);
                bl = true;
                while (bl) {
                    try {
                        n3 = process.waitFor();
                        bl = false;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.exception != null) {
                    this.exception.hideStackTrace = true;
                    throw this.exception;
                }
                if (n3 != 0) {
                    return false;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            String string4 = exception.getMessage();
            if (string4 != null && string4.indexOf("avr-gcc: not found") != -1) {
                Base.showWarning("Compiler error", "Could not find the compiler.\navr-gcc is missing from your PATH,\nsee readme.txt for help.", null);
                return false;
            }
            if (string4 != null && string4.indexOf("avr-g++: not found") != -1) {
                Base.showWarning("Compiler error", "Could not find the compiler.\navr-g++ is missing from your PATH,\nsee readme.txt for help.", null);
                return false;
            }
            exception.printStackTrace();
            n3 = -1;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (n3 != 0 && n3 != 1) {
            Base.openURL(BUGS_URL);
            throw new RunnerException(SUPER_BADNESS);
        }
        boolean bl = false;
        if (n3 == 0) {
            bl = true;
        }
        return bl;
    }

    public void message(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        String string3 = this.libFolder.getPath() + File.separator;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string3, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            n = n2 + string3.length();
        }
        stringBuffer.append(string.substring(n));
        string2 = stringBuffer.toString();
        System.err.print(string2);
        if (string.indexOf("error") != -1) {
            this.exception = new RunnerException("Error building library \"" + this.getName() + '\"');
        }
    }

    public void addSyntaxColors(PdeKeywords pdeKeywords) {
        File file = new File(this.libFolder.getPath() + File.separator + "keywords.txt");
        if (!file.exists() || !file.canRead()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string.trim().length() == 0 || string.indexOf(9) == -1 || (stringArray = PApplet.split(string, '\t')).length < 2) continue;
                String string2 = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                if (string3.length() <= 0) continue;
                boolean bl = false;
                if (string3.charAt(0) == 'K') {
                    bl = true;
                }
                boolean bl2 = bl;
                int n = string3.charAt(string3.length() - 1) - 49;
                byte by = (byte)((bl2 ? 6 : 3) + n);
                PdeKeywords.getKeywordColoring().add(string2, by);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Base.showError("Problem Loading Keywords", "Could not load or interpret 'keywords.txt' in " + this.getName() + " library.\nThis must be corrected before distributing.", exception);
        }
    }

    public Library(LibraryManager libraryManager, File file) {
        this.libFolder = file;
        this.libManager = libraryManager;
        this.utilityFolder = this.getUtilityFolder();
    }
}

