/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.SerialException;

public class EditorStatus
extends JPanel
implements ActionListener {
    static Color[] bgcolor;
    static Color[] fgcolor;
    static final int NOTICE = 0;
    static final int ERR = 1;
    static final int PROMPT = 2;
    static final int EDIT = 3;
    static final int SERIAL = 4;
    static final int YES = 1;
    static final int NO = 2;
    static final int CANCEL = 3;
    static final int OK = 4;
    static final int SEND = 5;
    static final String NO_MESSAGE = "";
    Editor editor;
    int mode;
    String message;
    Font font;
    FontMetrics metrics;
    int ascent;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    JButton yesButton;
    JButton noButton;
    JButton cancelButton;
    JButton okButton;
    JButton sendButton;
    JTextField editField;
    JTextField serialField;
    JComboBox serialRates;
    int response;

    public void empty() {
        this.mode = 0;
        this.message = NO_MESSAGE;
        this.repaint();
    }

    public void notice(String string) {
        this.mode = 0;
        this.message = string;
        this.repaint();
    }

    public void unnotice(String string) {
        if (this.message.equals(string)) {
            this.empty();
        }
    }

    public void error(String string) {
        this.mode = 1;
        this.message = string;
        this.repaint();
    }

    public void prompt(String string) {
        this.mode = 2;
        this.message = string;
        this.response = 0;
        this.yesButton.setVisible(true);
        this.noButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.yesButton.requestFocus();
        this.repaint();
    }

    public void unprompt() {
        this.yesButton.setVisible(false);
        this.noButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.empty();
    }

    public void edit(String string, String string2) {
        this.mode = 3;
        this.message = string;
        this.response = 0;
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.editField.setVisible(true);
        this.editField.setText(string2);
        this.editField.selectAll();
        this.editField.requestFocus();
        this.repaint();
    }

    public void unedit() {
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.editField.setVisible(false);
        this.empty();
    }

    public void serial() {
        this.mode = 4;
        this.message = NO_MESSAGE;
        this.sendButton.setVisible(true);
        this.serialRates.setVisible(true);
        this.serialField.setVisible(true);
        this.serialField.setText(NO_MESSAGE);
        this.serialField.requestFocus();
        this.repaint();
    }

    public void unserial() {
        this.sendButton.setVisible(false);
        this.serialField.setVisible(false);
        this.serialRates.setVisible(false);
        this.empty();
    }

    public void paintComponent(Graphics graphics) {
        if (this.yesButton == null) {
            this.setup();
        }
        Dimension dimension = this.getSize();
        if (dimension.width != this.sizeW || dimension.height != this.sizeH) {
            if (dimension.width > this.imageW || dimension.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = dimension.width;
                this.sizeH = dimension.height;
                this.setButtonBounds();
            }
        }
        if (this.offscreen == null) {
            this.sizeW = dimension.width;
            this.sizeH = dimension.height;
            this.setButtonBounds();
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        if (this.font == null) {
            this.font = Preferences.getFont("status.font");
            graphics2.setFont(this.font);
            this.metrics = graphics2.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        graphics2.setColor(bgcolor[this.mode]);
        graphics2.fillRect(0, 0, this.imageW, this.imageH);
        graphics2.setColor(fgcolor[this.mode]);
        graphics2.setFont(this.font);
        graphics2.drawString(this.message, 6, (this.sizeH + this.ascent) / 2);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    protected void setup() {
        if (this.yesButton == null) {
            this.yesButton = new JButton("Yes");
            this.noButton = new JButton("No");
            this.cancelButton = new JButton("Cancel");
            this.okButton = new JButton("OK");
            this.sendButton = new JButton("Send");
            if (Base.isMacOS()) {
                this.yesButton.setBackground(bgcolor[2]);
                this.noButton.setBackground(bgcolor[2]);
                this.cancelButton.setBackground(bgcolor[2]);
                this.okButton.setBackground(bgcolor[2]);
                this.sendButton.setBackground(bgcolor[4]);
            }
            this.setLayout(null);
            this.yesButton.addActionListener(this);
            this.noButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.okButton.addActionListener(this);
            this.sendButton.addActionListener(this);
            this.add(this.yesButton);
            this.add(this.noButton);
            this.add(this.cancelButton);
            this.add(this.okButton);
            this.add(this.sendButton);
            this.yesButton.setVisible(false);
            this.noButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.okButton.setVisible(false);
            this.sendButton.setVisible(false);
            this.editField = new JTextField();
            this.editField.addActionListener(this);
            this.editField.addKeyListener(new KeyAdapter(){

                public final void keyTyped(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (EditorStatus.this.mode == 3) {
                        if (c == '\n') {
                            String string = EditorStatus.this.editField.getText();
                            EditorStatus.this.editor.sketch.nameCode(string);
                            EditorStatus.this.unedit();
                            keyEvent.consume();
                        } else if (c != '\b' && c != '\u007f' && c != '\'' && c != '%' && c != '&' && c != '(' && c != '$' && c != '#' && c != '\u0010') {
                            if (c == '\u001b') {
                                EditorStatus.this.unedit();
                                EditorStatus.this.editor.buttons.clear();
                                keyEvent.consume();
                            } else if (c == ' ') {
                                String string = EditorStatus.this.editField.getText();
                                int n = EditorStatus.this.editField.getSelectionStart();
                                int n2 = EditorStatus.this.editField.getSelectionEnd();
                                EditorStatus.this.editField.setText(string.substring(0, n) + '_' + string.substring(n2));
                                EditorStatus.this.editField.setCaretPosition(n + 1);
                                keyEvent.consume();
                            } else if (!(c == '_' || c == '.' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                                if (c >= '0' && c <= '9') {
                                    if (EditorStatus.this.editField.getCaretPosition() == 0 || EditorStatus.this.editField.getSelectionStart() == 0) {
                                        keyEvent.consume();
                                    }
                                } else {
                                    keyEvent.consume();
                                }
                            }
                        }
                    }
                }
            });
            this.add(this.editField);
            this.editField.setVisible(false);
            this.serialField = new JTextField();
            this.serialField.addActionListener(this);
            this.serialField.addKeyListener(new KeyAdapter(){

                public final void keyTyped(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (c == '\n') {
                        EditorStatus.this.editor.serialPort.write(EditorStatus.this.serialField.getText());
                        keyEvent.consume();
                        EditorStatus.this.serialField.setText(EditorStatus.NO_MESSAGE);
                    }
                }
            });
            this.add(this.serialField);
            this.serialField.setVisible(false);
            String[] stringArray = new String[]{"300", "1200", "2400", "4800", "9600", "14400", "19200", "28800", "38400", "57600", "115200"};
            this.serialRates = new JComboBox();
            if (Base.isMacOS()) {
                this.serialRates.setBackground(bgcolor[4]);
            }
            int n = 0;
            while (n < stringArray.length) {
                this.serialRates.addItem(stringArray[n] + " baud");
                ++n;
            }
            this.serialRates.setSelectedItem(Preferences.get("serial.debug_rate") + " baud");
            this.serialRates.addActionListener(this);
            this.add(this.serialRates);
            this.serialRates.setVisible(false);
        }
    }

    protected void setButtonBounds() {
        int n = (this.sizeH - Preferences.BUTTON_HEIGHT) / 2;
        int n2 = 6 + Preferences.BUTTON_WIDTH;
        int n3 = this.sizeW - n2;
        int n4 = n3 - n2;
        int n5 = n4 - n2;
        this.yesButton.setLocation(n5, n);
        this.noButton.setLocation(n4, n);
        this.cancelButton.setLocation(n3, n);
        this.editField.setLocation(n5 - Preferences.BUTTON_WIDTH, n);
        this.serialField.setLocation(n5 - Preferences.BUTTON_WIDTH, n);
        this.okButton.setLocation(n4, n);
        this.serialRates.setLocation(0, n);
        this.sendButton.setLocation(n3, n);
        this.yesButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.noButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.cancelButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.okButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.sendButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.serialRates.setSize(3 * Preferences.BUTTON_WIDTH / 2, Preferences.BUTTON_HEIGHT);
        this.editField.setSize(2 * Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.serialField.setSize(3 * Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(300, 33);
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, 33);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.noButton) {
            this.unprompt();
            this.editor.checkModified2();
        } else if (actionEvent.getSource() == this.yesButton) {
            this.unprompt();
            this.editor.handleSave(true);
            this.editor.checkModified2();
        } else if (actionEvent.getSource() == this.cancelButton) {
            if (this.mode == 2) {
                this.unprompt();
            } else if (this.mode == 3) {
                this.unedit();
            }
            this.editor.buttons.clear();
        } else if (actionEvent.getSource() == this.okButton) {
            String string = this.editField.getText();
            this.editor.sketch.nameCode(string);
            this.unedit();
        } else if (actionEvent.getSource() == this.sendButton) {
            this.editor.serialPort.write(this.serialField.getText());
            this.serialField.setText(NO_MESSAGE);
        } else if (actionEvent.getSource() == this.serialRates) {
            String string = (String)this.serialRates.getSelectedItem();
            String string2 = string.substring(0, string.indexOf(32));
            int n = Integer.parseInt(string2);
            Preferences.set("serial.debug_rate", string2);
            this.editor.serialPort.dispose();
            try {
                this.editor.serialPort = new Serial(true);
            }
            catch (SerialException serialException) {
                this.editor.error(serialException);
            }
        }
    }

    public EditorStatus(Editor editor) {
        this.editor = editor;
        this.empty();
        if (bgcolor == null) {
            bgcolor = new Color[5];
            EditorStatus.bgcolor[0] = new Color(84, 145, 158);
            EditorStatus.bgcolor[1] = Preferences.getColor("status.error.bgcolor");
            EditorStatus.bgcolor[2] = Preferences.getColor("status.prompt.bgcolor");
            EditorStatus.bgcolor[3] = Preferences.getColor("status.prompt.bgcolor");
            EditorStatus.bgcolor[4] = new Color(84, 145, 158);
            fgcolor = new Color[5];
            EditorStatus.fgcolor[0] = Preferences.getColor("status.notice.fgcolor");
            EditorStatus.fgcolor[1] = Preferences.getColor("status.error.fgcolor");
            EditorStatus.fgcolor[2] = Preferences.getColor("status.prompt.fgcolor");
            EditorStatus.fgcolor[3] = Preferences.getColor("status.prompt.fgcolor");
            EditorStatus.fgcolor[4] = Preferences.getColor("status.notice.fgcolor");
        }
    }
}

