/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.syntax.JEditTextArea;

public class EditorListener {
    static final int CTRL_ALT = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    Editor editor;
    JEditTextArea textarea;
    boolean externalEditor;
    boolean tabsExpand;
    boolean tabsIndent;
    int tabSize;
    String tabString;
    boolean autoIndent;
    int selectionStart;
    int selectionEnd;
    int position;

    public void applyPreferences() {
        this.tabsExpand = Preferences.getBoolean("editor.tabs.expand");
        this.tabSize = Preferences.getInteger("editor.tabs.size");
        this.tabString = "                                                                                                                                                                                                               ".substring(0, this.tabSize);
        this.autoIndent = Preferences.getBoolean("editor.indent");
        this.externalEditor = Preferences.getBoolean("editor.external");
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.externalEditor) {
            return false;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if ((keyEvent.getModifiers() & CTRL_ALT) == CTRL_ALT) {
            if (n == 37) {
                this.editor.sketch.prevCode();
                return true;
            }
            if (n == 39) {
                this.editor.sketch.nextCode();
                return true;
            }
        }
        if ((keyEvent.getModifiers() & 4) != 0) {
            return false;
        }
        if (!this.editor.sketch.modified && (n == 8 || n == 9 || n == 10 || c >= ' ' && c < '\u0080')) {
            this.editor.sketch.setModified(true);
        }
        if (n == 38 && (keyEvent.getModifiers() & 2) != 0) {
            char[] cArray = this.textarea.getText().toCharArray();
            int n2 = this.textarea.getCaretPosition();
            int n3 = this.calcLineStart(n2 - 1, cArray);
            n3 -= 2;
            boolean bl = true;
            while (n3 > 0) {
                if (cArray[n3] == '\n') {
                    if (bl) {
                        ++n3;
                        break;
                    }
                    bl = true;
                } else if (cArray[n3] != ' ') {
                    bl = false;
                }
                --n3;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if ((keyEvent.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(n2);
                this.textarea.setSelectionEnd(n3);
            } else {
                this.textarea.setCaretPosition(n3);
            }
            keyEvent.consume();
            return true;
        }
        if (n == 40 && (keyEvent.getModifiers() & 2) != 0) {
            int n4;
            char[] cArray = this.textarea.getText().toCharArray();
            int n5 = n4 = this.textarea.getCaretPosition();
            int n6 = 0;
            boolean bl = false;
            while (n5 < cArray.length) {
                if (cArray[n5] == '\n') {
                    if (bl) {
                        n5 = n6;
                        break;
                    }
                    n6 = n5 + 1;
                    bl = true;
                } else if (cArray[n5] != ' ') {
                    bl = false;
                }
                ++n5;
            }
            if ((keyEvent.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(n4);
                this.textarea.setSelectionEnd(n5);
            } else {
                this.textarea.setCaretPosition(n5);
            }
            keyEvent.consume();
            return true;
        }
        switch (c) {
            case '\t': {
                int n7;
                if (this.tabsExpand) {
                    this.textarea.setSelectedText(this.tabString);
                    keyEvent.consume();
                    return true;
                }
                if (!this.tabsIndent) break;
                char[] cArray = this.textarea.getText().toCharArray();
                int n8 = this.textarea.getCaretPosition() - 1;
                int n9 = n7 = this.calcLineStart(n8, cArray);
                while (n9 < cArray.length - 1 && cArray[n9] != '\n') {
                    ++n9;
                }
                int n10 = 0;
                int n11 = n7;
                while (n11 < cArray.length && cArray[n11] != '\n') {
                    if (cArray[n11] == '{') {
                        ++n10;
                    } else if (cArray[n11] == '}') {
                        --n10;
                    }
                    ++n11;
                }
                int n12 = n10 > 0 ? n7 : n9;
                int n13 = this.calcBraceIndent(n12, cArray);
                n13 = n13 == -1 ? 0 : (n13 += this.tabSize);
                int n14 = this.calcSpaceCount(n8, cArray);
                this.textarea.setSelectionStart(n7);
                this.textarea.setSelectionEnd(n7 + n14);
                this.textarea.setSelectedText("                                                                                                                                                                                                               ".substring(0, n13));
                keyEvent.consume();
                return true;
            }
            case '\n': 
            case '\r': {
                int n15;
                if (!this.autoIndent) break;
                char[] cArray = this.textarea.getText().toCharArray();
                int n16 = this.textarea.getCaretPosition() - 1;
                int n17 = this.calcSpaceCount(n16, cArray);
                int n18 = n16;
                while (n18 >= 0 && Character.isWhitespace(cArray[n18])) {
                    --n18;
                }
                if (n18 != -1 && cArray[n18] == '{') {
                    n17 = this.calcSpaceCount(n18, cArray);
                    n17 += this.tabSize;
                }
                int n19 = n16 + 1;
                int n20 = 0;
                while (n19 < cArray.length && cArray[n19] == ' ') {
                    ++n20;
                    ++n19;
                }
                int n21 = 0;
                while (n19 < cArray.length && cArray[n19] != '\n') {
                    if (cArray[n19] == '}') {
                        ++n21;
                    }
                    ++n19;
                }
                if ((n17 -= n20) < 0) {
                    this.textarea.setSelectionEnd(this.textarea.getSelectionEnd() - n17);
                    this.textarea.setSelectedText("\n");
                } else {
                    String string = "\n" + "                                                                                                                                                                                                               ".substring(0, n17);
                    this.textarea.setSelectedText(string);
                }
                if (n21 > 0 && (n15 = this.textarea.getSelectionStart()) - this.tabSize >= 0) {
                    this.textarea.select(n15 - this.tabSize, n15);
                    String string = "                                                                                                                                                                                                               ".substring(0, this.tabSize);
                    if (this.textarea.getSelectedText().equals(string)) {
                        this.textarea.setSelectedText("");
                    } else {
                        this.textarea.select(n15, n15);
                    }
                }
                keyEvent.consume();
                return true;
            }
            case '}': {
                int n22;
                if (!this.autoIndent) break;
                if (this.textarea.getSelectionStart() != this.textarea.getSelectionEnd()) {
                    this.textarea.setSelectedText("");
                }
                char[] cArray = this.textarea.getText().toCharArray();
                int n23 = n22 = this.textarea.getCaretPosition() - 1;
                boolean bl = false;
                while (n23 != -1 && !bl) {
                    if (cArray[n23] == '\n') {
                        bl = true;
                        ++n23;
                        continue;
                    }
                    if (cArray[n23] != ' ') {
                        return false;
                    }
                    --n23;
                }
                if (!bl) {
                    return false;
                }
                int n24 = n23;
                int n25 = this.calcBraceIndent(n22, cArray);
                if (n25 == -1) {
                    return false;
                }
                this.textarea.setSelectionStart(n24);
                this.textarea.setSelectedText("                                                                                                                                                                                                               ".substring(0, n25));
                keyEvent.consume();
                return true;
            }
        }
        return false;
    }

    protected int calcLineStart(int n, char[] cArray) {
        boolean bl = false;
        boolean bl2 = false;
        while (n != -1 && !bl2) {
            if (cArray[n] == '\n' || cArray[n] == '\r') {
                bl2 = true;
                continue;
            }
            --n;
        }
        return n + 1;
    }

    protected int calcSpaceCount(int n, char[] cArray) {
        n = this.calcLineStart(n, cArray);
        int n2 = 0;
        while (n < cArray.length && n >= 0 && cArray[n++] == ' ') {
            ++n2;
        }
        return n2;
    }

    protected int calcBraceIndent(int n, char[] cArray) {
        int n2 = 1;
        boolean bl = false;
        while (n != -1 && !bl) {
            if (cArray[n] == '}') {
                ++n2;
                --n;
                continue;
            }
            if (cArray[n] == '{') {
                if (--n2 == 0) {
                    bl = true;
                }
                --n;
                continue;
            }
            --n;
        }
        if (!bl) {
            return -1;
        }
        return this.calcSpaceCount(n, cArray);
    }

    protected char[] getCleanedContents() {
        char[] cArray = this.textarea.getText().toCharArray();
        int n = 0;
        while (n < cArray.length - 1) {
            if (cArray[n] == '/' && cArray[n + 1] == '*') {
                cArray[n++] = '\u0000';
                cArray[n++] = '\u0000';
                while (n < cArray.length - 1 && (cArray[n] != '*' || cArray[n + 1] != '/')) {
                    cArray[n++] = '\u0000';
                }
                continue;
            }
            if (cArray[n] != '/' || cArray[n + 1] != '/') continue;
            while (n < cArray.length && cArray[n] != '\n') {
                cArray[n++] = '\u0000';
            }
            if (n == cArray.length) continue;
            ++n;
        }
        return cArray;
    }

    public EditorListener(Editor editor, JEditTextArea jEditTextArea) {
        this.editor = editor;
        this.textarea = jEditTextArea;
        jEditTextArea.editorListener = this;
        this.applyPreferences();
    }
}

