/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;

public class EditorHeader
extends JComponent {
    static Color backgroundColor;
    static Color[] textColor;
    static final String[] STATUS;
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    static final String[] WHERE;
    static final int LEFT = 0;
    static final int MIDDLE = 1;
    static final int RIGHT = 2;
    static final int MENU = 3;
    static final int PIECE_WIDTH = 4;
    Editor editor;
    int[] tabLeft;
    int[] tabRight;
    Font font;
    FontMetrics metrics;
    int fontAscent;
    JMenu menu;
    JPopupMenu popup;
    JMenuItem hideItem;
    int menuLeft;
    int menuRight;
    Image[][] pieces;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Sketch sketch = this.editor.sketch;
        if (sketch == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.width != this.sizeW || dimension.height != this.sizeH) {
            if (dimension.width > this.imageW || dimension.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = dimension.width;
                this.sizeH = dimension.height;
            }
        }
        if (this.offscreen == null) {
            this.sizeW = dimension.width;
            this.sizeH = dimension.height;
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        if (this.font == null) {
            this.font = Preferences.getFont("header.text.font");
        }
        graphics2.setFont(this.font);
        this.metrics = graphics2.getFontMetrics();
        this.fontAscent = this.metrics.getAscent();
        graphics2.setColor(backgroundColor);
        graphics2.fillRect(0, 0, this.imageW, this.imageH);
        if (this.tabLeft == null || this.tabLeft.length < sketch.codeCount) {
            this.tabLeft = new int[sketch.codeCount];
            this.tabRight = new int[sketch.codeCount];
        }
        boolean bl = false;
        if (sketch.current != sketch.code[0]) {
            bl = true;
        }
        this.hideItem.setEnabled(bl);
        int n = 6;
        int n2 = 0;
        while (n2 < sketch.codeCount) {
            SketchCode sketchCode = sketch.code[n2];
            String string = sketchCode.flavor == 0 ? sketchCode.name : sketchCode.file.getName();
            String string2 = "  " + string + (sketchCode.modified ? " \u00a7" : "  ");
            Graphics2D graphics2D = (Graphics2D)graphics2;
            int n3 = (int)this.font.getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth();
            int n4 = 2 + n3 / 4;
            int n5 = n4 * 4;
            int n6 = 0;
            if (sketchCode == sketch.current) {
                n6 = 1;
            }
            int n7 = n6;
            graphics2.drawImage(this.pieces[n7][0], n, 0, null);
            int n8 = n += 4;
            this.tabLeft[n2] = n;
            int n9 = 0;
            while (n9 < n4) {
                graphics2.drawImage(this.pieces[n7][1], n, 0, null);
                n += 4;
                ++n9;
            }
            this.tabRight[n2] = n;
            n9 = n8 + (n5 - n3) / 2;
            graphics2.setColor(textColor[n7]);
            int n10 = (this.sizeH + this.fontAscent) / 2;
            graphics2.drawString(string2, n9, n10);
            graphics2.drawImage(this.pieces[n7][2], n, 0, null);
            n += 3;
            ++n2;
        }
        this.menuLeft = this.sizeW - (16 + this.pieces[0][3].getWidth(this));
        this.menuRight = this.sizeW - 16;
        graphics2.drawImage(this.pieces[this.popup.isVisible()][3], this.menuLeft, 0, null);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void rebuild() {
        this.rebuildMenu();
        this.repaint();
    }

    public void rebuildMenu() {
        int n;
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu();
            this.popup = this.menu.getPopupMenu();
            this.add(this.popup);
            this.popup.setLightWeightPopupEnabled(true);
        }
        JMenuItem jMenuItem = new JMenuItem("New Tab");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                EditorHeader.this.editor.sketch.newCode();
            }
        });
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                EditorHeader.this.editor.sketch.renameCode();
                if (EditorHeader.this.editor.sketch.current == EditorHeader.this.editor.sketch.code[0]) {
                    EditorHeader.this.editor.sketchbook.rebuildMenus();
                }
            }
        });
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                EditorHeader.this.editor.sketch.deleteCode();
            }
        });
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Hide");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                EditorHeader.this.editor.sketch.hideCode();
            }
        });
        this.menu.add(jMenuItem);
        this.hideItem = jMenuItem;
        JMenu jMenu = new JMenu("Unhide");
        ActionListener actionListener = new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                EditorHeader.this.editor.sketch.unhideCode(string);
                EditorHeader.this.rebuildMenu();
            }
        };
        Sketch sketch = this.editor.sketch;
        if (sketch != null) {
            n = 0;
            while (n < sketch.hiddenCount) {
                jMenuItem = new JMenuItem(sketch.hidden[n].name + Sketch.flavorExtensionsShown[sketch.hidden[n].flavor]);
                jMenuItem.setActionCommand(sketch.hidden[n].name + Sketch.flavorExtensionsShown[sketch.hidden[n].flavor]);
                jMenuItem.addActionListener(actionListener);
                jMenu.add(jMenuItem);
                ++n;
            }
        }
        if (jMenu.getItemCount() == 0) {
            jMenu.setEnabled(false);
        }
        this.menu.add(jMenu);
        this.menu.addSeparator();
        n = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        jMenuItem = new JMenuItem("Previous Tab");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(37, n);
        jMenuItem.setAccelerator(keyStroke);
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Next Tab");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(39, n);
        jMenuItem.setAccelerator(keyStroke2);
        this.menu.add(jMenuItem);
        if (sketch != null) {
            this.menu.addSeparator();
            ActionListener actionListener2 = new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    EditorHeader.this.editor.sketch.setCurrent(actionEvent.getActionCommand());
                }
            };
            int n2 = 0;
            while (n2 < sketch.codeCount) {
                jMenuItem = new JMenuItem(sketch.code[n2].name + Sketch.flavorExtensionsShown[sketch.code[n2].flavor]);
                jMenuItem.addActionListener(actionListener2);
                this.menu.add(jMenuItem);
                ++n2;
            }
        }
    }

    public void deselectMenu() {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (Base.isMacOS()) {
            return new Dimension(300, 33);
        }
        return new Dimension(300, 32);
    }

    public Dimension getMaximumSize() {
        if (Base.isMacOS()) {
            return new Dimension(3000, 33);
        }
        return new Dimension(3000, 32);
    }

    public EditorHeader(Editor editor) {
        this.editor = editor;
        this.pieces = new Image[STATUS.length][WHERE.length];
        int n = 0;
        while (n < STATUS.length) {
            int n2 = 0;
            while (n2 < WHERE.length) {
                this.pieces[n][n2] = Base.getImage("tab-" + STATUS[n] + '-' + WHERE[n2] + ".gif", this);
                ++n2;
            }
            ++n;
        }
        if (backgroundColor == null) {
            backgroundColor = new Color(33, 104, 134);
            EditorHeader.textColor[1] = Preferences.getColor("header.text.selected.color");
            EditorHeader.textColor[0] = Preferences.getColor("header.text.unselected.color");
        }
        this.addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (n > EditorHeader.this.menuLeft && n < EditorHeader.this.menuRight) {
                    EditorHeader.this.popup.show(EditorHeader.this, n, n2);
                } else {
                    int n3 = 0;
                    while (n3 < EditorHeader.this.editor.sketch.codeCount) {
                        if (n > EditorHeader.this.tabLeft[n3] && n < EditorHeader.this.tabRight[n3]) {
                            EditorHeader.this.editor.sketch.setCurrent(n3);
                            EditorHeader.this.repaint();
                        }
                        ++n3;
                    }
                }
            }
        });
    }

    static {
        textColor = new Color[2];
        STATUS = new String[]{"unsel", "sel"};
        WHERE = new String[]{"left", "mid", "right", "menu"};
    }
}

