/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EditorButtons
extends JComponent
implements MouseInputListener {
    static final String[] title = new String[]{"Verify", "Stop", "New", "Open", "Save", "Upload to I/O Board", "Serial Monitor"};
    static final int BUTTON_COUNT = title.length;
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_HEIGHT = 32;
    static final int BUTTON_GAP = 15;
    static final int RUN = 0;
    static final int STOP = 1;
    static final int NEW = 2;
    static final int OPEN = 3;
    static final int SAVE = 4;
    static final int EXPORT = 5;
    static final int SERIAL = 6;
    static final int INACTIVE = 0;
    static final int ROLLOVER = 1;
    static final int ACTIVE = 2;
    Editor editor;
    Image offscreen;
    int width;
    int height;
    Color bgcolor;
    Image buttons;
    Image[] inactive;
    Image[] rollover;
    Image[] active;
    int currentRollover;
    JPopupMenu popup;
    int buttonCount;
    int[] state;
    Image[] stateImage;
    int[] which;
    int[] x1;
    int[] x2;
    int y1;
    int y2;
    String status;
    Font statusFont;
    Color statusColor;
    int wasDown;

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.inactive == null) {
            this.inactive = new Image[BUTTON_COUNT];
            this.rollover = new Image[BUTTON_COUNT];
            this.active = new Image[BUTTON_COUNT];
            int n2 = 33;
            n = 0;
            while (n < BUTTON_COUNT) {
                this.inactive[n] = this.createImage(27, 32);
                Graphics graphics2 = this.inactive[n].getGraphics();
                graphics2.drawImage(this.buttons, -(n * n2) - 3, -2 * n2, null);
                this.rollover[n] = this.createImage(27, 32);
                graphics2 = this.rollover[n].getGraphics();
                graphics2.drawImage(this.buttons, -(n * n2) - 3, -1 * n2, null);
                this.active[n] = this.createImage(27, 32);
                graphics2 = this.active[n].getGraphics();
                graphics2.drawImage(this.buttons, -(n * n2) - 3, 0, null);
                ++n;
            }
            this.state = new int[this.buttonCount];
            this.stateImage = new Image[this.buttonCount];
            n = 0;
            while (n < this.buttonCount) {
                this.setState(n, 0, false);
                ++n;
            }
        }
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.width || dimension.height != this.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.width = dimension.width;
            this.height = dimension.height;
            this.y1 = 0;
            this.y2 = 32;
            this.x1 = new int[this.buttonCount];
            this.x2 = new int[this.buttonCount];
            n = 3;
            int n3 = 0;
            while (n3 < this.buttonCount) {
                this.x1[n3] = n;
                if (n3 == 2) {
                    int n4 = n3;
                    this.x1[n4] = this.x1[n4] + 15;
                }
                this.x2[n3] = this.x1[n3] + 27;
                n = this.x2[n3];
                ++n3;
            }
        }
        Graphics graphics3 = this.offscreen.getGraphics();
        graphics3.setColor(this.bgcolor);
        graphics3.fillRect(0, 0, this.width, this.height);
        int n5 = 0;
        while (n5 < this.buttonCount) {
            graphics3.drawImage(this.stateImage[n5], this.x1[n5], this.y1, null);
            ++n5;
        }
        graphics3.setColor(this.statusColor);
        graphics3.setFont(this.statusFont);
        n5 = (32 + graphics3.getFontMetrics().getAscent()) / 2;
        graphics3.drawString(this.status, this.buttonCount * 27 + 30, n5);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.state == null) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, false);
        }
        this.handleMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void handleMouse(int n, int n2) {
        int n3;
        if (this.currentRollover != -1) {
            if (n > this.x1[this.currentRollover] && n2 > this.y1 && n < this.x2[this.currentRollover] && n2 < this.y2) {
                return;
            }
            this.setState(this.currentRollover, 0, true);
            this.messageClear(title[this.currentRollover]);
            this.currentRollover = -1;
        }
        if ((n3 = this.findSelection(n, n2)) == -1) {
            return;
        }
        if (this.state[n3] != 2) {
            this.setState(n3, 1, true);
            this.currentRollover = n3;
        }
    }

    private final int findSelection(int n, int n2) {
        if (this.x1 == null || this.x2 == null) {
            return -1;
        }
        int n3 = 0;
        while (n3 < this.buttonCount) {
            if (n2 > this.y1 && n > this.x1[n3] && n2 < this.y2 && n < this.x2[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private final void setState(int n, int n2, boolean bl) {
        this.state[n] = n2;
        switch (n2) {
            case 0: {
                this.stateImage[n] = this.inactive[this.which[n]];
                break;
            }
            case 2: {
                this.stateImage[n] = this.active[this.which[n]];
                break;
            }
            case 1: {
                this.stateImage[n] = this.rollover[this.which[n]];
                this.message(title[this.which[n]]);
                break;
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, true);
        }
        this.status = "";
        this.handleMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = this.findSelection(n2, n = mouseEvent.getY());
        if (n3 == -1) {
            return;
        }
        this.currentRollover = -1;
        switch (n3) {
            case 0: {
                this.editor.handleRun(mouseEvent.isShiftDown());
                break;
            }
            case 1: {
                this.editor.handleStop();
                break;
            }
            case 3: {
                if (this.popup == null) {
                    this.popup = this.editor.sketchbook.getPopupMenu();
                    this.add(this.popup);
                }
                this.popup.show(this, n2, n);
                break;
            }
            case 2: {
                this.editor.handleNew(mouseEvent.isShiftDown());
                break;
            }
            case 4: {
                this.editor.handleSave(false);
                break;
            }
            case 5: {
                this.editor.handleExport();
                break;
            }
            case 6: {
                this.editor.handleSerial();
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void running(boolean bl) {
        this.setState(0, bl ? 2 : 0, true);
    }

    public void activate(int n) {
        if (this.inactive == null) {
            return;
        }
        this.setState(n, 2, true);
    }

    public void clear() {
        if (this.inactive == null) {
            return;
        }
        int n = 1;
        while (n < this.buttonCount) {
            this.setState(n, 0, false);
            ++n;
        }
        this.repaint();
    }

    public void message(String string) {
        this.status = string;
    }

    public void messageClear(String string) {
        if (this.status.equals(string)) {
            this.status = "";
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension((BUTTON_COUNT + 1) * 27, 32);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }

    private final /* synthetic */ void this() {
        this.state = new int[BUTTON_COUNT];
        this.wasDown = -1;
    }

    public EditorButtons(Editor editor) {
        this.this();
        this.editor = editor;
        this.buttons = Base.getImage("buttons.gif", this);
        this.buttonCount = 0;
        this.which = new int[BUTTON_COUNT];
        this.which[this.buttonCount++] = 0;
        this.which[this.buttonCount++] = 1;
        this.which[this.buttonCount++] = 2;
        this.which[this.buttonCount++] = 3;
        this.which[this.buttonCount++] = 4;
        this.which[this.buttonCount++] = 5;
        this.which[this.buttonCount++] = 6;
        this.currentRollover = -1;
        this.bgcolor = new Color(4, 79, 111);
        this.status = "";
        this.statusFont = Preferences.getFont("buttons.status.font");
        this.statusColor = Preferences.getColor("buttons.status.color");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

