/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import processing.app.AvrdudeUploader;
import processing.app.Base;
import processing.app.EditorButtons;
import processing.app.EditorConsole;
import processing.app.EditorHeader;
import processing.app.EditorLineStatus;
import processing.app.EditorListener;
import processing.app.EditorStatus;
import processing.app.FindReplace;
import processing.app.LibraryManager;
import processing.app.Preferences;
import processing.app.RunnerException;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Sketchbook;
import processing.app.Target;
import processing.app.Uploader;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.TextAreaPainter;
import processing.app.tools.Archiver;
import processing.app.tools.AutoFormat;
import processing.app.tools.DiscourseFormat;
import processing.core.PApplet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Editor
extends JFrame
implements MRJAboutHandler,
MRJQuitHandler,
MRJPrefsHandler,
MRJOpenDocumentHandler {
    static final String WINDOW_TITLE = "Arduino LumiNet Edition (based on Arduino - 0014, modified by R. Bohne)";
    public static final String EMPTY = "                                                                                                                                                                                                               ";
    public static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    static final int HANDLE_NEW = 1;
    static final int HANDLE_OPEN = 2;
    static final int HANDLE_QUIT = 3;
    Image icon;
    int checkModifiedMode;
    String handleOpenPath;
    boolean handleNewShift;
    boolean handleNewLibrary;
    PageFormat pageFormat;
    PrinterJob printerJob;
    EditorButtons buttons;
    EditorHeader header;
    EditorStatus status;
    EditorConsole console;
    Serial serialPort;
    JSplitPane splitPane;
    JPanel consolePanel;
    JLabel lineNumberComponent;
    public Sketch sketch;
    EditorLineStatus lineStatus;
    public JEditTextArea textarea;
    EditorListener listener;
    Point appletLocation;
    RunButtonWatcher watcher;
    JMenuItem exportAppItem;
    JMenuItem saveMenuItem;
    JMenuItem saveAsMenuItem;
    JMenuItem burnBootloader8Item;
    JMenuItem burnBootloader8ParallelItem;
    JMenuItem burnBootloader168DiecimilaItem;
    JMenuItem burnBootloader168DiecimilaParallelItem;
    JMenuItem burnBootloader168NGItem;
    JMenuItem burnBootloader168NGParallelItem;
    JMenu serialMenu;
    JMenu serialRateMenu;
    JMenu mcuMenu;
    SerialMenuListener serialMenuListener;
    boolean running;
    boolean presenting;
    boolean debugging;
    JMenuItem undoItem;
    JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    UndoManager undo;
    CompoundEdit compoundEdit;
    Sketchbook sketchbook;
    FindReplace find;

    public Dimension getMinimumSize() {
        return new Dimension(500, 550);
    }

    public void prepareLibraries() {
        try {
            LibraryManager libraryManager = new LibraryManager();
            libraryManager.buildAllUnbuilt();
            libraryManager.addSyntaxColoring(new PdeKeywords());
        }
        catch (RunnerException runnerException) {
            this.message("Error compiling library ...");
            this.error(runnerException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sketchbook.rebuildMenus();
    }

    public void restorePreferences() {
        int n;
        int n2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl = true;
        if (Preferences.get("last.screen.height") != null) {
            n2 = Preferences.getInteger("last.screen.width");
            n = Preferences.getInteger("last.screen.height");
            if (dimension.width != n2 || dimension.height != n) {
                bl = false;
            }
            int n3 = Preferences.getInteger("last.window.x");
            int n4 = Preferences.getInteger("last.window.y");
            if (n3 < 0 || n4 < 0 || n3 > n2 || n4 > n) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            n2 = Preferences.getInteger("default.window.height");
            n = Preferences.getInteger("default.window.width");
            this.setBounds((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
            Preferences.setInteger("last.divider.location", this.splitPane.getDividerLocation());
        } else {
            this.setBounds(Preferences.getInteger("last.window.x"), Preferences.getInteger("last.window.y"), Preferences.getInteger("last.window.width"), Preferences.getInteger("last.window.height"));
        }
        if (Base.openedAtStartup != null) {
            this.handleOpen2(Base.openedAtStartup);
        } else {
            String string = Preferences.get("last.sketch.path");
            if (string != null && new File(string).exists()) {
                this.handleOpen2(string);
            } else {
                this.handleNew2(true);
            }
        }
        int n5 = Preferences.getInteger("last.divider.location");
        this.splitPane.setDividerLocation(n5);
        this.applyPreferences();
    }

    public void applyPreferences() {
        boolean bl = Preferences.getBoolean("editor.external");
        this.textarea.setEditable(bl ^ true);
        this.saveMenuItem.setEnabled(bl ^ true);
        this.saveAsMenuItem.setEnabled(bl ^ true);
        TextAreaPainter textAreaPainter = this.textarea.getPainter();
        if (bl) {
            Color color = Preferences.getColor("editor.external.bgcolor");
            textAreaPainter.setBackground(color);
            textAreaPainter.setLineHighlightEnabled(false);
            this.textarea.setCaretVisible(false);
        } else {
            Color color = Preferences.getColor("editor.bgcolor");
            textAreaPainter.setBackground(color);
            boolean bl2 = Preferences.getBoolean("editor.linehighlight");
            textAreaPainter.setLineHighlightEnabled(bl2);
            this.textarea.setCaretVisible(true);
        }
        textAreaPainter.setFont(Preferences.getFont("editor.font"));
        this.listener.applyPreferences();
        this.sketchbook.rebuildMenusAsync();
    }

    public void storePreferences() {
        Rectangle rectangle = this.getBounds();
        Preferences.setInteger("last.window.x", rectangle.x);
        Preferences.setInteger("last.window.y", rectangle.y);
        Preferences.setInteger("last.window.width", rectangle.width);
        Preferences.setInteger("last.window.height", rectangle.height);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Preferences.setInteger("last.screen.width", dimension.width);
        Preferences.setInteger("last.screen.height", dimension.height);
        Preferences.set("last.sketch.path", this.sketch.getMainFilePath());
        int n = this.splitPane.getDividerLocation();
        Preferences.setInteger("last.divider.location", n);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = Editor.newJMenuItem("New", 78);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleNew(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(this.sketchbook.getOpenMenu());
        this.saveMenuItem = Editor.newJMenuItem("Save", 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleSave(false);
            }
        });
        jMenu.add(this.saveMenuItem);
        this.saveAsMenuItem = Editor.newJMenuItem("Save As...", 83, true);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleSaveAs();
            }
        });
        jMenu.add(this.saveAsMenuItem);
        jMenuItem = Editor.newJMenuItem("Upload to I/O Board", 85);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleExport();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Burn bootloader to I/O Board", 66);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                String string = Preferences.get("bootprogrammer");
                Editor.this.handleBurnBootloader(string);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = Editor.newJMenuItem("Page Setup", 80, true);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handlePageSetup();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Print", 80);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handlePrint();
            }
        });
        jMenu.add(jMenuItem);
        if (!Base.isMacOS()) {
            jMenu.addSeparator();
            jMenuItem = Editor.newJMenuItem("Preferences", 44);
            jMenuItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handlePrefs();
                }
            });
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
            jMenuItem = Editor.newJMenuItem("Quit", 81);
            jMenuItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleQuitInternal();
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    protected JMenu buildSketchMenu() {
        JMenu jMenu = new JMenu("Sketch");
        JMenuItem jMenuItem = Editor.newJMenuItem("Verify/Compile", 82);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleRun(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Stop");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleStop();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(this.sketchbook.getImportMenu());
        jMenuItem = Editor.newJMenuItem("Show Sketch Folder", 75, false);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Base.openFolder(Editor.this.sketch.folder);
            }
        });
        jMenu.add(jMenuItem);
        if (!Base.openFolderAvailable()) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem = new JMenuItem("Add File...");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.sketch.addFile();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu buildToolsMenu() {
        Object object;
        Object object2;
        this.serialMenuListener = new SerialMenuListener();
        JMenu jMenu = new JMenu("Tools");
        JMenuItem jMenuItem = Editor.newJMenuItem("Auto Format", 84, false);
        jMenuItem.addActionListener(new ActionListener(){

            public final synchronized void actionPerformed(ActionEvent actionEvent) {
                new AutoFormat(Editor.this).show();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Copy for Forum");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public final void run() {
                        new DiscourseFormat(Editor.this).show();
                    }
                });
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Archive Sketch");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                new Archiver(Editor.this).show();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Board");
        ButtonGroup buttonGroup = new ButtonGroup();
        Object object3 = Preferences.getSubKeys("boards");
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = new BoardMenuAction((String)object2);
            jMenuItem = new JRadioButtonMenuItem((Action)object);
            if (((String)object2).equals(Preferences.get("board"))) {
                jMenuItem.setSelected(true);
            }
            buttonGroup.add(jMenuItem);
            jMenu2.add(jMenuItem);
        }
        jMenu.add(jMenu2);
        this.serialMenu = new JMenu("Serial Port");
        this.populateSerialMenu();
        jMenu.add(this.serialMenu);
        jMenu.addSeparator();
        object3 = new JMenu("Burn Bootloader");
        object2 = new ButtonGroup();
        object = Preferences.getSubKeys("programmers");
        while (object.hasNext()) {
            String string = (String)object.next();
            BootloaderMenuAction bootloaderMenuAction = new BootloaderMenuAction(string);
            jMenuItem = new JRadioButtonMenuItem(bootloaderMenuAction);
            if (string.equals(Preferences.get("bootprogrammer"))) {
                jMenuItem.setSelected(true);
            }
            ((ButtonGroup)object2).add(jMenuItem);
            ((JMenu)object3).add(jMenuItem);
        }
        jMenu.add((JMenuItem)object3);
        jMenu.addMenuListener(new MenuListener(){

            public final void menuCanceled(MenuEvent menuEvent) {
            }

            public final void menuDeselected(MenuEvent menuEvent) {
            }

            public final void menuSelected(MenuEvent menuEvent) {
                Editor.this.populateSerialMenu();
            }
        });
        return jMenu;
    }

    protected void populateSerialMenu() {
        this.serialMenu.removeAll();
        boolean bl = true;
        try {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                String string = commPortIdentifier.getName();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, string.equals(Preferences.get("serial.port")));
                jCheckBoxMenuItem.addActionListener(this.serialMenuListener);
                this.serialMenu.add(jCheckBoxMenuItem);
                bl = false;
            }
            if (!bl) {
                this.serialMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            System.out.println("error retrieving port list");
            exception.printStackTrace();
        }
        if (this.serialMenu.getItemCount() == 0) {
            this.serialMenu.setEnabled(false);
        }
    }

    protected JMenu buildHelpMenu() {
        JMenuItem jMenuItem;
        JMenu jMenu = new JMenu("Help");
        if (!Base.isLinux()) {
            jMenuItem = new JMenuItem("Getting Started");
            jMenuItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    if (Base.isWindows()) {
                        Base.openURL(System.getProperty("user.dir") + File.separator + "reference" + File.separator + "Guide_Windows.html");
                    } else {
                        Base.openURL(System.getProperty("user.dir") + File.separator + "reference" + File.separator + "Guide_MacOSX.html");
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Environment");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Base.showEnvironment();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Troubleshooting");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Base.showTroubleshooting();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reference");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Base.showReference();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Find in Reference", 70, true);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.textarea.isSelectionActive()) {
                    Editor.this.handleReference();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Frequently Asked Questions");
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Base.showFAQ();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Visit www.arduino.cc", 53);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Base.openURL("http://www.arduino.cc/");
            }
        });
        jMenu.add(jMenuItem);
        if (!Base.isMacOS()) {
            jMenu.addSeparator();
            jMenuItem = new JMenuItem("About Arduino");
            jMenuItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleAbout();
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public JMenu buildEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        this.undoItem = Editor.newJMenuItem("Undo", 90);
        this.undoAction = new UndoAction();
        this.undoItem.addActionListener(this.undoAction);
        jMenu.add(this.undoItem);
        this.redoItem = Editor.newJMenuItem("Redo", 89);
        this.redoAction = new RedoAction();
        this.redoItem.addActionListener(this.redoAction);
        jMenu.add(this.redoItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem = Editor.newJMenuItem("Cut", 88);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textarea.cut();
                Editor.this.sketch.setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Copy", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textarea.copy();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Paste", 86);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textarea.paste();
                Editor.this.sketch.setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Select All", 65);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textarea.selectAll();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = Editor.newJMenuItem("Find...", 70);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.show();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Find Next", 71);
        jMenuItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.find != null) {
                    Editor.this.find.find(true);
                }
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenuItem newJMenuItem(String string, int n) {
        return Editor.newJMenuItem(string, n, false);
    }

    public static JMenuItem newJMenuItem(String string, int n, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (bl) {
            n2 |= 1;
        }
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        return jMenuItem;
    }

    public void handleAbout() {
        final Image image = Base.getImage("about.jpg", this);
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        final Window window = new Window(this){

            public final void paint(Graphics graphics) {
                graphics.drawImage(image, 0, 0, null);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                graphics.setFont(new Font("SansSerif", 0, 11));
                graphics.setColor(Color.white);
                graphics.drawString("0014", 50, 30);
            }
        };
        window.addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent mouseEvent) {
                window.dispose();
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
        window.show();
    }

    public void handlePrefs() {
        Preferences preferences = new Preferences();
        preferences.showFrame(this);
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String string, int n, int n2) {
        this.beginCompoundEdit();
        this.textarea.setText(string);
        this.endCompoundEdit();
        n = Math.max(0, Math.min(n, this.textarea.getDocumentLength()));
        n2 = Math.max(0, Math.min(n, this.textarea.getDocumentLength()));
        this.textarea.select(n, n2);
        this.textarea.requestFocus();
    }

    public void setCode(SketchCode sketchCode) {
        if (sketchCode.document == null) {
            sketchCode.document = new SyntaxDocument();
            sketchCode.document.setTokenMarker(new PdeKeywords());
            try {
                sketchCode.document.insertString(0, sketchCode.program, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            sketchCode.undo = new UndoManager();
            sketchCode.document.addUndoableEditListener(new UndoableEditListener(){

                public final void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    if (Editor.this.compoundEdit != null) {
                        Editor.this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                    } else if (Editor.this.undo != null) {
                        Editor.this.undo.addEdit(undoableEditEvent.getEdit());
                        Editor.this.undoAction.updateUndoState();
                        Editor.this.redoAction.updateRedoState();
                    }
                }
            });
        }
        this.textarea.setDocument(sketchCode.document, sketchCode.selectionStart, sketchCode.selectionStop, sketchCode.scrollPosition);
        this.textarea.requestFocus();
        this.undo = sketchCode.undo;
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    public void beginCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    public void endCompoundEdit() {
        this.compoundEdit.end();
        this.undo.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        this.compoundEdit = null;
    }

    public void handleRun(boolean bl) {
        String string;
        this.doClose();
        this.running = true;
        this.buttons.activate(0);
        this.message("Compiling...");
        int n = 0;
        while (n < 10) {
            System.out.println();
            ++n;
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        this.presenting = bl;
        if (this.presenting && Base.isMacOS() && (string = System.getProperty("os.version").substring(0, 4)).equals("10.2")) {
            Base.showWarning("Time for an OS Upgrade", "The \"Present\" feature may not be available on\nMac OS X 10.2, because of what appears to be\na bug in the Java 1.4 implementation on 10.2.\nIn case it works on your machine, present mode\nwill start, but if you get a flickering white\nwindow, using Command-Q to quit the sketch", null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                try {
                    if (!Editor.this.sketch.handleRun(new Target(System.getProperty("user.dir") + File.separator + "hardware" + File.separator + "cores", Preferences.get("boards." + Preferences.get("board") + ".build.core")))) {
                        return;
                    }
                    Editor.this.watcher = new RunButtonWatcher();
                    Editor.this.message("Done compiling.");
                    if (Editor.this.watcher != null) {
                        Editor.this.watcher.stop();
                    }
                }
                catch (RunnerException runnerException) {
                    Editor.this.message("Error compiling...");
                    Editor.this.error(runnerException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.buttons.clear();
    }

    public void handleSerial() {
        if (!this.debugging) {
            try {
                this.serialPort = new Serial(true);
                this.console.clear();
                this.buttons.activate(6);
                this.debugging = true;
                this.status.serial();
            }
            catch (SerialException serialException) {
                this.error(serialException);
            }
        } else {
            this.doStop();
        }
    }

    public void handleStop() {
        if (this.presenting) {
            this.doClose();
        } else {
            this.doStop();
        }
        this.buttons.clear();
    }

    public void doStop() {
        if (this.debugging) {
            this.status.unserial();
            this.serialPort.dispose();
            this.debugging = false;
        }
        if (this.watcher != null) {
            this.watcher.stop();
        }
        this.message(EMPTY);
        this.buttons.clear();
        this.running = false;
    }

    public void doClose() {
        this.doStop();
        this.sketch.cleanup();
        this.toFront();
    }

    protected void checkModified(int n) {
        this.checkModifiedMode = n;
        if (!this.sketch.modified) {
            this.checkModified2();
            return;
        }
        String string = "Save changes to " + this.sketch.name + "?  ";
        if (n != 3) {
            this.status.prompt(string);
        } else if (!Base.isMacOS() || PApplet.javaVersion < 1.5f) {
            int n2 = JOptionPane.showConfirmDialog(this, string, "Quit", 1, 3);
            if (n2 == 0) {
                this.handleSave(true);
                this.checkModified2();
            } else if (n2 == 1) {
                this.checkModified2();
            }
        } else {
            JOptionPane jOptionPane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
            Object[] objectArray = new String[]{"Save", "Cancel", "Don't Save"};
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(objectArray[0]);
            jOptionPane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
            JDialog jDialog = jOptionPane.createDialog(this, null);
            jDialog.show();
            Object object = jOptionPane.getValue();
            if (object == objectArray[0]) {
                this.handleSave(true);
                this.checkModified2();
            } else if (object == objectArray[2]) {
                this.checkModified2();
            }
        }
    }

    public void checkModified2() {
        switch (this.checkModifiedMode) {
            case 1: {
                this.handleNew2(false);
                break;
            }
            case 2: {
                this.handleOpen2(this.handleOpenPath);
                break;
            }
            case 3: {
                this.handleQuit2();
                break;
            }
        }
        this.checkModifiedMode = 0;
    }

    public void handleNew(final boolean bl) {
        this.buttons.activate(2);
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Editor.this.doStop();
                Editor.this.handleNewShift = bl;
                Editor.this.handleNewLibrary = false;
                Editor.this.checkModified(1);
            }
        });
    }

    public void handleNewUnchecked() {
        this.doStop();
        this.handleNewShift = false;
        this.handleNewLibrary = false;
        this.handleNew2(true);
    }

    public void handleNewLibrary() {
        this.doStop();
        this.handleNewShift = false;
        this.handleNewLibrary = true;
        this.checkModified(1);
    }

    protected void handleNew2(boolean bl) {
        try {
            String string = this.sketchbook.handleNew(bl, this.handleNewShift, this.handleNewLibrary);
            if (string != null) {
                this.handleOpen2(string);
            }
        }
        catch (IOException iOException) {
            Base.showError("Problem creating a new sketch", "An error occurred while creating\na new sketch. Arduino must now quit.", iOException);
        }
        this.buttons.clear();
        this.setText("void setup()\n{\n}\n\nvoid loop()\n{\n}\n", 0, 0);
    }

    public void handleOpenFile(File file) {
        this.handleOpen(file.getAbsolutePath());
    }

    public void handleOpen(final String string) {
        this.buttons.activate(3);
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                String string2 = string;
                if (string2 == null && (string2 = Editor.this.sketchbook.handleOpen()) == null) {
                    return;
                }
                Editor.this.doClose();
                Editor.this.handleOpenPath = string2;
                Editor.this.checkModified(2);
            }
        });
    }

    public void handleOpenUnchecked(String string, int n, int n2, int n3, int n4) {
        this.doClose();
        this.handleOpen2(string);
        this.sketch.setCurrent(n);
        this.textarea.select(n2, n3);
        this.textarea.setScrollPosition(n4);
    }

    protected void handleOpen2(String string) {
        Object object;
        Object object2;
        if (this.sketch != null) {
            try {
                object2 = this.sketch.code[0].file.getCanonicalPath();
                object = new File(string).getCanonicalPath();
                if (!((String)object2).equals(object) && Base.calcFolderSize(this.sketch.folder) == 0) {
                    Base.removeDir(this.sketch.folder);
                    this.sketchbook.rebuildMenusAsync();
                }
            }
            catch (Exception exception) {}
        }
        try {
            object2 = new File(string);
            object = new File(((File)object2).getParent());
            String string2 = ((File)object).getName();
            String string3 = string2 + ".pde";
            File file = new File(((File)object2).getParent(), string3);
            if (!string3.equals(((File)object2).getName())) {
                if (file.exists()) {
                    string = file.getAbsolutePath();
                } else {
                    if (!string.endsWith(".pde")) {
                        Base.showWarning("Bad file selected", "Arduino can only open its own sketches\nand other files ending in .pde", null);
                        return;
                    }
                    String string4 = ((File)object2).getName().substring(0, ((File)object2).getName().length() - 4);
                    Object[] objectArray = new Object[]{"OK", "Cancel"};
                    String string5 = "The file \"" + ((File)object2).getName() + "\" needs to be inside\na sketch folder named \"" + string4 + "\".\nCreate this folder, move the file, and continue?";
                    int n = JOptionPane.showOptionDialog(this, string5, "Moving", 0, 3, null, objectArray, objectArray[0]);
                    if (n == 0) {
                        File file2 = new File(((File)object2).getParent(), string4);
                        if (file2.exists()) {
                            Base.showWarning("Error", "A folder named \"" + string4 + "\" already exists. Can't open sketch.", null);
                            return;
                        }
                        if (!file2.mkdirs()) {
                            throw new IOException("Couldn't create sketch folder");
                        }
                        File file3 = new File(file2, ((File)object2).getName());
                        File file4 = new File(string);
                        Base.copyFile(file4, file3);
                        file4.delete();
                        string = file3.getAbsolutePath();
                    } else if (n == 1) {
                        return;
                    }
                }
            }
            this.sketch = new Sketch(this, string);
            this.header.rebuild();
            if (Preferences.getBoolean("console.auto_clear")) {
                this.console.clear();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void handleSave(boolean bl) {
        this.doStop();
        this.buttons.activate(4);
        if (bl) {
            this.handleSave2();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    Editor.this.handleSave2();
                }
            });
        }
    }

    public void handleSave2() {
        this.message("Saving...");
        try {
            if (this.sketch.save()) {
                this.message("Done Saving.");
            } else {
                this.message(EMPTY);
            }
        }
        catch (Exception exception) {
            this.error(exception);
            this.checkModifiedMode = 0;
        }
        this.buttons.clear();
    }

    public void handleSaveAs() {
        this.doStop();
        this.buttons.activate(4);
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Editor.this.message("Saving...");
                try {
                    if (Editor.this.sketch.saveAs()) {
                        Editor.this.message("Done Saving.");
                    } else {
                        Editor.this.message("Save Cancelled.");
                    }
                }
                catch (Exception exception) {
                    Editor.this.error(exception);
                }
                Editor.this.buttons.clear();
            }
        });
    }

    public synchronized void handleExport() {
        if (this.debugging) {
            this.doStop();
        }
        this.buttons.activate(5);
        this.console.clear();
        this.message("Uploading to I/O Board...");
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                try {
                    boolean bl = Editor.this.sketch.exportApplet(new Target(System.getProperty("user.dir") + File.separator + "hardware" + File.separator + "cores", Preferences.get("boards." + Preferences.get("board") + ".build.core")));
                    if (bl) {
                        Editor.this.message("Done uploading.");
                    }
                }
                catch (RunnerException runnerException) {
                    Editor.this.message("Error during upload.");
                    Editor.this.error(runnerException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Editor.this.buttons.clear();
            }
        });
    }

    public synchronized void handleExportApp() {
        this.message("Exporting application...");
        try {
            if (this.sketch.exportApplication()) {
                this.message("Done exporting.");
            }
        }
        catch (Exception exception) {
            this.message("Error during export.");
            exception.printStackTrace();
        }
        this.buttons.clear();
    }

    public boolean handleExportCheckModified() {
        if (!this.sketch.modified) {
            return true;
        }
        Object[] objectArray = new Object[]{"OK", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Save changes before export?", "Save", 2, 3, null, objectArray, objectArray[0]);
        if (n != 0) {
            this.message("Export canceled, changes must first be saved.");
            this.buttons.clear();
            return false;
        }
        this.handleSave(true);
        return true;
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.message("Printing...");
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(this.textarea.getPainter(), this.pageFormat);
        } else {
            this.printerJob.setPrintable(this.textarea.getPainter());
        }
        this.printerJob.setJobName(this.sketch.current.name);
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.message("Done printing.");
            }
            catch (PrinterException printerException) {
                this.error("Error while printing.");
                printerException.printStackTrace();
            }
        } else {
            this.message("Printing canceled.");
        }
    }

    public void handleQuitInternal() {
        this.doClose();
        this.checkModified(3);
    }

    public void handleQuit() {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Editor.this.handleQuitInternal();
            }
        });
        throw new IllegalStateException("Quit Pending User Confirmation");
    }

    protected void handleQuit2() {
        this.storePreferences();
        Preferences.save();
        this.sketchbook.clean();
        this.console.handleQuit();
        System.exit(0);
    }

    protected void handleReference() {
        String string = this.textarea.getSelectedText().trim();
        if (string.length() == 0) {
            this.message("First select a word to find in the reference.");
        } else {
            String string2 = PdeKeywords.getReference(string);
            if (string2 == null) {
                this.message("No reference available for \"" + string + '\"');
            } else {
                Base.showReference(string2 + ".html");
            }
        }
    }

    protected void handleBurnBootloader(final String string) {
        if (this.debugging) {
            this.doStop();
        }
        this.console.clear();
        this.message("Burning bootloader to I/O Board (this may take a minute)...");
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                try {
                    AvrdudeUploader avrdudeUploader = new AvrdudeUploader();
                    if (((Uploader)avrdudeUploader).burnBootloader(string)) {
                        Editor.this.message("Done burning bootloader.");
                    }
                }
                catch (RunnerException runnerException) {
                    Editor.this.message("Error while burning bootloader.");
                    Editor.this.error(runnerException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Editor.this.buttons.clear();
            }
        });
    }

    public void highlightLine(int n) {
        if (n < 0) {
            this.textarea.select(0, 0);
            return;
        }
        String string = this.textarea.getText();
        int n2 = string.length();
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        if (n == 0) {
            n3 = 0;
        }
        int n7 = 0;
        while (n7 < n2) {
            ++n4;
            boolean bl = false;
            if (string.charAt(n7) == '\r') {
                if (n7 != n2 - 1 && string.charAt(n7 + 1) == '\n') {
                    ++n7;
                }
                ++n6;
                bl = true;
            } else if (string.charAt(n7) == '\n') {
                ++n6;
                bl = true;
            }
            if (bl) {
                if (n6 == n) {
                    n3 = n4;
                } else if (n6 == n + 1) {
                    n5 = n4 - 1;
                    break;
                }
            }
            ++n7;
        }
        if (n5 == -1) {
            n5 = n2;
        }
        if (n3 == -1) {
            n3 = n2;
        }
        this.textarea.select(n3, n5);
    }

    public void error(String string) {
        this.status.error(string);
    }

    public void error(Exception exception) {
        if (exception == null) {
            System.err.println("Editor.error() was passed a null exception.");
            return;
        }
        String string = exception.getMessage();
        if (string != null) {
            String string2;
            String string3 = "RuntimeException: ";
            if (string.indexOf(string3) == 0) {
                string = string.substring(string3.length());
            }
            if (string.indexOf(string2 = "java.lang.") == 0) {
                string = string.substring(string2.length());
            }
            this.error(string);
        }
        exception.printStackTrace();
    }

    public void error(RunnerException runnerException) {
        String string;
        String string2;
        String string3;
        if (runnerException.file >= 0) {
            this.sketch.setCurrent(runnerException.file);
        }
        if (runnerException.line >= 0) {
            this.highlightLine(runnerException.line);
        }
        if ((string3 = runnerException.getMessage()).indexOf(string2 = "RuntimeException: ") == 0) {
            string3 = string3.substring(string2.length());
        }
        if (string3.indexOf(string = "java.lang.") == 0) {
            string3 = string3.substring(string.length());
        }
        this.error(string3);
        this.buttons.clear();
    }

    public void message(String string) {
        this.status.notice(string);
    }

    private final /* synthetic */ void this() {
        this.burnBootloader8Item = null;
        this.burnBootloader8ParallelItem = null;
        this.burnBootloader168DiecimilaItem = null;
        this.burnBootloader168DiecimilaParallelItem = null;
        this.burnBootloader168NGItem = null;
        this.burnBootloader168NGParallelItem = null;
    }

    public Editor() {
        super(WINDOW_TITLE);
        this.this();
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this);
        MRJApplicationUtils.registerPrefsHandler((MRJPrefsHandler)this);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this);
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)this);
        Preferences.init();
        try {
            this.icon = Base.getImage("icon.gif", this);
            this.setIconImage(this.icon);
        }
        catch (Exception exception) {}
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
                Editor.this.handleQuitInternal();
            }
        });
        this.setDefaultCloseOperation(0);
        PdeKeywords pdeKeywords = new PdeKeywords();
        this.sketchbook = new Sketchbook(this);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildEditMenu());
        jMenuBar.add(this.buildSketchMenu());
        jMenuBar.add(this.buildToolsMenu());
        jMenuBar.add(this.buildHelpMenu());
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        Box box = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        this.buttons = new EditorButtons(this);
        box2.add(this.buttons);
        this.header = new EditorHeader(this);
        box2.add(this.header);
        this.textarea = new JEditTextArea(new PdeTextAreaDefaults());
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        this.consolePanel = new JPanel();
        this.consolePanel.setLayout(new BorderLayout());
        this.status = new EditorStatus(this);
        this.consolePanel.add((Component)this.status, "North");
        this.console = new EditorConsole(this);
        this.console.setBorder(null);
        this.consolePanel.add((Component)this.console, "Center");
        this.lineStatus = new EditorLineStatus(this.textarea);
        this.consolePanel.add((Component)this.lineStatus, "South");
        box2.add(this.textarea);
        this.splitPane = new JSplitPane(0, box2, this.consolePanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        int n = Preferences.getInteger("editor.divider.size");
        if (n != 0) {
            this.splitPane.setDividerSize(n);
        }
        this.splitPane.setMinimumSize(new Dimension(600, 600));
        box.add(this.splitPane);
        this.listener = new EditorListener(this, this.textarea);
        jPanel.add(box);
        jPanel.setTransferHandler(new TransferHandler(){

            public final boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return true;
            }

            public final boolean importData(JComponent jComponent, Transferable transferable) {
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n = 0;
                int n2 = 0;
                while (n2 < dataFlavorArray.length) {
                    try {
                        Object object = transferable.getTransferData(dataFlavorArray[n2]);
                        if (object instanceof List) {
                            List list = (List)object;
                            int n3 = 0;
                            while (n3 < list.size()) {
                                Object e = list.get(n3);
                                if (e instanceof File) {
                                    File file;
                                    String string;
                                    File file2 = (File)e;
                                    String string2 = file2.getName();
                                    if (string2.endsWith(".pde") && (string = string2.substring(0, string2.length() - 4)).equals((file = file2.getParentFile()).getName())) {
                                        Editor.this.handleOpenFile(file2);
                                        return true;
                                    }
                                    if (Editor.this.sketch.addFile(file2)) {
                                        ++n;
                                    }
                                }
                                ++n3;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                    ++n2;
                }
                if (n == 0) {
                    Editor.this.error("No files were added to the sketch.");
                } else if (n == 1) {
                    Editor.this.message("One file added to the sketch.");
                } else {
                    Editor.this.message(n + " files added to the sketch.");
                }
                return true;
            }
        });
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SerialMenuListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (Editor.this.serialMenu == null) {
                System.out.println("serialMenu is null");
                return;
            }
            int n = Editor.this.serialMenu.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                ((JCheckBoxMenuItem)Editor.this.serialMenu.getItem(n2)).setState(false);
                ++n2;
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            jCheckBoxMenuItem.setState(true);
            String string = jCheckBoxMenuItem.getText();
            Preferences.set("serial.port", string);
        }

        SerialMenuListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BoardMenuAction
    extends AbstractAction {
        private String board;

        public void actionPerformed(ActionEvent actionEvent) {
            Preferences.set("board", this.board);
            try {
                LibraryManager libraryManager = new LibraryManager();
                libraryManager.rebuildAllBuilt();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (RunnerException runnerException) {
                Editor.this.message("Error rebuilding libraries...");
                Editor.this.error(runnerException);
            }
        }

        public BoardMenuAction(String string) {
            super(Preferences.get("boards." + string + ".name"));
            this.board = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BootloaderMenuAction
    extends AbstractAction {
        private String programmer;

        public void actionPerformed(ActionEvent actionEvent) {
            Preferences.set("bootprogrammer", this.programmer);
        }

        public BootloaderMenuAction(String string) {
            super("w/ " + Preferences.get("programmers." + string + ".name"));
            this.programmer = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UndoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {}
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                Editor.this.undoItem.setText(Editor.this.undo.getUndoPresentationName());
                this.putValue("Name", Editor.this.undo.getUndoPresentationName());
                if (Editor.this.sketch != null) {
                    Editor.this.sketch.setModified(true);
                }
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText("Undo");
                this.putValue("Name", "Undo");
                if (Editor.this.sketch != null) {
                    Editor.this.sketch.setModified(false);
                }
            }
        }

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RedoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {}
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                Editor.this.redoItem.setText(Editor.this.undo.getRedoPresentationName());
                this.putValue("Name", Editor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText("Redo");
                this.putValue("Name", "Redo");
            }
        }

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RunButtonWatcher
    implements Runnable {
        Thread thread = new Thread((Runnable)this, "run button watcher");

        public void run() {
            while (Thread.currentThread() == this.thread) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stop() {
            Editor.this.buttons.running(false);
            this.thread = null;
        }

        public RunButtonWatcher() {
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TextAreaPopup
    extends JPopupMenu {
        String referenceFile;
        JMenuItem cutItem;
        JMenuItem copyItem;
        JMenuItem referenceItem;

        public void show(Component component, int n, int n2) {
            if (Editor.this.textarea.isSelectionActive()) {
                this.cutItem.setEnabled(true);
                this.copyItem.setEnabled(true);
                String string = Editor.this.textarea.getSelectedText().trim();
                this.referenceFile = PdeKeywords.getReference(string);
                boolean bl = false;
                if (this.referenceFile != null) {
                    bl = true;
                }
                this.referenceItem.setEnabled(bl);
            } else {
                this.cutItem.setEnabled(false);
                this.copyItem.setEnabled(false);
                this.referenceItem.setEnabled(false);
            }
            super.show(component, n, n2);
        }

        private final /* synthetic */ void this() {
            this.referenceFile = null;
        }

        public TextAreaPopup() {
            this.this();
            this.cutItem = new JMenuItem("Cut");
            this.cutItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.textarea.cut();
                    Editor.this.sketch.setModified(true);
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem("Copy");
            this.copyItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.textarea.copy();
                }
            });
            this.add(this.copyItem);
            JMenuItem jMenuItem = new JMenuItem("Paste");
            jMenuItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.textarea.paste();
                    Editor.this.sketch.setModified(true);
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Select All");
            jMenuItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.textarea.selectAll();
                }
            });
            this.add(jMenuItem);
            this.addSeparator();
            this.referenceItem = new JMenuItem("Find in Reference");
            this.referenceItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleReference();
                }
            });
            this.add(this.referenceItem);
        }
    }
}

