/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import processing.app.Base;
import processing.app.LuminetUploader;
import processing.app.Preferences;
import processing.app.RunnerException;
import processing.app.Uploader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AvrdudeUploader
extends Uploader {
    String useThisProgrammer;

    public boolean uploadUsingPreferences(String string, String string2) throws RunnerException {
        String string3 = Preferences.get("boards." + Preferences.get("board") + ".upload.using");
        if (string3 == null) {
            string3 = Preferences.get("upload.using");
            System.out.println("upload.using is null");
        }
        if (string3.equals("bootloader")) {
            return this.uploadViaBootloader(string, string2);
        }
        if (string3.equals("byInfection")) {
            System.out.println("upload.using is byInfection");
            return new LuminetUploader().infectNetwork(string, string2);
        }
        Collection collection = this.getProgrammerCommands(string3);
        collection.add("-Uflash:w:" + string + File.separator + string2 + ".hex:i");
        return this.avrdude(collection);
    }

    private final boolean uploadViaBootloader(String string, String string2) throws RunnerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = Preferences.get("boards." + Preferences.get("board") + ".upload.protocol");
        if (string3.equals("stk500")) {
            string3 = "stk500v1";
        }
        arrayList.add("-c" + string3);
        arrayList.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
        if (!string3.equals("stk500v2")) {
            arrayList.add("-b" + Preferences.getInteger("boards." + Preferences.get("board") + ".upload.speed"));
            arrayList.add("-D");
        }
        arrayList.add("-Uflash:w:" + string + File.separator + string2 + ".hex:i");
        if (Preferences.get("boards." + Preferences.get("board") + ".upload.disable_flushing") == null || !Preferences.getBoolean("boards." + Preferences.get("board") + ".upload.disable_flushing")) {
            this.flushSerialBuffer();
        }
        return this.avrdude(arrayList);
    }

    public boolean burnBootloader(String string) throws RunnerException {
        return this.burnBootloader(this.getProgrammerCommands(string));
    }

    private final Collection getProgrammerCommands(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-c" + Preferences.get("programmers." + string + ".protocol"));
        if ("usb".equals(Preferences.get("programmers." + string + ".communication"))) {
            arrayList.add("-Pusb");
        } else if ("serial".equals(Preferences.get("programmers." + string + ".communication"))) {
            arrayList.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
        } else if ("diecimila".equals(Preferences.get("programmers." + string + ".protocol"))) {
            System.out.println("fdti parameters added.");
            arrayList.add("-Pft0");
            arrayList.add("-B4800");
        }
        if (Preferences.get("programmers." + string + ".force") != null && Preferences.getBoolean("programmers." + string + ".force")) {
            arrayList.add("-F");
        }
        if (Preferences.get("programmers." + string + ".delay") != null) {
            arrayList.add("-i" + Preferences.get("programmers." + string + ".delay"));
        }
        this.useThisProgrammer = string;
        return arrayList;
    }

    protected boolean burnBootloader(Collection collection) throws RunnerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-e");
        if (Preferences.get("boards." + Preferences.get("board") + ".bootloader.unlock_bits") != null) {
            arrayList.add("-Ulock:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.unlock_bits") + ":m");
        }
        if (Preferences.get("boards." + Preferences.get("board") + ".bootloader.extended_fuses") != null) {
            arrayList.add("-Uefuse:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.extended_fuses") + ":m");
        }
        if (Preferences.get("boards." + Preferences.get("board") + ".bootloader.high_fuses") != null) {
            arrayList.add("-Uhfuse:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.high_fuses") + ":m");
        }
        if (Preferences.get("boards." + Preferences.get("board") + ".bootloader.low_fuses") != null) {
            arrayList.add("-Ulfuse:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.low_fuses") + ":m");
        }
        if (!this.avrdude(collection, arrayList)) {
            System.out.println("programming fuses failed.");
            return false;
        }
        System.out.println("programming fuses ok.");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("-Uflash:w:hardware" + File.separator + "bootloaders" + File.separator + Preferences.get("boards." + Preferences.get("board") + ".bootloader.path") + File.separator + Preferences.get("boards." + Preferences.get("board") + ".bootloader.file") + ":i");
        if (Preferences.get("boards." + Preferences.get("board") + ".bootloader.unlock_bits") != null) {
            arrayList2.add("-Ulock:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.lock_bits") + ":m");
        }
        if (!this.avrdude(collection, arrayList2)) {
            System.out.println("programming bootloader failed.");
            return false;
        }
        System.out.println("programming bootloader ok.");
        return true;
    }

    public boolean avrdude(Collection collection, Collection collection2) throws RunnerException {
        ArrayList arrayList = new ArrayList(collection);
        arrayList.addAll(collection2);
        return this.avrdude(arrayList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean avrdude(Collection collection) throws RunnerException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "avrdude.conf";
        if (this.useThisProgrammer.equals("diecimila") || this.useThisProgrammer.equals("ftdi")) {
            if (!Base.isWindows()) return false;
            arrayList.add("avrdudeFTDI");
            string2 = "avrdudeFTDI.conf";
            System.out.println("using avrdudeFTDI.");
        } else {
            arrayList.add("avrdude");
        }
        if (Base.isMacOS()) {
            arrayList.add("-Chardware/tools/avr/etc/" + string2);
        } else if (Base.isWindows()) {
            string = System.getProperty("user.dir") + File.separator;
            arrayList.add("-C" + string + "hardware/tools/avr/etc/" + string2);
        } else {
            arrayList.add("-Chardware/tools/" + string2);
        }
        if (Preferences.getBoolean("upload.verbose")) {
            arrayList.add("-v");
            arrayList.add("-v");
            arrayList.add("-v");
            arrayList.add("-v");
        } else {
            arrayList.add("-q");
            arrayList.add("-q");
        }
        string = Preferences.get("boards." + Preferences.get("board") + ".build.mcu");
        if (string.startsWith("atmega")) {
            arrayList.add("-pm" + string.substring(6));
        } else if (string.startsWith("attiny")) {
            arrayList.add("-pt" + string.substring(6));
        } else {
            arrayList.add("-pm" + string.substring(6));
        }
        arrayList.addAll(collection);
        return this.executeUploadCommand(arrayList);
    }

    private final /* synthetic */ void this() {
        this.useThisProgrammer = "";
    }

    public AvrdudeUploader() {
        this.this();
    }
}

