/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Sketchbook;
import processing.app.Target;

public class ExportFolder {
    static JFileChooser fc;
    Editor editor;

    public void show() {
        if (fc.showOpenDialog(new JDialog()) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        Vector vector = new Vector();
        try {
            this.addSketches(vector, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        boolean bl = true;
        int n = 0;
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.editor.message("Exporting sketch " + ++n + " of " + vector.size());
                String string = (String)enumeration.nextElement();
                this.editor.handleOpen(string);
                bl = this.editor.sketch.exportApplet(new Target(System.getProperty("user.dir") + File.separator + "hardware" + File.separator + "cores", Preferences.get("boards." + Preferences.get("board") + ".build.core")));
                if (bl) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.editor.error(exception);
            bl = false;
        }
        if (bl) {
            this.editor.message("Done exporting.");
        }
    }

    protected void addSketches(Vector vector, File file) throws IOException {
        if (!file.isDirectory()) {
            return;
        }
        System.out.println(file.getAbsolutePath());
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '.') {
                File file2 = new File(file, stringArray[n]);
                File file3 = new File(file2, stringArray[n] + ".pde");
                if (file3.exists()) {
                    vector.add(file3.getAbsolutePath());
                } else if (file2.isDirectory()) {
                    this.addSketches(vector, file2);
                }
            }
            ++n;
        }
    }

    public ExportFolder(Editor editor) {
        this.editor = editor;
        if (fc == null) {
            fc = new JFileChooser();
            fc.setSelectedFile(new File(Sketchbook.getSketchbookPath()));
            fc.setFileSelectionMode(1);
        }
    }
}

