/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import processing.app.EditorLineStatus;
import processing.app.EditorListener;
import processing.app.syntax.InputHandler;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.TextUtilities;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JEditTextArea
extends JComponent {
    public static String LEFT_OF_SCROLLBAR = "los";
    protected static String CENTER = "center";
    protected static String RIGHT = "right";
    protected static String BOTTOM = "bottom";
    protected static JEditTextArea focusedComponent;
    protected static Timer caretTimer;
    public EditorListener editorListener;
    public EditorLineStatus editorLineStatus;
    protected TextAreaPainter painter;
    protected JPopupMenu popup;
    protected EventListenerList eventListenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected InputHandler inputHandler;
    protected SyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    protected boolean rectSelect;
    static /* synthetic */ Class class$javax$swing$event$CaretListener;

    public int getScrollPosition() {
        return this.vertical.getValue();
    }

    public void setScrollPosition(int n) {
        this.vertical.setValue(n);
    }

    public final boolean isManagingFocus() {
        return true;
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean bl) {
        this.caretBlinks = bl;
        if (!bl) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public final boolean isCaretVisible() {
        boolean bl = false;
        if ((!this.caretBlinks || this.blink) && this.caretVisible) {
            bl = true;
        }
        return bl;
    }

    public void setCaretVisible(boolean bl) {
        this.caretVisible = bl;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink ^= true;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int n) {
        this.electricScroll = n;
    }

    public void updateScrollBars() {
        if (this.vertical != null && this.visibleLines != 0) {
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(this.visibleLines);
        }
        if (this.horizontal != null && this.painter.getWidth() != 0) {
            int n;
            int n2 = this.horizontal.getValue();
            int n3 = this.getLineCount();
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                n = this.getLineLength(n5);
                if (n > n4) {
                    n4 = n;
                }
                ++n5;
            }
            n5 = this.painter.getFontMetrics().charWidth('w');
            n = n4 * n5;
            int n6 = this.painter.getWidth();
            this.horizontal.setValues(-this.horizontalOffset, n6, 0, n);
            this.horizontal.setUnitIncrement(n5);
            this.horizontal.setBlockIncrement(n / 2);
        }
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int n) {
        if (n == this.firstLine) {
            return;
        }
        int n2 = this.firstLine;
        this.firstLine = n;
        if (n != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int n = this.painter.getHeight();
        int n2 = this.painter.getFontMetrics().getHeight();
        int n3 = this.visibleLines;
        this.visibleLines = n / n2;
        this.updateScrollBars();
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int n) {
        if (n == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = n;
        if (n != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public boolean setOrigin(int n, int n2) {
        boolean bl = false;
        int n3 = this.firstLine;
        if (n2 != this.horizontalOffset) {
            this.horizontalOffset = n2;
            bl = true;
        }
        if (n != this.firstLine) {
            this.firstLine = n;
            bl = true;
        }
        if (bl) {
            this.updateScrollBars();
            this.painter.repaint();
        }
        return bl;
    }

    public boolean scrollToCaret() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = Math.max(0, Math.min(this.getLineLength(n) - 1, this.getCaretPosition() - n2));
        return this.scrollTo(n, n3);
    }

    public boolean scrollTo(int n, int n2) {
        if (this.visibleLines == 0) {
            this.setFirstLine(Math.max(0, n - this.electricScroll));
            return true;
        }
        int n3 = this.firstLine;
        int n4 = this.horizontalOffset;
        if (n < this.firstLine + this.electricScroll) {
            n3 = Math.max(0, n - this.electricScroll);
        } else if (n + this.electricScroll >= this.firstLine + this.visibleLines) {
            n3 = n - this.visibleLines + this.electricScroll + 1;
            if (n3 + this.visibleLines >= this.getLineCount()) {
                n3 = this.getLineCount() - this.visibleLines;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        }
        int n5 = this._offsetToX(n, n2);
        int n6 = this.painter.getFontMetrics().charWidth('w');
        if (n5 < 0) {
            n4 = Math.min(0, this.horizontalOffset - n5 + n6 + 5);
        } else if (n5 + n6 >= this.painter.getWidth()) {
            n4 = this.horizontalOffset + (this.painter.getWidth() - n5) - n6 - 5;
        }
        return this.setOrigin(n3, n4);
    }

    public int lineToY(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        return (n - this.firstLine) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    public int yToLine(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, n / n2 + this.firstLine));
    }

    public final int offsetToX(int n, int n2) {
        this.painter.currentLineTokens = null;
        return this._offsetToX(n, n2);
    }

    public int _offsetToX(int n, int n2) {
        Token token;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        this.getLineText(n, this.lineSegment);
        int n3 = this.lineSegment.offset;
        int n4 = this.horizontalOffset;
        if (tokenMarker == null) {
            this.lineSegment.count = n2;
            return n4 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
        }
        if (this.painter.currentLineIndex == n && this.painter.currentLineTokens != null) {
            token = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = n;
            token = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n);
        }
        Toolkit toolkit = this.painter.getToolkit();
        Font font = this.painter.getFont();
        SyntaxStyle[] syntaxStyleArray = this.painter.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            fontMetrics = by == 0 ? this.painter.getFontMetrics() : syntaxStyleArray[by].getFontMetrics(font);
            int n5 = token.length;
            if (n2 + n3 < this.lineSegment.offset + n5) {
                this.lineSegment.count = n2 - (this.lineSegment.offset - n3);
                return n4 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
            }
            this.lineSegment.count = n5;
            n4 += Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
            this.lineSegment.offset += n5;
            token = token.next;
        }
        return n4;
    }

    public int xToOffset(int n, int n2) {
        Token token;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        this.getLineText(n, this.lineSegment);
        char[] cArray = this.lineSegment.array;
        int n3 = this.lineSegment.offset;
        int n4 = this.lineSegment.count;
        int n5 = this.horizontalOffset;
        if (tokenMarker == null) {
            int n6 = 0;
            while (n6 < n4) {
                char c = cArray[n6 + n3];
                int n7 = c == '\t' ? (int)this.painter.nextTabStop(n5, n6) - n5 : fontMetrics.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? n2 - n7 <= n5 : n2 - n7 / 2 <= n5) {
                    return n6;
                }
                n5 += n7;
                ++n6;
            }
            return n4;
        }
        if (this.painter.currentLineIndex == n && this.painter.currentLineTokens != null) {
            token = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = n;
            token = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n);
        }
        int n8 = 0;
        Toolkit toolkit = this.painter.getToolkit();
        Font font = this.painter.getFont();
        SyntaxStyle[] syntaxStyleArray = this.painter.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            fontMetrics = by == 0 ? this.painter.getFontMetrics() : syntaxStyleArray[by].getFontMetrics(font);
            int n9 = token.length;
            int n10 = 0;
            while (n10 < n9) {
                char c = cArray[n3 + n8 + n10];
                int n11 = c == '\t' ? (int)this.painter.nextTabStop(n5, n8 + n10) - n5 : fontMetrics.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? n2 - n11 <= n5 : n2 - n11 / 2 <= n5) {
                    return n8 + n10;
                }
                n5 += n11;
                ++n10;
            }
            n8 += n9;
            token = token.next;
        }
        return n8;
    }

    public int xyToOffset(int n, int n2) {
        int n3 = this.yToLine(n2);
        int n4 = this.getLineStartOffset(n3);
        return n4 + this.xToOffset(n3, n);
    }

    public final SyntaxDocument getDocument() {
        return this.document;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        if (this.document == syntaxDocument) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = syntaxDocument;
        syntaxDocument.addDocumentListener(this.documentHandler);
        this.select(0, 0);
        this.updateScrollBars();
        this.painter.repaint();
    }

    public void setDocument(SyntaxDocument syntaxDocument, int n, int n2, int n3) {
        if (this.document == syntaxDocument) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = syntaxDocument;
        syntaxDocument.addDocumentListener(this.documentHandler);
        this.select(n, n2);
        this.updateScrollBars();
        this.setScrollPosition(n3);
        this.painter.repaint();
    }

    public final TokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int n) {
        return this.document.getDefaultRootElement().getElementIndex(n);
    }

    public int getLineStartOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getStartOffset();
    }

    public int getLineEndOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset();
    }

    public int getLineLength(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset() - element.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setText(String string) {
        try {
            try {
                this.document.beginCompoundEdit();
                this.document.remove(0, this.document.getLength());
                this.document.insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.document.endCompoundEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.document.endCompoundEdit();
            return;
        }
    }

    public final String getText(int n, int n2) {
        try {
            return this.document.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public final void getText(int n, int n2, Segment segment) {
        try {
            this.document.getText(n, n2, segment);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int n) {
        int n2 = this.getLineStartOffset(n);
        return this.getText(n2, this.getLineEndOffset(n) - n2 - 1);
    }

    public final void getLineText(int n, Segment segment) {
        int n2 = this.getLineStartOffset(n);
        this.getText(n2, this.getLineEndOffset(n) - n2 - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int n) {
        if (n == this.selectionStartLine) {
            return this.selectionStart;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n2 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - 1;
            return Math.min(n4, n3 + n2);
        }
        return this.getLineStartOffset(n);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final void setSelectionStart(int n) {
        this.select(n, this.selectionEnd);
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionEnd(int n) {
        if (n == this.selectionEndLine) {
            return this.selectionEnd;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n2 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - 1;
            return Math.min(n4, n3 + n2);
        }
        return this.getLineEndOffset(n) - 1;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    public final void setSelectionEnd(int n) {
        this.select(this.selectionStart, n);
    }

    public final boolean isSelectionActive() {
        boolean bl = false;
        if (this.selectionStart != this.selectionEnd) {
            bl = true;
        }
        return bl;
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final void setCaretPosition(int n) {
        this.select(n, n);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    public void select(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        if (n <= n2) {
            n4 = n;
            n3 = n2;
            bl = false;
        } else {
            n4 = n2;
            n3 = n;
            bl = true;
        }
        if (n4 < 0 || n3 > this.getDocumentLength()) {
            throw new IllegalArgumentException("Bounds out of range: " + n4 + ',' + n3);
        }
        if (n4 != this.selectionStart || n3 != this.selectionEnd || bl != this.biasLeft) {
            int n5 = this.getLineOfOffset(n4);
            int n6 = this.getLineOfOffset(n3);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(n2);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
            }
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(n5, n6);
            this.document.addUndoableEdit(new CaretUndo(this.selectionStart, this.selectionEnd));
            this.selectionStart = n4;
            this.selectionEnd = n3;
            this.selectionStartLine = n5;
            this.selectionEndLine = n6;
            this.biasLeft = bl;
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        if (this.selectionStart == this.selectionEnd) {
            this.rectSelect = false;
        }
        this.magicCaret = -1;
        this.scrollToCaret();
        if (this.editorLineStatus != null) {
            this.editorLineStatus.set(this.selectionStartLine, this.selectionEndLine);
        }
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            int n2 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            if (n2 < n) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Segment segment = new Segment();
            int n4 = this.selectionStartLine;
            while (n4 <= this.selectionEndLine) {
                Element element2 = element.getElement(n4);
                int n5 = element2.getStartOffset();
                int n6 = element2.getEndOffset() - 1;
                int n7 = n6 - n5;
                n5 = Math.min(n5 + n, n6);
                n7 = Math.min(n2 - n, n6 - n5);
                this.getText(n5, n7, segment);
                stringBuffer.append(segment.array, segment.offset, segment.count);
                if (n4 != this.selectionEndLine) {
                    stringBuffer.append('\n');
                }
                ++n4;
            }
            return stringBuffer.toString();
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSelectedText(String var1_1) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        this.document.beginCompoundEdit();
        try {
            try {
                block12: {
                    if (!this.rectSelect) break block12;
                    var4_2 = this.document.getDefaultRootElement();
                    var5_4 = this.selectionStart - var4_2.getElement(this.selectionStartLine).getStartOffset();
                    var6_5 = this.selectionEnd - var4_2.getElement(this.selectionEndLine).getStartOffset();
                    if (var6_5 < var5_4) {
                        var7_6 = var6_5;
                        var6_5 = var5_4;
                        var5_4 = var7_6;
                    }
                    var7_6 = 0;
                    var8_7 = 0;
                    var9_8 = this.selectionStartLine;
                    while (true) {
                        block13: {
                            if (var9_8 <= this.selectionEndLine) break block13;
                            if (var1_1 != null && var8_7 != var1_1.length()) {
                                var9_8 = var4_2.getElement(this.selectionEndLine).getEndOffset() - 1;
                                this.document.insertString(var9_8, "\n", null);
                                this.document.insertString(var9_8 + 1, var1_1.substring(var8_7 + 1), null);
                            }
                            ** GOTO lbl-1000
                        }
                        var10_9 = var4_2.getElement(var9_8);
                        var11_10 = var10_9.getStartOffset();
                        var12_11 = var10_9.getEndOffset() - 1;
                        var13_12 = Math.min(var12_11, var11_10 + var5_4);
                        this.document.remove(var13_12, Math.min(var12_11 - var13_12, var6_5 - var5_4));
                        if (var1_1 != null) {
                            var8_7 = var1_1.indexOf(10, var7_6);
                            if (var8_7 == -1) {
                                var8_7 = var1_1.length();
                            }
                            this.document.insertString(var13_12, var1_1.substring(var7_6, var8_7), null);
                            var7_6 = Math.min(var1_1.length(), var8_7 + 1);
                        }
                        ++var9_8;
                    }
                }
                this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                if (var1_1 != null) {
                    this.document.insertString(this.selectionStart, var1_1, null);
                }
            }
            catch (BadLocationException var4_3) {
                var4_3.printStackTrace();
                throw new InternalError("Cannot replace selection");
            }
        }
        catch (Throwable var2_13) {
            var3_14 = null;
            this.document.endCompoundEdit();
            throw var2_13;
        }
lbl-1000:
        // 2 sources

        {
            var3_15 = null;
            this.document.endCompoundEdit();
            this.setCaretPosition(this.selectionEnd);
            return;
        }
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int n) {
        this.magicCaret = n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void overwriteSetSelectedText(String string) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(string);
            return;
        }
        int n = this.getCaretPosition();
        int n2 = this.getLineEndOffset(this.getCaretLine());
        if (n2 - n <= string.length()) {
            this.setSelectedText(string);
            return;
        }
        this.document.beginCompoundEdit();
        try {
            try {
                this.document.remove(n, string.length());
                this.document.insertString(n, string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.document.endCompoundEdit();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.document.endCompoundEdit();
            return;
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        this.overwrite = bl;
        this.painter.invalidateSelectedLines();
    }

    public final boolean isSelectionRectangular() {
        return this.rectSelect;
    }

    public final void setSelectionRectangular(boolean bl) {
        this.rectSelect = bl;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void addCaretListener(CaretListener caretListener) {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JEditTextArea.class("[Ljavax.swing.event.CaretListener;", false);
        }
        this.eventListenerList.add(clazz, caretListener);
    }

    public final void removeCaretListener(CaretListener caretListener) {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JEditTextArea.class("[Ljavax.swing.event.CaretListener;", false);
        }
        this.eventListenerList.remove(clazz, caretListener);
    }

    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String string = this.getSelectedText();
            int n = this.inputHandler.getRepeatCount();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(string);
                ++n2;
            }
            clipboard.setContents(new StringSelection(stringBuffer.toString()), null);
        }
    }

    public void paste() {
        if (this.editable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                String string = ((String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
                string = string.replace('\u00a0', ' ');
                int n = this.inputHandler.getRepeatCount();
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(string);
                    ++n2;
                }
                string = stringBuffer.toString();
                this.setSelectedText(string);
            }
            catch (Exception exception) {
                this.getToolkit().beep();
                System.err.println("Clipboard does not contain a string");
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (this.inputHandler == null) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                this.inputHandler.keyTyped(keyEvent);
                break;
            }
            case 401: {
                if (this.editorListener == null || this.editorListener.keyPressed(keyEvent)) break;
                this.inputHandler.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.inputHandler.keyReleased(keyEvent);
                break;
            }
        }
    }

    protected void fireCaretEvent() {
        Object[] objectArray = this.eventListenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class clazz = class$javax$swing$event$CaretListener;
            if (clazz == null) {
                clazz = JEditTextArea.class("[Ljavax.swing.event.CaretListener;", false);
            }
            if (object == clazz) {
                ((CaretListener)objectArray[n + 1]).caretUpdate(this.caretEvent);
            }
            --n;
        }
    }

    protected void updateBracketHighlight(int n) {
        if (n == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int n2 = TextUtilities.findMatchingBracket(this.document, n - 1);
            if (n2 != -1) {
                this.bracketLine = this.getLineOfOffset(n2);
                this.bracketPosition = n2 - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(this.document.getDefaultRootElement());
        int n = elementChange == null ? 0 : elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
        int n2 = this.getLineOfOffset(documentEvent.getOffset());
        if (n == 0) {
            this.painter.invalidateLine(n2);
        } else if (n2 < this.firstLine) {
            this.setFirstLine(this.firstLine + n);
        } else {
            this.painter.invalidateLineRange(n2, this.firstLine + this.visibleLines);
            this.updateScrollBars();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JEditTextArea(TextAreaDefaults textAreaDefaults) {
        this.enableEvents(8L);
        this.painter = new TextAreaPainter(this, textAreaDefaults);
        this.documentHandler = new DocumentHandler();
        this.eventListenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        this.setLayout(new ScrollLayout());
        this.add(CENTER, this.painter);
        this.vertical = new JScrollBar(1);
        this.add(RIGHT, this.vertical);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(new DragHandler());
        this.addFocusListener(new FocusHandler());
        this.setInputHandler(textAreaDefaults.inputHandler);
        this.setDocument(textAreaDefaults.document);
        this.editable = textAreaDefaults.editable;
        this.caretVisible = textAreaDefaults.caretVisible;
        this.caretBlinks = textAreaDefaults.caretBlinks;
        this.electricScroll = textAreaDefaults.electricScroll;
        focusedComponent = this;
        this.addMouseWheelListener(new MouseWheelListener(){

            public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (!JEditTextArea.this.scrollBarsInitialized) {
                    return;
                }
                int n = mouseWheelEvent.getWheelRotation();
                JEditTextArea.this.vertical.setValue(JEditTextArea.this.vertical.getValue() + n * 3);
            }
        });
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CaretUndo
    extends AbstractUndoableEdit {
        private int start;
        private int end;

        public boolean isSignificant() {
            return false;
        }

        public String getPresentationName() {
            return "caret move";
        }

        public void undo() throws CannotUndoException {
            super.undo();
            JEditTextArea.this.select(this.start, this.end);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            JEditTextArea.this.select(this.start, this.end);
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof CaretUndo) {
                CaretUndo caretUndo = (CaretUndo)undoableEdit;
                this.start = caretUndo.start;
                this.end = caretUndo.end;
                caretUndo.die();
                return true;
            }
            return false;
        }

        CaretUndo(int n, int n2) {
            this.start = n;
            this.end = n2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DocumentHandler
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            JEditTextArea.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = JEditTextArea.this.selectionStart > n || JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd && JEditTextArea.this.selectionStart == n ? JEditTextArea.this.selectionStart + n2 : JEditTextArea.this.selectionStart;
            int n4 = JEditTextArea.this.selectionEnd >= n ? JEditTextArea.this.selectionEnd + n2 : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(n3, n4);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JEditTextArea.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = JEditTextArea.this.selectionStart > n ? (JEditTextArea.this.selectionStart > n + n2 ? JEditTextArea.this.selectionStart - n2 : n) : JEditTextArea.this.selectionStart;
            int n4 = JEditTextArea.this.selectionEnd > n ? (JEditTextArea.this.selectionEnd > n + n2 ? JEditTextArea.this.selectionEnd - n2 : n) : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(n3, n4);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        DocumentHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MutableCaretEvent
    extends CaretEvent {
        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }

        MutableCaretEvent() {
            super(JEditTextArea.this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ScrollLayout
    implements LayoutManager {
        private Component center;
        private Component right;
        private Component bottom;
        private Vector leftOfScrollBar;

        public void addLayoutComponent(String string, Component component) {
            if (string.equals(CENTER)) {
                this.center = component;
            } else if (string.equals(RIGHT)) {
                this.right = component;
            } else if (string.equals(BOTTOM)) {
                this.bottom = component;
            } else if (string.equals(LEFT_OF_SCROLLBAR)) {
                this.leftOfScrollBar.addElement(component);
            }
        }

        public void removeLayoutComponent(Component component) {
            if (this.center == component) {
                this.center = null;
            }
            if (this.right == component) {
                this.right = null;
            }
            if (this.bottom == component) {
                this.bottom = null;
            } else {
                this.leftOfScrollBar.removeElement(component);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.center.getPreferredSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            Dimension dimension3 = this.right.getPreferredSize();
            dimension.width += dimension3.width;
            Dimension dimension4 = this.bottom.getPreferredSize();
            dimension.height += dimension4.height;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.center.getMinimumSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            Dimension dimension3 = this.right.getMinimumSize();
            dimension.width += dimension3.width;
            Dimension dimension4 = this.bottom.getMinimumSize();
            dimension.height += dimension4.height;
            dimension.height += 5;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = insets.left;
            int n3 = insets.bottom;
            int n4 = insets.right;
            int n5 = this.right.getPreferredSize().width;
            int n6 = this.bottom.getPreferredSize().height;
            int n7 = dimension.width - n5 - n2 - n4;
            int n8 = dimension.height - n6 - n - n3;
            this.center.setBounds(n2, n, n7, n8);
            this.right.setBounds(n2 + n7, n, n5, n8);
            Enumeration enumeration = this.leftOfScrollBar.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                Dimension dimension2 = component.getPreferredSize();
                component.setBounds(n2, n + n8, dimension2.width, n6);
                n2 += dimension2.width;
            }
            this.bottom.setBounds(n2, n + n8, dimension.width - n5 - n2 - n4, n6);
        }

        private final /* synthetic */ void this() {
            this.leftOfScrollBar = new Vector();
        }

        ScrollLayout() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AdjustHandler
    implements AdjustmentListener {
        public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    if (adjustmentEvent.getAdjustable() == JEditTextArea.this.vertical) {
                        JEditTextArea.this.setFirstLine(JEditTextArea.this.vertical.getValue());
                    } else {
                        JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.horizontal.getValue());
                    }
                }
            });
        }

        AdjustHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ComponentHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            JEditTextArea.this.recalculateVisibleLines();
            JEditTextArea.this.scrollBarsInitialized = true;
        }

        ComponentHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            JEditTextArea.this.requestFocus();
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
            boolean bl2 = false;
            if ((mouseEvent.getModifiers() & 4) != 0) {
                bl2 = true;
            }
            if (!(bl = bl2) && mouseEvent.isPopupTrigger()) {
                bl = true;
            }
            if (bl && JEditTextArea.this.popup != null) {
                JEditTextArea.this.popup.show(JEditTextArea.this.painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            int n = JEditTextArea.this.yToLine(mouseEvent.getY());
            int n2 = JEditTextArea.this.xToOffset(n, mouseEvent.getX());
            int n3 = JEditTextArea.this.getLineStartOffset(n) + n2;
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    this.doSingleClick(mouseEvent, n, n2, n3);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(mouseEvent, n, n2, n3);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(mouseEvent, n, n2, n3);
                    break;
                }
            }
        }

        private final void doSingleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            if ((mouseEvent.getModifiers() & 1) != 0) {
                boolean bl = false;
                if ((mouseEvent.getModifiers() & 2) != 0) {
                    bl = true;
                }
                JEditTextArea.this.rectSelect = bl;
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), n3);
            } else {
                JEditTextArea.this.setCaretPosition(n3);
            }
        }

        private final void doDoubleClick(MouseEvent mouseEvent, int n, int n2, int n3) throws BadLocationException {
            if (JEditTextArea.this.getLineLength(n) == 0) {
                return;
            }
            try {
                int n4 = TextUtilities.findMatchingBracket(JEditTextArea.this.document, Math.max(0, n3 - 1));
                if (n4 != -1) {
                    int n5 = JEditTextArea.this.getMarkPosition();
                    if (n4 > n5) {
                        ++n4;
                        --n5;
                    }
                    JEditTextArea.this.select(n5, n4);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            String string = (String)JEditTextArea.this.document.getProperty("noWordSep");
            if (string == null) {
                string = "";
            }
            String string2 = JEditTextArea.this.getLineText(n);
            int n6 = 0;
            int n7 = string2.length();
            char c = string2.charAt(Math.max(0, n2 - 1));
            boolean bl = false;
            if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
                bl = true;
            }
            boolean bl2 = bl;
            int n8 = n2 - 1;
            while (n8 >= 0) {
                c = string2.charAt(n8);
                boolean bl3 = false;
                if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
                    bl3 = true;
                }
                if (bl2 != bl3) {
                    n6 = n8 + 1;
                    break;
                }
                --n8;
            }
            n8 = n2;
            while (n8 < string2.length()) {
                c = string2.charAt(n8);
                boolean bl4 = false;
                if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
                    bl4 = true;
                }
                if (bl2 != bl4) {
                    n7 = n8;
                    break;
                }
                ++n8;
            }
            n8 = JEditTextArea.this.getLineStartOffset(n);
            JEditTextArea.this.select(n8 + n6, n8 + n7);
        }

        private final void doTripleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(n), JEditTextArea.this.getLineEndOffset(n) - 1);
        }

        MouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DragHandler
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            boolean bl = false;
            if ((mouseEvent.getModifiers() & 2) != 0) {
                bl = true;
            }
            JEditTextArea.this.setSelectionRectangular(bl);
            JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY()));
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        DragHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
        }

        public void focusLost(FocusEvent focusEvent) {
            JEditTextArea.this.setCaretVisible(false);
            focusedComponent = null;
        }

        FocusHandler() {
        }
    }

    static class CaretBlinker
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }

        CaretBlinker() {
        }
    }
}

