/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private final synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.start();
        }
    }

    public SwingWorker() {
        final Runnable runnable = new Runnable(){

            public final void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    SwingWorker.this.threadVar.clear();
                    throw throwable;
                }
                {
                    Object var2_3 = null;
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        Thread thread = new Thread(runnable2);
        this.threadVar = new ThreadVar(thread);
    }

    private static class ThreadVar {
        private Thread thread;

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }

        ThreadVar(Thread thread) {
            this.thread = thread;
        }
    }
}

