/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import processing.app.Preferences;
import processing.app.SerialException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Serial
implements SerialPortEventListener {
    SerialPort port;
    int rate;
    int parity;
    int databits;
    int stopbits;
    boolean monitor;
    InputStream input;
    OutputStream output;
    byte[] buffer;
    int bufferIndex;
    int bufferLast;

    public void setup() {
    }

    public void dispose() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.input = null;
        this.output = null;
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.port = null;
    }

    /*
     * Exception decompiling
     */
    public synchronized void serialEvent(SerialPortEvent var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 24->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return (char)-1;
        }
        return (char)this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readBytes(byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            if (n > byArray.length) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex += n;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readBytesUntil(int n) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte by = (byte)n;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2 = -1;
            int n3 = this.bufferIndex;
            while (n3 < this.bufferLast) {
                if (this.buffer[n3] == by) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 == -1) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            n3 = n2 - this.bufferIndex + 1;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n3);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readBytesUntil(int n, byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte by = (byte)n;
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n2 = -1;
            int n3 = this.bufferIndex;
            while (n3 < this.bufferLast) {
                if (this.buffer[n3] == by) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 == -1) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return 0;
            }
            n3 = n2 - this.bufferIndex + 1;
            if (n3 > byArray.length) {
                System.err.println("readBytesUntil() byte buffer is too small for the " + n3 + " bytes up to and including char " + n);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n3);
            this.bufferIndex += n3;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n3;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public void write(int n) {
        try {
            this.output.write(n & 0xFF);
            this.output.flush();
        }
        catch (Exception exception) {
            Serial.errorMessage("write", exception);
        }
    }

    public void write(byte[] byArray) {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }

    public void setDTR(boolean bl) {
        this.port.setDTR(bl);
    }

    public static String[] list() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = CommPortIdentifier.getPortIdentifiers();
            while (objectArray.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)objectArray.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                String string = commPortIdentifier.getName();
                vector.addElement(string);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Serial.errorMessage("ports", unsatisfiedLinkError);
        }
        catch (Exception exception) {
            Serial.errorMessage("ports", exception);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void errorMessage(String string, Throwable throwable) {
        System.err.println("Error inside Serial." + string + "()");
        throwable.printStackTrace();
    }

    private final /* synthetic */ void this() {
        this.monitor = false;
        this.buffer = new byte[32768];
    }

    public Serial(boolean bl) throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
        this.monitor = bl;
    }

    public Serial() throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(int n) throws SerialException {
        this(Preferences.get("serial.port"), n, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String string, int n) throws SerialException {
        this(string, n, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String string) throws SerialException {
        this(string, Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String string, int n, char c, int n2, float f) throws SerialException {
        this.this();
        this.rate = n;
        this.parity = 0;
        if (c == 'E') {
            this.parity = 2;
        }
        if (c == 'O') {
            this.parity = 1;
        }
        this.databits = n2;
        this.stopbits = 1;
        if (f == 1.5f) {
            this.stopbits = 3;
        }
        if (f == 2.0f) {
            this.stopbits = 2;
        }
        try {
            this.port = null;
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals(string)) continue;
                this.port = (SerialPort)commPortIdentifier.open("serial madness", 2000);
                this.input = this.port.getInputStream();
                this.output = this.port.getOutputStream();
                this.port.setSerialPortParams(this.rate, this.databits, this.stopbits, this.parity);
                this.port.addEventListener((SerialPortEventListener)this);
                this.port.notifyOnDataAvailable(true);
            }
        }
        catch (PortInUseException portInUseException) {
            throw new SerialException("Serial port '" + string + "' already in use.  Try quiting any programs that may be using it.");
        }
        catch (Exception exception) {
            throw new SerialException("Error opening serial port '" + string + "'.", exception);
        }
        if (this.port == null) {
            throw new SerialException("Serial port '" + string + "' not found.  Did you select the right one from the Tools > Serial Port menu?");
        }
    }
}

