/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;

public class Preferences {
    static final String PREFS_FILE = "preferences.txt";
    static final String[] platforms = new String[]{"other", "windows", "macos9", "macosx", "linux"};
    static final String PROMPT_YES = "Yes";
    static final String PROMPT_NO = "No";
    static final String PROMPT_CANCEL = "Cancel";
    static final String PROMPT_OK = "OK";
    static final String PROMPT_SEND = "Send";
    static final String PROMPT_BROWSE = "Browse";
    public static int BUTTON_WIDTH = 76;
    public static int BUTTON_HEIGHT = 24;
    static final int GRID_SIZE = 33;
    static final int GUI_BIG = 13;
    static final int GUI_BETWEEN = 10;
    static final int GUI_SMALL = 6;
    static Hashtable table = new Hashtable();
    static Hashtable prefixes = new Hashtable();
    static File preferencesFile;
    JFrame dialog = new JFrame("Preferences");
    int wide;
    int high;
    JTextField sketchbookLocationField;
    JCheckBox exportSeparateBox;
    JCheckBox sketchPromptBox;
    JCheckBox sketchCleanBox;
    JCheckBox externalEditorBox;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JTextField fontSizeField;
    Editor editor;

    public static void init() {
        try {
            Preferences.load(Base.getStream(PREFS_FILE));
        }
        catch (Exception exception) {
            Base.showError(null, "Could not read default settings.\nYou'll need to reinstall Arduino.", exception);
        }
        String string = "." + platforms[PApplet.platform];
        int n = string.length();
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.endsWith(string)) continue;
            String string3 = string2.substring(0, string2.length() - n);
            String string4 = Preferences.get(string2);
            table.put(string3, string4);
        }
        Preferences.setColor("run.window.bgcolor", SystemColor.control);
        preferencesFile = Base.getSettingsFile(PREFS_FILE);
        if (!preferencesFile.exists()) {
            Preferences.save();
        } else {
            try {
                Preferences.load(new FileInputStream(preferencesFile));
            }
            catch (Exception exception) {
                Base.showError("Error reading preferences", "Error reading the preferences file. Please delete (or move)\n" + preferencesFile.getAbsolutePath() + " and restart Arduino.", exception);
            }
        }
        try {
            Preferences.load(new FileInputStream(new File(System.getProperty("user.dir") + File.separator + "hardware" + File.separator + "boards.txt")), "boards");
        }
        catch (Exception exception) {
            Base.showError("Error reading board definitions", "Error reading the board definitions file. Please re-download or re-unzip Arduino.\n", exception);
        }
        try {
            Preferences.load(new FileInputStream(new File(System.getProperty("user.dir") + File.separator + "hardware" + File.separator + "programmers.txt")), "programmers");
        }
        catch (Exception exception) {
            Base.showError("Error reading programmers definitions", "Error reading the programmers definitions file. Please re-download or re-unzip Arduino.\n", exception);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.wide, this.high);
    }

    public void disposeFrame() {
        this.dialog.dispose();
    }

    public void applyFrame() {
        Preferences.setBoolean("sketchbook.prompt", this.sketchPromptBox.isSelected());
        Preferences.setBoolean("sketchbook.auto_clean", this.sketchCleanBox.isSelected());
        Preferences.set("sketchbook.path", this.sketchbookLocationField.getText());
        Preferences.setBoolean("editor.external", this.externalEditorBox.isSelected());
        Preferences.setBoolean("update.check", this.checkUpdatesBox.isSelected());
        String string = this.fontSizeField.getText();
        try {
            int n = Integer.parseInt(string.trim());
            String[] stringArray = PApplet.split(Preferences.get("editor.font"), ',');
            stringArray[2] = String.valueOf(n);
            Preferences.set("editor.font", PApplet.join(stringArray, ','));
        }
        catch (Exception exception) {
            System.err.println("ignoring invalid font size " + string);
        }
        this.editor.applyPreferences();
    }

    public void showFrame(Editor editor) {
        this.editor = editor;
        this.sketchPromptBox.setSelected(Preferences.getBoolean("sketchbook.prompt"));
        this.sketchCleanBox.setSelected(Preferences.getBoolean("sketchbook.auto_clean"));
        this.sketchbookLocationField.setText(Preferences.get("sketchbook.path"));
        this.externalEditorBox.setSelected(Preferences.getBoolean("editor.external"));
        this.checkUpdatesBox.setSelected(Preferences.getBoolean("update.check"));
        this.dialog.show();
    }

    public static void load(InputStream inputStream) throws IOException {
        Preferences.load(inputStream, null);
    }

    public static void load(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Hashtable<String, String> hashtable = table;
        if (string != null) {
            hashtable = new Hashtable<String, String>();
            prefixes.put(string, hashtable);
        }
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            if (string2.length() == 0 || string2.charAt(0) == '#' || (n = string2.indexOf(61)) == -1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            hashtable.put(string3, string4);
        }
        bufferedReader.close();
    }

    public static void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(preferencesFile);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileOutputStream));
            Enumeration enumeration = table.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                printWriter.println(string + '=' + (String)table.get(string));
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            Base.showWarning(null, "Error while saving the settings file", iOException);
        }
    }

    public static String get(String string) {
        String string2;
        Hashtable hashtable = table;
        if (string.indexOf(46) != -1 && prefixes.containsKey(string2 = string.substring(0, string.indexOf(46)))) {
            hashtable = (Hashtable)prefixes.get(string2);
            string = string.substring(string.indexOf(46) + 1);
        }
        return (String)hashtable.get(string);
    }

    public static Iterator getSubKeys(String string) {
        if (!prefixes.containsKey(string)) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = ((Hashtable)prefixes.get(string)).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(46) != -1) {
                string2 = string2.substring(0, string2.indexOf(46));
            }
            hashSet.add(string2);
        }
        return hashSet.iterator();
    }

    public static void set(String string, String string2) {
        table.put(string, string2);
    }

    public static boolean getBoolean(String string) {
        String string2 = Preferences.get(string);
        return new Boolean(string2);
    }

    public static void setBoolean(String string, boolean bl) {
        Preferences.set(string, bl ? "true" : "false");
    }

    public static int getInteger(String string) {
        return Integer.parseInt(Preferences.get(string));
    }

    public static void setInteger(String string, int n) {
        Preferences.set(string, String.valueOf(n));
    }

    public static Color getColor(String string) {
        Color color = null;
        String string2 = Preferences.get(string);
        if (string2 != null && string2.indexOf("#") == 0) {
            try {
                int n = Integer.parseInt(string2.substring(1), 16);
                color = new Color(n);
            }
            catch (Exception exception) {}
        }
        return color;
    }

    public static void setColor(String string, Color color) {
        String string2 = Integer.toHexString(color.getRed());
        String string3 = Integer.toHexString(color.getGreen());
        String string4 = Integer.toHexString(color.getBlue());
        Preferences.set(string, "#" + string2.substring(string2.length() - 2) + string3.substring(string3.length() - 2) + string4.substring(string4.length() - 2));
    }

    public static Font getFont(String string) {
        String string2 = Preferences.get(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        int n = 0;
        if (string4.indexOf("bold") != -1) {
            n = 1;
        }
        return new Font(string3, n | (string4.indexOf("italic") != -1 ? 2 : 0), Integer.parseInt(stringTokenizer.nextToken()));
    }

    public static SyntaxStyle getStyle(String string) {
        String string2 = Preferences.get("editor." + string + ".style");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = stringTokenizer.nextToken();
        if (string3.indexOf("#") == 0) {
            string3 = string3.substring(1);
        }
        Color color = new Color(Integer.parseInt(string3, 16));
        string3 = stringTokenizer.nextToken();
        boolean bl = false;
        if (string3.indexOf("bold") != -1) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (string3.indexOf("italic") != -1) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        return new SyntaxStyle(color, bl4, bl2);
    }

    public Preferences() {
        this.dialog.setResizable(false);
        Container container = this.dialog.getContentPane();
        container.setLayout(null);
        int n = 13;
        int n2 = 13;
        int n3 = 0;
        this.sketchPromptBox = new JCheckBox("Prompt for name when opening or creating a sketch");
        container.add(this.sketchPromptBox);
        Dimension dimension = this.sketchPromptBox.getPreferredSize();
        this.sketchPromptBox.setBounds(n2, n, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        this.sketchCleanBox = new JCheckBox("Delete empty sketches on Quit");
        container.add(this.sketchCleanBox);
        dimension = this.sketchCleanBox.getPreferredSize();
        this.sketchCleanBox.setBounds(n2, n += dimension.height + 10, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        JLabel jLabel = new JLabel("Sketchbook location:");
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setBounds(n2, n += dimension.height + 10, dimension.width, dimension.height);
        n += dimension.height;
        this.sketchbookLocationField = new JTextField(40);
        container.add(this.sketchbookLocationField);
        dimension = this.sketchbookLocationField.getPreferredSize();
        JButton jButton = new JButton(PROMPT_BROWSE);
        jButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                File file = new File(Preferences.this.sketchbookLocationField.getText());
                File file2 = Base.selectFolder("Select new sketchbook location", file, Preferences.this.dialog);
                if (file2 != null) {
                    Preferences.this.sketchbookLocationField.setText(file2.getAbsolutePath());
                }
            }
        });
        container.add(jButton);
        Dimension dimension2 = jButton.getPreferredSize();
        int n4 = Math.max(dimension.height, dimension2.height);
        this.sketchbookLocationField.setBounds(n2, n + (n4 - dimension.height) / 2, dimension.width, dimension.height);
        int n5 = n2 + dimension.width + 6;
        jButton.setBounds(n5, n + (n4 - dimension2.height) / 2, dimension2.width, dimension2.height);
        n3 = Math.max(n3, n5 + dimension2.width + 13);
        n += n4 + 10;
        Box box = Box.createHorizontalBox();
        jLabel = new JLabel("Editor font size: ");
        box.add(jLabel);
        this.fontSizeField = new JTextField(4);
        box.add(this.fontSizeField);
        jLabel = new JLabel("  (requires restart of Arduino)");
        box.add(jLabel);
        container.add(box);
        dimension = ((Container)box).getPreferredSize();
        box.setBounds(n2, n, dimension.width, dimension.height);
        Font font = Preferences.getFont("editor.font");
        this.fontSizeField.setText(String.valueOf(font.getSize()));
        this.externalEditorBox = new JCheckBox("Use external editor");
        container.add(this.externalEditorBox);
        dimension = this.externalEditorBox.getPreferredSize();
        this.externalEditorBox.setBounds(n2, n += dimension.height + 10, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        this.checkUpdatesBox = new JCheckBox("Check for updates on startup");
        container.add(this.checkUpdatesBox);
        dimension = this.checkUpdatesBox.getPreferredSize();
        this.checkUpdatesBox.setBounds(n2, n += dimension.height + 10, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        n += dimension.height + 10;
        jLabel = new JLabel("More preferences can be edited directly in the file");
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setForeground(Color.gray);
        jLabel.setBounds(n2, n, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        jLabel = new JLabel(preferencesFile.getAbsolutePath());
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setBounds(n2, n += dimension.height, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        n += dimension.height;
        jLabel = new JLabel("(edit only when Arduino is not running)");
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setForeground(Color.gray);
        jLabel.setBounds(n2, n, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        n += dimension.height;
        jButton = new JButton(PROMPT_OK);
        jButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.applyFrame();
                Preferences.this.disposeFrame();
            }
        });
        container.add(jButton);
        dimension2 = jButton.getPreferredSize();
        BUTTON_HEIGHT = dimension2.height;
        n5 = n3 - (BUTTON_WIDTH + 6 + BUTTON_WIDTH);
        jButton.setBounds(n5, n, BUTTON_WIDTH, BUTTON_HEIGHT);
        jButton = new JButton(PROMPT_CANCEL);
        jButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.disposeFrame();
            }
        });
        container.add(jButton);
        jButton.setBounds(n5 += BUTTON_WIDTH + 6, n, BUTTON_WIDTH, BUTTON_HEIGHT);
        this.wide = n3 + 13;
        this.high = (n += BUTTON_HEIGHT + 10) + 6;
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
                Preferences.this.disposeFrame();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.disposeFrame();
            }
        };
        Base.registerWindowCloseKeys(this.dialog.getRootPane(), actionListener);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((dimension3.width - this.wide) / 2, (dimension3.height - this.high) / 2);
        this.dialog.pack();
        Insets insets = this.dialog.getInsets();
        this.dialog.setSize(this.wide + insets.left + insets.right, this.high + insets.top + insets.bottom);
        container.addKeyListener(new KeyAdapter(){

            public final void keyPressed(KeyEvent keyEvent) {
                KeyStroke keyStroke = Editor.WINDOW_CLOSE_KEYSTROKE;
                if (keyEvent.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke)) {
                    Preferences.this.disposeFrame();
                }
            }
        });
    }
}

