/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.app.Base;
import processing.app.MessageConsumer;
import processing.app.MessageSiphon;
import processing.app.Preferences;
import processing.app.RunnerException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LuminetUploader
implements MessageConsumer {
    int rxtimeoutms;
    InputStream input2;
    OutputStream output2;
    byte[] image;
    int imagesize;
    RunnerException exception;

    private final int byte2int(byte by) {
        int n = by & 0x80;
        return n += by & 0x7F;
    }

    private final int byte2int(int n) {
        int n2 = n & 0x80;
        return n2 += n & 0x7F;
    }

    public boolean infectNetwork(String string, String string2) {
        Object object;
        String string3;
        String string4 = string + File.separator + string2 + ".hex";
        String string5 = string + File.separator + string2 + ".bin";
        System.out.println("Converting hex file: " + string4);
        if (Base.isMacOS()) {
            string3 = new String("hardware/tools/avr/bin/");
        } else if (Base.isLinux()) {
            string3 = new String("");
        } else {
            object = System.getProperty("user.dir") + File.separator;
            string3 = new String((String)object + "hardware" + File.separator + "tools" + File.separator + "avr" + File.separator + "bin" + File.separator);
        }
        object = new ArrayList<String>(Arrays.asList(string3 + "avr-objcopy", "-I", "ihex", "-O", "binary", string4, string5));
        try {
            if (this.execAsynchronously((List)object) != 0) {
                System.err.println("Cannot create .bin file");
                return false;
            }
        }
        catch (Exception exception) {
            System.err.println("Error: Exception while creating .bin file");
            return false;
        }
        System.out.println("infecting network, please wait...");
        String string6 = Preferences.get("serial.port");
        try {
            this.upload(string5, string6, 9600, 64, System.out);
        }
        catch (Exception exception) {
            System.err.println("error while uploading");
            return false;
        }
        System.out.println("done.");
        return true;
    }

    private final void upload(String string, String string2, int n, int n2, OutputStream outputStream) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        this.imagesize = (int)new File(string).length();
        this.image = new byte[this.imagesize];
        ((InputStream)bufferedInputStream).read(this.image);
        ((InputStream)bufferedInputStream).close();
        System.out.println(".bin file read into memory: " + this.imagesize + " byes.");
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string2);
        SerialPort serialPort = (SerialPort)commPortIdentifier.open("serial madness2", 4001);
        serialPort.setSerialPortParams(n, 8, 1, 0);
        serialPort.setDTR(false);
        serialPort.disableReceiveThreshold();
        serialPort.disableReceiveTimeout();
        this.input2 = serialPort.getInputStream();
        this.output2 = serialPort.getOutputStream();
        this.output2.write(160);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        System.out.println("START sent. If upload does not start soon, please restart this application and reset the LumiNet network.");
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this.imagesize) {
            n5 = this.byte2int(this.image[n3]);
            ++n3;
            this.output2.write(176);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            this.output2.write(n5);
            while (this.input2.available() == 0) {
            }
            n4 = this.byte2int(this.input2.read());
            while (n4 != n5) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                this.output2.write(177);
                System.out.println("RETRANSMIT: " + n5);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                this.output2.write(n5);
                while (this.input2.available() == 0) {
                }
                n4 = this.byte2int(this.input2.read());
            }
            System.out.print(".");
        }
        this.output2.write(192);
        System.out.println("STOP sent.");
        serialPort.setDTR(true);
        serialPort.close();
    }

    public int execAsynchronously(List list) throws RunnerException, IOException {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        int n = 0;
        if (Preferences.getBoolean("build.verbose")) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                System.out.print(stringArray[n2] + ' ');
                ++n2;
            }
            System.out.println();
        }
        Process process = Runtime.getRuntime().exec(stringArray);
        new MessageSiphon(process.getInputStream(), this);
        new MessageSiphon(process.getErrorStream(), this);
        boolean bl = true;
        while (bl) {
            try {
                n = process.waitFor();
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exception != null) {
            this.exception.hideStackTrace = true;
            throw this.exception;
        }
        return n;
    }

    public void message(String string) {
        System.out.println("message: " + string);
    }

    private final /* synthetic */ void this() {
        this.rxtimeoutms = 10000;
        this.image = new byte[20000];
        this.imagesize = 0;
    }

    public LuminetUploader() {
        this.this();
    }
}

