/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JMenu;
import processing.app.Base;
import processing.app.Library;
import processing.app.Preferences;
import processing.app.RunnerException;
import processing.app.Target;
import processing.app.syntax.PdeKeywords;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LibraryManager {
    private File libDir;
    private List libraries;
    private Target target;

    public Target getTarget() {
        return this.target;
    }

    private final void refreshLibraries() {
        FileFilter fileFilter = new FileFilter(){

            public final boolean accept(File file) {
                return file.isDirectory();
            }
        };
        this.libraries.clear();
        File[] fileArray = this.libDir.listFiles(fileFilter);
        int n = 0;
        while (n < fileArray.length) {
            this.libraries.add(new Library(this, fileArray[n]));
            ++n;
        }
    }

    public Collection getAll() {
        this.refreshLibraries();
        return Collections.unmodifiableList(this.libraries);
    }

    public Collection getBuiltLibraries() {
        this.refreshLibraries();
        ArrayList<Library> arrayList = new ArrayList<Library>();
        ListIterator listIterator = this.libraries.listIterator();
        while (listIterator.hasNext()) {
            Library library = (Library)listIterator.next();
            if (!library.isBuilt()) continue;
            arrayList.add(library);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Collection getLibrariesToBuild() {
        this.refreshLibraries();
        ArrayList<Library> arrayList = new ArrayList<Library>();
        ListIterator listIterator = this.libraries.listIterator();
        while (listIterator.hasNext()) {
            Library library = (Library)listIterator.next();
            if (!library.isUnbuiltBuildable()) continue;
            arrayList.add(library);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public int rebuildAllBuilt() throws RunnerException {
        Collection collection = this.getBuiltLibraries();
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            try {
                if (library.build()) {
                    ++n;
                    continue;
                }
                return -1;
            }
            catch (RunnerException runnerException) {
                throw new RunnerException(runnerException.getMessage());
            }
            catch (Exception exception) {
                throw new RunnerException(exception.toString());
            }
        }
        return n;
    }

    public String[] getObjectFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = this.getBuiltLibraries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            File[] fileArray = library.getObjectFiles();
            int n = 0;
            while (n < fileArray.length) {
                arrayList.add(fileArray[n].getPath());
                ++n;
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getHeaderFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = this.getBuiltLibraries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            File[] fileArray = library.getHeaderFiles();
            int n = 0;
            while (n < fileArray.length) {
                arrayList.add(fileArray[n].getName());
                ++n;
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getFolderPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = this.getAll();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            arrayList.add(library.getFolder().getPath());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public int buildAllUnbuilt() throws RunnerException {
        Collection collection = this.getLibrariesToBuild();
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            try {
                if (library.build()) {
                    ++n;
                    continue;
                }
                return -1;
            }
            catch (RunnerException runnerException) {
                throw new RunnerException(runnerException.getMessage());
            }
            catch (Exception exception) {
                throw new RunnerException(exception.toString());
            }
        }
        return n;
    }

    public void populateExamplesMenu(JMenu jMenu, ActionListener actionListener) {
        Collection collection = this.getBuiltLibraries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            JMenu jMenu2 = library.getExamplesMenu(actionListener);
            if (jMenu2 == null) continue;
            jMenu.add(jMenu2);
        }
    }

    public void addSyntaxColoring(PdeKeywords pdeKeywords) {
        Collection collection = this.getBuiltLibraries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            library.addSyntaxColors(pdeKeywords);
        }
    }

    private final /* synthetic */ void this() {
        this.libraries = new ArrayList();
    }

    public LibraryManager() throws IOException {
        this.this();
        String string = System.getProperty("user.dir") + File.separator;
        this.libDir = new File((!Base.isMacOS() ? "" : string) + "hardware" + File.separator + "libraries");
        this.target = new Target(System.getProperty("user.dir") + File.separator + "hardware" + File.separator + "cores", Preferences.get("boards." + Preferences.get("board") + ".build.core"));
        this.refreshLibraries();
    }
}

