/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import processing.app.Base;
import processing.app.Library;
import processing.app.MessageConsumer;
import processing.app.MessageSiphon;
import processing.app.MessageStream;
import processing.app.Preferences;
import processing.app.RunnerException;
import processing.app.Sketch;
import processing.app.Target;

public class Compiler
implements MessageConsumer {
    static final String BUGS_URL = "https://developer.berlios.de/bugs/?group_id=3590";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to https://developer.berlios.de/bugs/?group_id=3590";
    static String bootClassPath;
    Sketch sketch;
    String buildPath;
    RunnerException exception;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public boolean compile(Sketch sketch, String string, Target target) throws RunnerException {
        Object object;
        Object object2;
        this.sketch = sketch;
        this.buildPath = string;
        MessageStream messageStream = new MessageStream(this);
        String string2 = System.getProperty("user.dir") + File.separator;
        String string3 = Base.isMacOS() ? new String("hardware/tools/avr/bin/") : (Base.isLinux() ? new String("") : new String(string2 + "hardware/tools/avr/bin/"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(target.getPath());
        int n = 0;
        while (n < sketch.importedLibraries.size()) {
            arrayList.add(((Library)sketch.importedLibraries.get(n)).getFolder().getPath());
            ++n;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(string3 + "avr-gcc", "-Os", "-Wl,--gc-sections,--cref", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-o", string + File.separator + sketch.name + ".elf"));
        String string4 = string + File.separator + "core.a";
        ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(string3 + "avr-ar", "rcs", string4));
        Object object3 = sketch.importedLibraries.iterator();
        while (object3.hasNext()) {
            object2 = (Library)object3.next();
            object = ((Library)object2).getObjectFiles();
            int n2 = 0;
            while (n2 < ((File[])object).length) {
                arrayList2.add(object[n2].getPath());
                ++n2;
            }
        }
        object3 = new ArrayList<String>(Arrays.asList(string3 + "avr-objcopy", "-O", "-R"));
        object2 = new ArrayList();
        object = new ArrayList();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = new ArrayList<String>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        int n3 = 0;
        while (n3 < sketch.codeCount) {
            if (sketch.code[n3].preprocName != null) {
                if (sketch.code[n3].preprocName.endsWith(".S")) {
                    arrayList4.add(string + File.separator + sketch.code[n3].preprocName);
                    arrayList7.add(string + File.separator + sketch.code[n3].preprocName + ".o");
                    arrayList9.add(string + File.separator + sketch.code[n3].preprocName + ".o");
                    System.out.println("1>>>" + sketch.code[n3].preprocName);
                } else if (sketch.code[n3].preprocName.endsWith(".c")) {
                    object2.add(string + File.separator + sketch.code[n3].preprocName);
                    arrayList5.add(string + File.separator + sketch.code[n3].preprocName + ".o");
                    arrayList9.add(string + File.separator + sketch.code[n3].preprocName + ".o");
                } else if (sketch.code[n3].preprocName.endsWith(".cpp")) {
                    object.add(string + File.separator + sketch.code[n3].preprocName);
                    arrayList6.add(string + File.separator + sketch.code[n3].preprocName + ".o");
                    arrayList9.add(string + File.separator + sketch.code[n3].preprocName + ".o");
                }
            }
            ++n3;
        }
        Iterator iterator = target.getSourceFilenames().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            if (string5 == null) continue;
            arrayList8.add(string + File.separator + string5 + ".o");
            if (string5.endsWith(".S")) {
                arrayList4.add(target.getPath() + File.separator + string5);
                arrayList7.add(string + File.separator + string5 + ".o");
                System.out.println("2>>>" + string5);
                continue;
            }
            if (string5.endsWith(".c")) {
                object2.add(target.getPath() + File.separator + string5);
                arrayList5.add(string + File.separator + string5 + ".o");
                continue;
            }
            if (!string5.endsWith(".cpp")) continue;
            object.add(target.getPath() + File.separator + string5);
            arrayList6.add(string + File.separator + string5 + ".o");
        }
        arrayList2.addAll(arrayList9);
        arrayList2.addAll(arrayList8);
        arrayList2.add("-lm");
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        int n4 = 0;
        try {
            boolean bl = true;
            int n5 = 0;
            while (n5 < arrayList4.size()) {
                if (this.execAsynchronously(Compiler.getCommandCompilerASM(string3, arrayList, (String)arrayList4.get(n5), (String)arrayList7.get(n5))) != 0) {
                    return false;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < object2.size()) {
                if (this.execAsynchronously(Compiler.getCommandCompilerC(string3, arrayList, (String)object2.get(n5), (String)arrayList5.get(n5))) != 0) {
                    return false;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < object.size()) {
                if (this.execAsynchronously(Compiler.getCommandCompilerCPP(string3, arrayList, (String)object.get(n5), (String)arrayList6.get(n5))) != 0) {
                    return false;
                }
                ++n5;
            }
            if (this.execAsynchronously(arrayList2) != 0) {
                return false;
            }
            ArrayList<String> arrayList10 = new ArrayList<String>((Collection<String>)object3);
            arrayList10.add(2, "ihex");
            arrayList10.set(3, "-j");
            arrayList10.add(".eeprom");
            arrayList10.add("--set-section-flags=.eeprom=alloc,load");
            arrayList10.add("--no-change-warnings");
            arrayList10.add("--change-section-lma");
            arrayList10.add(".eeprom=0");
            arrayList10.add(string + File.separator + sketch.name + ".elf");
            arrayList10.add(string + File.separator + sketch.name + ".eep");
            if (this.execAsynchronously(arrayList10) != 0) {
                return false;
            }
            arrayList10 = new ArrayList(object3);
            arrayList10.add(2, "ihex");
            arrayList10.add(".eeprom");
            arrayList10.add(string + File.separator + sketch.name + ".elf");
            arrayList10.add(string + File.separator + sketch.name + ".hex");
            if (this.execAsynchronously(arrayList10) != 0) {
                return false;
            }
        }
        catch (Exception exception) {
            String string6 = exception.getMessage();
            if (string6 != null && string6.indexOf("avr-gcc: not found") != -1) {
                Base.showWarning("Compiler error", "Could not find the compiler.\navr-gcc is missing from your PATH.", null);
                return false;
            }
            exception.printStackTrace();
            n4 = -1;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (n4 != 0 && n4 != 1) {
            Base.openURL(BUGS_URL);
            throw new RunnerException(SUPER_BADNESS);
        }
        boolean bl = false;
        if (n4 == 0) {
            bl = true;
        }
        return bl;
    }

    public int execAsynchronously(List list) throws RunnerException, IOException {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        int n = 0;
        if (Preferences.getBoolean("build.verbose")) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                System.out.print(stringArray[n2] + ' ');
                ++n2;
            }
            System.out.println();
        }
        Process process = Runtime.getRuntime().exec(stringArray);
        new MessageSiphon(process.getInputStream(), this);
        new MessageSiphon(process.getErrorStream(), this);
        boolean bl = true;
        while (bl) {
            try {
                n = process.waitFor();
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exception != null) {
            this.exception.hideStackTrace = true;
            throw this.exception;
        }
        return n;
    }

    public void message(String string) {
        if (string.indexOf("warning") != -1) {
            return;
        }
        String string2 = this.buildPath.replace(File.separatorChar, File.separatorChar) + File.separatorChar;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.sketch.codeCount) {
            if (this.sketch.code[n3].preprocName != null && (n = string.indexOf(string3 = string2 + this.sketch.code[n3].preprocName)) != -1) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n != -1) {
            int n4;
            int n5;
            String string4 = string.substring(n + string3.length() + 1);
            int n6 = string4.indexOf(58);
            if (string4.indexOf("In function") != -1 || n6 == -1) {
                System.err.print(string4);
                return;
            }
            try {
                n5 = Integer.parseInt(string4.substring(0, n6));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.print(string4);
                return;
            }
            if (n2 == 0) {
                --n5;
            }
            if (n2 == 0) {
                n4 = 1;
                while (n4 < this.sketch.codeCount) {
                    if (this.sketch.code[n4].flavor == 0 && this.sketch.code[n4].preprocOffset < n5) {
                        n2 = n4;
                    }
                    ++n4;
                }
                if (n2 != 0) {
                    n5 -= this.sketch.code[n2].preprocOffset;
                }
            }
            if ((n4 = string4.indexOf(":")) != -1) {
                if (this.firstErrorFound) {
                    this.secondErrorFound = true;
                    return;
                }
                this.firstErrorFound = true;
                String string5 = string4.substring(n4 += ":".length());
                string5 = string5.trim();
                System.err.print(string5);
                this.exception = new RunnerException(string5, n2, n5 - 1, -1);
            } else {
                System.err.println("i suck: " + string);
            }
        } else if (!this.secondErrorFound) {
            System.err.println(string);
        }
    }

    private static final List getCommandCompilerC(String string, List list, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-gcc", "-c", "-g", "-Os", "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu")));
        int n = 0;
        while (n < list.size()) {
            arrayList.add("-I" + (String)list.get(n));
            ++n;
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static final List getCommandCompilerCPP(String string, List list, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-g++", "-c", "-g", "-Os", "-w", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu")));
        int n = 0;
        while (n < list.size()) {
            arrayList.add("-I" + (String)list.get(n));
            ++n;
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static final List getCommandCompilerASM(String string, List list, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-gcc", "-c", "-g", "-x", "assembler-with-cpp", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu")));
        int n = 0;
        while (n < list.size()) {
            arrayList.add("-I" + (String)list.get(n));
            ++n;
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    public static String calcBootClassPath() {
        if (bootClassPath == null) {
            String string = "";
            if (Base.isMacOS()) {
                string = Compiler.contentsToClassPath(new File("/System/Library/Java/Extensions/"));
            }
            bootClassPath = System.getProperty("sun.boot.class.path") + string;
        }
        return bootClassPath;
    }

    public static String contentsToClassPath(File file) {
        if (file == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        try {
            String string2 = file.getCanonicalPath();
            stringBuffer.append(string);
            stringBuffer.append(string2);
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().endsWith(".o") || stringArray[n].toLowerCase().endsWith(".a")) {
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    stringBuffer.append(stringArray[n]);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }
}

