/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.UpdateCheck;
import processing.core.PApplet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Base {
    static final int VERSION = 14;
    static final String VERSION_NAME = "0014";
    static String openedAtStartup;
    static final int kDocumentsFolderType = 1685021555;
    static final int kPreferencesFolderType = 1886545254;
    static final int kDomainLibraryFolderType = 1684826466;
    static final short kUserDomain = -32763;
    static File buildFolder;
    Editor editor;
    static /* synthetic */ Class class$com$apple$mrj$MRJOSType;
    static /* synthetic */ Class class$com$apple$mrj$MRJFileUtils;

    public static void main(String[] stringArray) {
        if (PApplet.javaVersion < 1.4f) {
            Base.showError("Need to install Java 1.4", "This version of Processing requires    \nJava 1.4 or later to run properly.\nPlease visit java.com to upgrade.", null);
        }
        if (stringArray.length == 1) {
            openedAtStartup = stringArray[0];
        }
        MRJOpenDocumentHandler mRJOpenDocumentHandler = new MRJOpenDocumentHandler(){

            public final void handleOpenFile(File file) {
                if (openedAtStartup == null) {
                    openedAtStartup = file.getAbsolutePath();
                }
            }
        };
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)mRJOpenDocumentHandler);
        Base base = new Base();
    }

    public static boolean isMacOS() {
        boolean bl = false;
        if (PApplet.platform == 3) {
            bl = true;
        }
        return bl;
    }

    public static boolean isWindows() {
        boolean bl = false;
        if (PApplet.platform == 1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isLinux() {
        boolean bl = false;
        if (PApplet.platform == 4) {
            bl = true;
        }
        return bl;
    }

    public static File getSettingsFolder() {
        Object object;
        Object object2;
        File file = null;
        String string = Preferences.get("settings.path");
        if (string != null) {
            file = new File(string);
        } else if (Base.isMacOS()) {
            try {
                object2 = new MRJOSType("dlib");
                Class clazz = class$com$apple$mrj$MRJFileUtils;
                if (clazz == null) {
                    clazz = class$com$apple$mrj$MRJFileUtils = Base.class("[Lcom.apple.mrj.MRJFileUtils;", false);
                }
                Class[] classArray = new Class[2];
                classArray[0] = Short.TYPE;
                Class clazz2 = class$com$apple$mrj$MRJOSType;
                if (clazz2 == null) {
                    clazz2 = class$com$apple$mrj$MRJOSType = Base.class("[Lcom.apple.mrj.MRJOSType;", false);
                }
                classArray[1] = clazz2;
                object = clazz.getMethod("findFolder", classArray);
                File file2 = (File)((Method)object).invoke(null, new Short(-32763), object2);
                file = new File(file2, "Arduino");
            }
            catch (Exception exception) {
                Base.showError("Problem getting data folder", "Error getting the Arduino data folder.", exception);
            }
        } else if (Base.isWindows()) {
            try {
                object2 = Registry.HKEY_CURRENT_USER;
                object = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
                RegistryKey registryKey = object2.openSubKey((String)object);
                String string2 = Base.cleanKey(registryKey.getStringValue("AppData"));
                file = new File(string2, "Arduino");
            }
            catch (Exception exception) {
                Base.showError("Problem getting data folder", "Error getting the Arduino data folder.", exception);
            }
        } else {
            object2 = new File(System.getProperty("user.home"));
            file = new File((File)object2, ".arduino");
        }
        boolean bl = true;
        if (!file.exists()) {
            bl = file.mkdirs();
        }
        if (!bl) {
            System.out.println("Using fallback path for settings.");
            object = Preferences.get("settings.path.fallback");
            file = new File((String)object);
            if (!file.exists()) {
                bl = file.mkdirs();
            }
        }
        if (!bl) {
            Base.showError("Settings issues", "Arduino cannot run because it could not\ncreate a folder to store your settings.", null);
        }
        return file;
    }

    public static File getSettingsFile(String string) {
        return new File(Base.getSettingsFolder(), string);
    }

    public static File getBuildFolder() {
        if (buildFolder == null) {
            String string = Preferences.get("build.path");
            if (string != null) {
                buildFolder = new File(string);
            } else {
                buildFolder = Base.createTempFolder("build");
                buildFolder.deleteOnExit();
            }
        }
        return buildFolder;
    }

    public static File createTempFolder(String string) {
        try {
            File file = File.createTempFile(string, null);
            file.delete();
            file.mkdirs();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File getDefaultSketchbookFolder() {
        Object object;
        RegistryKey registryKey;
        File file = null;
        if (Base.isMacOS()) {
            try {
                registryKey = new MRJOSType("docs");
                Class clazz = class$com$apple$mrj$MRJFileUtils;
                if (clazz == null) {
                    clazz = class$com$apple$mrj$MRJFileUtils = Base.class("[Lcom.apple.mrj.MRJFileUtils;", false);
                }
                Class[] classArray = new Class[2];
                classArray[0] = Short.TYPE;
                Class clazz2 = class$com$apple$mrj$MRJOSType;
                if (clazz2 == null) {
                    clazz2 = class$com$apple$mrj$MRJOSType = Base.class("[Lcom.apple.mrj.MRJOSType;", false);
                }
                classArray[1] = clazz2;
                object = clazz.getMethod("findFolder", classArray);
                File file2 = (File)((Method)object).invoke(null, new Short(-32763), registryKey);
                file = new File(file2, "Arduino");
            }
            catch (Exception exception) {
                file = Base.promptSketchbookLocation();
            }
        } else if (Base.isWindows()) {
            try {
                registryKey = Registry.HKEY_CURRENT_USER;
                object = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
                RegistryKey registryKey2 = registryKey.openSubKey((String)object);
                String string = Base.cleanKey(registryKey2.getStringValue("Personal"));
                file = new File(string, "Arduino");
            }
            catch (Exception exception) {
                file = Base.promptSketchbookLocation();
            }
        } else {
            file = Base.promptSketchbookLocation();
        }
        boolean bl = true;
        if (!file.exists()) {
            bl = file.mkdirs();
        }
        if (!bl) {
            System.out.println("Using fallback path for sketchbook.");
            object = Preferences.get("sketchbook.path.fallback");
            file = new File((String)object);
            if (!file.exists()) {
                bl = file.mkdirs();
            }
        }
        if (!bl) {
            Base.showError("error", "Arduino cannot run because it could not\ncreate a folder to store your sketchbook.", null);
        }
        return file;
    }

    protected static File promptSketchbookLocation() {
        File file = null;
        file = new File(System.getProperty("user.home"), "sketchbook");
        if (!file.exists()) {
            file.mkdirs();
            return file;
        }
        file = Base.selectFolder("Select (or create new) folder for sketches...", null, null);
        if (file == null) {
            System.exit(0);
        }
        return file;
    }

    public static File selectFolder(String string, File file, Frame frame) {
        if (Base.isMacOS()) {
            if (frame == null) {
                frame = new Frame();
            }
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            if (file != null) {
                fileDialog.setDirectory(file.getParent());
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.show();
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (fileDialog.getFile() == null) {
                return null;
            }
            return new File(fileDialog.getDirectory(), fileDialog.getFile());
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        if (file != null) {
            jFileChooser.setSelectedFile(file);
        }
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(new JDialog());
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static String cleanKey(String string) {
        char[] cArray = string.toCharArray();
        char c = '\uff80';
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] >= c) {
                int n2 = n;
                cArray[n2] = (char)(cArray[n2] & 0xFF);
            }
            ++n;
        }
        return new String(cArray);
    }

    public static void registerWindowCloseKeys(JRootPane jRootPane, ActionListener actionListener) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        keyStroke = KeyStroke.getKeyStroke(87, n);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
    }

    public static void showReference(String string) {
        Base.openURL(Base.getContents("reference" + File.separator + string));
    }

    public static void showReference() {
        Base.showReference("index.html");
    }

    public static void showEnvironment() {
        Base.showReference("Guide_Environment.html");
    }

    public static void showTroubleshooting() {
        Base.showReference("Guide_Troubleshooting.html");
    }

    public static void showFAQ() {
        Base.showReference("faq.html");
    }

    public static void openURL(String string) {
        try {
            if (Base.isWindows()) {
                if (string.startsWith("http://")) {
                    Runtime.getRuntime().exec("cmd /c start " + string);
                } else {
                    Runtime.getRuntime().exec("cmd /c \"" + string + '\"');
                }
            } else if (Base.isMacOS()) {
                if (!string.startsWith("http://") && (string = "file://" + string).indexOf(32) != -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = string.toCharArray();
                    int n = 0;
                    while (n < cArray.length) {
                        if (cArray[n] == ' ') {
                            stringBuffer.append("%20");
                        } else {
                            stringBuffer.append(cArray[n]);
                        }
                        ++n;
                    }
                    string = stringBuffer.toString();
                }
                MRJFileUtils.openURL((String)string);
            } else if (Base.isLinux()) {
                String string2 = Preferences.get("launcher.linux");
                if (string2 != null) {
                    Runtime.getRuntime().exec(new String[]{string2, string});
                }
            } else {
                String string3 = Preferences.get("launcher");
                if (string3 != null) {
                    Runtime.getRuntime().exec(new String[]{string3, string});
                } else {
                    System.err.println("Unspecified platform, no launcher available.");
                }
            }
        }
        catch (IOException iOException) {
            Base.showWarning("Could not open URL", "An error occurred while trying to open\n" + string, iOException);
        }
    }

    static boolean openFolderAvailable() {
        if (Base.isWindows() || Base.isMacOS()) {
            return true;
        }
        if (Base.isLinux()) {
            if (Preferences.get("launcher.linux") != null) {
                return true;
            }
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                int n = process.waitFor();
                Preferences.set("launcher.linux", "gnome-open");
                return true;
            }
            catch (Exception exception) {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    int n = process.waitFor();
                    Preferences.set("launcher.linux", "kde-open");
                    return true;
                }
                catch (Exception exception2) {}
            }
        }
        return false;
    }

    public static void openFolder(File file) {
        try {
            String string;
            String string2 = file.getAbsolutePath();
            if (Base.isWindows()) {
                Runtime.getRuntime().exec("explorer \"" + string2 + '\"');
            } else if (Base.isMacOS()) {
                Base.openURL(string2);
            } else if (Base.isLinux() && (string = Preferences.get("launcher.linux")) != null) {
                Runtime.getRuntime().exec(new String[]{string, string2});
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void showMessage(String string, String string2) {
        if (string == null) {
            string = "Message";
        }
        JOptionPane.showMessageDialog(new Frame(), string2, string, 1);
    }

    public static void showWarning(String string, String string2, Exception exception) {
        if (string == null) {
            string = "Warning";
        }
        JOptionPane.showMessageDialog(new Frame(), string2, string, 2);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public static void showError(String string, String string2, Throwable throwable) {
        if (string == null) {
            string = "Error";
        }
        JOptionPane.showMessageDialog(new Frame(), string2, string, 0);
        if (throwable != null) {
            throwable.printStackTrace();
        }
        System.exit(1);
    }

    public static String getContents(String string) {
        String string2 = System.getProperty("user.dir");
        return string2 + File.separator + string;
    }

    public static String getLibContents(String string) {
        String string2 = System.getProperty("arduino.app-resources");
        if (string2 != null) {
            return string2 + File.separator + string;
        }
        return Base.getContents("lib" + File.separator + string);
    }

    public static Image getImage(String string, Component component) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        image = toolkit.getImage(Base.getLibContents(string));
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        return image;
    }

    public static InputStream getStream(String string) throws IOException {
        return new FileInputStream(Base.getLibContents(string));
    }

    public static byte[] grabFile(File file) throws IOException {
        int n;
        int n2 = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while ((n = fileInputStream.read(byArray, n3, n2 - n3)) != -1) {
            n3 += n;
            if (n == 0) break;
        }
        fileInputStream.close();
        fileInputStream = null;
        return byArray;
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray = new byte[16384];
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((InputStream)bufferedInputStream).close();
        bufferedInputStream = null;
        ((OutputStream)bufferedOutputStream).close();
        bufferedOutputStream = null;
        file2.setLastModified(file.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        if (file.length() == 0L) {
            return "";
        }
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void saveFile(String string, File file) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(fileWriter));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            printWriter.println(string2);
        }
        printWriter.flush();
        printWriter.close();
    }

    public static void copyDir(File file, File file2) throws IOException {
        file2.mkdirs();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(".") && !stringArray[n].equals("..")) {
                File file3 = new File(file, stringArray[n]);
                File file4 = new File(file2, stringArray[n]);
                if (file3.isDirectory()) {
                    Base.copyDir(file3, file4);
                    file4.setLastModified(file3.lastModified());
                } else {
                    Base.copyFile(file3, file4);
                }
            }
            ++n;
        }
    }

    public static void removeDir(File file) {
        if (file.exists()) {
            Base.removeDescendants(file);
            if (!file.delete()) {
                System.err.println("Could not delete " + file);
            }
        }
    }

    public static void removeDescendants(File file) {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(".") && !stringArray[n].equals("..")) {
                File file2 = new File(file, stringArray[n]);
                if (!file2.isDirectory()) {
                    if (!Preferences.getBoolean("compiler.save_build_files") && !file2.delete()) {
                        System.err.println("Could not delete " + file2);
                    }
                } else {
                    Base.removeDir(file2);
                }
            }
            ++n;
        }
    }

    public static int calcFolderSize(File file) {
        int n = 0;
        String[] stringArray = file.list();
        if (stringArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!(stringArray[n2].equals(".") || stringArray[n2].equals("..") || stringArray[n2].equals(".DS_Store"))) {
                File file2 = new File(file, stringArray[n2]);
                n = file2.isDirectory() ? (n += Base.calcFolderSize(file2)) : (n += (int)file2.length());
            }
            ++n2;
        }
        return n;
    }

    public static String[] listFiles(String string, boolean bl) {
        return Base.listFiles(new File(string), bl);
    }

    public static String[] listFiles(File file, boolean bl) {
        String string = file.getAbsolutePath();
        Vector vector = new Vector();
        Base.listFiles(bl ? string + File.separator : "", string, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static void listFiles(String string, String string2, Vector vector) {
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '.') {
                File file2 = new File(string2, stringArray[n]);
                String string3 = file2.getAbsolutePath();
                if (string3.startsWith(string)) {
                    string3 = string3.substring(string.length());
                }
                vector.add(string3);
                if (file2.isDirectory()) {
                    Base.listFiles(string, string3, vector);
                }
            }
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Base() {
        try {
            if (Base.isMacOS()) {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                UIManager.put("Component.visualMargin", new Insets(1, 1, 1, 1));
            } else if (Base.isLinux()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.editor = new Editor();
        this.editor.pack();
        this.editor.restorePreferences();
        this.editor.show();
        this.editor.prepareLibraries();
        if (Preferences.getBoolean("update.check")) {
            new UpdateCheck(this.editor);
        }
    }
}

