/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.jnlp.JNLPRandomAccessFileImpl;
import com.sun.jnlp.MeteredFileOutputStream;
import com.sun.jnlp.PersistenceServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class FileContentsImpl
implements FileContents {
    private String _name = null;
    private File _file = null;
    private long _limit = Long.MAX_VALUE;
    private URL _url = null;
    private JNLPRandomAccessFile _raf = null;
    private PersistenceServiceImpl _psCallback = null;

    public long getLength() {
        Long l = (Long)AccessController.doPrivileged(new PrivilegedAction(this){
            private final FileContentsImpl this$0;
            {
                this.this$0 = fileContentsImpl;
            }

            public Object run() {
                return new Long(FileContentsImpl.access$000(this.this$0).length());
            }
        });
        return l;
    }

    public long getMaxLength() throws IOException {
        return this._limit;
    }

    public boolean canRead() throws IOException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this){
            private final FileContentsImpl this$0;
            {
                this.this$0 = fileContentsImpl;
            }

            public Object run() {
                return new Boolean(FileContentsImpl.access$000(this.this$0).canRead());
            }
        });
        return bl;
    }

    public boolean canWrite() throws IOException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this){
            private final FileContentsImpl this$0;
            {
                this.this$0 = fileContentsImpl;
            }

            public Object run() {
                return new Boolean(FileContentsImpl.access$000(this.this$0).canWrite());
            }
        });
        return bl;
    }

    public long setMaxLength(long l) throws IOException {
        if (this._psCallback != null) {
            this._limit = this._psCallback.setMaxLength(this._url, l);
            return this._limit;
        }
        this._limit = l;
        return this._limit;
    }

    FileContentsImpl(File file, long l) throws IOException {
        this._file = file;
        this._limit = l;
        this._name = this._file.getName();
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                private final FileContentsImpl this$0;
                {
                    this.this$0 = fileContentsImpl;
                }

                public Object run() throws IOException {
                    return new FileInputStream(FileContentsImpl.access$000(this.this$0));
                }
            });
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    public OutputStream getOutputStream(boolean bl) throws IOException {
        try {
            OutputStream outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(this, bl){
                private final boolean val$append;
                private final FileContentsImpl this$0;
                {
                    this.this$0 = fileContentsImpl;
                    this.val$append = bl;
                }

                public Object run() throws IOException {
                    return new MeteredFileOutputStream(FileContentsImpl.access$000(this.this$0), !this.val$append, this.this$0);
                }
            });
            return outputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    public String getName() {
        return this._name;
    }

    static File access$000(FileContentsImpl fileContentsImpl) {
        return fileContentsImpl._file;
    }

    private IOException rethrowException(PrivilegedActionException privilegedActionException) throws IOException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new IOException(exception.getMessage());
    }

    public JNLPRandomAccessFile getRandomAccessFile(String string) throws IOException {
        try {
            return (JNLPRandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(this, string){
                private final String val$mode;
                private final FileContentsImpl this$0;

                public Object run() throws MalformedURLException, IOException {
                    return new JNLPRandomAccessFileImpl(FileContentsImpl.access$000(this.this$0), this.val$mode, this.this$0);
                }
                {
                    this.this$0 = fileContentsImpl;
                    this.val$mode = string;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    FileContentsImpl(File file, PersistenceServiceImpl persistenceServiceImpl, URL uRL, long l) {
        this._file = file;
        this._url = uRL;
        this._psCallback = persistenceServiceImpl;
        this._limit = l;
        int n = uRL.getFile().lastIndexOf(47);
        this._name = n != -1 ? uRL.getFile().substring(n + 1) : uRL.getFile();
    }
}

