/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SunJSSE_b;

public class KeyManagerFactory {
    private Provider a;
    private KeyManagerFactorySpi b;
    private String c;

    public final String getAlgorithm() {
        return this.c;
    }

    public static final String getDefaultAlgorithm() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.KeyManagerFactory.algorithm");
            }
        });
        if (string == null) {
            string = "SunX509";
        }
        return string;
    }

    public final void init(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.b.engineInit(keyStore, cArray);
    }

    public final Provider getProvider() {
        return this.a;
    }

    public final KeyManager[] getKeyManagers() {
        return this.b.engineGetKeyManagers();
    }

    public final void init(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.b.engineInit(managerFactoryParameters);
    }

    public static final KeyManagerFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = SunJSSE_b.a(string, "KeyManagerFactory", (String)null);
            return new KeyManagerFactory((KeyManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    protected KeyManagerFactory(KeyManagerFactorySpi keyManagerFactorySpi, Provider provider, String string) {
        this.b = keyManagerFactorySpi;
        this.a = provider;
        this.c = string;
    }

    public static final KeyManagerFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SunJSSE_b.a(string, "KeyManagerFactory", string2);
        return new KeyManagerFactory((KeyManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final KeyManagerFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SunJSSE_b.a(string, "KeyManagerFactory", provider);
        return new KeyManagerFactory((KeyManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }
}

