/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.SunJSSE_br;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;

final class X509KeyManagerImpl
implements X509KeyManager {
    private static final Debug a = Debug.getInstance("ssl");
    private static final String[] b = new String[0];
    private Map c = new HashMap();
    private Map d = new HashMap();

    X509KeyManagerImpl(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            Certificate[] certificateArray;
            Key key;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || !((key = keyStore.getKey(string, cArray)) instanceof PrivateKey) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length == 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (!(certificateArray instanceof X509Certificate[])) {
                object = new X509Certificate[certificateArray.length];
                System.arraycopy(certificateArray, 0, object, 0, certificateArray.length);
                certificateArray = object;
            }
            object = new SunJSSE_br((PrivateKey)key, (X509Certificate[])certificateArray);
            this.c.put(string, object);
            if (a == null || !Debug.isOn("keymanager")) continue;
            System.out.println("***");
            System.out.println("found key for : " + string);
            for (int i = 0; i < certificateArray.length; ++i) {
                System.out.println("chain [" + i + "] = " + certificateArray[i]);
            }
            System.out.println("***");
        }
    }

    public PrivateKey getPrivateKey(String string) {
        if (string == null) {
            return null;
        }
        SunJSSE_br sunJSSE_br = (SunJSSE_br)this.c.get(string);
        if (sunJSSE_br == null) {
            return null;
        }
        return sunJSSE_br.a;
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        SunJSSE_br sunJSSE_br = (SunJSSE_br)this.c.get(string);
        if (sunJSSE_br == null) {
            return null;
        }
        return (X509Certificate[])sunJSSE_br.b.clone();
    }

    private static X500Principal[] a(Principal[] principalArray) {
        ArrayList<Principal> arrayList = new ArrayList<Principal>(principalArray.length);
        for (int i = 0; i < principalArray.length; ++i) {
            Principal principal = principalArray[i];
            if (principal instanceof X500Principal) {
                arrayList.add(principal);
                continue;
            }
            try {
                arrayList.add(new X500Principal(principal.getName()));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new X500Principal[arrayList.size()]);
    }

    private String[] a(String string, Principal[] principalArray) {
        if (string == null) {
            return null;
        }
        if (principalArray == null) {
            principalArray = new X500Principal[]{};
        }
        if (!(principalArray instanceof X500Principal[])) {
            principalArray = X509KeyManagerImpl.a(principalArray);
        }
        X500Principal[] x500PrincipalArray = (X500Principal[])principalArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.c.entrySet().iterator();
        block0: while (stringArray.hasNext()) {
            Map.Entry entry = stringArray.next();
            String string2 = (String)entry.getKey();
            SunJSSE_br sunJSSE_br = (SunJSSE_br)entry.getValue();
            X509Certificate[] x509CertificateArray = sunJSSE_br.b;
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            if (principalArray.length == 0) {
                arrayList.add(string2);
                if (a == null || !Debug.isOn("keymanager")) continue;
                System.out.println("matching alias: " + string2);
                continue;
            }
            Set set = sunJSSE_br.a();
            for (int i = 0; i < x500PrincipalArray.length; ++i) {
                if (!set.contains(principalArray[i])) continue;
                arrayList.add(string2);
                if (a == null || !Debug.isOn("keymanager")) continue block0;
                System.out.println("matching alias: " + string2);
                continue block0;
            }
        }
        stringArray = arrayList.toArray(b);
        return stringArray.length == 0 ? null : stringArray;
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.a(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.a(string, principalArray);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (principalArray == null || principalArray.length == 0) {
            stringArray = (String[])this.d.get(string);
            if (stringArray == null) {
                stringArray = this.getServerAliases(string, principalArray);
                if (stringArray == null) {
                    stringArray = b;
                }
                this.d.put(string, stringArray);
            }
        } else {
            stringArray = this.getServerAliases(string, principalArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getClientAliases(stringArray[i], principalArray);
            if (stringArray2 == null || stringArray2.length <= 0) continue;
            return stringArray2[0];
        }
        return null;
    }
}

