/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.SocketException;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketOpts;

class OptionAdaptor {
    private final SocketOpts.IP opts;

    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.opts().receiveBufferSize();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public int getSendBufferSize() throws SocketException {
        try {
            return this.opts().sendBufferSize();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public int getSoLinger() throws SocketException {
        try {
            return this.opts().linger();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public int getTrafficClass() throws SocketException {
        try {
            return this.opts().typeOfService();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public boolean getBroadcast() throws SocketException {
        try {
            return this.opts().broadcast();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public boolean getKeepAlive() throws SocketException {
        try {
            return this.opts().keepAlive();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public boolean getOOBInline() throws SocketException {
        try {
            return this.opts().outOfBandInline();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public boolean getReuseAddress() throws SocketException {
        try {
            return this.opts().reuseAddress();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public boolean getTcpNoDelay() throws SocketException {
        try {
            return this.tcpOpts().noDelay();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public void setReceiveBufferSize(int n2) throws SocketException {
        try {
            this.opts().receiveBufferSize(n2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setSendBufferSize(int n2) throws SocketException {
        try {
            this.opts().sendBufferSize(n2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setTrafficClass(int n2) throws SocketException {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("tc is not in range 0 -- 255");
        }
        try {
            this.opts().typeOfService(n2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setBroadcast(boolean bl2) throws SocketException {
        try {
            this.opts().broadcast(bl2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setKeepAlive(boolean bl2) throws SocketException {
        try {
            this.opts().keepAlive(bl2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setOOBInline(boolean bl2) throws SocketException {
        try {
            this.opts().outOfBandInline(bl2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setReuseAddress(boolean bl2) throws SocketException {
        try {
            this.opts().reuseAddress(bl2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setTcpNoDelay(boolean bl2) throws SocketException {
        try {
            this.tcpOpts().noDelay(bl2);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void setSoLinger(boolean bl2, int n2) throws SocketException {
        try {
            if (n2 > 65535) {
                n2 = 65535;
            }
            this.opts().linger(bl2 ? n2 : -1);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    OptionAdaptor(DatagramChannelImpl datagramChannelImpl) {
        this.opts = (SocketOpts.IP)datagramChannelImpl.options();
    }

    OptionAdaptor(ServerSocketChannelImpl serverSocketChannelImpl) {
        this.opts = (SocketOpts.IP)serverSocketChannelImpl.options();
    }

    OptionAdaptor(SocketChannelImpl socketChannelImpl) {
        this.opts = (SocketOpts.IP)socketChannelImpl.options();
    }

    private SocketOpts.IP opts() {
        return this.opts;
    }

    private SocketOpts.IP.TCP tcpOpts() {
        return (SocketOpts.IP.TCP)this.opts;
    }
}

