/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Hashtable;
import sun.misc.NativeSignalHandler;
import sun.misc.SignalHandler;

public final class Signal {
    private static Hashtable handlers = new Hashtable(4);
    private static Hashtable signals = new Hashtable(4);
    private int number;
    private String name;

    public int getNumber() {
        return this.number;
    }

    public int hashCode() {
        return this.number;
    }

    private static void dispatch(int n2) {
        Signal signal = (Signal)signals.get(new Integer(n2));
        SignalHandler signalHandler = (SignalHandler)handlers.get(signal);
        Runnable runnable = new Runnable(signalHandler, signal){
            private final SignalHandler val$handler;
            private final Signal val$sig;

            public void run() {
                this.val$handler.handle(this.val$sig);
            }
            {
                this.val$handler = signalHandler;
                this.val$sig = signal;
            }
        };
        if (signalHandler != null) {
            new Thread(runnable, signal + " handler").start();
        }
    }

    private static native void raise0(int var0);

    private static native long handle0(int var0, long var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)object;
        return this.name.equals(signal.name) && this.number == signal.number;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "SIG" + this.name;
    }

    private static native int findSignal(String var0);

    public Signal(String string) {
        this.number = Signal.findSignal(string);
        this.name = string;
        if (this.number < 0) {
            throw new IllegalArgumentException("Unknown signal: " + string);
        }
    }

    public static void raise(Signal signal) throws IllegalArgumentException {
        if (handlers.get(signal) == null) {
            throw new IllegalArgumentException("Unhandled signal: " + signal);
        }
        Signal.raise0(signal.number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SignalHandler handle(Signal signal, SignalHandler signalHandler) throws IllegalArgumentException {
        long l2 = signalHandler instanceof NativeSignalHandler ? ((NativeSignalHandler)signalHandler).getHandler() : 2L;
        long l3 = Signal.handle0(signal.number, l2);
        if (l3 == -1L) {
            throw new IllegalArgumentException("Signal already used by VM: " + signal);
        }
        signals.put(new Integer(signal.number), signal);
        Hashtable hashtable = handlers;
        synchronized (hashtable) {
            SignalHandler signalHandler2 = (SignalHandler)handlers.get(signal);
            handlers.remove(signal);
            if (l2 == 2L) {
                handlers.put(signal, signalHandler);
            }
            if (l3 == 0L) {
                return SignalHandler.SIG_DFL;
            }
            if (l3 == 1L) {
                return SignalHandler.SIG_IGN;
            }
            if (l3 == 2L) {
                return signalHandler2;
            }
            return new NativeSignalHandler(l3);
        }
    }
}

