/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.IOException;
import java.util.Locale;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderAdapter
implements Parser,
ContentHandler {
    XMLReader xmlReader;
    DocumentHandler documentHandler;
    AttributesAdapter qAtts;

    public XMLReaderAdapter() throws SAXException {
        this.setup(XMLReaderFactory.createXMLReader());
    }

    public void endDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument();
        }
    }

    private void setupXMLReader() throws SAXException {
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        try {
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.xmlReader.setContentHandler(this);
    }

    public void startDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.startDocument();
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(cArray, n2, n3);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(cArray, n2, n3);
        }
    }

    public void endPrefixMapping(String string) {
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void setLocale(Locale locale) throws SAXException {
        throw new SAXNotSupportedException("setLocale not supported");
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.xmlReader.setDTDHandler(dTDHandler);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.xmlReader.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.setupXMLReader();
        this.xmlReader.parse(inputSource);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(locator);
        }
    }

    public XMLReaderAdapter(XMLReader xMLReader) {
        this.setup(xMLReader);
    }

    private void setup(XMLReader xMLReader) {
        if (xMLReader == null) {
            throw new NullPointerException("XMLReader must not be null");
        }
        this.xmlReader = xMLReader;
        this.qAtts = new AttributesAdapter(this);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(string, string2);
        }
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(string3);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.documentHandler != null) {
            this.qAtts.setAttributes(attributes);
            this.documentHandler.startElement(string3, this.qAtts);
        }
    }

    final class AttributesAdapter
    implements AttributeList {
        private Attributes attributes;
        private final XMLReaderAdapter this$0;

        public int getLength() {
            return this.attributes.getLength();
        }

        public String getName(int n2) {
            return this.attributes.getQName(n2);
        }

        public String getType(int n2) {
            return this.attributes.getType(n2);
        }

        public String getValue(int n2) {
            return this.attributes.getValue(n2);
        }

        void setAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        AttributesAdapter(XMLReaderAdapter xMLReaderAdapter) {
            this.this$0 = xMLReaderAdapter;
        }

        public String getType(String string) {
            return this.attributes.getType(string);
        }

        public String getValue(String string) {
            return this.attributes.getValue(string);
        }
    }
}

