/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.util.EventObject;
import javax.swing.tree.TreePath;

public class TreeSelectionEvent
extends EventObject {
    protected TreePath[] paths;
    protected boolean[] areNew;
    protected TreePath oldLeadSelectionPath;
    protected TreePath newLeadSelectionPath;

    public boolean isAddedPath() {
        return this.areNew[0];
    }

    public boolean isAddedPath(int n2) {
        if (this.paths == null || n2 < 0 || n2 >= this.paths.length) {
            throw new IllegalArgumentException("index is beyond range of added paths identified by TreeSelectionEvent");
        }
        return this.areNew[n2];
    }

    public TreePath getNewLeadSelectionPath() {
        return this.newLeadSelectionPath;
    }

    public TreePath getOldLeadSelectionPath() {
        return this.oldLeadSelectionPath;
    }

    public TreePath getPath() {
        return this.paths[0];
    }

    public TreePath[] getPaths() {
        int n2 = this.paths.length;
        TreePath[] treePathArray = new TreePath[n2];
        System.arraycopy(this.paths, 0, treePathArray, 0, n2);
        return treePathArray;
    }

    public boolean isAddedPath(TreePath treePath) {
        for (int i2 = this.paths.length - 1; i2 >= 0; --i2) {
            if (!this.paths[i2].equals(treePath)) continue;
            return this.areNew[i2];
        }
        throw new IllegalArgumentException("path is not a path identified by the TreeSelectionEvent");
    }

    public Object cloneWithSource(Object object) {
        return new TreeSelectionEvent(object, this.paths, this.areNew, this.oldLeadSelectionPath, this.newLeadSelectionPath);
    }

    public TreeSelectionEvent(Object object, TreePath treePath, boolean bl2, TreePath treePath2, TreePath treePath3) {
        super(object);
        this.paths = new TreePath[1];
        this.paths[0] = treePath;
        this.areNew = new boolean[1];
        this.areNew[0] = bl2;
        this.oldLeadSelectionPath = treePath2;
        this.newLeadSelectionPath = treePath3;
    }

    public TreeSelectionEvent(Object object, TreePath[] treePathArray, boolean[] blArray, TreePath treePath, TreePath treePath2) {
        super(object);
        this.paths = treePathArray;
        this.areNew = blArray;
        this.oldLeadSelectionPath = treePath;
        this.newLeadSelectionPath = treePath2;
    }
}

