/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private int value = 0;
    private int extent = 0;
    private int min = 0;
    private int max = 100;
    private boolean isAdjusting = false;
    static Class class$javax$swing$event$ChangeListener;

    public int getExtent() {
        return this.extent;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getValue() {
        return this.value;
    }

    public DefaultBoundedRangeModel() {
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$ChangeListener == null ? DefaultBoundedRangeModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setExtent(int n2) {
        int n3 = Math.max(0, n2);
        if (this.value + n3 > this.max) {
            n3 = this.max - this.value;
        }
        this.setRangeProperties(this.value, n3, this.min, this.max, this.isAdjusting);
    }

    public void setMaximum(int n2) {
        int n3 = Math.min(n2, this.min);
        int n4 = Math.min(n2 - n3, this.extent);
        int n5 = Math.min(n2 - n4, this.value);
        this.setRangeProperties(n5, n4, n3, n2, this.isAdjusting);
    }

    public void setMinimum(int n2) {
        int n3 = Math.max(n2, this.max);
        int n4 = Math.max(n2, this.value);
        int n5 = Math.min(n3 - n4, this.extent);
        this.setRangeProperties(n4, n5, n2, n3, this.isAdjusting);
    }

    public void setValue(int n2) {
        int n3 = Math.max(n2, this.min);
        if (n3 + this.extent > this.max) {
            n3 = this.max - this.extent;
        }
        this.setRangeProperties(n3, this.extent, this.min, this.max, this.isAdjusting);
    }

    public DefaultBoundedRangeModel(int n2, int n3, int n4, int n5) {
        if (n5 < n4 || n2 < n4 || n2 + n3 < n2 || n2 + n3 > n5) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = n2;
        this.extent = n3;
        this.min = n4;
        this.max = n5;
    }

    public void setRangeProperties(int n2, int n3, int n4, int n5, boolean bl2) {
        boolean bl3;
        if (n4 > n5) {
            n4 = n5;
        }
        if (n2 > n5) {
            n5 = n2;
        }
        if (n2 < n4) {
            n4 = n2;
        }
        if ((long)n3 + (long)n2 > (long)n5) {
            n3 = n5 - n2;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        boolean bl4 = bl3 = n2 != this.value || n3 != this.extent || n4 != this.min || n5 != this.max || bl2 != this.isAdjusting;
        if (bl3) {
            this.value = n2;
            this.extent = n3;
            this.min = n4;
            this.max = n5;
            this.isAdjusting = bl2;
            this.fireStateChanged();
        }
    }

    public void setValueIsAdjusting(boolean bl2) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, bl2);
    }

    public String toString() {
        String string = "value=" + this.getValue() + ", " + "extent=" + this.getExtent() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "adj=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + string + "]";
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultBoundedRangeModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultBoundedRangeModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultBoundedRangeModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

